<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="rtl">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description"
          content="{{ \App\Model\Settings::getSettingName('descriptionSite')}}">
    <meta name="keywords"
          content="{{ \App\Model\Settings::getSettingName('keywords')}}">
    <meta name="author" content="PIXINVENT">
    <title>{{ \App\Model\Settings::getSettingName('titleSite')}} @yield('title')</title>
    <link rel="apple-touch-icon" href="../../../app-assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="../../../app-assets/images/ico/favicon.ico">
    <link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600" rel="stylesheet">

    <!-- BEGIN: Vendor CSS-->


    <link rel="stylesheet" type="text/css"
          href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">

    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/vendors/css/vendors-rtl.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/vendors/css/tables/datatable/datatables.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/vendors/css/tables/datatable/extensions/dataTablesCheckboxes.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/vendors/css/charts/apexcharts.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/vendors/css/extensions/tether-theme-arrows.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/vendors/css/extensions/tether.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/vendors/css/extensions/shepherd-theme-default.css') }}">

    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/bootstrap.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/bootstrap-extended.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/colors.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/components.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/themes/dark-layout.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/themes/semi-dark-layout.css') }}">

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/css-rtl/core/menu/menu-types/vertical-menu.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/css-rtl/core/colors/palette-gradient.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('Admin/app-assets/css-rtl/plugins/forms/validation/form-validation.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/pages/dashboard-analytics.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/pages/card-analytics.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/plugins/tour/tour.css') }}">

    <!-- END: Page CSS-->


    <!-- BEGIN: Custom CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/pages/data-list-view.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/app-assets/css-rtl/custom-rtl.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('Admin/assets/css/style-rtl.css') }}">

    @yield('css')

</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern 2-columns  navbar-floating footer-static  " data-open="click"
      data-menu="vertical-menu-modern" data-col="2-columns">

<!-- BEGIN: Header-->
<nav class="header-navbar navbar-expand-lg navbar navbar-with-menu floating-nav navbar-light navbar-shadow">
    <div class="navbar-wrapper">
        <div class="navbar-container content">
            <div class="navbar-collapse" id="navbar-mobile">
                <ul class="nav navbar-nav float-left">

                    <li class="dropdown dropdown-user nav-item">
                        <span><img class="round " style="margin-top: 8px"
                                   src="/{{\Illuminate\Support\Facades\Auth::user()->imageInfo}}"
                                   alt="avatar" height="40" width="40"></span>
                        <a class="dropdown-toggle nav-link dropdown-user-link float-right"
                           href="#" data-toggle="dropdown">
                            <div class="user-nav d-sm-flex d-none dir-rtl "
                                 style="line-height: 3; font-family: 'iransans' ">
                                <div
                                    class="user-name text-bold-600">{{\Illuminate\Support\Facades\Auth::user()->name}} {{\Illuminate\Support\Facades\Auth::user()->family}}</div>
                            </div>

                        </a>
                        <div class="dropdown-menu dropdown-menu-right dir-rtl">
                            <a class="dropdown-item"
                               href="{{route('Admin.users.profile.edit')}}"><i
                                    class="feather icon-user"></i>{{trans('langPanel.profile')}}</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="{{route('logoute')}}"><i class="feather icon-power"></i>
                                {{trans('langPanel.logout')}}</a>
                        </div>
                    </li>


                </ul>

                <div class="ml-auto float-right bookmark-wrapper d-flex align-items-center">

                    <ul class="nav navbar-nav bookmark-icons mr-2">
                        <!-- li.nav-item.mobile-menu.d-xl-none.mr-auto-->
                        <!--   a.nav-link.nav-menu-main.menu-toggle.hidden-xs(href='#')-->
                        <!--     i.ficon.feather.icon-menu-->
                        <li class="nav-item d-none d-lg-block"><a class="nav-link" href="{{route('Admin.blogs.index')}}"
                                                                  data-toggle="tooltip" data-placement="top"
                                                                  title="{{trans('langPanel.blogList')}}"><i
                                    class="ficon feather icon-clipboard"></i></a></li>
                        <li class="nav-item d-none d-lg-block"><a class="nav-link"
                                                                  href="{{route('Admin.comments.index')}}"
                                                                  data-toggle="tooltip" data-placement="top"
                                                                  title="{{trans('langPanel.comment')}}"><i
                                    class="ficon feather icon-message-circle"></i></a></li>

                        <li class="nav-item d-none d-lg-block"><a class="nav-link nav-link-expand"><i
                                    class="ficon feather icon-maximize"></i></a></li>

                    </ul>
                    <ul class="nav navbar-nav">
                        <li class="nav-item mobile-menu d-xl-none mr-auto"><a
                                class="nav-link nav-menu-main menu-toggle hidden-xs" href="#"><i
                                    class="ficon feather icon-menu"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</nav>
<!-- END: Header-->


<!-- END: Header-->


<!-- BEGIN: Main Menu-->
<div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
    <div class="navbar-header">
        <ul class="nav navbar-nav flex-row">
            <li class="nav-item mr-auto"><a class="navbar-brand"
                                            href="/">
                    <div class="brand-logo" style="background: url(/{{\Illuminate\Support\Facades\Auth::user()->imageInfo}}) no-repeat;background-size: 27px 27px;"></div>
                    <h2 class="brand-text mb-0">{{\Illuminate\Support\Facades\Auth::user()->name}} {{\Illuminate\Support\Facades\Auth::user()->family}}</h2>
                </a></li>
            <li class="nav-item nav-toggle">
                <a class="nav-link modern-nav-toggle pr-0" data-toggle="collapse">
                    <i class="feather icon-x d-block d-xl-none font-medium-4 primary toggle-icon"></i>
                    <i class="toggle-icon feather icon-disc font-medium-4 d-none d-xl-block collapse-toggle-icon primary"
                       data-ticon="icon-disc"></i>
                </a>
            </li>
        </ul>
    </div>
    <div class="shadow-bottom"></div>
    <div class="main-menu-content">
        <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">

            <li class=" nav-item">
                <a href="{{route('Admin.index')}}">
                    <i class="feather icon-home"></i>
                    <span class="menu-title"
                          data-i18n="{{trans('langPanel.dashboard')}}">{{trans('langPanel.dashboard')}}</span>
                </a>
            </li>


            <li class=" nav-item"><a href="{{route('Admin.users.profile.edit')}}"><i class="feather icon-user"></i><span
                        class="menu-title"
                        data-i18n="{{trans('langPanel.profile')}}">{{trans('langPanel.profile')}}</span></a>

            </li>


            <li class=" nav-item">
                <a href="{{route('Admin.settings.show')}}">
                    <i class="feather icon-settings"></i>
                    <span class="menu-title"
                          data-i18n="{{trans('langPanel.setting')}}">{{trans('langPanel.setting')}}</span>
                </a>
            </li>


            <li class=" nav-item">
                <a href="{{route('Admin.contacts.index')}}">
                    <i class="feather icon-layout"></i>
                    <span class="menu-title"
                          data-i18n="{{trans('langPanel.contacts')}}">{{trans('langPanel.contacts')}}</span>
                </a>
            </li>


            <li class=" nav-item"><a href="#"><i class="feather icon-message-square"></i><span class="menu-title"
                                                                                               data-i18n="{{trans('langPanel.comment')}}">{{trans('langPanel.comment')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.comments.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.commentInsert')}}">{{trans('langPanel.commentInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.comments.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.commentList')}}">{{trans('langPanel.commentList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>



            <li class=" nav-item"><a href="#"><i class="feather icon-file-text"></i><span class="menu-title"
                                                                                          data-i18n="{{trans('langPanel.blog')}}">{{trans('langPanel.blog')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.blogs.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.blogInsert')}}">{{trans('langPanel.blogInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.blogs.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.blogList')}}">{{trans('langPanel.blogList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>


            <li class=" nav-item"><a href="#"><i class="feather icon-edit"></i><span class="menu-title"
                                                                                     data-i18n="{{trans('langPanel.service')}}">{{trans('langPanel.service')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.services.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.serviceInsert')}}">{{trans('langPanel.serviceInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.services.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.serviceList')}}">{{trans('langPanel.serviceList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>


            <li class=" nav-item"><a href="#"><i class="feather icon-list"></i><span class="menu-title"
                                                                                     data-i18n="{{trans('langPanel.category')}}">{{trans('langPanel.category')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.categorys.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.categoryInsert')}}">{{trans('langPanel.categoryInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.categorys.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.categoryList')}}">{{trans('langPanel.categoryList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>


            <li class=" nav-item"><a href="#"><i class="feather icon-check-circle"></i><span class="menu-title"
                                                                                             data-i18n="{{trans('langPanel.resume')}}">{{trans('langPanel.resume')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.resumes.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.resumeInsert')}}">{{trans('langPanel.resumeInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.resumes.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.resumeList')}}">{{trans('langPanel.resumeList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>


            <li class=" nav-item"><a href="#"><i class="feather icon-grid"></i><span class="menu-title"
                                                                                     data-i18n="{{trans('langPanel.portfolio')}}">{{trans('langPanel.portfolio')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.portfolios.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.portfolioInsert')}}">{{trans('langPanel.portfolioInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.portfolios.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.portfolioList')}}">{{trans('langPanel.portfolioList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>


            <li class=" nav-item"><a href="#"><i class="feather icon-server"></i><span class="menu-title"
                                                                                       data-i18n="{{trans('langPanel.skills')}}">{{trans('langPanel.skills')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.skills.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.skillsInsert')}}">{{trans('langPanel.skillsInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.skills.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.skillsList')}}">{{trans('langPanel.skillsList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>
            <li class=" nav-item"><a href="#"><i class="feather icon-award"></i><span class="menu-title"
                                                                                      data-i18n="{{trans('langPanel.counter')}}">{{trans('langPanel.counter')}}</span></a>
                <ul class="menu-content">
                    <li>
                        <a href="{{route('Admin.counters.create')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.counterInsert')}}">{{trans('langPanel.counterInsert')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('Admin.counters.index')}}">
                            <i class="feather icon-circle"></i>
                            <span class="menu-item"
                                  data-i18n="{{trans('langPanel.counterList')}}">{{trans('langPanel.counterList')}}</span>
                        </a>
                    </li>
                </ul>
            </li>


        </ul>
    </div>
</div>
<!-- END: Main Menu-->


@yield('content')

<div class="sidenav-overlay"></div>
<div class="drag-target"></div>

<!-- BEGIN: Footer-->
<footer class="footer footer-static footer-light">
    <p class="clearfix blue-grey lighten-2 mb-0">
        <span class="float-md-left d-block d-md-inline-block mt-25">تمامی حقوق محفوظ است <a
                class="text-bold-800 grey darken-2" href="setinco.com" target="_blank">setinco</a></span><span
            class="float-md-right d-none d-md-block">طراحی و توسعه  ستین<i class="feather icon-heart pink"></i> </span>
        <button class="btn btn-primary btn-icon scroll-top" type="button"><i class="feather icon-arrow-up"></i></button>
    </p>
</footer>
<!-- END: Footer-->


<!-- BEGIN: Vendor JS-->
<script src="{{ asset('Admin/app-assets/vendors/js/vendors.min.js')}}"></script>
<!-- BEGIN Vendor JS-->

<script src="{{ asset('Admin/app-assets/vendors/js/extensions/dropzone.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/tables/datatable/datatables.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/tables/datatable/dataTablesSelect.min.js')}}"></script>

<script src="{{ asset('Admin/app-assets/vendors/js/charts/apexcharts.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/extensions/tether.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/extensions/shepherd.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/extensions/jquery.steps.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/forms/validation/jquery.validate.min.js')}}"></script>
<script src="{{ asset('Admin/app-assets/vendors/js/forms/validation/jqBootstrapValidation.js')}}"></script>


<!-- END: Page Vendor JS-->

<!-- BEGIN: Theme JS-->
<script src="{{ asset('Admin/app-assets/js/core/app-menu.js')}}"></script>
<script src="{{ asset('Admin/app-assets/js/core/app.js')}}"></script>
<script src="{{ asset('Admin/app-assets/js/scripts/components.js')}}"></script>
<script src="{{ asset('Admin/app-assets/js/scripts/forms/validation/form-validation.js')}}"></script>
<script src="{{ asset('Admin/app-assets/js/scripts/ui/data-list-view.js')}}"></script>

<!-- BEGIN: Page JS-->
<script src="https://unpkg.com/axios/dist/axios.min.js"></script>
<script src="{{ asset('Admin/app-assets/tinymce/tinymce.min.js')}}"></script>
<script src="https://cdn.tiny.cloud/1/ky776fcfzivsxgjcd0oftwbo4z4qlhozznrgmbpopgq4a587/tinymce/5/tinymce.min.js"
        referrerpolicy="origin"></script>
<script src="{{ asset('Admin/app-assets/js/script.js')}}"></script>
<!-- END: Page Vendor JS-->


@yield("script")

<!-- END: Page Vendor JS-->

<!-- BEGIN: Theme JS-->


{{--deletereCord--}}
<script>
    var url = window.location.href;
    $('.navigation  li').each(function () {

        var href = $(this).find('a').attr('href');
        if (url == href) {
            $(this).parents("li").addClass('sidebar-group-active open');
            $(this).addClass('active');
        }
    });

    function deleteRecord(urlSuccess) {
        Swal.fire({
            title: '{{trans('langPanel.are_you_sure?')}}',
            text: "{{trans('langPanel.you_will_not_be_able_to_restore_after_deletion')}}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '{{trans('langPanel.yes')}}',
            cancelButtonText: '{{trans('langPanel.cancel_operations')}}'
        }).then((result) => {
            if (result.value) {
                window.location.replace(urlSuccess)
            }
        })
    }

    function confirmation(urlSuccess) {
        Swal.fire({
            title: '{{trans('langPanel.are_you_sure?')}}',
            text: "{{trans('langPanel.Do_you_agree')}}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '{{trans('langPanel.yes')}}',
            cancelButtonText: '{{trans('langPanel.cancel_operations')}}'
        }).then((result) => {
            if (result.value) {
                window.location.replace(urlSuccess)
            }
        })
    }



        @if(!empty(session()->getOldInput()))
    var oldValus =
    {!!  json_encode(session()->getOldInput()) !!}
        for (var i in oldValus)
        $("[name='" + i + "']").val(oldValus[i]);
        @endif

        @isset($errors)
    var errors ={!! $errors !!};
    $.each(errors, function (index, value) {
        $("[name='" + index + "']").css('border-color', 'red');
        $("[data-id='" + index + "']").css('border-color', 'red');
    });
    @endisset

</script>


{{--end deletereCord--}}

<script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
<script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>

<script type="text/javascript">
    $(document).ready(function () {
        $(".Datepick").persianDatepicker({
            observer: true,
            format: 'YYYY/MM/DD',
            initialValueType: 'persian'
        });
    });
</script>

</body>
<!-- END: Body-->

</html>
