@extends('Layouts.adminLayout')
@section('title')
    |{{trans('langPanel.portfolioEdit')}}
@endsection
@section('content')
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#">{{trans('langPanel.panel')}}</a>
                                    </li>
                                    <li class="breadcrumb-item"><a href="#">{{trans('langPanel.portfolio')}}</a>
                                    </li>
                                    <li class="breadcrumb-item active"><a
                                            href="#">{{trans('langPanel.portfolioEdit')}}</a>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="content-body">
                <!-- Basic Horizontal form layout section start -->
                <section id="basic-horizontal-layouts">
                    <div class="row match-height row justify-content-center">

                        <div class=" col-md-10 col-12">
                            <div class="card">
                                @include('Layouts.msg')

                                <div class="card-header">
                                    <h4 class="card-title">{{trans('langPanel.portfolioEdit')}}</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <form class="form-horizontal" method="POST"
                                              action="{{route('Admin.portfolios.update',$data['Portfolio']->id)}}"
                                              enctype="multipart/form-data"
                                              novalidate>
                                            @CSRF
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>{{trans('langPanel.title')}}</label>
                                                        <div class="controls">
                                                            <input type="text" name="title" class="form-control"
                                                                   data-validation-required-message="{{trans('langPanel.inputTitle')}}"
                                                                   placeholder="{{trans('langPanel.inputTitle')}}"
                                                                   required value="{{$data['Portfolio']->title}}">
                                                        </div>
                                                    </div>


                                                    <div class="form-group">
                                                        <label>{{trans('langPanel.category')}}</label>
                                                        <div class="controls">
                                                            <div class="form-group">
                                                                <select class="select2 form-control" name="category"
                                                                        id="category">
                                                                    @foreach($data['Categorys'] as $Category)

                                                                        <option
                                                                            value="{{$Category->id}}">{{$Category->title}}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">

                                                    <div class="form-group">
                                                        <label>{{trans('langPanel.end_date')}}</label>
                                                        <div class="controls">
                                                            <input type="text" name="end_date" class="form-control Datepick"
                                                                   data-validation-required-message="{{trans('langPanel.end_dateInput')}}"
                                                                   placeholder="{{trans('langPanel.end_dateInput')}}"
                                                                   required value="{{$data['Portfolio']->end_date}}">
                                                        </div>
                                                    </div>


                                                    <fieldset class="form-group">
                                                        <label
                                                            for="basicInputFile">{{trans('langPanel.choose_file')}}</label>
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input"
                                                                   id="inputGroupFile01" name="file">
                                                            <label class="custom-file-label"
                                                                   for="inputGroupFile01">{{trans('langPanel.upload')}}</label>
                                                        </div>
                                                    </fieldset>

                                                </div>
                                                <div class="media mb-2">
                                                    <a class="mr-2 my-25">
                                                        <img src="/{{$data['Portfolio']->image}}"
                                                             alt="{{$data['Portfolio']->title}}"
                                                             class="users-avatar-shadow rounded" height="90" width="90">
                                                    </a>

                                                </div>

                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                       <textarea id="full-featured-non1" class="fullpremium"
                                                 name="text">
												 {{$data['Portfolio']->text}}
                                       </textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-2 offset-md-10">
                                                <button type="submit"
                                                        class="btn btn-primary">{{trans('langPanel.update')}}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- // Basic Horizontal form layout section end -->


            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
            @isset($data['Portfolioc']->id )
        var val ={!! $data['Portfolioc']->id !!};
        $('#category option[value=' + val + ']').attr('selected', 'selected');
        @endisset
    </script>


@endsection

