<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class Portfolios extends FormRequest
{

    protected $rules = [
        'title' => 'required:max:30',
        'category' => 'required:max:30',
        'end_date' => 'required:max:30',
        'file' => 'required|image|dimensions:max_width:37,max_height:37',
    ];

    public function authorize()
    {
        if (\Request::route()->getName() == "Admin.portfolios.update") {
            $this->rules['file'] = 'nullable';
        }

        return true;
    }

    public function rules()
    {
        return $this->rules;
    }
}
