<?php
/* template name: Portfolio */
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
?>
<div class="page-wrap archive-portfolio">
    <div class="container-lg">
        <div class="row">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="page-title  wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo get_the_title(); ?>
                    </h1>
                    <?php get_template_part('templates/content/breadcrumb'); ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-lg-10 mx-auto">
                <div class="isotope-toolbar">
                    <button class="isotope-toolbar-btn active" data-type="*" name="isotope-filter">
                        <span>همه</span>
                    </button>

                    <?php
                    $terms = get_terms(array(
                        'taxonomy'   => 'portfolio_category',
                        'hide_empty' => true,
                    ));
                
                    if (!is_wp_error($terms) && !empty($terms)) :
                        foreach ($terms as $term) :
                    ?>
                        <button class="isotope-toolbar-btn"
                                data-type="<?php echo esc_attr($term->slug); ?>"
                                name="isotope-filter">
                            <span><?php echo esc_html($term->name); ?></span>
                        </button>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </div>

                <div class="row mx-auto isotope-box">
                    <?php
                    $args = array(
                        'post_type' => 'portfolio',
                        'paged' => $paged,
                        'post_status ' => 'publish',
                        'posts_per_page' => '16',
                    );
                    $posts = new WP_Query($args);
                    if ($posts->have_posts()):
                        $i = 0.25;
                        while ($posts->have_posts()) : $posts->the_post();
                        $terms = get_the_terms(get_the_ID(), 'portfolio_category');
                        $term_slugs = [];
                        if (!is_wp_error($terms) && !empty($terms)) {
                            foreach ($terms as $term) {
                                $term_slugs[] = $term->slug;
                            }
                        }
                
                        $data_type = implode(' ', $term_slugs);
                ?>
                        <div class="col-6 col-sm-6 col-md-4 mb-4 isotope-item"  data-type="<?php echo esc_attr($data_type); ?>" >
                            <?php get_template_part('templates/card/portfolio', 'card'); ?>
                        </div>
                    <?php $i += 0.25; endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                    <div class="col col-12">
                        <div class="site-pagination">
                            <?php pagination_bar($posts); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php get_footer('inner'); ?>
