<?php
/* template name: Blog */
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
?>
<div class="page-wrap archive-blog">
    <div class="container-lg">
        <div class="row">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="page-title  wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo get_the_title(); ?>
                    </h1>
                    <?php get_template_part('templates/content/breadcrumb'); ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-md-8 col-lg-9 order-md-last">
                <div class="row">
                    <?php
                    $args = array(
                        'post_type' => 'post',
                        'paged' => $paged,
                        'post_status ' => 'publish',
                    );
                    $posts = new WP_Query($args);
                    if ($posts->have_posts()):
                        $i = 0.25;
                        while ($posts->have_posts()) : $posts->the_post();
                            ?>
                            <div class="col-12 col-sm-6 col-lg-4 mb-4 wow fadeInUp" data-wow-delay="<?php echo $i; ?>s">
                                <?php get_template_part('templates/card/blog', 'card'); ?>
                            </div>
                    <?php $i += 0.25; endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                    <div class="col col-12">
                        <div class="site-pagination">
                            <?php pagination_bar($posts); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 col-lg-3 order-md-first">
                <?php get_sidebar(); ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer('inner'); ?>
