jQuery(document).ready(function ($) {
    "use strict";
    new WOW().init();

    $(window).scroll(function(){
        var headerHeight = $('.site-header').outerHeight();
        if ($(window).scrollTop() >= headerHeight) {
            $('.site-header').addClass('fixed-header');
        }
        else {
            $('.site-header').removeClass('fixed-header');
        }
    });
});


(function ($) {
    var opener = $(".mobile-menu-btn");
    var pushClass = "";
    var menuItems = $(".unxw-fullscreen-menu > ul > li > a");

    var delayStep = 70;

    function addStagger() {
        menuItems.each(function (i) {
            $(this).css({
                "animation-delay": (delayStep * (i + 1)) + "ms"
            });
        });
    }

    if (!opener.length) return;

    if ($("body").hasClass("unxw-fade-push-text-right")) {
        pushClass = "unxw-push-nav-right";
    } else if ($("body").hasClass("unxw-fade-push-text-top")) {
        pushClass = "unxw-push-text-top";
    }

    opener.on("click", function (e) {
        e.preventDefault();

        var body = $("body");

        if (opener.hasClass("unxw-fm-opened")) {
            opener.removeClass("unxw-fm-opened");
            body.removeClass("unxw-fullscreen-menu-opened unxw-fullscreen-fade-in")
                .addClass("unxw-fullscreen-fade-out")
                .addClass(pushClass)
                .css("overflow", "");

            $("nav.unxw-fullscreen-menu ul.sub_menu").slideUp(200);

        } else {
            // Open
            opener.addClass("unxw-fm-opened");
            body.removeClass("unxw-fullscreen-fade-out " + pushClass)
                .addClass("unxw-fullscreen-menu-opened unxw-fullscreen-fade-in")
                .css("overflow", "hidden");

            addStagger() 

            $(document).on("keyup.fullscreenClose", function (e) {
                if (e.keyCode === 27) {
                    opener.removeClass("unxw-fm-opened");
                    body.removeClass("unxw-fullscreen-menu-opened unxw-fullscreen-fade-in")
                        .addClass("unxw-fullscreen-fade-out")
                        .addClass(pushClass)
                        .css("overflow", "");

                    $("nav.unxw-fullscreen-menu ul.sub_menu").slideUp(200);
                    clearMenuAnimation();
                    $(document).off("keyup.fullscreenClose");
                }
            });
        }
    });
    
    
    
    var $box = $(".isotope-box").isotope({
      itemSelector: ".isotope-item",
      originLeft: false,
    });

    $(".isotope-toolbar").on("click", "button", function () {
      var filterValue = $(this).attr("data-type");
      $(".isotope-toolbar-btn").removeClass("active");
      $(this).addClass("active");
      if (filterValue !== "*") {
        filterValue = '[data-type="' + filterValue + '"]';
      }
      console.log(filterValue);
      $box.isotope({ filter: filterValue });
    });
    

})(jQuery);

// const interleaveOffset = 0.75;

// var portfolioSwiper = new Swiper('.single-portfolio .swiper-container', {
//   direction: 'vertical',
//   speed: 800,
//   mousewheelControl: true,
//   watchSlidesProgress: true,
//   mousewheel: {
//     releaseOnEdges: true,
//   },
//   pagination: {
//     el: '.swiper-pagination',
//     clickable: false,
//     type: 'bullets',
//     renderBullet: function (index, className) {
//       return '<span class="' + className + '">' + ('0' + (index + 1)) + '</span>';
//     }
//   },
//   on: {
//     progress: function() {
//       let swiper = this;

//       for (let i = 0; i < swiper.slides.length; i++) {
//         let slideProgress = swiper.slides[i].progress;
//         let innerOffset = swiper.height * interleaveOffset;
//         let innerTranslate = slideProgress * innerOffset;

//         TweenMax.set(swiper.slides[i].querySelector(".slide-inner"), {
//           y: innerTranslate,
//         });
//       }
//     },
//     setTransition: function(slider, speed) {
//       let swiper = this;
//       for (let i = 0; i < swiper.slides.length; i++) {
//         swiper.slides[i].style.transition = speed + "ms";
//         swiper.slides[i].querySelector(".slide-inner").style.transition =
//           speed + "ms";
//       }
//     }
//   }
// });



// const interleaveOffset = 0.75;
// const portfolioSwiper = new Swiper('.single-portfolio .swiper-container', {
//   direction: 'vertical',
//   speed: 800,
//   allowTouchMove: false,
//   watchSlidesProgress: true,
//   on: {
//     progress() {
//       const swiper = this;

//       swiper.slides.forEach(slide => {
//         const slideProgress = slide.progress;
//         const innerOffset = swiper.height * interleaveOffset;
//         const innerTranslate = slideProgress * innerOffset;

//         gsap.set(slide.querySelector('.slide-inner'), {
//           y: innerTranslate
//         });
//       });
//     },
//     setTransition(swiper, speed) {
//       swiper.slides.forEach(slide => {
//         slide.style.transition = `${speed}ms`;
//         slide.querySelector('.slide-inner').style.transition = `${speed}ms`;
//       });
//     }
//   }
// });


// let canScroll = true;
// let accumulatedDelta = 0;
// const SCROLL_TRIGGER = 80;
// let allowPageScroll = false;

// const section = document.querySelector('.single-portfolio');

// portfolioSwiper.on('slideChangeTransitionEnd', () => {
//   canScroll = true;

//   const isLast =
//     portfolioSwiper.activeIndex === portfolioSwiper.slides.length - 1;

//   allowPageScroll = isLast;
// });

// section.addEventListener(
//   'wheel',
//   (e) => {

//     if (allowPageScroll && e.deltaY > 0) {
//       return;
//     }


//     if (portfolioSwiper.activeIndex === 0 && e.deltaY < 0) {
//       return;
//     }

//     e.preventDefault();

//     if (!canScroll) return;

//     accumulatedDelta += e.deltaY;

//     if (Math.abs(accumulatedDelta) < SCROLL_TRIGGER) return;

//     canScroll = false;

//     if (accumulatedDelta > 0) {
//       portfolioSwiper.slideNext();
//     } else {
//       portfolioSwiper.slidePrev();
//     }

//     accumulatedDelta = 0;
//   },
//   { passive: false }
// );



const mqDesktop = window.matchMedia('(min-width: 991px)');

let portfolioSwiper = null;
let wheelHandler = null;

/* =========================
   DESKTOP SWIPER (991+)
========================= */
// function initDesktopSwiper() {
//   const interleaveOffset = 0.75;

//   portfolioSwiper = new Swiper('.single-portfolio .swiper-container', {
//     direction: 'vertical',
//     speed: 800,
//     allowTouchMove: false,
//     watchSlidesProgress: true,
//     on: {
//       progress() {
//         const swiper = this;

//         swiper.slides.forEach(slide => {
//           const slideProgress = slide.progress;
//           const innerOffset = swiper.height * interleaveOffset;
//           const innerTranslate = slideProgress * innerOffset;

//           gsap.set(slide.querySelector('.slide-inner'), {
//             y: innerTranslate
//           });
//         });
//       },
//       setTransition(swiper, speed) {
//         swiper.slides.forEach(slide => {
//           slide.style.transition = `${speed}ms`;
//           slide.querySelector('.slide-inner').style.transition = `${speed}ms`;
//         });
//       }
//     }
//   });

//   let canScroll = true;
//   let accumulatedDelta = 0;
//   const SCROLL_TRIGGER = 80;
//   let allowPageScroll = false;

//   const section = document.querySelector('.single-portfolio');

//   portfolioSwiper.on('slideChangeTransitionEnd', () => {
//     canScroll = true;
//     allowPageScroll =
//       portfolioSwiper.activeIndex === portfolioSwiper.slides.length - 1;
//   });

//   wheelHandler = (e) => {
//     if (allowPageScroll && e.deltaY > 0) return;
//     if (portfolioSwiper.activeIndex === 0 && e.deltaY < 0) return;

//     e.preventDefault();
//     if (!canScroll) return;

//     accumulatedDelta += e.deltaY;
//     if (Math.abs(accumulatedDelta) < SCROLL_TRIGGER) return;

//     canScroll = false;

//     accumulatedDelta > 0
//       ? portfolioSwiper.slideNext()
//       : portfolioSwiper.slidePrev();

//     accumulatedDelta = 0;
//   };

//   section.addEventListener('wheel', wheelHandler, { passive: false });
// }


function initDesktopSwiper() {
  const section = document.querySelector('.single-portfolio');
  const slidesCount =
    section.querySelectorAll('.swiper-slide').length;

  /* اگر فقط یک اسلاید داریم → اسکرول آزاد */
  if (slidesCount <= 1) {
    portfolioSwiper = new Swiper('.single-portfolio .swiper-container', {
      direction: 'vertical',
      speed: 800,
      allowTouchMove: false
    });

    return; // هیچ wheelای اضافه نمی‌کنیم
  }

  /* =========================
     حالت چند اسلاید (کد اصلی)
  ========================= */
  const interleaveOffset = 0.75;

  portfolioSwiper = new Swiper('.single-portfolio .swiper-container', {
    direction: 'vertical',
    speed: 800,
    allowTouchMove: false,
    watchSlidesProgress: true,
    on: {
      progress() {
        const swiper = this;

        swiper.slides.forEach(slide => {
          const slideProgress = slide.progress;
          const innerOffset = swiper.height * interleaveOffset;
          const innerTranslate = slideProgress * innerOffset;

          gsap.set(slide.querySelector('.slide-inner'), {
            y: innerTranslate
          });
        });
      },
      setTransition(swiper, speed) {
        swiper.slides.forEach(slide => {
          slide.style.transition = `${speed}ms`;
          slide.querySelector('.slide-inner').style.transition = `${speed}ms`;
        });
      }
    }
  });

  let canScroll = true;
  let accumulatedDelta = 0;
  const SCROLL_TRIGGER = 80;
  let allowPageScroll = false;

  portfolioSwiper.on('slideChangeTransitionEnd', () => {
    canScroll = true;
    allowPageScroll =
      portfolioSwiper.activeIndex === portfolioSwiper.slides.length - 1;
  });

  wheelHandler = (e) => {
    // if (allowPageScroll && e.deltaY > 0) return;
    
    if (
    (allowPageScroll && e.deltaY > 0) ||
      (portfolioSwiper.activeIndex === 0 && e.deltaY < 0)
    ) {
      return;
    }

    if (portfolioSwiper.activeIndex === 0 && e.deltaY < 0) return;

    e.preventDefault();
    if (!canScroll) return;

    accumulatedDelta += e.deltaY;
    if (Math.abs(accumulatedDelta) < SCROLL_TRIGGER) return;

    canScroll = false;

    accumulatedDelta > 0
      ? portfolioSwiper.slideNext()
      : portfolioSwiper.slidePrev();

    accumulatedDelta = 0;
  };

  section.addEventListener('wheel', wheelHandler, { passive: false });
}


/* =========================
   MOBILE SWIPER
========================= */
function initMobileSwiper() {
  portfolioSwiper = new Swiper('.single-portfolio .swiper-container', {
     direction: 'horizontal',
    speed: 700,
    allowTouchMove: true,
    autoplay: {
      delay: 3000,
      disableOnInteraction: false
    }
  });
}

/* =========================
   DESTROY
========================= */
function destroySwiper() {
  const section = document.querySelector('.single-portfolio');

  if (wheelHandler) {
    section.removeEventListener('wheel', wheelHandler);
    wheelHandler = null;
  }

  if (portfolioSwiper) {
    portfolioSwiper.destroy(true, true);
    portfolioSwiper = null;
  }
}
 
/* =========================
   RESPONSIVE SWITCH 
========================= */
function handleResponsive(e) {
  destroySwiper();

  if (e.matches) {
    initDesktopSwiper(); // ≥ 991px
  } else {
    initMobileSwiper();  // < 991px
  }
}

handleResponsive(mqDesktop);
mqDesktop.addEventListener('change', handleResponsive);

