<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-6">
                <?php
                /**
                 * Hook: woocommerce_before_single_product_summary.
                 *
                 * @hooked woocommerce_show_product_sale_flash - 10
                 * @hooked woocommerce_show_product_images - 20
                 */
                do_action( 'woocommerce_before_single_product_summary' );
                ?>
            </div>
            <div class="col-12 col-md-6">
                <div class="summary entry-summary">
                    <?php
                    /**
                     * Hook: woocommerce_single_product_summary.
                     *
                     * @hooked woocommerce_template_single_title - 5
                     * @hooked woocommerce_template_single_rating - 10
                     * @hooked woocommerce_template_single_price - 10
                     * @hooked woocommerce_template_single_excerpt - 20
                     * @hooked woocommerce_template_single_add_to_cart - 30
                     * @hooked woocommerce_template_single_meta - 40
                     * @hooked woocommerce_template_single_sharing - 50
                     * @hooked WC_Structured_Data::generate_product_data() - 60
                     */
                    do_action( 'woocommerce_single_product_summary' );
                    ?>
                </div>
            </div>
        </div>
    </div>
	<?php
	/**
	 * Hook: woocommerce_after_single_product_summary.
	 *
	 * @hooked woocommerce_output_product_data_tabs - 10
	 * @hooked woocommerce_upsell_display - 15
	 * @hooked woocommerce_output_related_products - 20
	 */
	do_action( 'woocommerce_after_single_product_summary' );
	?>

    <section class="single-product_info">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6">
                    <?php
                        $attributes = $product->get_attributes();

                        if ( ! $attributes ) {
                            return;
                        }

                        echo '<ul class="product-attributes">';

                        foreach ( $attributes as $attribute ) {

                            if ( $attribute->is_taxonomy() ) {
                                $values = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'names' ) );
                                $value = implode( ', ', $values );
                            } else {
                                $value = $attribute->get_options();
                                $value = implode( ', ', $value );
                            }

                            echo '<li><strong>' . wc_attribute_label( $attribute->get_name() ) . ':</strong> ' . esc_html( $value ) . '</li>';
                        }

                        echo '</ul>';
                    ?>
                </div>

                <?php
                if( have_rows('chart_acord') ): ?>
                    <div class="col-12 col-md-6">
                        <div class="row row-cols-md-5">
                            <?php while( have_rows('chart_acord') ) : the_row();
                                $chart_title = get_sub_field('chart_aq');
                                $aq_val  = $chart_title['value'];
                                $sep_aq = explode(" - ", $aq_val);

                                $white_items = array("violet", "cacao", "patchouli", "animalic", "Cannabi", "camphor", "Amber" , "Smoky" , "Oud" , "Marine" , "Tobacco" , "Warm Spice" , "Green" , "coffee" , "Earthy" , "Woody" , "Leather" , "Sweet" , "Rose" , "Iris" , "Cinnamon" , "Cannabi" , "animalic" , "patchouli" , "Conifer");
                                ?>
                                <div class="col acord-card text-center">
                                    <div class="acord-image">
                                        <img src="" alt="">
                                    </div>
                                    <h5 class="acord-title">
                                        <?php echo $chart_title['label']; ?>
                                    </h5>
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" style="width: <?php the_sub_field('value'); ?>%; color: <?php echo in_array($sep_aq[0], $white_items) ? '#fff' : '#000'; ?>; background-color: <?php echo $sep_aq[1]; ?> " aria-valuenow="<?php the_sub_field('value'); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section class="single-product_banner">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6">

                </div>
                <div class="col-12 col-md-6">

                </div>
            </div>
        </div>
    </section>

    <section class="single-product_poll">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-4">

                </div>
                <div class="col-12 col-md-4">

                </div>
                <div class="col-12 col-md-4">

                </div>
            </div>
        </div>
    </section>

    <?php
        $video_banner_title = get_field('video_banner_title');
        $video_title = get_field('video_title');
        $video_desc = get_field('video_desc');
        $video_image = get_field('video_image');
        $video_embed = get_field('video_embed');
    ?>
    <section class="single-product_video">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="introduce-video position-relative">
                        <div class="introduce-video_inner position-absolute">
                            <div class="introduce-video_caption">
                                <?php
                                    if($video_banner_title!='') {
                                        echo '<h3>'.$video_banner_title.'</h3>';
                                    }
                                    if($video_desc!='') {
                                        echo '<p>'.$video_desc.'</p>';
                                    }

                                    if($video_embed!='') {
                                ?>
                                <button type="button" class="video-modal_btn btn btn-primary" data-bs-toggle="modal" data-bs-target="#videoeModal">
                                    مشاهده ویدیو
                                    <i class="icon-arrow-left"></i>
                                </button>
                                <?php } ?>
                            </div>
                            <?php if( !empty( $video_image ) ): ?>
                            <div class="introduce-video_image">
                                <figure class="introduce-video_img">
                                    <img src="<?php echo $video_image['url']; ?>" width="<?php echo $video_image['width']; ?>" height="<?php echo $video_image['height']; ?>" alt="<?php echo $video_image['alt']; ?>">
                                </figure>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


</div>

<div class="modal modal-video fade" id="videoeModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <?php if($video_title!='') {
                    echo '<h5 class="modal-title" id="exampleModalLabel">'. $video_title. '</h5>';
                } ?>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo $video_embed; ?>
            </div>
        </div>
    </div>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
