<?php
function unixa_auth_user_detection_form(){
    ?>
    <div id="user_detection_form_wrapper">
        <form method="post" id="user_detection_form" novalidate="novalidate">
            <div class="field-wrapper">
				<label class="label mb-2">شماره موبایل</label>
				<input type="number" name="mobile" id="mobile" class="field ltr form-control mb-4" placeholder="09*********" maxlength="11">
            </div>

            <?php wp_nonce_field('auth_user_detection_nonce','auth_user_detection_nonce_field'); ?>
            <input type="hidden" name="action" value="unixa_auth_user_detection"/>
            <button type="submit" class="button">ارسال</button>
        </form>
    </div>
    <?php
}

function unixa_auth_user_login_form(){
    $auth_password_strategy = get_field('auth_password_strategy', 'option');
    ?>
    <div id="user_login_form_wrapper">
        <form method="post" id="user_login_form" novalidate="novalidate">
            <div class="field-wrapper">
				<label class="label">رمز عبور</label>
				<input type="number" name="password" id="password" class="field ltr form-control mb-4" placeholder="******" maxlength="6">
            </div>

			<div class="buttons-wrapper">
				<?php wp_nonce_field('auth_user_login_nonce','auth_user_login_nonce_field'); ?>
				<input type="hidden" name="action" value="unixa_auth_user_login"/>
				<button type="submit" class="button">ورود</button>

				<?php
				if($auth_password_strategy == 'otp'){
					$label = 'ارسال رمز عبور یکبار مصرف';
					$type = 'otp-password';
				}else{
					$label = 'بازیابی رمز عبور';
					$type = 'reset-password';
				}
				?>
				<div class="resend_code_wrapper">
					<span class="resend-code" data-type="<?php echo esc_attr($type); ?>"><?php echo esc_html($label); ?></span>
				</div>
			</div>
        </form>
    </div>
    <?php
}

function unixa_auth_user_register_form(){
    ?>
    <div id="user_register_form_wrapper">
        <form method="post" id="user_register_form" novalidate="novalidate">
            <div class="field-wrapper">
				<label class="label mb-2">کد تایید</label>
				<input type="number" name="verification_code" id="verification_code" class="field ltr form-control mb-4" placeholder="******" maxlength="6">
            </div>

			<div class="buttons-wrapper">
				<?php wp_nonce_field('auth_user_register_nonce','auth_user_register_nonce_field'); ?>
				<input type="hidden" name="action" value="unixa_auth_user_register"/>
				<button type="submit" class="button">عضویت</button>

				<div class="resend_code_wrapper">
					<span class="resend-code" data-type="verification-code">ارسال کد تایید</span>
				</div>
			</div>
        </form>
    </div>
    <?php
}

function unixa_auth_user_profile_form(){
    $password_strategy = get_field('auth_password_strategy', 'option');
    ?>
    <div id="user_profile_form_wrapper">
        <form method="post" id="user_profile_form" novalidate="novalidate">
			<div class="field-wrapper">
				<label class="label">نام</label>
				<input type="text" name="first_name" id="first_name" class="field form-control mb-4" placeholder="علی">
			</div>
			<div class="field-wrapper">
				<label class="label">نام خانوادگی</label>
				<input type="text" name="last_name" id="last_name" class="field form-control mb-4" placeholder="حسینی">
			</div>

			<div class="field-wrapper">
				<label class="label">آدرس ایمیل</label>
				<input type="email" name="email" id="email" class="field ltr form-control mb-4" placeholder="company@gamil.com">
			</div>


            <?php if($password_strategy == 'user_choice'){ ?>
            <div class="field-wrapper">
				<label class="label">رمز عبور</label>
				<input type="number" name="new_password" id="new_password" class="field ltr form-control mb-4" placeholder="******" maxlength="6">
            </div>
            <?php } ?>

            <div class="field-wrapper">
				<label class="label">جنسیت</label>
				<div class="form-check-wrap mb-4">
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="gender" id="gender_male" value="male" checked>
						<label class="form-check-label" for="gender_male">آقا</label>
					</div>
					<div class="form-check form-check-inline">
						<input class="form-check-input" type="radio" name="gender" id="gender_female" value="female">
						<label class="form-check-label" for="gender_female">خانم</label>
					</div>
				</div>
            </div>

            <?php wp_nonce_field('auth_user_profile_nonce','auth_user_profile_nonce_field'); ?>
            <input type="hidden" name="action" value="unixa_auth_user_profile"/>
            <button type="submit" class="button">تکمیل عضویت</button>
        </form>
    </div>
    <?php
}
