<?php
$discount_title = get_field('discount_title', 'option');
$expire_date = get_field('expire_date', 'option');
$timestamp = strtotime($expire_date);

$current_time = time();
$deal_active = ($timestamp > $current_time);
?>
<section class="slider-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-7">
                <?php if (have_rows('add_slider', 'option')): ?>
                    <div class="home-slider position-relative" id="slider">
                        <div class="swiper-container main-slider">
                            <div class="swiper-wrapper">
                                <?php while (have_rows('add_slider', 'option')) : the_row();
                                    $slider_title = get_sub_field('slider_title', 'option');
                                    $slider_link = get_sub_field('slider_link', 'option');
                                    $slider_image = get_sub_field('slider_image', 'option');
                                    ?>
                                    <div class="swiper-slide">
                                        <img src="<?php echo esc_url($slider_image['url']); ?>"
                                             width="<?php echo esc_attr($slider_image['width']); ?>"
                                             height="<?php echo esc_attr($slider_image['height']); ?>"
                                             alt="<?php echo esc_attr($slider_title); ?>" class="animated fadeInLeft">
                                        <div class="slider-caption">
                                            <?php if ($slider_title != ''): ?>
                                                <h2 class="caption-title animated fadeInUp"><?php echo esc_html($slider_title); ?></h2>
                                            <?php endif; ?>

                                            <?php if ($slider_link != ''): ?>
                                                <a href="<?php echo esc_url($slider_link); ?>"
                                                   class="button animated fadeInUp"> همین حالا بخرید
                                                    <i class="icon-arrow-left"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                            </div>

                            <!-- Swiper Navigation -->
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-12 col-md-5">
                <div class="discount-daily_wrapper">
                    <div class="discount-daily_head d-flex justify-content-between align-items-center">
                        <?php if($discount_title != '') { ?>
                        <h3 class="discount-daily_title">
                            <?php echo esc_html($discount_title); ?>
                        </h3>
                        <?php }
                        if($deal_active):
                        ?>

                        <ul class="discount-daily_countdown d-flex" id="countdown">
                            <li class="d-flex flex-column"><span class="days"></span> روز</li>
                            <li class="d-flex flex-column"><span class="hours"></span> ساعت</li>
                            <li class="d-flex flex-column"><span class="minutes"></span> دقیقه </li>
                            <li class="d-flex flex-column"><span class="seconds"></span> ثانیه</li>
                        </ul>
                        <?php endif; ?>
                    </div>

                    <?php if ($deal_active): ?>
                    <ul>
                        <?php
                        $args = array(
                            'post_type' => 'product',
                            'posts_per_page' => -1,
                            'meta_query' => array(
                                array(
                                    'key' => 'is_flash_deal',
                                    'value' => '1',
                                    'compare' => '='
                                )
                            )
                        );
                        $flash_deals = new WP_Query($args);
                        if($flash_deals->have_posts()):
                            while($flash_deals->have_posts()): $flash_deals->the_post();
                                $product = wc_get_product(get_the_ID());
                                set_query_var('product', $product);
                                get_template_part('templates/card/small-product-card');
                             endwhile;
                        endif; wp_reset_postdata(); ?>
                    </ul>
                    <?php else: ?>
                        <div class="flash-deal-expired">
                            <p>تخفیف ویژه به پایان رسید!</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
