<?php
$product = get_query_var('product');
if ( ! $product ) return;
?>

<li class="discount-product_card">
    <div class="product-card-header">
        <span class="flash-icon">🔥</span>
    </div>

    <div class="product-card-body">
        <div class="product-image">
            <a href="<?php echo get_permalink( $product->get_id() ); ?>">
                <?php echo $product->get_image( 'woocommerce_thumbnail' ); ?>
            </a>
        </div>

        <div class="product-info">
            <h3 class="product-title">
                <a href="<?php echo get_permalink( $product->get_id() ); ?>">
                    <?php echo $product->get_name(); ?>
                </a>
            </h3>

            <div class="product-price">
                <?php if ( $product->get_sale_price() ) : ?>
                    <span class="regular-price">
                        <?php echo wc_price( $product->get_regular_price() ); ?>
                    </span>
                    <span class="sale-price">
                        <?php echo wc_price( $product->get_sale_price() ); ?>
                    </span>
                <?php else : ?>
                    <span class="regular-price">
                        <?php echo wc_price( $product->get_price() ); ?>
                    </span>
                <?php endif; ?>
            </div>

            <?php
            $a5_terms = wc_get_product_terms(
                $product->get_id(),
                'pa_a5',
                array( 'fields' => 'names' )
            );

            if ( ! empty( $a5_terms ) && ! is_wp_error( $a5_terms ) ) :
                ?>
                <div class="product-volume_items d-flex">
                    <?php foreach ( $a5_terms as $term_name ) : ?>
                        <span class="variant"><?php echo esc_html( $term_name ); ?></span>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

        </div>
    </div>
</li>
