<?php
defined('ABSPATH') || exit;
global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
    return;
}
?>
<div <?php wc_product_class('product-item', $product); ?>>
    <div class="product-media position-relative text-center">
        <?php woocommerce_show_product_loop_sale_flash(); ?>
        <?php if(get_field('new_product')!='') {
            echo '<span class="new-badge"></span>';
        } ?>
        <a class="entry-media" href="<?php echo get_permalink(); ?>">
            <?php woocommerce_template_loop_product_thumbnail(); ?>
        </a>
    </div>
    <div class="entry-wrapper">
        <h2 class="entry-title woocommerce-loop-product__title">
            <a href="<?php echo get_permalink(); ?>" title="<?php echo get_the_title(); ?>">
                <?php echo get_the_title(); ?>
            </a>
        </h2>
        <div class="d-flex justify-content-between align-items-center">
            <?php echo woocommerce_template_loop_price(); ?>
            <?php echo woocommerce_template_loop_add_to_cart(); ?>
        </div>
    </div>
</div>
