<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
global $wp_query;
$tag_id = $wp_query->get_queried_object_id();
?>
<div class="page-wrap category-blog">
    <div class="page-header-wrap">
        <div class="container">
            <div class="row page-header">
                <div class="col-12 text-center">
                    <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo single_tag_title(); ?>
                    </h1>
                    <?php if (tag_description() != '') { ?>
                        <div class="entry-description wow fadeInUp" data-wow-delay="0.5s">
                            <?php echo tag_description(); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-9 order-first order-lg-last">
                <div class="site-post-archive">
                    <div class="row">
                        <?php
                        $args = array(
                            'post_type' => 'post',
                            'paged' => $paged,
                            'post_status ' => 'publish',
                            'tag_id' => $tag_id,
                        );
                        $posts = new WP_Query($args);
                        if ($posts->have_posts()):
                            $i = 0.25;
                            while ($posts->have_posts()) : $posts->the_post();
                                ?>
                                <div class="col-12 col-sm-6 col-md-4 wow fadeInUp" data-wow-delay="<?php echo $i; ?>s">
                                    <?php get_template_part('templates/card/blog', 'card'); ?>
                                </div>
                         <?php $i += 0.25; endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>


                        <div class="col col-12">
                            <div class="site-pagination">
                                <?php pagination_bar($posts); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-3 order-last order-lg-first">
                <?php get_sidebar(); ?>
            </div>
        </div>

    </div>
</div>
<?php get_footer(); ?>


