<?php
    defined('ABSPATH') || exit;

    add_action('wp_ajax_custom_add_to_cart', 'custom_add_to_cart');
    add_action('wp_ajax_nopriv_custom_add_to_cart', 'custom_add_to_cart');
    function custom_add_to_cart() {
        check_ajax_referer('cart_nonce', 'nonce');

        $product_id   = absint($_POST['product_id']);
        $variation_id = absint($_POST['variation_id']);
        $quantity     = absint($_POST['quantity']);
        $attributes   = isset($_POST['attributes']) ? (array) $_POST['attributes'] : [];

        if ($variation_id && ! empty($attributes)) {
            WC()->cart->add_to_cart(
                $product_id,
                $quantity,
                $variation_id,
                $attributes
            );
        } else {
            WC()->cart->add_to_cart($product_id, $quantity);
        }

        wp_die();
    }

    add_action('wp_ajax_custom_update_cart', 'custom_update_cart');
    add_action('wp_ajax_nopriv_custom_update_cart', 'custom_update_cart');

    function custom_update_cart()
        {
        check_ajax_referer('cart_nonce', 'nonce');

        foreach (WC()->cart->get_cart() as $key => $item) {
        if (
        $item['product_id'] == $_POST['product_id'] &&
        $item['variation_id'] == $_POST['variation_id']
        ) {
        WC()->cart->set_quantity($key, absint($_POST['quantity']));
        break;
        }
        }
        wp_die();
    }

    add_action('wp_ajax_custom_remove_cart', 'custom_remove_cart');
    add_action('wp_ajax_nopriv_custom_remove_cart', 'custom_remove_cart');

    function custom_remove_cart()
    {
        check_ajax_referer('cart_nonce', 'nonce');

        foreach (WC()->cart->get_cart() as $key => $item) {
        if (
        $item['product_id'] == $_POST['product_id'] &&
        $item['variation_id'] == $_POST['variation_id']
        ) {
        WC()->cart->remove_cart_item($key);
        break;
        }
        }
        wp_die();
    }



    // AJAX برای گرفتن محتویات سبد خرید (هم برای کاربر لاگین و هم مهمان)
    add_action('wp_ajax_get_cart_contents', 'get_cart_contents');
    add_action('wp_ajax_nopriv_get_cart_contents', 'get_cart_contents');

    function get_cart_contents() {
        if (!WC()->cart) {
            wp_send_json([]);
        }

        $cart_items = [];

        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
            $cart_items[] = [
                'product_id'   => $cart_item['product_id'],
                'variation_id' => isset($cart_item['variation_id']) ? $cart_item['variation_id'] : 0,
                'quantity'     => $cart_item['quantity'],
            ];
        }

        wp_send_json($cart_items);
    }
?>
