<?php
// After setup theme hook adds WC support
function mytheme_add_woocommerce_support()
{
    add_theme_support('woocommerce'); //
    remove_theme_support( 'wc-product-gallery-zoom' );
    remove_theme_support( 'wc-product-gallery-lightbox' );
    remove_theme_support( 'wc-product-gallery-slider' );
}
add_action('after_setup_theme', 'mytheme_add_woocommerce_support');


//Change the order of filter in product archive
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);

remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 10);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price' , 10);
remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );

add_action('template_redirect', 'remove_sidebar_shop');

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 30 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 40 );


add_action( 'woocommerce_before_shop_loop_item', 'custom_product_link_open', 10 );
function custom_product_link_open() {
    echo '<a href="' . esc_url( get_the_permalink() ) . '" class="product-card_link">';
}

add_action( 'woocommerce_shop_loop_item_title', 'custom_product_link_close', 15 );
function custom_product_link_close() {
    echo '</a>';
}

remove_action( 'woocommerce_product_additional_information', 'woocommerce_product_additional_information_tab', 10 );


function remove_sidebar_shop()
{
    if (is_product()) {
        remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar');
    }
}

add_filter('woocommerce_enqueue_styles', '__return_empty_array');
// Remove Marketing Hub menu item
add_filter('woocommerce_marketing_menu_items', '__return_empty_array');

// Sidebar
function sidebar_woocommerce_filter()
{
    register_sidebar(array(
        'name' => __('سایدبار فروشگاه', 'textdomain'),
        'id' => 'sidebar-woocommerce-filter',
        'before_widget' => '<div id="%1$s" class="widget widget-product %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>'
    ));
}

add_action('widgets_init', 'sidebar_woocommerce_filter');

/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter('loop_shop_per_page', 'new_loop_shop_per_page', 20);

function new_loop_shop_per_page($cols)
{
    $cols = 3;
    return $cols;
}

//Remove download from my account
add_filter('woocommerce_account_menu_items', 'bbloomer_remove_downloads_my_account', 999);

function bbloomer_remove_downloads_my_account($items)
{
    unset($items['downloads']);
    return $items;
}

add_filter('woocommerce_product_tabs', 'woo_rename_tabs', 98);
function woo_rename_tabs($tabs)
{
    $tabs['description']['title'] = __('اطلاعات تکمیلی');        // Rename the description tab
    $tabs['additional_information']['title'] = __('مشخصات کالا');    // Rename the additional information tab
    return $tabs;
}

add_filter('woocommerce_product_tabs', 'tg_reorder_tabs', 98);
function tg_reorder_tabs($tabs)
{
    $tabs['description']['priority'] = 1; // 2nd - description
    $tabs['additional_information']['priority'] = 2; // 1st - Additional information third
    $tabs['reviews']['priority'] = 3; // 3rd - reviews
    return $tabs;
}

/* Remove the Dashboard tab of the My Account Page */
function custom_my_account_menu_items($items)
{
    unset($items['dashboard']);
    return $items;
}

add_filter('woocommerce_account_menu_items', 'custom_my_account_menu_items');




add_filter('woocommerce_structured_data_product', 'structured_data_product_nulled', 10, 2);
function structured_data_product_nulled($markup, $product)
{
    if (is_product()) {
        $markup = '';
    }
    return $markup;
}

/**
 * Process the checkout
 **/

add_action('woocommerce_checkout_process', 'my_custom_checkout_field_process');
function my_custom_checkout_field_process()
{
    global $woocommerce;

    // Check if set, if its not set add an error. This one is only requite for companies
    if (!(preg_match('/^[0-9]{11}$/D', $_POST['billing_phone']))) {
        wc_add_notice("شماره تلفن شما باید 11 رقم باشد . ورود حروف غیرمجاز است.", 'error');
    }
    // Check if set, if its not set add an error. This one is only requite for companies
    if (!(preg_match('/^[0-9]{10}$/D', $_POST['billing_postcode']))) {
        wc_add_notice("طول کدپستی در صورتحساب باید 10 رقم باشد.", 'error');
    }
}

add_filter('woocommerce_save_account_details_required_fields', 'wc_save_account_details_required_fields');
function wc_save_account_details_required_fields($required_fields)
{
    unset($required_fields['account_display_name']);
    return $required_fields;
}



add_filter( 'woocommerce_add_to_cart_fragments', 'refresh_cart_count', 50, 1 );
function refresh_cart_count( $fragments ){
    ob_start();
    ?>
    <span class="counter cart-count-icon" id="cart-count"><?php
        $cart_count = WC()->cart->get_cart_contents_count();
        echo sprintf ( _n( '%d', '%d', $cart_count ), $cart_count );
        ?></span>
    <?php
    $fragments['#cart-count'] = ob_get_clean();

    return $fragments;
}

require get_template_directory() . '/includes/cart-ajax.php';

add_action('wp_enqueue_scripts', function () {
    wp_enqueue_script(
        'custom-cart',
        get_template_directory_uri() . '/assets/js/cart.js',
        ['jquery'],
        null,
        true
    );

    wp_localize_script('custom-cart', 'wc_cart', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('cart_nonce')
    ]);
});


add_action('wp_footer', function () {
    if (!WC()->cart) return;
    ?>
    <script>
        jQuery(function ($) {

            <?php foreach (WC()->cart->get_cart() as $cart_item): ?>
            const productId   = <?= (int) $cart_item['product_id'] ?>;
            const variationId = <?= (int) $cart_item['variation_id'] ?>;
            const qty         = <?= (int) $cart_item['quantity'] ?>;

            const card = $('.product-card[data-product-id="' + productId + '"]');

            const option = card
                .find('.variation-option[data-variation-id="' + variationId + '"]');

            if (option.length) {
                option.addClass('active')
                    .siblings().removeClass('active');

                card.find('.add-to-cart-btn').addClass('hidden');
                card.find('.qty-wrapper').removeClass('hidden')
                    .find('.qty-input').val(qty);
            }
            <?php endforeach; ?>

        });
    </script>
    <?php
});

// اجازه جستجو و انتخاب متغیرها در بخش محصولات مرتبط و گروهی ادمین
add_filter( 'woocommerce_json_search_found_products', function( $found_products ) {
    $term = isset($_GET['term']) ? sanitize_text_field($_GET['term']) : '';
    if ( empty($term) ) return $found_products;

    $args = array(
        'post_type'      => array( 'product_variation' ),
        'posts_per_page' => 15,
        's'              => $term
    );

    $variations = get_posts( $args );

    if ( ! empty( $variations ) ) {
        foreach ( $variations as $variation ) {
            $product_variation = wc_get_product( $variation->ID );
            if ( $product_variation ) {
                // نمایش نام محصول به همراه ویژگی (مثلاً: ساواژ - 10 میل)
                $found_products[ $variation->ID ] = $product_variation->get_formatted_name();
            }
        }
    }

    return $found_products;
});

//add_action( 'woocommerce_after_shop_loop_item', 'display_selected_variations_on_card', 25 );
//function display_selected_variations_on_card() {
//    global $product;
//
//    // فقط برای محصولات از نوع گروهی
//    if ( ! $product || ! $product->is_type( 'grouped' ) ) return;
//
//    $children_ids = $product->get_children();
//    if ( empty( $children_ids ) ) return;
//
//    echo '<div class="custom-grouped-list">';
//
//    foreach ( $children_ids as $child_id ) {
//        $child_product = wc_get_product( $child_id );
//        if ( ! $child_product ) continue;
//
//        // تشخیص نام: اگر متغیر بود نام دقیق حجم، اگر محصول ساده بود نام محصول
//        if ( $child_product->is_type( 'variation' ) ) {
//            $attributes = $child_product->get_attributes();
//            // اگر ویژگی خاصی دارد آن را نشان بده، در غیر این صورت نام کامل متغیر
//            $label = !empty($attributes) ? implode(' ', array_values($attributes)) : $child_product->get_name();
//        } else {
//            $label = $child_product->get_name();
//        }
//
//        // ساختار HTML مشابه عکس شما
//        echo '<div class="grouped-item-row">';
//        echo '  <span class="item-tick">✓</span>';
//        echo '  <span class="item-text">' . esc_html($label) . '</span>';
//        echo '</div>';
//    }
//
//    echo '</div>';
//}


add_action( 'woocommerce_shop_loop_item_title', 'display_selected_variations_on_card', 25 );
function display_selected_variations_on_card() {
    global $product;

    if ( ! $product || ! $product->is_type( 'grouped' ) ) return;

    $children_ids = $product->get_children();
    if ( empty( $children_ids ) ) return;

    echo '<div class="custom-grouped-list">';

    foreach ( $children_ids as $child_id ) {
        $child_product = wc_get_product( $child_id );
        if ( ! $child_product ) continue;

        if ( $child_product->is_type( 'variation' ) ) {
            $attributes = $child_product->get_attributes();

            if ( !empty($attributes) ) {
                // تبدیل کدهای درصد به حروف فارسی و حذف خط تیره
                $label = implode(' ', array_values($attributes));
                $label = urldecode($label);
                $label = str_replace('-', ' ', $label);
            } else {
                $label = urldecode($child_product->get_name());
            }
        } else {
            $label = $child_product->get_name();
        }

        echo '<div class="grouped-item-row">';
        echo '  <span class="item-tick">✓</span>';
        echo '  <span class="item-text">' . esc_html($label) . '</span>';
        echo '</div>';
    }

    echo '</div>';
}
?>
