<?php
function socialshares()
{
    $title = urlencode(get_the_title());
    $url = urlencode(get_permalink());
    $homeurl = urlencode(get_bloginfo('url'));
    $desc = urlencode(get_the_excerpt());
    $share = '<div class="share-wrapper position-relative"><span class="share-icon-wrapper"><i class="icon-share"></i></span><ul class="share-social">';
    $share .= '';
//    $share .= '<li><a href="https://www.facebook.com/sharer/sharer.php?u=' . $url . '&amp;t=' . $title . '" title="Share on Facebook" target="_blank" rel=" nofollow noopener" class="facebook"><i class="icon-facebook"></i></a></li>';
//    $share .= '<li><a href="https://twitter.com/intent/tweet?source=' . $url . '&amp;text=' . $title . ':' . $homeurl . '" target="_blank" title="Tweet" rel="nofollow noopener" class="twitter"><i class="icon-twitter"></i></a></li>';
    $share .= '<li ><a href="https://telegram.me/share/url?url=' . $url . '&amp;text=' . $title . ':' . $homeurl . '" title="telegram" rel="nofollow noopener" target="_blank" class="telegram"><i class="icon-telegram"></i></a></li>';
//    $share .= '<li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=' . $url . '&amp;title=' . $title . '&amp;summary=' . $desc . '&amp;source=' . $homeurl . '" target="_blank" title="Share on LinkedIn" class="linkedin" rel="nofollow noopener" ><i class="icon-linkedin"></i></a></li>';
    $share .= '<li><a href="whatsapp://send?text=' . $title . ' '. $url.'" target="_blank" title="Share on Whatsapp" class="whatsapp" rel="nofollow noopener" ><i class="icon-whatsapp"></i></a></li>';
    $share .= '</ul></div>';
    return $share;
}

function socilaLinlks()
{
    if (have_rows('social_links', 'option')):
        $share = '<ul class="social-list d-flex justify-content-center justify-content-lg-end">';
        while (have_rows('social_links', 'option')) : the_row();
            $social_name = get_sub_field('social_name', 'option');
            $social_url = get_sub_field('social_url', 'option');
            if ($social_url != '') {
                $share .= '<li>';
                $share .= '<a href = "' . $social_url . '" target = "_blank" class="' . $social_name . '" >';
                $share .= '<i class="icon-' . $social_name . '" ></i >';
                $share .= '</a >';
                $share .= '</li>';
            }
        endwhile;
        $share .= '</ul>';
        return $share;
    endif;
}

// Pagination
function pagination_bar($custom_query)
{
    $total_pages = $custom_query->max_num_pages;
    //echo $total_pages;
    $big = 999999999; // need an unlikely integer
    if ($total_pages > 1) {
        $current_page = max(1, get_query_var('paged'));
        echo paginate_links(array(
            'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format' => '?paged=%#%',
            'prev_text' => '<i class="icon-arrow-right"></i>',
            'next_text' => '<i class="icon-arrow-right"></i>',
            'before_page_number' => '',
            'current' => $current_page,
            'total' => $total_pages,
        ));
    }
}

add_filter( "comment_class", function( $classes, $class, $comment_id, $comment ) {
    if( $comment->user_id > 0 && $user = get_userdata( $comment->user_id ) && user_can( $comment->user_id, "administrator" ) ) {
        $classes[] = "posted-by-admin";
    }
    return $classes;
}, 10, 4 );


//lightgallery
add_filter('post_gallery', 'ct_post_gallery', 10, 2);
function ct_post_gallery($output, $attr) {
    global $post;

    if (isset($attr['orderby'])) {
        $attr['orderby'] = sanitize_sql_orderby($attr['orderby']);
        if (!$attr['orderby'])
            unset($attr['orderby']);
    }

    extract(shortcode_atts(array(
        'order' => 'ASC',
        'orderby' => 'menu_order ID',
        'id' => $post->ID,
        'itemtag' => 'dl',
        'icontag' => 'dt',
        'captiontag' => 'dd',
        'columns' => 3,
        'size' => 'medium',
        'include' => '',
        'exclude' => ''
    ), $attr));

    $id = intval($id);
    if ('RAND' == $order) $orderby = 'none';

    if (!empty($include)) {
        $include = preg_replace('/[^0-9,]+/', '', $include);
        $_attachments = get_posts(array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));

        $attachments = array();
        foreach ($_attachments as $key => $val) {
            $attachments[$val->ID] = $_attachments[$key];
        }
    }

    if (empty($attachments)) return '';

    // Here's your actual output, you may customize it to your need
    $output .= "<div class=\"position-relative blur-bg\"><div class=\"swiper swiper-gallery\"><div class=\"swiper-wrapper page_lightgallery\" id=\"page_lightgallery\">\n";

    // Now you loop through each attachment
    foreach ($attachments as $id => $attachment) {
        // Fetch the thumbnail (or full image, it's up to you)
        $full = wp_get_attachment_image_src($id, 'full');
        // $img = wp_get_attachment_image_src($id, 'my-custom-image-size');
        $size = 'medium';
        $img = wp_get_attachment_image_src($id, $size);
        $image_alt = get_post_meta( $id , '_wp_attachment_image_alt', true);
        $output .= "<div class=\"swiper-slide gallery_item\" data-src=\"{$full[0]}\" data-thumb=\"{$full[0]}\">\n";
        $output .= "<a href=\"{$full[0]}\" ><i class='icon-zoom'></i><img src=\"{$img[0]}\" width=\"{$img[1]}\" height=\"{$img[2]}\" alt=\"{$image_alt}\" /></a>\n";
        $output .= "</div>\n";
    }

    $output .= "</div></div><div class=\"swiper-button-prev\"></div><div class=\"swiper-button-next\"></div></div>\n";

    return $output;
}
