<?php
function normalize_search_keyword($text) {
    $map = [
        'آ' => 'ا', 'أ' => 'ا', 'إ' => 'ا',
        'ي' => 'ی', 'ئ' => 'ی',
        'ك' => 'ک',
        'ة' => 'ه', 'ۀ' => 'ه',
        ' ' => '', '‌' => '' // حذف فاصله و نیم‌فاصله
    ];
    return strtr($text, $map);
}

add_action('wp_ajax_precise_woo_search', 'precise_woo_search_callback');
add_action('wp_ajax_nopriv_precise_woo_search', 'precise_woo_search_callback');

function precise_woo_search_callback() {
    global $wpdb;

    if (ob_get_length()) ob_clean();

    $keyword = isset($_POST['keyword']) ? sanitize_text_field($_POST['keyword']) : '';

    if (empty($keyword)) {
        wp_die();
    }

    $clean_keyword = normalize_search_keyword($keyword);

    $query = "
        SELECT ID, post_title FROM {$wpdb->posts} 
        WHERE post_type = 'product' 
        AND post_status = 'publish' 
        AND (
            REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(post_title, ' ', ''), '‌', ''), 'آ', 'ا'), 'ي', 'ی'), 'ك', 'ک'), 'ة', 'ه') 
            LIKE %s
        )
        LIMIT 8";

    $results = $wpdb->get_results($wpdb->prepare($query, '%' . $wpdb->esc_like($clean_keyword) . '%'));

    if ($results) {
        foreach ($results as $post) {
            $product = wc_get_product($post->ID);
            $image = get_the_post_thumbnail_url($post->ID, 'thumbnail') ?: wc_placeholder_img_src();
            $price = $product->get_price_html();

            echo '<a href="' . get_permalink($post->ID) . '" class="ajax-search-item">
                    <div class="item-thumb"><img src="' . $image . '"></div>
                    <div class="item-info">
                        <span class="item-title">' . $post->post_title . '</span>
                        <span class="item-price">' . $price . '</span>
                    </div>
                  </a>';
        }
        echo '<a href="' . home_url('/?s=' . $keyword . '&post_type=product') . '" class="view-all-results">مشاهده همه نتایج...</a>';
    } else {
        echo '<div class="no-result">محصولی پیدا نشد.</div>';
    }

    // این خط حیاتی است تا وردپرس ادامه صفحه را لود نکند
    wp_die();
}
