<?php
$copy_right = get_field('copyright_text', 'option');
$footer_text = get_field('about_text', 'option');
$footer_image = get_field('footer_image', 'option');
?>
</main>
<footer class="site-footer <?php echo !is_home() || !is_front_page() ? 'inner-footer' : ''; ?>">
    <div class="main-footer">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-7">
                    <div class="footer-about">
                        <h3 class="footer-about_title">درباره مستر پرفیوم </h3>
                        <?php
                            if($footer_text!='') {
                                echo '<p>'.$footer_text.'</p>';
                            }
                        ?>
                        <div class="footer-about_social">
                            <?php echo socilaLinlks(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-5">
                    <div class="footer-image">
                        <img src="<?php echo $footer_image['url']; ?>" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="copyright">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-12 col-lg-8 copyright-text text-center text-lg-start">
                    <?php
                        if ($copy_right != '') {
                            echo '<p class="mb-0">' . $copy_right . '</p>';
                        }
                    ?>
                </div>
                <div class="col-12 col-lg-4">
                   <?php echo socilaLinlks(); ?>
                </div>
            </div>
        </div>
    </div>
</footer>

<!--<div id="mask"></div>-->
<!--<div class="site-offcanvas">-->
<!--    <div class="site-scroll ps ps--active-y">-->
<!--        <div class="site-offcanvas--header">-->
<!--            --><?php //$logo = get_field('logo', 'option');
//            if ($logo) {
//                ?>
<!--                <div class="site-brand">-->
<!--                    <a href="--><?php //echo get_bloginfo('url'); ?><!--" title="--><?php //echo get_bloginfo('name'); ?><!--">-->
<!--                        <img src="--><?php //echo $logo['url']; ?><!--" width="--><?php //echo $logo['width']; ?><!--"-->
<!--                             height="--><?php //echo $logo['height']; ?><!--"-->
<!--                             alt="--><?php //echo get_bloginfo('name'); ?><!--">-->
<!--                    </a>-->
<!--                </div>-->
<!--            --><?php //} ?>
<!--            <div class="offcanvas-close"><i class="icon-close"></i></div>-->
<!--        </div>-->
<!--        <div class="site-offcanvas--main">-->
<!--            <nav class="site-menu mobile-menu vertical-menu">-->
<!--                --><?php
//                wp_nav_menu(array('theme_location' => 'mobile'));
//                ?>
<!--            </nav>-->
<!--        </div>-->
<!--    </div>-->
<!--</div>-->
<?php if (!is_user_logged_in()) { ?>
    <div class="modal fade" id="unixa-auth-modal" tabindex="-1" role="dialog" aria-labelledby="unixa-auth-modal-label"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="unixa-auth-modal-label">ورود / عضویت</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <?php
                    unixa_auth_user_detection_form();
                    unixa_auth_user_login_form();
                    unixa_auth_user_register_form();
                    unixa_auth_user_profile_form();
                    ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<?php wp_footer();
if (is_home() || is_front_page()) {
    $expire_date = get_field('expire_date', 'option');
    ?>
    <script>
        const countdownEl = document.querySelector('#countdown');
        if(countdownEl){
            const endTime = new Date('<?php echo $expire_date; ?>').getTime();
            function updateCountdown(){
                const now = new Date().getTime();
                const distance = endTime - now;

                if(distance > 0){
                    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    countdownEl.querySelector('.days').innerText = days;
                    countdownEl.querySelector('.hours').innerText = hours;
                    countdownEl.querySelector('.minutes').innerText = minutes;
                    countdownEl.querySelector('.seconds').innerText = seconds;
                } else {
                    countdownEl.style.display = 'none';
                    document.querySelector('#countdown').style.display = 'block';
                }
            }

            updateCountdown();
            setInterval(updateCountdown, 1000);
        }
    </script>
    <?php
}

if (is_singular()) {
    ?>
    <script>
        jQuery('#commentform').validate({
            rules: {
                author: {
                    required: true,
                    minlength: 2
                },
                email: {
                    required: true,
                    email: true
                },

                comment: {
                    required: true,
                    minlength: 1
                }
            },

            messages: {
                author: "نام و نام خانوادگی الزامی است",
                email: "ایمیل الزامی است",
                comment: "متن نظر الزامی است"
            },

            errorElement: "div",
            errorPlacement: function (error, element) {
                element.after(error);
                jQuery(element).parent('div').addClass('check_error');
            }
        });
    </script>
<?php } ?>
</body>
</html>
