<?php 
$args = array(
  'post_type'      => 'post',
  'posts_per_page' => 3,
);

$recent_posts = new WP_Query($args);
if ( $recent_posts->have_posts() ) :
$recent_sec = get_field('recent_sec', 'option');
?>
<section class="recently-posts ui-pt-32 ui-pb-64">
    <div class="container-lg">
        <div class="row align-items-center section-head">
            <div class="col">
                <h2 class="section-title fs-4 fw-medium">
                    <i class="icon-user"></i>
                   <?php echo $recent_sec['_title']; ?>
                </h2>
            </div>
            <div class="col-auto d-none d-sm-block">
                <a href="<?php echo $recent_sec['_link']; ?>" class="more-btn_text text-btn">
                    بیشتر
                    <i class="icon-arrow-left"></i>
                </a>
            </div>
        </div>
            
        <div class="row row-scrollable">
            <?php while ( $recent_posts->have_posts() ) : $recent_posts->the_post(); ?>
                <div class="col-10 col-sm-8 col-md-4">
                    <?php get_template_part('templates/card/blog', 'card'); ?>
                </div>
            <?php
                endwhile;
            ?>
        </div>
    </div>
</section>
<?php wp_reset_postdata(); 
endif; ?>