<?php $terms = get_field('blog_cat', 'option'); 
if($terms) { 
?>
<div class="category-nav_wrapper category-nav_home">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 col-lg-7 mx-auto">
                <div class="category-nav text-center">
                    <!-- <span class="category-nav_title">دسته‌بندی مطالب</span> -->
                    <?php get_search_form(); ?>
                    <ul class="category-nav_menu d-flex align-items-center justify-content-start justify-content-md-center">
                        <?php foreach( $terms as $term ): 
                            $term_icon = get_field('_icon', 'category_'. $term);
                            $term_link = get_term_link($term);
                        ?>
                        <li class="category-nav_menu_item">
                            <a href="<?php echo esc_url($term_link); ?>">
                                <?php if ( $term_icon ) :
                                    echo '<img 
                                        src="'. esc_url($term_icon) .'" 
                                        alt="'. esc_attr(get_the_category_by_ID($term)) .'" 
                                        class="category-icon"
                                        width="32"
                                        height="32"
                                    />';
                                endif ?> 
                                <?php echo get_the_category_by_ID($term); ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>