<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta content="telephone=no" name="format-detection">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php
    $favIcon = get_field('favicon', 'option');
    if ($favIcon) { ?>
        <link rel="shortcut icon" type="image/png" href="<?php echo $favIcon['url']; ?>"/><?php } ?>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open();
if (is_home() || is_front_page()) {
    $cls_header = 'home-header';
} else {
    $cls_header = 'inner-header';
}

$header_btn = get_field('header_btn', 'option'); 
$header_btn_text = $header_btn['text'];
$header_btn_link = $header_btn['link'];
?>
<header class="site-header <?php echo $cls_header; ?>" id="header">
    <div class="container-lg">
        <div class="row align-items-center">
            <div class="col-6 col-sm-9 col-md-8 col-right">

                <?php
                    /* logo */
                    $logo = get_field('logo', 'options');
                    if ($logo) {
                        echo '<div class="site-logo d-inline-flex"><a class="logo-header" href="' . get_bloginfo('url') . '" title="' . get_bloginfo('name') . '">';
                        echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . get_bloginfo('name') . '" />';
                        echo '</a> </div>';
                    }

                    if (has_nav_menu('main')) {
                        echo '<nav class="site-menu d-none d-sm-inline-flex">';
                            $defaults = array(
                                'theme_location' => 'main',
                                'container' => '',
                                'menu_class' => 'main-menu d-flex',
                                'echo' => true,
                                'fallback_cb' => 'wp_page_menu',
                                'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                'depth' => 1,
                            );
                            wp_nav_menu($defaults);
                        echo '</nav>';
                    }
                ?>
            </div>

            <div class="col-6 col-sm-3 col-md-4 text-end">
                <a href="<?php echo esc_url($header_btn['link']); ?>" class="header-btn">
                    <i class="icon-user"></i>
                    <?php echo esc_html($header_btn['text']); ?>
                    <span></span>
                </a>
            </div>
        </div>
    </div>
</header>

<main class="main-content">
    <?php if(!is_front_page()) { get_template_part('templates/content/breadcrumb'); } ?>
