<?php
/***************************************************************
/ Design and Debug : TravianDesign.IR --------> +989398533517***
/***************************************************************
*/

include_once("GameEngine/Account.php");
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// متن تبلیغاتی
$ad_text = "بازی تراوین سرور فارسی - بهترین سرور فارسی تراوین با ویژگی‌های منحصر به فرد";

if($session->access != ADMIN) { 
    echo "شما ادمين نيستيد لطفا تلاش نکنيد."; 
} 
else {
    include "Templates/html.tpl";  

    if(isset($_POST['submitted'])) {
        // دریافت داده‌ها از فرم
        $names_input = trim($_POST['names']);
        $min_population = intval($_POST['min_population']);
        $max_population = intval($_POST['max_population']);
        
        // اعتبارسنجی ورودی‌ها
        $errors = array();
        
        if(empty($names_input)) {
            $errors[] = "لطفا حداقل یک نام وارد کنید.";
        }
        
        if($min_population < 0 || $min_population > 1000) {
            $errors[] = "حداقل جمعیت باید بین 0 تا 1000 باشد.";
        }
        
        if($max_population < $min_population || $max_population > 10000) {
            $errors[] = "حداکثر جمعیت باید بین {$min_population} تا 10000 باشد.";
        }
        
        if(empty($errors)) {
            // تبدیل اسامی به آرایه
            $names_array = explode(',', $names_input);
            $names_array = array_map('trim', $names_array);
            $names_array = array_unique(array_filter($names_array)); // حذف موارد تکراری و خالی
            
            $created_users = 0;
            $failed_users = 0;
            $already_existing = 0;
            $results = array();
            
            foreach($names_array as $username) {
                // بررسی اینکه آیا کاربر با این نام وجود دارد یا خیر
                $user_exists = $database->getUserArray($username, 1);
                
                if($user_exists) {
                    // اگر کاربر وجود دارد
                    $already_existing++;
                    $results[] = array(
                        'username' => $username,
                        'status' => 'exists',
                        'message' => 'کاربر از قبل وجود دارد'
                    );
                } else {
                    // ایجاد کاربر جدید
                    try {
                        // تولید اطلاعات تصادفی
                        $email = $username . "@fake.travian";
                        $mobile = "09" . rand(10000000, 99999999);
                        $password = "user" . rand(1000, 9999);
                        $captcha = "fakecap" . rand(1000, 9999);
                        
                        // تنظیم معرف به ID 4
                        $_POST['invited'] = 4;
                        
                        // تولید جمعیت تصادفی در محدوده مشخص شده
                        $random_population = rand($min_population, $max_population);
                        
                        // روستای پیش فرض
                        $village_id = rand(1,3);
                        $kid = rand(1,4);
                        
                        // ایجاد کاربر
                        $uid = $database->register($username, md5($password), $email, $mobile, $village_id, $kid, $captcha);
                        
                        if($uid) {
                            // ایجاد چهره قهرمان تصادفی
                            $frandom0 = rand(0,3);
                            $frandom1 = rand(0,3);
                            $frandom2 = rand(0,4);
                            $frandom3 = rand(0,3);
                            
                            $database->addHeroFace($uid, $frandom0, $frandom1, $frandom2, $frandom3, $frandom3, $frandom2, $frandom1, $frandom0, $frandom2);
                            $database->addHero($uid);
                            
                            $database->updateUserField($uid, "act", "", 1);
                            $database->updateUserField($uid, "invited", $_POST['invited'], 1);
                            
                            // تنظیم جمعیت
                            $database->updateUserField($uid, "pop", $random_population, 1);
                            
                            // تولید پایگاه اولیه
                            // برای PHP 5.3 باید مطمئن شویم $this وجود دارد
                            
                                $account->generateBase($kid, $uid, $username);
                            
                            
                            // تنظیم قهرمان
                            $village_field_hero = $database->getVFH($uid);
                            if($village_field_hero) {
                                $database->modifyUnit($village_field_hero, 'hero', 1, 1);
                                $database->modifyHero2('wref', $village_field_hero, $uid, 0);
                            }
                            
                            // اضافه کردن ماجراجویی‌ها
                            	mysql_query("UPDATE ".TB_PREFIX."vdata SET pop = ".$random_population." WHERE owner = ".$uid);
		
                            
                            $created_users++;
                            
                            // ذخیره اطلاعات کاربر
                            $results[] = array(
                                'username' => $username,
                                'status' => 'created',
                                'message' => 'با موفقیت ایجاد شد',
                                'password' => $password,
                                'population' => $random_population
                            );
                            
                            // ذخیره در فایل لاگ
                            $log_entry = date("Y-m-d H:i:s") . " | User: $username | Pass: $password | Email: $email | Mobile: $mobile | Pop: $random_population\n";
                            $log_file = "fake_users.log";
                            
                            if(file_exists($log_file)) {
                                $file_handle = fopen($log_file, 'a');
                                if($file_handle) {
                                    fwrite($file_handle, $log_entry);
                                    fclose($file_handle);
                                }
                            } else {
                                $file_handle = fopen($log_file, 'w');
                                if($file_handle) {
                                    fwrite($file_handle, $log_entry);
                                    fclose($file_handle);
                                }
                            }
                        } else {
                            $failed_users++;
                            $results[] = array(
                                'username' => $username,
                                'status' => 'failed',
                                'message' => 'خطا در ایجاد کاربر'
                            );
                        }
                    } catch(Exception $e) {
                        $failed_users++;
                        $results[] = array(
                            'username' => $username,
                            'status' => 'error',
                            'message' => $e->getMessage()
                        );
                        continue;
                    }
                }
            }
            
            // پیام نتیجه
            $message1 = "<div style='color: #333; padding: 15px; margin: 15px 0; background-color: #f8f9fa; border: 1px solid #ddd; border-radius: 5px;'>
                <h4 style='margin-top: 0; color: #2196F3;'>نتایج ایجاد کاربران:</h4>
                <div style='margin-bottom: 15px;'>
                    <span style='background-color: #4CAF50; color: white; padding: 5px 10px; border-radius: 3px; margin-left: 5px; display: inline-block;'>
                        ✅ ایجاد شده: $created_users
                    </span>
                    <span style='background-color: #ff9800; color: white; padding: 5px 10px; border-radius: 3px; margin-left: 5px; display: inline-block;'>
                        ⚠️ موجود بود: $already_existing
                    </span>
                    <span style='background-color: #f44336; color: white; padding: 5px 10px; border-radius: 3px; margin-left: 5px; display: inline-block;'>
                        ❌ خطا: $failed_users
                    </span>
                </div>";
            
            // نمایش جزئیات نتایج
            if(!empty($results)) {
                $message1 .= "<div style='max-height: 300px; overflow-y: auto; border: 1px solid #eee; padding: 10px; border-radius: 4px;'>
                    <table style='width: 100%; border-collapse: collapse; font-size: 12px;'>
                        <thead>
                            <tr style='background-color: #f5f5f5;'>
                                <th style='padding: 8px; border: 1px solid #ddd;'>نام کاربری</th>
                                <th style='padding: 8px; border: 1px solid #ddd;'>وضعیت</th>
                                <th style='padding: 8px; border: 1px solid #ddd;'>جزئیات</th>
                                <th style='padding: 8px; border: 1px solid #ddd;'>رمز عبور</th>
                                <th style='padding: 8px; border: 1px solid #ddd;'>جمعیت</th>
                            </tr>
                        </thead>
                        <tbody>";
                
                foreach($results as $result) {
                    $status_color = '';
                    $status_icon = '';
                    
                    switch($result['status']) {
                        case 'created':
                            $status_color = '#e8f5e8';
                            $status_icon = '✅';
                            break;
                        case 'exists':
                            $status_color = '#fff3e0';
                            $status_icon = '⚠️';
                            break;
                        case 'failed':
                        case 'error':
                            $status_color = '#ffebee';
                            $status_icon = '❌';
                            break;
                        default:
                            $status_color = '#ffffff';
                            $status_icon = '';
                    }
                    
                    $password_display = isset($result['password']) ? $result['password'] : '-';
                    $population_display = isset($result['population']) ? $result['population'] : '-';
                    
                    $message1 .= "<tr style='background-color: {$status_color};'>
                        <td style='padding: 8px; border: 1px solid #ddd;'><strong>{$result['username']}</strong></td>
                        <td style='padding: 8px; border: 1px solid #ddd;'>{$status_icon} {$result['status']}</td>
                        <td style='padding: 8px; border: 1px solid #ddd;'>{$result['message']}</td>
                        <td style='padding: 8px; border: 1px solid #ddd; font-family: monospace;'>{$password_display}</td>
                        <td style='padding: 8px; border: 1px solid #ddd; text-align: center;'>{$population_display}</td>
                    </tr>";
                }
                
                $message1 .= "</tbody></table></div>";
            }
            
            $message1 .= "<p style='margin-top: 15px; color: #666;'>
                <strong>معرف همه کاربران:</strong> کاربر با ID 4
                <br><strong>محدوده جمعیت:</strong> {$min_population} تا {$max_population}
            </p></div>";
            
        } else {
            // نمایش خطاها
            $error_html = implode('<br>', $errors);
            $message1 = "<div style='color: red; padding: 10px; margin: 10px 0; background-color: #ffebee; border: 1px solid #f44336; border-radius: 5px;'>
                ❌ خطا در ورودی‌ها:<br>{$error_html}
            </div>";
        }
    }
?>
<body class="v35 webkit chrome statistics">
    <div id="wrapper"> 
        <img id="staticElements" src="img/x.gif" alt="" /> 
        <div id="logoutContainer"> 
            <a id="logout" href="logout.php" title="<?php echo LOGOUT; ?>">&nbsp;</a> 
        </div> 
        <div class="bodyWrapper"> 
            <img style="filter:chroma();" src="img/x.gif" id="msfilter" alt="" /> 
            <div id="header"> 
                <div id="mtop">
                    <a id="logo" href="../" target="_blank" title="<?php echo SERVER_NAME ?>"></a>
                    <ul id="navigation">
                        <li id="n1" class="resources">
                            <a class="" href="dorf1.php" accesskey="1" title="<?php echo HEADER_DORF1; ?>"></a>
                        </li>
                        <li id="n2" class="village">
                            <a class="" href="dorf2.php" accesskey="2" title="<?php echo HEADER_DORF2; ?>"></a>
                        </li>
                        <li id="n3" class="map">
                            <a class="" href="karte.php" accesskey="3" title="<?php echo HEADER_MAP; ?>"></a>
                        </li>
                        <li id="n4" class="stats">
                            <a class=" active" href="statistiken.php" accesskey="4" title="<?php echo HEADER_STATS; ?>"></a>
                        </li>
                        <?php
                            $messages_count = count($database->getMessage($session->uid,7));
                            if($messages_count >= 1000) {
                                $unmsg = "+1000";
                            } else { 
                                $unmsg = $messages_count; 
                            }
                            
                            $notices_count = count($database->getMessage($session->uid,8));
                            if($notices_count >= 1000) {
                                $unnotice = "+1000";
                            } else { 
                                $unnotice = $notices_count; 
                            }
                        ?>
                        <li id="n5" class="reports"> 
                            <a href="berichte.php" accesskey="5" title="<?php echo HEADER_NOTICES; ?><?php if($message->nunread){ echo' ('.$notices_count.')'; } ?>"></a>
                            <?php
                                if(isset($message->nunread) && $message->nunread){
                                    echo "<div class=\"ltr bubble\" title=\"".$unnotice." ".HEADER_NOTICES_NEW."\" style=\"display:block\">
                                            <div class=\"bubble-background-l\"></div>
                                            <div class=\"bubble-background-r\"></div>
                                            <div class=\"bubble-content\">".$unnotice."</div></div>";
                                }
                            ?>
                        </li>
                        <li id="n6" class="messages"> 
                            <a href="nachrichten.php" accesskey="6" title="<?php echo HEADER_MESSAGES; ?><?php if(isset($message->unread) && $message->unread){ echo' ('.$messages_count.')'; } ?>"></a> 
                            <?php
                                if(isset($message->unread) && $message->unread) {
                                    echo "<div class=\"ltr bubble\" title=\"".$unmsg." ".HEADER_MESSAGES_NEW."\" style=\"display:block\">
                                            <div class=\"bubble-background-l\"></div>
                                            <div class=\"bubble-background-r\"></div>
                                            <div class=\"bubble-content\">".$unmsg."</div></div>";
                                }
                            ?>
                        </li>
                    </ul>
                    <div class="clear"></div> 
                </div> 
            </div>
            <div id="mid">
                <div class="clear"></div> 
                <div id="contentOuterContainer"> 
                    <div class="contentTitle">&nbsp;</div> 
                    <div class="contentContainer"> 
                        <div id="content" class="statistics">
                            <script type="text/javascript"> 
                                window.addEvent('domready', function() {
                                    $$('.subNavi').each(function(element) {
                                        new Travian.Game.Menu(element);
                                    });
                                });
                            </script>

                            <h1 class="titleInHeader">تنظیمات گزینه های پلاس<?php if($session->access == ADMIN) { echo " <a href=\"\"></a>"; } ?></h1>
                            
                            <!-- نمایش تبلیغات -->
                            <div style="background-color: #f0f8ff; padding: 15px; margin: 10px 0; border: 2px solid #4CAF50; border-radius: 8px;">
                                <h3 style="color: #4CAF50; margin-top: 0;"><?php echo $ad_text; ?></h3>
                            </div>
                            
                            <!-- نمایش پیام موفقیت/خطا -->
                            <?php 
                                if(isset($message1)) {
                                    echo $message1;
                                }
                            ?>
                            
                            <!-- فرم ایجاد کاربران فیک -->
                            <div style="background-color: #fff; padding: 20px; margin: 15px 0; border: 1px solid #ddd; border-radius: 5px;">
                                <h3 style="color: #333; margin-top: 0; border-bottom: 2px solid #4CAF50; padding-bottom: 10px;">ایجاد کاربران فیک</h3>
                                <p style="color: #666; margin-bottom: 20px; font-size: 14px;">
                                    با استفاده از این فرم می‌توانید کاربران فیک برای تست یا افزایش جمعیت سرور ایجاد کنید.
                                    <br><strong>ویژگی‌های جدید:</strong>
                                </p>
                                <ul style="color: #666; margin-bottom: 20px; padding-left: 20px;">
                                    <li>بررسی وجود کاربر قبل از ایجاد</li>
                                    <li>تنظیم جمعیت تصادفی در محدوده مشخص</li>
                                    <li>نمایش جزئیات نتایج</li>
                                    <li>معرف همه کاربران: ID 4</li>
                                </ul>
                                
                                <form action="" method="post">
                                    <input type="hidden" name="submitted" value="1">
                                    
                                    <table style="width: 100%; border-collapse: collapse;">
                                        <tr>
                                            <td style="padding: 10px; width: 25%; vertical-align: top;">
                                                <label for="names" style="font-weight: bold;">اسامی کاربران:</label>
                                                <p style="color: #999; font-size: 12px; margin-top: 5px;">
                                                    (با ویرگول جدا کنید)
                                                </p>
                                            </td>
                                            <td style="padding: 10px;">
                                                <textarea name="names" id="names" rows="6" style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-family: Tahoma, sans-serif;" required placeholder="مثال: 
حسین
محمد
علی
رضا
سعید
یا:
حسین, محمد, علی, رضا, سعید"><?php echo isset($_POST['names']) ? htmlspecialchars($_POST['names']) : ''; ?></textarea>
                                                <p style="color: #666; font-size: 12px; margin-top: 5px;">
                                                    <strong>توجه:</strong> سیستم ابتدا بررسی می‌کند که آیا کاربری با این نام وجود دارد یا خیر.
                                                </p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 10px; width: 25%;">
                                                <label for="min_population" style="font-weight: bold;">حداقل جمعیت:</label>
                                            </td>
                                            <td style="padding: 10px;">
                                                <input type="number" name="min_population" id="min_population" min="0" max="1000" value="<?php echo isset($_POST['min_population']) ? $_POST['min_population'] : '10'; ?>" style="width: 150px; padding: 8px; border: 1px solid #ccc; border-radius: 4px;" required>
                                                <span style="color: #999; font-size: 12px; margin-right: 10px;">(0 تا 1000)</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 10px; width: 25%;">
                                                <label for="max_population" style="font-weight: bold;">حداکثر جمعیت:</label>
                                            </td>
                                            <td style="padding: 10px;">
                                                <input type="number" name="max_population" id="max_population" min="1" max="10000" value="<?php echo isset($_POST['max_population']) ? $_POST['max_population'] : '100'; ?>" style="width: 150px; padding: 8px; border: 1px solid #ccc; border-radius: 4px;" required>
                                                <span style="color: #999; font-size: 12px; margin-right: 10px;">(حداقل جمعیت تا 10000)</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" style="padding: 20px; text-align: center;">
                                                <br>
                                                <input type="submit" value="ایجاد کاربران" style="background-color: #4CAF50; color: white; padding: 12px 30px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; font-weight: bold;">
                                                <input type="reset" value="بازنشانی فرم" style="background-color: #f44336; color: white; padding: 12px 30px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; font-weight: bold; margin-right: 15px;">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" style="padding: 10px; text-align: center;">
                                                <div style="background-color: #fff8e1; padding: 10px; border: 1px solid #ffd54f; border-radius: 4px; margin-top: 10px;">
                                                    <strong>نکته:</strong> برای هر نام وارد شده، سیستم بررسی می‌کند که آیا کاربر از قبل وجود دارد یا خیر. اگر وجود نداشته باشد، کاربر جدید با مشخصات زیر ایجاد می‌شود:
                                                    <ul style="text-align: right; margin: 5px 0;">
                                                        <li>ایمیل: username@fake.travian</li>
                                                        <li>رمز عبور: تصادفی</li>
                                                        <li>شماره موبایل: تصادفی</li>
                                                        <li>جمعیت: تصادفی در محدوده مشخص شده</li>
                                                        <li>معرف: کاربر با ID 4</li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </form>
                            </div>
                            
                            <br><hr><br>
                            
                            <!-- جدول تنظیمات پلاس (محتوای اصلی صفحه) -->
                            <table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
                                <form action="" method="post">
                                    <input type="hidden" name="submitted" value="1">
                                    <tr style="background-color: #4CAF50; color: white;">
                                        <th style="padding: 10px; text-align: right;">نام</th>
                                        <th style="padding: 10px; text-align: right;">سکه</th>
                                        <th style="padding: 10px; text-align: right;">وضعیت</th>
                                    </tr>
                                    <?php
                                        // اینجا کد نمایش آیتم‌های پلاس قرار می‌گیرد
                                    ?>
                                    <tr>
                                        <td colspan="3" style="padding: 20px; text-align: center;">
                                            <input type="submit" value="ارسال تغییرات" style="background-color: #2196F3; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px;">
                                        </td>
                                    </tr>
                                </form>
                            </table>
                        </div>
                    </div>
                    <div class="contentFooter">&nbsp;</div>
                </div>
                <?php
                    // بررسی وجود فایل‌های تمپلیت قبل از include
                    $templates = array(
                        "sideinfo.tpl",
                        "footer.tpl", 
                        "header.tpl",
                        "res.tpl",
                        "vname.tpl",
                        "quest.tpl"
                    );
                    
                    foreach($templates as $template) {
                        if(file_exists("Templates/" . $template)) {
                            include("Templates/" . $template);
                        }
                    }
                ?>
            </div>
            <div id="ce"></div>
        </div>
    </div>
</body>
</html>
<?php } ?>