<?php

if (!defined('ABSPATH')) {
    exit;
}


require dirname(__FILE__) . '/includes/ajax.php';
require dirname(__FILE__) . '/libs/vendor/autoload.php';
require dirname(__FILE__) . '/includes/init.php';

function digad_show_socialogin_settings()
{
    $digpc = get_site_option('dig_purchasecode');
    if (empty($digpc)) return;


    ?>

    <div class="dig_admin_head">
        <span><?php _e('Social Logins', 'digits'); ?></span>
    </div>

    <div class="dig_admin_tab_grid">
        <div class="dig_admin_tab_grid_elem">
            <?php
            digits_settings_social_login();
            ?>
        </div>
        <div>
        </div>
    </div>
    <?php
}


function digsociallogin_scripts()
{
    $digpc = get_site_option('dig_purchasecode');
    if (empty($digpc)) return;


    if (is_user_logged_in()) {
        return;
    }


    wp_enqueue_style('digits-social-login', plugins_url('/css/social-login.min.css', __FILE__));

    wp_register_script('digits-social-login', plugins_url('/js/social-login.min.js', __FILE__), array('jquery'), false, true);

    $jsData = array(
        'ajax_url' => admin_url('admin-ajax.php'),
    );
    wp_localize_script('digits-social-login', 'dig_social', $jsData);
    wp_enqueue_script('digits-social-login');
}

add_action('wp_enqueue_scripts', 'digsociallogin_scripts');
add_action('login_enqueue_scripts', 'digsociallogin_scripts');