<?php

/*
 * Plugin Name: DIGITS: Social Login Addon
 * Description: Provide social login functionality with all major providers alongside Digits.
 * Version: 2.5
 * Plugin URI: https://digits.unitedover.com/addons
 * Author URI: https://www.unitedover.com/
 * Author: UnitedOver
 * Text Domain: digsociallogin
 * Requires PHP: 5.5
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}


require dirname(__FILE__) . '/handler.php';
require dirname(__FILE__) . '/Puc/v4p6/Factory.php';
require dirname(__FILE__) . '/Puc/v4/Factory.php';
require dirname(__FILE__) . '/Puc/v4p6/Autoloader.php';
new Puc_v4p6_Autoloader();

foreach (
    array(
        'Plugin_UpdateChecker' => 'Puc_v4p6_Plugin_UpdateChecker',
        'Vcs_PluginUpdateChecker' => 'Puc_v4p6_Vcs_PluginUpdateChecker',
    )
    as $pucGeneralClass => $pucVersionedClass
) {
    Puc_v4_Factory::addVersion($pucGeneralClass, $pucVersionedClass, '4.6');

    Puc_v4p6_Factory::addVersion($pucGeneralClass, $pucVersionedClass, '4.6');
}


function digits_addon_digsociallogin()
{
    return 'digsociallogin';
}


function dig_show_sociallogin($active_tab)
{
    ?>
    <div data-tab="digsociallogintab"
         class="dig_admin_in_pt digsociallogintab digtabview <?php echo $active_tab == digits_addon_digsociallogin() ? 'digcurrentactive' : '" style="display:none;'; ?>">
        <?php digad_show_socialogin_settings(); ?>
    </div>

    <?php

}

add_action('digits_settings_page', 'dig_show_sociallogin');


$digmergphneUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'https://bridge.unitedover.com/updates/changelog/addons.php?addon=digsociallogin',
    __FILE__,
    'digsociallogin'
);

$digmergphneUpdateChecker->addQueryArgFilter('digsociallogin_filter_update_checks');
function digsociallogin_filter_update_checks($queryArgs)
{


    $queryArgs['license_key'] = get_site_option('dig_purchasecode');

    $queryArgs['request_site'] = network_home_url();

    $queryArgs['license_type'] = get_site_option('dig_license_type', 1);

    $plugin_data = get_plugin_data(__FILE__);
    $plugin_version = $plugin_data['Version'];

    $queryArgs['version'] = $plugin_version;


    return $queryArgs;
}


function digsociallogin_addon($list)
{
    $list[] = 'digsociallogin';
    return $list;
}

add_filter('digits_addon', 'digsociallogin_addon');

function digsociallogin_addon_tab($tabs)
{
    $tabs['digsociallogin'] = array('label' => esc_attr__('Social Logins', 'digits'));
    return $tabs;
}

add_filter('digits_admin_addon_tab', 'digsociallogin_addon_tab');

