<?php
// محتوای فایل sell.php
if (!defined('ABSPATH')) {
    exit; // جلوگیری از دسترسی مستقیم
}

// دریافت محصولات از ووکامرس
$products = wc_get_products(array('limit' => -1));

if (isset($_POST['generate_invoice'])) {
    $order_id = generate_invoice()->get_id();
}

// تعریف wc_ajax_url
$wc_ajax_url = admin_url('admin-ajax.php');
?>
<style>
h2{
	font-size:24px
}
.card{
	max-width:100%;
}
.container {
    display: flex;
	height:100vh;
	overflow:hidden;
	position:absolute;
	top:0;
	left:0;
	width:100%;
}
	
.content {
    flex-grow: 1;
    padding: 15px;
	overflow:auto;
}

.hamburger {
    display: none;
    font-size: 30px;
    position: fixed;
    top: 15px;
    right: 15px;
}

.product-item {
    display: flex;
    align-items: center;
    gap: 5px;
	    margin-bottom: 12px;
}

.text-field {
    height: 30px;
    min-width: 260px;
    direction: ltr;
    text-align: left;
	width:100%;
}
.text-field::placeholder {
    text-align: right;
}
.product-select{
	min-width:30%;
	width:100%
}
.variation-select{
	min-width:30%
}
.billing-fields {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px;
}
.billing-fields input{
	width:100%;
}
.isReq{
display:none;
	    font-size: 20px;
    color: #eb0f0f;
	    height: 5px;
}
.billing-fields label{
	display:flex;
	align-items:center;
}

.notice:not(.accnot){
	display:none!important
}






@media (max-width: 768px) {
	.content{
		padding-top:70px;
	}
    .container {
        flex-direction: column;
    }

    .sidebar {
        width: 100%;
        display: none;
    position: fixed;
    top: 0;
    right: 0;
    width: 100%;
    z-index: 99;
		padding-top:70px;
		height:100%;
    }

    .hamburger {
        display: block;
		z-index:999;
    }
	
}
</style>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
<script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>

<div class="wrap">
    <h1>صدور فاکتور فروش</h1>
	<?php
	if(@$order_id){
		?>
	<div class="notice inline notice-success  is-dismissible " style="">
				<p>
		سفارش با موفقیت ایجاد شد.
					<a target="_blank" href="<?= get_admin_url() ?>admin.php?page=wc-orders&action=edit&id=<?= $order_id;?>">
					مشاهده سفارش
					</a>
		</p>
				<button type="button" class="notice-dismiss"><span class="screen-reader-text">
					لغو				</span>
				</button>
		</div>
	<?php
	}
	?>
	<form method="post">
		<div style=" display: flex; justify-content: space-between; align-items: center; ">
			<div>
				<label for="order_status">وضعیت سفارش:</label>
				<select type="text" id="order_status" name="order_status" >
				<?php foreach(wc_get_order_statuses() as $key => $status){ ?>
					<option value="<?= $key ?>" <?= 'wc-completed' == $key ? 'selected' : '' ?> > <?= $status ?> </option>
					<?php } ?>
				</select>
			</div>
			<div>
				<label for="order_date_in_en">تاریخ سفارش:</label>
  				<input id="order_date_in_en" hidden name="order_date_in_en" >
  				<input id="order_date_alt" name="order_date_alt" >
				
			</div>
		</div>
	<div class="card">
		<h2>اضافه کردن محصولات:</h2>
        <table class="form-table" >
            <tr>
                <td>
					
                    <div id="product-list">
						<div class="barcode-loading" style="position: absolute;left: 0;top: 0;width: 100%;height: 100%;background: #00000020;z-index: 9999;display:none">
							
						</div>
						<div class="product-item">
							<input class="text-field" id="barcode" placeholder="بارکد محصول">
                            <select name="products[]" class="product-select">
                                <option value="">-- انتخاب کنید --</option>
                                <?php foreach ($products as $product): ?>
                                    <option value="<?php echo $product->get_id(); ?>" data-product-price="<?= $product->get_price() ?>" data-title="<?= $product->get_name() ?>" data-product-type="<?php echo $product->get_type(); ?>">
                                        <?php echo $product->get_name(); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <select name="variations[]" class="variation-select" style="display: none;"></select>
                            <input type="number" name="quantities[]" value="1" min="1" class="quantities" placeholder="تعداد">
                            <button type="button" class="button add-product">افزودن</button>
                    </div>
						</div>
                </td>
            </tr>
        </table>
		</div>
		
	
		<div class="card">
			<h2>
			فهرست محصولات اضافه شده
		</h2>
		<table id="added-items" class="widefat fixed"> 
            <thead>
                <tr>
                    <th>محصول</th>
                    <th>تعداد</th>
                    <th>قیمت واحد</th>
                    <th>قیمت کل</th>
                </tr>
            </thead>
            <tbody>
			</tbody>
		</table>
		</div>
		
		<div class="card">
			<h2>
			اطلاعات مشتری
	</h2>
			<div>
				<label> مشتری: </label>
				<select id="customer" name="customer">
				<option value=""> مشتری مهمان </option>
				<option value="new"> ایجاد مشتری جدید </option>
			</select>
			</div>
			<hr>
			<div class="billing-fields">
				  <div>
  <label for="billing_first_name">نام:</label>
  <input type="text" id="billing_first_name" name="billing_first_name" >
</div>

<div>
  <label for="billing_last_name">نام خانوادگی:</label>
  <input type="text" id="billing_last_name" name="billing_last_name" >
</div>

<div>
  <label for="billing_company">نام شرکت:</label>
  <input type="text" id="billing_company" name="billing_company">
</div>

<div>
  <label for="billing_address_1">آدرس ۱:</label>
  <input type="text" id="billing_address_1" name="billing_address_1" >
</div>

<div>
  <label for="billing_city">شهر:</label>
  <input type="text" id="billing_city" name="billing_city">
</div>

<div>
  <label for="billing_postcode">کد پستی:</label>
  <input type="text" id="billing_postcode" name="billing_postcode">
</div>

<div>
  	<label for="billing_country">کشور:</label>
	<input type="text" id="billing_country" name="billing_country">
</div>

<div>
  <label for="billing_state">استان:</label>
  <input type="text" id="billing_state" name="billing_state">
</div>

<div>
  <label for="billing_email">ایمیل: <span class="isReq">*</span></label>
  <input type="email" id="billing_email" name="billing_email">
</div>

<div>
  <label for="billing_phone">شماره تماس: <span class="isReq">*</span> </label>
  <input type="tel" id="billing_phone" name="billing_phone">
</div>

			</div>
			
		</div>
        <p class="submit">
            <button type="submit" name="generate_invoice" class="button button-primary">صدور فاکتور</button>
        </p>
    </form>
</div>
<script>
	var $ = jQuery.noConflict();
    const wc_ajax_url = "<?php echo $wc_ajax_url; ?>";
jQuery(function($){
	$('.add-product').click(function(){
		var mainSelected = $('.product-select').find('option:selected'); 
		if(mainSelected.data('product-type') == 'variable' && !$('.variation-select').val()){
			return;
		}
		var selected = $('.variation-select').val() ? $('.variation-select').find('option:selected') :  $('.product-select').find('option:selected'); 
		var price = $('.variation-select').val() ? selected.data('product-price') : mainSelected.data('product-price');
		$('#added-items tbody').append(`
<tr>
<td> ${mainSelected.data('title')} ${$('.variation-select').val() ? '-'+selected.data('title') : ''} <input hidden type="hidden" name="product_id[]" value="${$('.variation-select').val() ? $('.variation-select').val() : $('.product-select').val()}"> </td>
<td> ${$('.quantities').val()} <input hidden type="hidden" name="quantities[]" value="${$('.quantities').val()}" />  </td>
<td> ${price.toLocaleString("fa-IR")+' <?= get_woocommerce_currency_symbol() ?>'} </td>
<td> ${($('.quantities').val() * price).toLocaleString("fa-IR")+' <?= get_woocommerce_currency_symbol()?>' } </td>
</tr>
`);
	})
	
	$('#customer').change(function(){
		if($(this).val() == 'new'){
			$('#billing_email,#billing_phone').attr('required',true);
			$(".isReq").show();
		}else{
			$('#billing_email,#billing_phone').attr('required',false);
			$(".isReq").hide();
		}
	})
	$('#barcode').change(async function(){
		let cl = $(this).val();
		$.ajax({
			url:`/wp-admin/admin-ajax.php?action=find_product_by_barcode&barcode=${cl}`,
			dataType:"json",
			beforeSend:function(){
				$('.barcode-loading').show();
			},
			success:function(res){
				if(res.data){
				$('#added-items tbody').append(`
<tr>
<td> ${res.data.title} <input hidden type="hidden" name="product_id[]" value="${res.data.id}"> </td>
<td> ${1} <input hidden type="hidden" name="quantities[]" value="${1}" />  </td>
<td> ${res.data.price.toLocaleString("fa-IR")+' <?= get_woocommerce_currency_symbol() ?>'} </td>
<td> ${(1 * res.data.price).toLocaleString("fa-IR")+' <?= get_woocommerce_currency_symbol()?>' } </td>
</tr>
`);
				}else{
					alert(res.error);
				}
				$('#barcode').val("");
				$('.barcode-loading').hide();
				$('#barcode').focus()
			}
		})
	})
	
	$("#barcode").keydown(function(e) {
  if (e.key === "Enter") {
    e.preventDefault();
	 $(this).trigger("change");
  }
});
	
	$("#order_date_alt").pDatepicker({
		altField:'#order_date_in_en',
		    timePicker: {
        enabled: true,
        meridiem:false
    },
		  initialDate: true,
		  format: 'YYYY-MM-DD HH:mm:ss',
		    onSelect: function(unix) {
				console.log(unix);
    var date = new Date(unix);
    var gregorianDate = date.toISOString().replace('T','').replace('Z', '');
    console.log(gregorianDate);
  }
	});
})



    document.getElementById('product-list').addEventListener('change', function (e) {
        if (e.target.classList.contains('product-select')) {
            const productSelect = e.target;
            const variationSelect = productSelect.closest('.product-item').querySelector('.variation-select');
            const selectedOption = productSelect.options[productSelect.selectedIndex];
            const productId = selectedOption.value;
            const productType = selectedOption.getAttribute('data-product-type');

            if (productType === 'variable') {
                // درخواست برای دریافت متغیرهای محصول
                jQuery("button").attr('disabled',true);
				fetch(wc_ajax_url + '?action=get_variations&product_id=' + productId)
                    .then(response => response.json())
                    .then(data => {
					jQuery("button").attr('disabled',false);
                        if (data.success) {
                            variationSelect.innerHTML = "<option value=''>-- انتخاب متغیر --</option>";
                            data.data.variations.forEach(variation => {
                                variationSelect.innerHTML += `<option value="${variation.id}" data-product-price="${variation.price}" data-title="${variation.name}" >${variation.name}</option>`;
                            });
                            variationSelect.style.display = "inline-block";
                        }
                    });
            } else {
                variationSelect.style.display = "none";
                variationSelect.innerHTML = "";
            }
        }
    });
</script>

