<?php
// محتوای فایل sell.php
if (!defined('ABSPATH')) {
    exit; // جلوگیری از دسترسی مستقیم
}

// دریافت محصولات از ووکامرس
$products = wc_get_products(array('limit' => -1));

if (isset($_POST['generate_cart'])) {
    $order_id = generate_cart();
}

// تعریف wc_ajax_url
$wc_ajax_url = admin_url('admin-ajax.php');
?>
<div class="wrap">
    <h1>صدور فاکتور فروش</h1>
	<?php
	if(@$order_id){
		?>
	<div class="notice inline notice-success  is-dismissible" style="">
				<p>
		سبد خرید با موفقیت ایجاد شد.
					<a target="_blank" href="<?= get_admin_url() ?>admin.php?page=wc-orders&action=edit&id=<?= $order_id;?>">
					مشاهده سبد
					</a>
		</p>
				<button type="button" class="notice-dismiss"><span class="screen-reader-text">
					لغو				</span>
				</button>
		</div>
	<?php
	}
	?>
	<div class="card">
		<h2>اضافه کردن محصولات:</h2>
        <table class="form-table" >
            <tr>
                <td>
                    <div id="product-list">
                        <form onsubmit="return false;" class="product-item" id="topform">
							<input class="text-field" placeholder="بارکد محصول">
                            <select name="products[]" class="product-select" required>
                                <option value="">-- انتخاب کنید --</option>
                                <?php foreach ($products as $product): ?>
                                    <option value="<?php echo $product->get_id(); ?>" data-product-price="<?= $product->get_price() ?>" data-title="<?= $product->get_name() ?>" data-product-type="<?php echo $product->get_type(); ?>">
                                        <?php echo $product->get_name(); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <select name="variations[]" class="variation-select" style="display: none;"></select>
                            <input type="number" name="quantities[]" value="1" min="1" class="quantities" required placeholder="تعداد">
                            <button type="button" class="button add-product">افزودن</button>
                        </form>
                    </div>
                </td>
            </tr>
        </table>
		</div>
		
	<form method="post">
		<div class="card">
			<h2>
			فهرست محصولات اضافه شده
		</h2>
		<table id="added-items" class="widefat fixed"> 
            <thead>
                <tr>
                    <th>محصول</th>
                    <th>تعداد</th>
                    <th>قیمت واحد</th>
                    <th>قیمت کل</th>
                </tr>
            </thead>
            <tbody>
			</tbody>
		</table>
		</div>
        <p class="submit">
            <button type="submit" name="generate_cart" class="button button-primary">صدور فاکتور</button>
        </p>
    </form>
</div>
<script>
    const wc_ajax_url = "<?php echo $wc_ajax_url; ?>";
jQuery(function($){
	$('.add-product').click(function(){
		var mainSelected = $('.product-select').find('option:selected'); 
		if(mainSelected.data('product-type') == 'variable' && !$('.variation-select').val()){
			return;
		}
		var selected = $('.variation-select').val() ? $('.variation-select').find('option:selected') :  $('.product-select').find('option:selected'); 
		var price = $('.variation-select').val() ? selected.data('product-price') : mainSelected.data('product-price');
		$('#added-items tbody').append(`
<tr>
<td> ${mainSelected.data('title')} ${$('.variation-select').val() ? '-'+selected.data('title') : ''} <input hidden type="hidden" name="product_id[]" value="${$('.variation-select').val() ? $('.variation-select').val() : $('.product-select').val()}"> </td>
<td> ${$('.quantities').val()} <input hidden type="hidden" name="quantities[]" value="${$('.quantities').val()}" />  </td>
<td> ${price.toLocaleString("fa-IR")+' <?= get_woocommerce_currency_symbol() ?>'} </td>
<td> ${($('.quantities').val() * price).toLocaleString("fa-IR")+' <?= get_woocommerce_currency_symbol()?>' } </td>
</tr>
`);
		document.getElementById('topform').reset()
	})
	
	$('#customer').change(function(){
		if($(this).val() == 'new'){
			$('#billing_email,#billing_phone').attr('required',true);
			$(".isReq").show();
		}else{
			$('#billing_email,#billing_phone').attr('required',false);
			$(".isReq").hide();
		}
	})
	
})



    document.getElementById('product-list').addEventListener('change', function (e) {
        if (e.target.classList.contains('product-select')) {
            const productSelect = e.target;
            const variationSelect = productSelect.closest('.product-item').querySelector('.variation-select');
            const selectedOption = productSelect.options[productSelect.selectedIndex];
            const productId = selectedOption.value;
            const productType = selectedOption.getAttribute('data-product-type');

            if (productType === 'variable') {
                // درخواست برای دریافت متغیرهای محصول
                jQuery("button").attr('disabled',true);
				fetch(wc_ajax_url + '?action=get_variations&product_id=' + productId)
                    .then(response => response.json())
                    .then(data => {
					jQuery("button").attr('disabled',false);
                        if (data.success) {
                            variationSelect.innerHTML = "<option value=''>-- انتخاب متغیر --</option>";
                            data.data.variations.forEach(variation => {
                                variationSelect.innerHTML += `<option value="${variation.id}" data-product-price="${variation.price}" data-title="${variation.name}" >${variation.name}</option>`;
                            });
                            variationSelect.style.display = "inline-block";
                        }
                    });
            } else {
                variationSelect.style.display = "none";
                variationSelect.innerHTML = "";
            }
        }
    });
</script>

