<?php
/*
Plugin Name: accounting
Plugin URI: 
Description: accounting app
Version: 1.0.1
Requires at least: 5.9
Requires PHP: 5.6
Author: Automattic
Author URI: 
License: GPL2
Text Domain: accounting
*/
defined( 'ABSPATH' ) || exit;

define("ADMIN_PAGE",'accounting');

function create_ln_quickcart_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ln_quickcart';

    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        ID mediumint(9) NOT NULL AUTO_INCREMENT,
        products text NOT NULL,
        discount float NULL,
        create_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
        PRIMARY KEY  (ID)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

register_activation_hook(__FILE__, 'create_ln_quickcart_table');


function my_custom_admin_page() {
    add_submenu_page(
		'woocommerce',
        'فاکتور فروش فوری',
        'فاکتور فروش فوری',
        'manage_options', // قابلیت دسترسی
        ADMIN_PAGE, // شناسه منو
        'custom_admin_page_content', // تابع نمایش محتوا
        '', // آیکون منو (می‌توانید مسیر تصویر خود را قرار دهید)
        100 // موقعیت منو
    );
}
add_action('admin_menu', 'my_custom_admin_page');

function custom_admin_page_content() {
    require_once(plugin_dir_path(__FILE__).'admin/sell.php');
}

function my_custom_admin_styles() {
	var_dump($screen->id);
    $screen = get_current_screen();
    if ($screen->id == 'toplevel_page_'.ADMIN_PAGE) {
        wp_enqueue_style('custom_admin_css', plugin_dir_url(__FILE__) . 'assets/css/admin-style.css',[],time());
        wp_enqueue_script('custom_admin_js', plugin_dir_url(__FILE__) . 'assets/js/admin-js.js', array('jquery'), time(), true);
    }
}
add_action('admin_enqueue_scripts', 'my_custom_admin_styles');

function generate_invoice() {
	 global $woocommerce;

  $address = array(
      'first_name' => sanitize_text_field($_POST['billing_first_name']),
      'last_name'  => sanitize_text_field($_POST['billing_last_name']),
      'company'    => sanitize_text_field($_POST['billing_company']),
      'email'      => sanitize_text_field($_POST['billing_email']),
      'phone'      => sanitize_text_field($_POST['billing_phone']),
      'address_1'  => sanitize_text_field($_POST['billing_address_1']),
      'city'       => sanitize_text_field($_POST['billing_city']),
      'state'      => sanitize_text_field($_POST['billing_state']),
      'postcode'   => sanitize_text_field($_POST['billing_postcode']),
      'country'    => sanitize_text_field($_POST['billing_country']),
  );

  // Now we create the order
  $order = wc_create_order();
	$qtys = $_POST['quantities'];
  foreach($_POST['product_id'] as $key=>$product_id){
  $order->add_product( wc_get_product($product_id), $qtys[$key]);
  }
$sended_date = sanitize_text_field($_POST['order_date_in_en']);
$sended_date = $sended_date / 1000;
	$timezone = wp_timezone_string();
	$date = new DateTime("now", new DateTimeZone($timezone));
	$date->setTimestamp($sended_date);
	$order_date= $date->format('Y-m-d H:i:s');
$order->set_date_created($order_date);
  $order->set_address( $address, 'billing' );
	
	    if ($order->get_billing_email()) {
        // Check if a customer already exists with this email
        $customer = get_user_by('email', $order->get_billing_email());
		if($customer){
			 $order->set_customer_id($customer->ID);
		}elseif (!$customer && $_POST['customer'] == 'new' ) {
            // Prepare the customer data
            $customer_data = array(
                'user_login' => $order->get_billing_email(),
                'user_pass' => wp_generate_password(), // Generate a random password
                'user_email' => $order->get_billing_email(),
                'first_name' => $order->get_billing_first_name(),
                'last_name' => $order->get_billing_last_name(),
                'role' => 'customer', // Default role for customers
            );
		$user_id = wp_insert_user($customer_data);
			$order->set_customer_id($user_id);
		}
		}
  //
  $order->calculate_totals();
  $order->update_status($_POST['order_status'], 'Imported order', TRUE);  

	return $order;
}


add_action('wp_ajax_get_variations', 'get_variations_callback');
function get_variations_callback() {
    if (!isset($_GET['product_id'])) {
        wp_send_json_error(['message' => 'Product ID is missing']);
    }

    $product_id = intval($_GET['product_id']);
    $product = wc_get_product($product_id);

    if (!$product || $product->get_type() !== 'variable') {
        wp_send_json_error(['message' => 'Invalid product']);
    }

    $variations = [];
    foreach ($product->get_available_variations() as $variation) {
        $variations[] = [
            'id' => $variation['variation_id'],
            'name' => implode(', ', array_values($variation['attributes'])),
            'price' => $variation['display_price'],
            'barcode' => $variation['display_price'],
        ];
    }

    wp_send_json_success(['variations' => $variations]);
}


function generate_cart(){
$qtys = $_POST['quantities'];
	$products = [];
  foreach($_POST['product_id'] as $key=>$product_id){
  $products []= ['product'=>$product_id,'qty'=>$qtys[$key]];
  }
	global $wpdb;
	$table_name = $wpdb->prefix . 'ln_quickcart';
	$insert = $wpdb->insert($table_name,[
		'products'=>json_encode($products)
	]);
	return $insert;
}


// اضافه کردن فیلد کاستوم به صفحه ویرایش محصول
// function add_product_barcode_field() {
//     global $woocommerce, $post;
//     $product = wc_get_product( $post->ID );
//     woocommerce_wp_text_input( 
//         array( 
//             'id'          => 'product_barcode', 
//             'label'       => __( 'بارکد محصول', 'woocommerce' ), 
//             'placeholder' => '',
//             'desc_tip'    => true,
//             'description' => __( 'بارکد محصول را وارد کنید.', 'woocommerce' ),
//             'value'       => get_post_meta($post->ID, 'product_barcode', true)
//         ) 
//     );
// }
// add_action('woocommerce_product_options_inventory_product_data', 'add_product_barcode_field');

// // ذخیره سازی فیلد کاستوم
// function save_product_barcode_field( $post_id ) {
//     $product_barcode = $_POST['product_barcode'];
//     update_post_meta( $post_id, 'product_barcode', sanitize_text_field( $product_barcode ) );
// }
// add_action('woocommerce_process_product_meta','save_product_barcode_field');

// اضافه کردن فیلد کاستوم به صفحه ویرایش متغیرهای محصول
function add_variation_barcode_field( $loop, $variation_data, $variation ) {
    woocommerce_wp_text_input( 
        array( 
            'id'          => 'variation_barcode['. $loop. ']', 
            'label'       => __( 'بارکد متغیر', 'woocommerce' ), 
            'placeholder' => '',
            'desc_tip'    => true,
            'description' => __( 'بارکد متغیر را وارد کنید.', 'woocommerce' ),
            'value'       => get_post_meta( $variation->ID, 'variation_barcode', true )
        ) 
    );
}
add_action( 'woocommerce_variation_options', 'add_variation_barcode_field', 10, 3 );

// ذخیره سازی متغیرهای فیلد کاستوم
function save_variation_barcode_field( $variation_id, $i ) {
    $variation_barcode = $_POST['variation_barcode'][$i];
    update_post_meta( $variation_id, 'variation_barcode', sanitize_text_field( $variation_barcode ) );
}
add_action( 'woocommerce_save_product_variation', 'save_variation_barcode_field', 10, 2 );

// // نمایش بارکد در صفحه جزئیات محصول
// function display_product_barcode_single_product() {
//     global $post;
//     $product_barcode = get_post_meta( $post->ID, 'product_barcode', true );
//     if (! empty( $product_barcode ) ) {
//         echo '<p>بارکد محصول: '. $product_barcode. '</p>';
//     }
// }
// add_action( 'woocommerce_single_product_summary', 'display_product_barcode_single_product', 15 );

// // نمایش بارکد برای هر متغیر در صفحه جزئیات محصول
// function display_variation_barcode_single_product( $variation_id ) {
//     $variation_barcode = get_post_meta( $variation_id, 'variation_barcode', true );
//     if (! empty( $variation_barcode ) ) {
//         echo '<p>بارکد متغیر: '. $variation_barcode. '</p>';
//     }
// }
// add_action( 'woocommerce_variation_options', 'display_variation_barcode_single_product', 10, 2 );

add_action("wp_ajax_find_product_by_barcode",'find_product_by_barcode');
function find_product_by_barcode(){
	global $wpdb;
	$barcode = $_REQUEST['barcode'];
	if(!$barcode){
		die();
	}
	$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->postmeta WHERE meta_value=%s",$barcode));
	if($row){
		$product = wc_get_product($row->post_id);
		$data = [
			'title'=>get_the_title($row->post_id),
			'price' => $product->get_price(),
			'id' =>$row->post_id
		];
		wp_send_json(['data'=>$data]);
	}else{
		wp_send_json(['error'=>"محصول یافت نشد"]);
	}
}