<?php
get_header();
?>

<div class="single-page">
    <?php
    if (have_posts()) :
        while (have_posts()) : the_post();
            ?>
            <div class="container mb-4">
                <div class="row">
                    <div class="col-12 col-md-10 mx-auto">
                        <h1 class="single-title text-center wow fadeInUp" data-wow-delay="0.25s">
                            <?php echo get_the_title(); ?>
                        </h1>
                        <div class="single-meta d-flex flex-wrap">
                            <div class="cat-post">
                                <span><i class="icon-category"></i></span>
                                <?php the_category(' , ', ' '); ?>
                            </div>
                            <span class="post_date">
                               <i class="icon-date"></i>
                                <?php echo get_the_date('j.M.Y'); ?>
                            </span>
                        </div>
                        <article class="post-single" itemscope="itemscope" itemtype="http://schema.org/Article">
                            <?php if (has_post_thumbnail()) { ?>
                                <div class="single-thumbnail text-center mb-5">
                                    <?php the_post_thumbnail('large'); ?>
                                </div>
                            <?php } ?>

                            <div class="default-editor"><?php the_content(); ?></div>
                            <div class="d-flex tag-wrapper">
                                <div class="col-12 col-lg-7 single-tags">
                                    <?php if (has_tag()) { ?>
                                        <span> برچسب ها : </span>
                                        <?php the_tags(' ', '  ', '  '); ?>
                                    <?php } ?>
                                </div>
                                <div class="col-12 col-lg-5 single-share-list">
                                    <?php echo socialshares(); ?>
                                </div>
                            </div>
                        </article>
                    </div>
                </div>
            </div>
        <?php
        endwhile;
    endif;
    $idsb = get_field('related_blog');
    if ($idsb) {
        $posts = new WP_Query(array(
            'post_type' => 'post',
            'post__in' => $idsb,
            'posts_per_page' => '4',
        ));
    } else {
        $posts = new WP_Query(array(
            'post_type' => 'post',
            'post__not_in' => array(get_the_ID()),
            'category__in' => wp_get_post_categories(get_the_ID()),
            'posts_per_page' => '4',
        ));
    }
    if ($posts->have_posts()) {
        ?>
        <!-- Related Blog-->
        <section class="related_section">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <h4 class="section-title text-center">مقالات مرتبط</h4>
                    </div>
                    <div class="col-12 col-lg-10 mx-auto">
                        <div class="row">
                            <?php
                            $i = 0.25;
                            while ($posts->have_posts()) :
                                $posts->the_post();
                                echo '<div class="col-12 col-sm-6 wow fadeInUp" data-wow-delay="' . $i . 's">'; ?>
                                <div class="related-item">
                                    <div class="row">
                                        <div class="col-12 col-sm-4">
                                            <?php
                                            if (has_post_thumbnail()) { ?>
                                                <a class="entry-media" href="<?php echo get_the_permalink(); ?>">
                                                    <?php the_post_thumbnail('thumbnail'); ?>
                                                </a>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                        <div class="col-12 col-sm-8">
                                            <div class="related-content">
                                                <h3 class="card-title">
                                                    <a href="<?php echo get_the_permalink(); ?>">
                                                        <?php echo get_the_title(); ?>
                                                    </a>
                                                </h3>
                                                <?php
                                                $trimexcerpt = get_the_excerpt();
                                                $shortexcerpt = mb_strimwidth($trimexcerpt, 0, $num_words = 80, ' ...');
                                                ?>
                                                <p><?php echo $shortexcerpt; ?></p>
                                                <a class="more-link" href="<?php echo get_the_permalink(); ?>">
                                                    <i class="icon-arrow-left"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php echo '</div>';
                                $i += 0.25; endwhile;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php }
    wp_reset_query();
    if (comments_open() && post_type_supports(get_post_type(), 'comments')) {
        ?>
        <!-- Comment-->
        <div class="comment-section">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12 col-md-10 mx-auto">
                        <h4 class="section-title text-center">نظرات کاربران</h4>

                        <?php comments_template(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
</div>
</div>
<?php get_footer(); ?>
