<?php
/*
**************   COMMENT DESIGN   **************
*/
add_filter('comment_author', 'custom_comment_author', 10, 2);

function custom_comment_author($author, $commentID)
{
    $comment = get_comment($commentID);
    $user = get_user_by('email', $comment->comment_author_email);
    if (!$user):
        return $author;
    else:
        $firstname = get_user_meta($user->id, 'first_name', true);
        $lastname = get_user_meta($user->id, 'last_name', true);
        if (empty($firstname) or empty($lastname)):
            return $author;
        else:
            return $firstname . ' ' . $lastname;
        endif;
    endif;
}

function tiyara_comment($comment, $args, $depth)
{
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);
    if ('div' == $args['style']) {
        $tag = 'div';
        $add_below = 'comment';
    } else {
        $tag = 'div';
        $add_below = 'div-comment ';
    }
    ?>
    <<?php echo $tag ?> <?php comment_class(empty($args['has_children']) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">
    <div class="comment_box">
        <?php if ('div' != $args['style']) : ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment-card">
            <?php endif; ?>
            <?php if ($comment->comment_approved == '0') : ?>
                <em class="comment-awaiting-moderation waiting_pm"><?php _e('Your comment is awaiting moderation.'); ?></em>
            <?php endif; ?>
            <div class="comment-meta d-flex">
                    <span class="comment_name">
                       <?php echo get_comment_author(); ?>
                    </span>
                <div class="comment-left-meta">
                        <span class="comment-date">
                            <?php echo get_comment_date('j . M . Y'); ?>
                        </span>
                    <div class="comment-reply">
                        <?php comment_reply_link(array_merge($args, array('reply_text' => 'پاسخ دهید', 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                    </div>
                </div>
            </div>
            <div class="comment-text">
                <?php comment_text(); ?>
            </div>
            <?php if ('div' != $args['style']) : ?>
        </div>
    <?php endif; ?>
    </div>
    </div>
<?php }

//Comments
if (!function_exists('tiyara_comment_form')) {
    /**
     * Comment form
     */
    function tiyara_comment_form($args = array(), $post_id = null)
    {
        $post_id = get_the_ID();

        $commenter = wp_get_current_commenter();
        $user = wp_get_current_user();
        $user_identity = $user->exists() ? $user->display_name : '';

        if (!isset($args['format']))
            $args['format'] = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';


        $req = get_option('require_name_email');

        $aria_req = ($req ? " aria-required='true'" : '');

        $html5 = 'html5' === $args['format'];
        $fields = array(
            'author' => '<div class="col-12 col-md-12 col-lg-6 "><div class="comment-form-author  comment-field">
				<input autocomplete="off" class="form-control author" id="author" placeholder="نام و نام خانوادگی" name="author" type="text"
				value="' . esc_attr($commenter['comment_author']) . '" ' . $aria_req . ' />
			</div></div>',
            'email' => '<div class="col-12 col-md-12 col-lg-6"><div class="comment-form-email  comment-field ">
        		<input autocomplete="off" id="email" class="form-control email" name="email" placeholder="info@sample.com" ' . ($html5 ? 'type="email"' : 'type="text"') . '
				value="' . esc_attr($commenter['comment_author_email']) . '" ' . $aria_req . ' />
				</div></div> ',
            'comment_field' => '<div class="col-12 col-md-12 col-lg-12"><div class="comment-field">
            <textarea class="form-control comment-message" id="comment" name="comment" placeholder="پیام خود را اینجا بنویسید" rows="3" aria-required="true"></textarea>
			</div></div>',
            'submit' => '<div class="col-12 form-submit">
			<input id="submit" name="submit" type="submit" value="ارسال نظر" /></div>',
        );

        $required_text = sprintf(' ' . __('Required fields are marked %s', 'tiyara'), '<span class="required">*</span>');
        $defaults = array(
            'fields' => apply_filters('comment_form_default_fields', $fields),
            'comment_field' => '',
            'must_log_in' => '<div class="alert alert-danger must-log-in">'
                . sprintf(__('You must be <a href="%s">logged in</a> to post a comment.'), wp_login_url(apply_filters('the_permalink', get_permalink($post_id))))
                . '</div>',
            'logged_in_as' => '<div class="alert-by-comment mb-4"><div class="logged-in-as">' . sprintf(__(' نام کاربری: <span>%2$s</span> <a href="%3$s" title="Log out of this account" class="trn_elm_logout">خروج</a>', 'tiyara'), get_bloginfo('url') . '/profile/?id=' . $user->id, $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</div></div><div class="col-12 form-group comment-form-comment">
			<div class="row login_textarea">
			<div class="col-12 col-md-12 col-lg-12 comment-field">
				<textarea class="form-control comment-message" id="comment" name="comment" placeholder="' . _x('پیام خود را اینجا بنویسید', 'noun', 'tiyara') . '" rows="8" aria-required="true"></textarea>
			</div>
			<div class="col-12 form-submit"><input class=""  id="submit" name="submit" type="submit" value="ارسال نظر"  /></div></div>',

            'comment_notes_before' => '',
            'comment_notes_after' => '<div class="form-allowed-tags">' . sprintf(__('You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s', 'tiyara'), ' <code>' . allowed_tags() . '</code>') . '</div>',
            'id_form' => 'commentform',
            'id_submit' => 'submit',
            'title_reply' => __('Leave a Reply', 'tiyara'),
            'title_reply_to' => __('Leave a Reply to %s', 'tiyara'),
            'cancel_reply_link' => __('انصراف', 'tiyara'),
            'label_submit' => __('Post Comment', 'tiyara'),
            'format' => 'xhtml',
        );

        $args = wp_parse_args($args, apply_filters('comment_form_defaults', $defaults));
        if (comments_open($post_id)) {
            do_action('comment_form_before'); ?>
            <div id="respond" class="comment-respond">
            <?php
            if (is_user_logged_in()) {
                $class = "login";
            } else {
                $class = " ";
            }
            ?>
            <h3 id="reply-title" class="comment-reply-title <?php echo $class; ?>">
                <small><?php cancel_comment_reply_link($args['cancel_reply_link']); ?></small>
            </h3>
            <?php if (get_option('comment_registration') && !is_user_logged_in()) {
                echo $args['must_log_in'];
                do_action('comment_form_must_log_in_after');
            } else { ?>
                <form action="<?php echo site_url('/wp-comments-post.php'); ?>" method="post"
                      id="<?php echo esc_attr($args['id_form']); ?>"
                      class="form-horizontal row comment-form"<?php echo $html5 ? ' novalidate' : ''; ?> >
                    <?php do_action('comment_form_top');
                    if (is_user_logged_in()) {
                        echo apply_filters('comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity);
                        do_action('comment_form_logged_in_after', $commenter, $user_identity);
                    } else {
                        echo $args['comment_notes_before'];
                        do_action('comment_form_before_fields');
                        foreach ((array)$args['fields'] as $name => $field) {
                            echo apply_filters("comment_form_field_{$name}", $field) . "\n";
                        }
                        do_action('comment_form_after_fields');
                    }
                    echo apply_filters('comment_form_field_comment', $args['comment_field']);
                    echo $args['comment_notes_after'];
                    comment_id_fields($post_id);
                    do_action('comment_form', $post_id); ?>
                </form>
                </div>
            <?php }
            do_action('comment_form_after');
        } else {
            do_action('comment_form_comments_closed');
        }
    }
}
?>
