<?php
require_once get_template_directory().'/libs/css_js_include.php';
require_once get_template_directory().'/libs/css_js_include_helper.php';
require_once get_template_directory().'/libs/plugins.php';
require_once get_template_directory().'/libs/help_functions.php';
require_once get_template_directory().'/libs/pin_management.php';
require_once get_template_directory().'/libs/ajax_functions.php';
require_once get_template_directory().'/libs/ajax_functions_edit.php';
require_once get_template_directory().'/libs/ajax_functions_booking.php';
require_once get_template_directory().'/libs/ajax_upload.php';
require_once get_template_directory().'/libs/3rdparty.php';
require_once get_template_directory().'/libs/theme-setup.php';
require_once get_template_directory().'/libs/general-settings.php';
require_once get_template_directory().'/libs/listing_functions.php';
require_once get_template_directory().'/libs/theme-slider.php';
require_once get_template_directory().'/libs/events.php';
require_once get_template_directory().'/libs/icalendar.php';
require_once get_template_directory().'/libs/reviews.php';
require_once get_template_directory().'/libs/megamenu.php';
require_once get_template_directory().'/libs/search_functions.php';
require_once get_template_directory().'/word_remove.php';
require_once get_template_directory().'/libs/dashboard_widgets.php';
require_once get_template_directory().'/world_manage.php';
require_once get_template_directory().'/libs/search_functions2.php';
require_once get_template_directory().'/libs/search_functions3.php';
require_once get_template_directory().'/libs/search_functions4.php';
require_once get_template_directory().'/libs/theme-import.php'; 
   
if ($current_user->has_cap('create_users') ) {
    add_action('admin_notices', 'wpestate_admin_display_verifications');
}


load_theme_textdomain('wprentals', get_template_directory() . '/languages');

define('ULTIMATE_NO_EDIT_PAGE_NOTICE', true);
define('ULTIMATE_NO_PLUGIN_PAGE_NOTICE', true);
define('CLUBLINK', 'rentalsclub.org');
define('CLUBLINKSSL', 'https');
# Disable check updates - 
define('BSF_6892199_CHECK_UPDATES',false);

# Disable license registration nag -
define('BSF_6892199_NAG', false);



/** REMOVE REDUX MESSAGES */
function remove_redux_messages() {
	if(class_exists('ReduxFramework')){
		remove_action( 'admin_notices', array( get_redux_instance('theme_options'), '_admin_notices' ), 99);
	}
}

/** HOOK TO REMOVE REDUX MESSAGES */
add_action('init', 'remove_redux_messages');


add_action( 'redux/loaded', 'remove_demo' );
/**
 * Removes the demo link and the notice of integrated demo from the redux-framework plugin
 */
if ( ! function_exists( 'remove_demo' ) ) {
    function remove_demo() {
        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
            remove_filter( 'plugin_row_meta', array(
                ReduxFrameworkPlugin::instance(),
                'plugin_metalinks'
            ), null, 2 );

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
        }
    }
}








function wpestate_admin_notice() {
    global $pagenow;
    global $typenow;
    
    
     wpestate_show_license_form();
    
    if (!empty($_GET['post'])) {
        $allowed_html   =   array();
        $post = get_post(wp_kses($_GET['post'],$allowed_html));
        $typenow = $post->post_type;
    }
//update_option('wp_estate_cache_notice','no');
    if(  esc_html( get_option('wp_estate_cache_notice') !=='yes') ){
        print '<div id="modal_notice" class="modal_notice"><p>'.esc_html__('For better speed results, the theme offers a built-in caching system for properties and categories.','wprentals').'</p>';
        print '<p>'.esc_html__('Because of that, properties or categories may not appear immediately on your site.','wprentals').'</p>';
        print '<p>'.esc_html__('Use the Clear Wp Rentals Cache button from the admin bar to see the changes made instantly. Automatic updates happen every 4 hours.','wprentals').'</p>';
        print '<p><a class="wpestate_admin_button reverse_but" id="cache_notice" style="margin-top:10px;" href="#">'.esc_html__('I Understand','wprentals').'</a></p>';
        print '</div>';
    }
    
    
    $api_key                        =   esc_html( wprentals_get_option('wp_estate_api_key') );
    if($api_key===''){
        print '<div class="error">
            <p>'.esc_html__( 'Google Maps will NOT WORK without a correct Api Key. Get one from ','wprentals').'<a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">'.esc_html__('here','wprentals').'</a></p>
        </div>';
    }
    
    if ( WP_MEMORY_LIMIT < 96 ) { 
        print '<div class="error">
            <p>'.esc_html__( 'Wordpress Memory Limit is set to ', 'wprentals' ).' '.WP_MEMORY_LIMIT.' '.esc_html__( 'Recommended memory limit should be at least 96MB. Please refer to : ','wprentals').'<a href="http://codex.wordpress.org/Editing_wp-config.php#Increasing_memory_allocated_to_PHP" target="_blank">'.esc_html__('Increasing memory allocated to PHP','wprentals').'</a></p>
        </div>';
    }
    
    if (!defined('PHP_VERSION_ID')) {
        $version = explode('.', PHP_VERSION);
        define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
    }

    if(PHP_VERSION_ID<50600){
        $version = explode('.', PHP_VERSION);
        print '<div class="error">
            <p>'.__( 'Your PHP version is ', 'wprentals' ).' '.$version[0].'.'.$version[1].'.'.$version[2].'. We recommend upgrading the PHP version to at least 5.6.1. The upgrade should be done on your server by your hosting company. </p>
        </div>';
    }
    
    if ( !extension_loaded('mbstring')) { 
        print '<div class="error">
            <p>'.__( 'MbString extension not detected. Please contact your hosting provider in order to enable it.', 'wprentals' ).'</p>
        </div>';
    }
    
    //print  $pagenow.' / '.$typenow .' / '.basename( get_page_template($post) );
    
    if (is_admin() &&   $pagenow=='post.php' && $typenow=='page' && basename( get_page_template($post))=='property_list_half.php' ){
        $header_type    =   get_post_meta ( $post->ID, 'header_type', true);
      
        if ( $header_type != 5){
            print '<div class="error">
            <p>'.esc_html__( 'Half Map Template - make sure your page has the "media header type" set as google map ', 'wprentals' ).'</p>
            </div>';
        }
       
    }
    
    if (is_admin() &&   $pagenow=='edit-tags.php'  && $typenow=='estate_property') {
    
        print '<div class="error">
            <p>'.esc_html__( 'Please do not manually change the slugs when adding new terms. If you need to edit a term name copy the new name in the slug field also.', 'wprentals' ).'</p>
        </div>';
    }
    
    
    if (is_admin() &&  ( $pagenow=='post-new.php' || $pagenow=='post.php') && $typenow=='estate_property') {
    
        print '<div class="error">
            <p>'.esc_html__( 'Please add properties from front end interface using an user with subscriber level registered in front end', 'wprentals' ).'</p>
        </div>';
    }
  
    if(wpestate_get_template_link('ical.php')==home_url()){
        print '<div class="update-nag">
            <p>'.esc_html__( 'You need to create a page with the template ICAL FEED (if you want to use icalendar export/import feature)', 'wprentals' ).'</p>
        </div>';
    }

     if(wpestate_get_template_link('user_dashboard_allinone.php')==home_url()){
        print '<div class="update-nag">
            <p>'.esc_html__( 'You need to create a page with the template All in one calendar (if you want to use all in one calendar feature)', 'wprentals' ).'</p>
        </div>';
    }
    
    $current_tz= date_default_timezone_get();
    if( wpestate_isValidTimezoneId2($current_tz)!= 1 ){
         print '<div class="update-nag">
            <p>'.esc_html__( 'It looks like you may have a problem with the server date.timezone settings and may encounter errors like the one described here:', 'wprentals' ).'<a href="http://help.wprentals.org/2015/12/21/calendar-doesnt-work-calendar-issues/">http://help.wprentals.org/2015/12/21/calendar-doesnt-work-calendar-issues/</a> '.esc_html__('Please resolve these issues with your hosting provider.','wprentals').' </p>
        </div>';
    }
}
 
function wpestate_isValidTimezoneId2($tzid){
    $valid = array();
    $tza = timezone_abbreviations_list();
   
    foreach ($tza as $zone)
        
      foreach ($zone as $item)
        $valid[$item['timezone_id']] = true;
    unset($valid['']);
    return !!$valid[$tzid];
}

add_action( 'admin_notices', 'wpestate_admin_notice' );

add_action('after_setup_theme', 'wp_estate_init');
if (!function_exists('wp_estate_init')):

    function wp_estate_init() {

        global $content_width;
        if (!isset($content_width)) {
            $content_width = 1800;
        }

        load_theme_textdomain('wprentals', get_template_directory() . '/languages');
        set_post_thumbnail_size(940, 198, true);
        add_editor_style();
        add_theme_support('post-thumbnails');
        add_theme_support('automatic-feed-links');
        add_theme_support('custom-background');
        add_theme_support("title-tag");
        wp_estate_setup();
      
        add_action('widgets_init', 'wpestate_widgets_init');
        
        //add_action('init', 'wpestate_shortcodes');
        wp_oembed_add_provider('#https?://twitter.com/\#!/[a-z0-9_]{1,20}/status/\d+#i', 'https://api.twitter.com/1/statuses/oembed.json', true);
        wpestate_image_size();
        add_filter('excerpt_length', 'wp_estate_excerpt_length');
        add_filter('excerpt_more', 'wpestate_new_excerpt_more');
        add_action('tgmpa_register', 'wpestate_required_plugins');
        add_action('wp_enqueue_scripts', 'wpestate_scripts'); // function in css_js_include.php
        add_action('admin_enqueue_scripts', 'wpestate_admin'); // function in css_js_include.php
        update_option( 'image_default_link_type', 'file' );
        
        if( get_option('wprentals_convert_to_redux_ammenities','')!='yes' ){
            wpestate_convert_to_redux_framework_ammenities();
            update_option('wprentals_convert_to_redux_ammenities','yes');
        }
        
    }

endif; // end   wp_estate_init  



///////////////////////////////////////////////////////////////////////////////////////////
/////// If admin create the menu
///////////////////////////////////////////////////////////////////////////////////////////
if (is_admin()) {
    //add_action('admin_menu', 'wpestate_manage_admin_menu');
}

if (!function_exists('wpestate_manage_admin_menu')):
    function wpestate_manage_admin_menu() {
        global $theme_name;
        add_menu_page('WpRentals Options', 'WpRentals Options', 'administrator', 'libs/theme-admin.php', 'wpestate_new_general_set', get_template_directory_uri() . '/img/rentals_icon.png', 1);
    

        require_once get_template_directory().'/libs/property-admin.php';
        require_once get_template_directory().'/libs/pin-admin.php';
        require_once get_template_directory().'/libs/theme-admin.php';
    }
endif; // end   wpestate_manage_admin_menu 




add_action( 'admin_post_wpestate_purge_cache', 'wpestate_purge_cache' );

function wpestate_purge_cache(){
    if ( isset( $_GET['action'], $_GET['_wpnonce'] ) ) {

            if ( ! wp_verify_nonce( $_GET['_wpnonce'], 'theme_purge_cache' ) ) {
                    wp_nonce_ays( '' );
            }
  
            wpestate_delete_cache();
            wp_redirect( wp_get_referer() );
            die();
	}
}

if ( !function_exists('wpestate_add_language_currency_cache')):
    function wpestate_add_language_currency_cache($name,$only_lang=0){
        if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
            $name.='_'. ICL_LANGUAGE_CODE;
        }

        if ( isset($_COOKIE['my_custom_curr_symbol'] )  && $only_lang==0 ){
            $name.='_'.$_COOKIE['my_custom_curr_symbol'];
        }
        return $name;
    }
endif;



//////////////////////////////////////////////////////////////////////////////////////////////
// page details : setting sidebar position etc...
//////////////////////////////////////////////////////////////////////////////////////////////

if (!function_exists('wpestate_page_details')):

    function wpestate_page_details($post_id) {
        $return_array = array();

        
        if ($post_id != '' && !is_home() && !is_tax() && !is_search()) {
            $sidebar_name   = esc_html(get_post_meta($post_id, 'sidebar_select', true));
            $sidebar_status = esc_html(get_post_meta($post_id, 'sidebar_option', true));
        } else {
            $sidebar_name   = esc_html(wprentals_get_option('wp_estate_blog_sidebar_name', ''));
            $sidebar_status = esc_html(wprentals_get_option('wp_estate_blog_sidebar', ''));
        }

        if ('' == $sidebar_name) {
            $sidebar_name = 'primary-widget-area';
        }
        if ('' == $sidebar_status) {
            $sidebar_status = 'right';
        }


        if ('left' == $sidebar_status) {
            $return_array['content_class'] = 'col-md-8 col-md-push-4 ';
            $return_array['sidebar_class'] = 'col-md-4 col-md-pull-8 ';
        } else if ($sidebar_status == 'right') {
            $return_array['content_class'] = 'col-md-8 ';
            $return_array['sidebar_class'] = 'col-md-4 ';
        } else {
            $return_array['content_class'] = 'col-md-12';
            $return_array['sidebar_class'] = 'none';
        }

        $return_array['sidebar_name'] = $sidebar_name;

        return $return_array;
    }

endif; // end   wpestate_page_details 



///////////////////////////////////////////////////////////////////////////////////////////
/////// generate custom css
///////////////////////////////////////////////////////////////////////////////////////////

add_action('wp_head', 'wpestate_generate_options_css');
if (!function_exists('wpestate_generate_options_css')):

    function wpestate_generate_options_css() {
        $general_font   = esc_html(wprentals_get_option('wp_estate_general_font'));
        $custom_css     = html_entity_decode(stripslashes(wprentals_get_option('wp_estate_custom_css')));
        $color_scheme   = esc_html(wprentals_get_option('wp_estate_color_scheme'));
        $on_child_theme = esc_html ( wprentals_get_option('wp_estate_on_child_theme') );
        echo "<style type='text/css'>";
          
            
            if($on_child_theme!=1){
            
                if ( $general_font != '' && $general_font != 'x'){
                    require_once get_template_directory().'/libs/custom_general_font.php';
                }
                require_once get_template_directory().'/libs/customcss.php';
                print $custom_css;
        
            }
        echo "</style>";
        
    }

endif; // end   generate_options_css 
///////////////////////////////////////////////////////////////////////////////////////////
///////  Display navigation to next/previous pages when applicable
///////////////////////////////////////////////////////////////////////////////////////////

if (!function_exists('wp_estate_content_nav')) :
    function wp_estate_content_nav($html_id) {
        global $wp_query;

        if ($wp_query->max_num_pages > 1) :
            ?>
            <nav id="<?php echo esc_attr($html_id); ?>">
                <h3 class="assistive-text"><?php esc_html_e('Post navigation', 'wprentals'); ?></h3>
                <div class="nav-previous"><?php next_posts_link(esc_html__( '<span class="meta-nav">&larr;</span> Older posts', 'wprentals')); ?></div>
                <div class="nav-next"><?php previous_posts_link(esc_html__( 'Newer posts <span class="meta-nav">&rarr;</span>', 'wprentals')); ?></div>
            </nav><!-- #nav-above -->
            <?php
        endif;
    }

endif; // wpestate_content_nav

///////////////////////////////////////////////////////////////////////////////////////////
///////  Comments
///////////////////////////////////////////////////////////////////////////////////////////

if (!function_exists('wpestate_comment')) :

    function wpestate_comment($comment, $args, $depth) {
        $GLOBALS['comment'] = $comment;
        switch ($comment->comment_type) :
            case 'pingback' :
            case 'trackback' :
                ?>
                <li class="post pingback">
                    <p><?php esc_html_e('Pingback:', 'wprentals'); ?> <?php comment_author_link(); ?><?php edit_comment_link(esc_html__( 'Edit', 'wprentals'), '<span class="edit-link">', '</span>'); ?></p>
                <?php
                break;
            default :
                ?>




        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">

            <?php
                $avatar =esc_url( wpestate_get_avatar_url(get_avatar($comment, 55)));
                print '<div class="blog_author_image singlepage" style="background-image: url(' . esc_url($avatar) . ');">';
                print '</div>';
                ?>

                <div id="comment-<?php comment_ID(); ?>" class="comment">     
                <?php edit_comment_link(esc_html__( 'Edit', 'wprentals'), '<span class="edit-link">', '</span>'); ?>
                    <div class="comment-meta">
                        <div class="comment-author vcard">
                        <?php
                        print '<div class="comment_name">' . get_comment_author_link() . '</div>';
                        print '<span class="comment_date">' . esc_html__( ' on ', 'wprentals') . ' ' . get_comment_date() . '</span>';
                        ?>
                        </div><!-- .comment-author .vcard -->

                <?php if ($comment->comment_approved == '0') : ?>
                    <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'wprentals'); ?></em>
                    <br />
                <?php endif; ?>

                </div>

                <div class="comment-content">
                <?php comment_text(); ?>

                <?php comment_reply_link(array_merge($args, array('reply_text' => '<i class="fas fa-reply"></i> ' . esc_html__( 'Reply', 'wprentals'), 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                </div>

            </div><!-- #comment-## -->
            <?php
            break;
        endswitch;
    }

endif; // ends check for  wpestate_comment 



if (!current_user_can('activate_plugins')) {
    
    if (!function_exists('wpestate_admin_bar_render')):
        function wpestate_admin_bar_render() {
            global $wp_admin_bar;
            $wp_admin_bar->remove_menu('edit-profile', 'user-actions');
        }
    endif;

    add_action('wp_before_admin_bar_render', 'wpestate_admin_bar_render');

    add_action('admin_init', 'wpestate_stop_access_profile');
    if (!function_exists('wpestate_stop_access_profile')):
        function wpestate_stop_access_profile() {
            global $pagenow;

            if (defined('IS_PROFILE_PAGE') && IS_PROFILE_PAGE === true) {
                wp_die(esc_html__( 'Please edit your profile page from site interface.', 'wprentals'));
            }

            if ($pagenow == 'user-edit.php') {
                wp_die(esc_html__( 'Please edit your profile page from site interface.', 'wprentals'));
            }
        }
    endif; // end   wpestate_stop_access_profile 
}// end user can activate_plugins


///////////////////////////////////////////////////////////////////////////////////////////
// get attachment info
///////////////////////////////////////////////////////////////////////////////////////////

if (!function_exists('wpestate_get_attachment')):
    function wpestate_get_attachment($attachment_id) {

        $attachment = get_post($attachment_id);
        return array(
            'alt' => get_post_meta($attachment->ID, '_wp_attachment_image_alt', true),
            'caption' => $attachment->post_excerpt,
            'description' => $attachment->post_content,
            'href' => esc_url( get_permalink($attachment->ID) ),
            'src' => $attachment->guid,
            'title' => $attachment->post_title
        );
    }
endif;


add_action('get_header', 'wpestate_my_filter_head');
if (!function_exists('wpestate_my_filter_head')):
    function wpestate_my_filter_head() {
        remove_action('wp_head', '_admin_bar_bump_cb');
    }
endif;

///////////////////////////////////////////////////////////////////////////////////////////
// loosing session fix
///////////////////////////////////////////////////////////////////////////////////////////
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head');

///////////////////////////////////////////////////////////////////////////////////////////
// forgot pass action
///////////////////////////////////////////////////////////////////////////////////////////

add_action('wp_head', 'wpestate_hook_javascript');
if (!function_exists('wpestate_hook_javascript')):
    function wpestate_hook_javascript() {
        global $wpdb;
        $allowed_html = array();
        if (isset($_GET['key']) && $_GET['action'] == "reset_pwd") {
            $reset_key  =   sanitize_text_field ( wp_kses($_GET['key'], $allowed_html) );
            $user_login =   sanitize_text_field( wp_kses($_GET['login'], $allowed_html) );
            $user_data  =   $wpdb->get_row($wpdb->prepare("SELECT ID, user_login, user_email FROM $wpdb->users 
    WHERE user_activation_key = %s AND user_login = %s", $reset_key, $user_login));


            if (!empty($user_data)) {
                $user_login     =   $user_data->user_login;
                $user_email     =   $user_data->user_email;
                $user_mobile    =   get_the_author_meta( 'mobile' , $user_data->ID );
                
                if (!empty($reset_key) && !empty($user_data)) {
                    $new_password = wp_generate_password(7, false);
                    wp_set_password($new_password, $user_data->ID);
                    
                    $arguments=array(
                        'user_pass'        =>  $new_password,
                        'user_login'       =>  $user_login,
                      
                    );
                    wpestate_select_email_type($user_email,'password_reseted',$arguments);
                    
                    $mess = '<div class="login-alert">' . esc_html__( 'A new password was sent via email!', 'wprentals') .$user_mobile. '</div>';
                    
                } else {
                    exit('Not a Valid Key.');
                }
            }// end if empty
            print '<div class="login_alert_full" id="forgot_notice">' . esc_html__( 'We have just sent you a new password. Please check your email!', 'wprentals') . '</div>';
        }
    }
endif;

if ( !function_exists('wpestate_get_pin_file_path_read')):
    
    function wpestate_get_pin_file_path_read(){
        if (function_exists('icl_translate') ) {
            $path=trailingslashit( get_template_directory_uri() ).'/pins-'.apply_filters( 'wpml_current_language', 'en' ).'.txt';
        }else{
            $path=trailingslashit( get_template_directory_uri() ).'/pins.txt';
        }
   
        return $path;
    }

endif;

if ( !function_exists('wpestate_get_pin_file_path_write')):
    
    function wpestate_get_pin_file_path_write(){
        if (function_exists('icl_translate') ) {
            $path=get_template_directory().'/pins-'.apply_filters( 'wpml_current_language', 'en' ).'.txt';
        }else{
            $path=get_template_directory().'/pins.txt';
        }
 
        return $path;
    }

endif;


add_filter( 'redirect_canonical','wpestate_disable_redirect_canonical',10,2 ); 
function wpestate_disable_redirect_canonical( $redirect_url ,$requested_url){
    //print '$redirect_url'.$redirect_url;
    //print '$requested_url'.$requested_url;
    if ( is_page_template('property_list.php') || is_page_template('property_list_half.php') ){
      //  print 'bag false';
        $redirect_url = false;
    }
    
   
    return $redirect_url;
}



if ( !function_exists('wpestate_check_user_level')):
    function wpestate_check_user_level(){
        $current_user                   =   wp_get_current_user();
        $userID                         =   $current_user->ID;
        $user_login                     =   $current_user->user_login;
        $separate_users_status          =   esc_html ( wprentals_get_option('wp_estate_separate_users') );   
        $publish_only                   =   esc_html ( wprentals_get_option('wp_estate_publish_only') );   
        
      
        if (trim($publish_only) != '' ){
            $user_array=explode(',',$publish_only);
          
            if ( in_array ($user_login,$user_array)){
                return true;
            }else{
                return false;
            }
            
        }
        
        
        if($separate_users_status=='no'){
            return true;
        }else{
            $user_level = intval( get_user_meta($userID,'user_type',true));
        
            if($user_level==0){ // user can book and rent
                return true;
            }else{// user can only book
                if( basename(get_page_template()) == 'user_dashboard.php' || 
                basename(get_page_template()) == 'user_dashboard_add_step1.php' || 
                basename(get_page_template()) == 'user_dashboard_edit_listing.php' || 
                basename(get_page_template()) == 'user_dashboard_my_bookings.php'  || 
                basename(get_page_template()) == 'user_dashboard_packs.php'  || 
                basename(get_page_template()) == 'user_dashboard_searches.php' ||
                basename(get_page_template()) == 'user_dashboard_allinone.php'  )    {
                   
                    return false;
                }
                
            }
            
        }
        
    }
endif;


function estate_create_onetime_nonce($action = -1) {
    $time = time();
  // print $time.$action;
   $nonce = wp_create_nonce($time.$action);
    return $nonce . '-' . $time;
}
//1455041901register_ajax_nonce_topbar

function estate_verify_onetime_nonce( $_nonce, $action = -1) {
    $parts  =   explode( '-', $_nonce );
    $nonce  =   $toadd_nonce    = $parts[0]; 
    $generated = $parts[1];

    $nonce_life = 60*60;
    $expires    = (int) $generated + $nonce_life;
    $time       = time();

    if( ! wp_verify_nonce( $nonce, $generated.$action ) || $time > $expires ){
        return false;
    }
    
    $used_nonces = get_option('_sh_used_nonces');

    if( isset( $used_nonces[$nonce] ) ) {
        return false;
    }

    if(is_array($used_nonces)){
        foreach ($used_nonces as $nonce=> $timestamp){
            if( $timestamp > $time ){
                break;
            }
            unset( $used_nonces[$nonce] );
        }
    }

    $used_nonces[$toadd_nonce] = $expires;
    asort( $used_nonces );
    update_option( '_sh_used_nonces',$used_nonces );
    return true;
}




function estate_verify_onetime_nonce_login( $_nonce, $action = -1) {
    $parts = explode( '-', $_nonce );
    $nonce =$toadd_nonce= $parts[0];
    $generated = $parts[1];

    $nonce_life = 60*60;
    $expires    = (int) $generated + $nonce_life;
    $expires2   = (int) $generated + 120;
    $time       = time();

    if( ! wp_verify_nonce( $nonce, $generated.$action ) || $time > $expires ){
        return false;
    }
    
    //Get used nonces
    $used_nonces = get_option('_sh_used_nonces');

    if( isset( $used_nonces[$nonce] ) ) {
        return false;
    }

    if(is_array($used_nonces)){
        foreach ($used_nonces as $nonce=> $timestamp){
            if( $timestamp > $time ){
                break;
            }
            unset( $used_nonces[$nonce] );
        }
    }

    //Add nonce in the stack after 2min
    if($time > $expires2){
        $used_nonces[$toadd_nonce] = $expires;
        asort( $used_nonces );
        update_option( '_sh_used_nonces',$used_nonces );
    }
    return true;
}




///////////////////////////////////////////////////////////////////////////////////////////
// prevent changing the author id when admin hit publish
///////////////////////////////////////////////////////////////////////////////////////////

add_action( 'transition_post_status', 'wpestate_correct_post_data',10,3 );

if( !function_exists('wpestate_correct_post_data') ):
    
function wpestate_correct_post_data( $strNewStatus,$strOldStatus,$post) {
    /* Only pay attention to posts (i.e. ignore links, attachments, etc. ) */
    if( $post->post_type !== 'estate_property' )
        return;

    if( $strOldStatus === 'new' ) {
        update_post_meta( $post->ID, 'original_author', $post->post_author );
    }

       
    
    /* If this post is being published, try to restore the original author */
    if( $strNewStatus === 'publish' ) {
    
         
            $originalAuthor_id =$post->post_author;
            $user = get_user_by('id',$originalAuthor_id); 
            if(!$user){
                return;
            }
            $user_email=$user->user_email;
            
      
            
            
            if( $user->roles[0]=='subscriber'){
                $arguments=array(
                    'post_id'           =>  $post->ID,
                    'property_url'      =>  get_permalink($post->ID),
                    'property_title'    =>  get_the_title($post->ID),
                    'listing_author'    =>  $post->post_author,
                );
                
                if($strOldStatus=='pending'){
                      
                    if( $user->roles[0]=='subscriber'){
                        $arguments=array(
                            'post_id'           =>  $post->ID,
                            'property_url'      =>  get_permalink($post->ID),
                            'property_title'    =>  get_the_title($post->ID),
                            'listing_author'    =>  $post->post_author,
                        );



                        wpestate_select_email_type($user_email,'approved_listing',$arguments); 
                        
                        $user_mobile    =   get_the_author_meta( 'mobile' , $user->ID );
                        wpestate_select_sms_type($user_mobile,'approved_listing',$arguments,$user_email, $user->ID);

                    }
                   
                }
            }
    }
}
endif; // end   wpestate_correct_post_data 



function wpestate_double_tax_cover($property_area,$property_city,$post_id){
        $prop_city_selected                  =   get_term_by('name', $property_city, 'property_city');
        $prop_area_selected                  =   get_term_by('name', $property_area, 'property_area');
        
     
        if(isset($prop_area_selected->term_id)){ // we have this tax
            //print  $prop_area_selected->term_id.' / '.$prop_area_selected->name;
            //print  $prop_city_selected->term_id.' / '.$prop_city_selected->name;
            $term_meta = get_option( "taxonomy_$prop_area_selected->term_id");
                  
       
            if( $term_meta['cityparent'] !=  $property_city){
                $new_property_area=$property_area.', '.$property_city;
             
            }else{
                  $new_property_area=$property_area;
                 
            }
            wp_set_object_terms($post_id,$new_property_area,'property_area'); 
            return $new_property_area;
        }else{
            wp_set_object_terms($post_id,$property_area,'property_area'); 
            return $property_area;
        }
                   
}


function wpestate_search_by_title_only( $search, $wp_query ) {
    if ( ! empty( $search ) && ! empty( $wp_query->query_vars['search_terms'] ) ) {
        global $wpdb;

        $q = $wp_query->query_vars;
        $n = ! empty( $q['exact'] ) ? '' : '%';

        $search = array();

        foreach ( ( array ) $q['search_terms'] as $term )
            $search[] = $wpdb->prepare( "$wpdb->posts.post_title LIKE %s", $n . $wpdb->esc_like( $term ) . $n );

        if ( ! is_user_logged_in() )
            $search[] = "$wpdb->posts.post_password = ''";

        $search = ' AND ' . implode( ' AND ', $search );
    }

    return $search;
}



function wpestate_file_upload_max_size() {
  static $max_size = -1;

  if ($max_size < 0) {
    // Start with post_max_size.
    $max_size = wpestate_parse_size(ini_get('post_max_size'));

    // If upload_max_size is less, then reduce. Except if upload_max_size is
    // zero, which indicates no limit.
    $upload_max = wpestate_parse_size(ini_get('upload_max_filesize'));
    if ($upload_max > 0 && $upload_max < $max_size) {
      $max_size = $upload_max;
    }
  }
  return $max_size;
}

function wpestate_parse_size($size) {
  $unit = preg_replace('/[^bkmgtpezy]/i', '', $size); // Remove the non-unit characters from the size.
  $size = preg_replace('/[^0-9\.]/', '', $size); // Remove the non-numeric characters from the size.
  if ($unit) {
    // Find the position of the unit in the ordered string which is the power of magnitude to multiply a kilobyte by.
    return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
  }
  else {
    return round($size);
  }
}


if(!function_exists('convertAccentsAndSpecialToNormal')):
function convertAccentsAndSpecialToNormal($string) {
    $table = array(
        'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A', 'Å'=>'A', 'Ă'=>'A', 'Ā'=>'A', 'Ą'=>'A', 'Æ'=>'A', 'Ǽ'=>'A',
        'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a', 'å'=>'a', 'ă'=>'a', 'ā'=>'a', 'ą'=>'a', 'æ'=>'a', 'ǽ'=>'a',

        'Þ'=>'B', 'þ'=>'b', 'ß'=>'Ss',

        'Ç'=>'C', 'Č'=>'C', 'Ć'=>'C', 'Ĉ'=>'C', 'Ċ'=>'C',
        'ç'=>'c', 'č'=>'c', 'ć'=>'c', 'ĉ'=>'c', 'ċ'=>'c',

        'Đ'=>'Dj', 'Ď'=>'D', 'Đ'=>'D',
        'đ'=>'dj', 'ď'=>'d',

        'È'=>'E', 'É'=>'E', 'Ê'=>'E', 'Ë'=>'E', 'Ĕ'=>'E', 'Ē'=>'E', 'Ę'=>'E', 'Ė'=>'E',
        'è'=>'e', 'é'=>'e', 'ê'=>'e', 'ë'=>'e', 'ĕ'=>'e', 'ē'=>'e', 'ę'=>'e', 'ė'=>'e',

        'Ĝ'=>'G', 'Ğ'=>'G', 'Ġ'=>'G', 'Ģ'=>'G',
        'ĝ'=>'g', 'ğ'=>'g', 'ġ'=>'g', 'ģ'=>'g',

        'Ĥ'=>'H', 'Ħ'=>'H',
        'ĥ'=>'h', 'ħ'=>'h',

        'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ï'=>'I', 'İ'=>'I', 'Ĩ'=>'I', 'Ī'=>'I', 'Ĭ'=>'I', 'Į'=>'I',
        'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ï'=>'i', 'į'=>'i', 'ĩ'=>'i', 'ī'=>'i', 'ĭ'=>'i', 'ı'=>'i',

        'Ĵ'=>'J',
        'ĵ'=>'j',

        'Ķ'=>'K',
        'ķ'=>'k', 'ĸ'=>'k',

        'Ĺ'=>'L', 'Ļ'=>'L', 'Ľ'=>'L', 'Ŀ'=>'L', 'Ł'=>'L',
        'ĺ'=>'l', 'ļ'=>'l', 'ľ'=>'l', 'ŀ'=>'l', 'ł'=>'l',

        'Ñ'=>'N', 'Ń'=>'N', 'Ň'=>'N', 'Ņ'=>'N', 'Ŋ'=>'N',
        'ñ'=>'n', 'ń'=>'n', 'ň'=>'n', 'ņ'=>'n', 'ŋ'=>'n', 'ŉ'=>'n',

        'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ō'=>'O', 'Ŏ'=>'O', 'Ő'=>'O', 'Œ'=>'O',
        'ò'=>'o', 'ó'=>'o', 'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ø'=>'o', 'ō'=>'o', 'ŏ'=>'o', 'ő'=>'o', 'œ'=>'o', 'ð'=>'o',

        'Ŕ'=>'R', 'Ř'=>'R',
        'ŕ'=>'r', 'ř'=>'r', 'ŗ'=>'r',

        'Š'=>'S', 'Ŝ'=>'S', 'Ś'=>'S', 'Ş'=>'S',
        'š'=>'s', 'ŝ'=>'s', 'ś'=>'s', 'ş'=>'s',

        'Ŧ'=>'T', 'Ţ'=>'T', 'Ť'=>'T',
        'ŧ'=>'t', 'ţ'=>'t', 'ť'=>'t',

        'Ù'=>'U', 'Ú'=>'U', 'Û'=>'U', 'Ü'=>'U', 'Ũ'=>'U', 'Ū'=>'U', 'Ŭ'=>'U', 'Ů'=>'U', 'Ű'=>'U', 'Ų'=>'U',
        'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'ü'=>'u', 'ũ'=>'u', 'ū'=>'u', 'ŭ'=>'u', 'ů'=>'u', 'ű'=>'u', 'ų'=>'u',

        'Ŵ'=>'W', 'Ẁ'=>'W', 'Ẃ'=>'W', 'Ẅ'=>'W',
        'ŵ'=>'w', 'ẁ'=>'w', 'ẃ'=>'w', 'ẅ'=>'w',

        'Ý'=>'Y', 'Ÿ'=>'Y', 'Ŷ'=>'Y',
        'ý'=>'y', 'ÿ'=>'y', 'ŷ'=>'y',

        'Ž'=>'Z', 'Ź'=>'Z', 'Ż'=>'Z', 'Ž'=>'Z',
        'ž'=>'z', 'ź'=>'z', 'ż'=>'z', 'ž'=>'z',

        '“'=>'"', '”'=>'"', '‘'=>"'", '’'=>"'", '•'=>'-', '…'=>'...', '—'=>'-', '–'=>'-', '¿'=>'?', '¡'=>'!', '°'=>' degrees ',
        '¼'=>' 1/4 ', '½'=>' 1/2 ', '¾'=>' 3/4 ', '⅓'=>' 1/3 ', '⅔'=>' 2/3 ', '⅛'=>' 1/8 ', '⅜'=>' 3/8 ', '⅝'=>' 5/8 ', '⅞'=>' 7/8 ',
        '÷'=>' divided by ', '×'=>' times ', '±'=>' plus-minus ', '√'=>' square root ', '∞'=>' infinity ',
        '≈'=>' almost equal to ', '≠'=>' not equal to ', '≡'=>' identical to ', '≤'=>' less than or equal to ', '≥'=>' greater than or equal to ',
        '←'=>' left ', '→'=>' right ', '↑'=>' up ', '↓'=>' down ', '↔'=>' left and right ', '↕'=>' up and down ',
        '℅'=>' care of ', '℮' => ' estimated ',
        'Ω'=>' ohm ',
        '♀'=>' female ', '♂'=>' male ',
        '©'=>' Copyright ', '®'=>' Registered ', '™' =>' Trademark ',
    );

    $string = strtr($string, $table);
    // Currency symbols: £¤¥€  - we dont bother with them for now
    $string = preg_replace("/[^\x9\xA\xD\x20-\x7F]/u", "", $string);

    return $string;
}
endif;

if(!function_exists('wpestate_check_admin_role')):
    function wpestate_check_admin_role(){
        $roles          =   array('administrator');
        $current_user   =   wp_get_current_user();
        $userID         =   $current_user->ID;

        if( array_intersect($roles, $current_user->roles )){
           //is admin - do not check
            return true;
        }else{
            return false;
        }
    }
endif;

function noo_enable_vc_auto_theme_update() {
	if( function_exists('vc_updater') ) {
		$vc_updater = vc_updater();
		remove_filter( 'upgrader_pre_download', array( $vc_updater, 'preUpgradeFilter' ), 10 );
		if( function_exists( 'vc_license' ) ) {
			if( !vc_license()->isActivated() ) {
				remove_filter( 'pre_set_site_transient_update_plugins', array( $vc_updater->updateManager(), 'check_update' ), 10 );
			}
		}
	}
}
add_action('vc_after_init', 'noo_enable_vc_auto_theme_update');


add_filter( 'manage_posts_columns', 'wpestate_add_id_column', 5 );
add_action( 'manage_posts_custom_column', 'wpestate_id_column_content', 5, 2 );
add_filter( 'manage_pages_columns', 'wpestate_add_id_column', 5 );
add_action( 'manage_pages_custom_column', 'wpestate_id_column_content', 5, 2 );
add_filter( 'manage_media_columns', 'wpestate_add_id_column', 5 );
add_action( 'manage_media_custom_column', 'wpestate_id_column_content', 5, 2 );

add_action( 'manage_edit-category_columns', 'wpestate_add_id_column',5 );
add_filter( 'manage_category_custom_column', 'wpestate_categoriesColumnsRow',10,3 );

add_action( 'manage_edit-property_category_columns', 'wpestate_add_id_column',5 );
add_filter( 'manage_property_category_custom_column', 'wpestate_categoriesColumnsRow',10,3 );

add_action( 'manage_edit-property_action_category_columns', 'wpestate_add_id_column',5 );
add_filter( 'manage_property_action_category_custom_column', 'wpestate_categoriesColumnsRow',10,3 );

add_action( 'manage_edit-property_city_columns', 'wpestate_add_id_column',5 );
add_filter( 'manage_property_city_custom_column', 'wpestate_categoriesColumnsRow',10,3 );


//add_action( 'manage_edit-property_area_columns', 'wpestate_add_id_column',5 );
//add_filter( 'manage_property_area_custom_column', 'wpestate_categoriesColumnsRow',10,3 );

function wpestate_add_id_column( $columns ) {
   $columns['revealid_id'] = 'ID';
   return $columns;
}

function wpestate_id_column_content( $column, $id ) {
  if( 'revealid_id' == $column ) {
    print $id;
  }
}


function wpestate_categoriesColumnsRow($argument, $columnName, $categoryID){
    if($columnName == 'revealid_id'){
            return $categoryID;
    }
}


//
//add_filter( 'option_posts_per_page', 'tdd_tax_filter_posts_per_page' );
//function tdd_tax_filter_posts_per_page( $value ) {
//    $prop_no            =    intval( wprentals_get_option('wp_estate_prop_no','') );
//    return (is_tax('estate_property')) ? 1 : $prop_no;
//}
 

function wpestate_wpml_logout_url(){
    $logout_url = home_url();
    if(function_exists('icl_translate')){
        $logout_url = apply_filters( 'wpml_home_url', home_url() );
    }
    return $logout_url;
}


if ( function_exists('icl_object_id') ) {
    add_action( 'add_attachment', 'sync_menu_order', 100 );
    add_action( 'edit_attachment', 'sync_menu_order', 100 );
    function sync_menu_order( $post_ID ) {
            $post = get_post( $post_ID );
            $menu_order = $post->menu_order;
            $trid = apply_filters( 'wpml_element_trid', false, $post_ID, 'post_attachment' );
            $translations = apply_filters( 'wpml_get_element_translations', false, $trid, 'post_attachment' );
            $translated_ids = wp_list_pluck( $translations, 'element_id' );
            if ( $menu_order !== null && (bool) $translated_ids !== false ) {
                    global $wpdb;
                    $query = $wpdb->prepare(
                            "UPDATE {$wpdb->posts}
                               SET menu_order=%s
                               WHERE ID IN (" . wpml_prepare_in( $translated_ids, '%d' ) . ')',
                            $menu_order
                    );
                    $wpdb->query( $query );
            }
    }
}


add_action( 'admin_menu', 'remove_redux_menu',12 );
function remove_redux_menu() {
    remove_submenu_page('tools.php','redux-about');
}



//////////////////////////////weglot fixed


add_filter('weglot_active_translation_before_treat_page', 'ajax_weglot_active_translation');

function ajax_weglot_active_translation(){
    if ('POST' === $_SERVER['REQUEST_METHOD'] && isset($_POST['action']) && ( $_POST['action'] === 'wpestate_ajax_check_booking_valability' || $_POST['action'] === 'wpestate_ajax_google_login_oauth' || $_POST['action'] === 'wpestate_ajax_facebook_login') ) { 
        return false;
    }
    
    return true;
}

add_action('admin_init','wprentals_convert_redux_action',50);
function wprentals_convert_redux_action(){
    if( wpestate_secondary_lic_plugin() ){
        if(function_exists('wpestate_convert_to_redux_framework')){
            if ( class_exists( 'Redux' ) ) {
                if( get_option('wprentals_convert_to_redux','')!='yes' ){
                    wpestate_convert_to_redux_framework();
                    update_option('wprentals_convert_to_redux','yes');
                }

                if( get_option('wprentals_convert_to_redux_ammenities','')!='yes' ){
                    wpestate_convert_to_redux_framework_ammenities();
                    update_option('wprentals_convert_to_redux_ammenities','yes');
                }
            }
        }

    }
}





   
add_action( 'admin_init', 'wprentals_deactivate_21_plugin' );
add_action( 'muplugins_loaded', 'wprentals_deactivate_21_plugin' ,0); 
function wprentals_deactivate_21_plugin(){
 
    $my_theme = wp_get_theme();
    $version = floatval( $my_theme->get( 'Version' ));

  

    if($version< 2.2 && $version!=1){ 
        deactivate_plugins( 'wprentals-core/wprentals-core.php' );
    }

    if(!class_exists('Redux')){

    class Redux{

        
        static function init(){

        }  
        static function setOption(){
            
        } 
   } 
}

   
    
}
?>