/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2019-01-12 06:35:32 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_ewwwio_images` (
  `id` int(14) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `gallery` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(75) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `converted` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `results` varchar(75) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `backup` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `level` int(5) unsigned DEFAULT NULL,
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `updates` int(5) unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '1971-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  UNIQUE KEY `id` (`id`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`),
  KEY `path` (`path`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=13115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18409 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2966 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=534 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "review_stars", "5");
INSERT INTO `wp_commentmeta` VALUES("2", "3", "review_stars", "5");
INSERT INTO `wp_commentmeta` VALUES("3", "4", "review_stars", "5");
INSERT INTO `wp_commentmeta` VALUES("4", "5", "review_stars", "3");
INSERT INTO `wp_commentmeta` VALUES("5", "6", "review_stars", "5");
INSERT INTO `wp_commentmeta` VALUES("6", "22", "review_stars", "5");
INSERT INTO `wp_commentmeta` VALUES("7", "23", "review_stars", "{\"accuracy\": 4,\"communication\": 4,\"cleanliness\": 4,\"location\": 4,\"check_in\": 4,\"value\": 3,\"rating\": 4.0}");
INSERT INTO `wp_commentmeta` VALUES("8", "24", "review_stars", "{\"accuracy\": 5,\"communication\": 4,\"cleanliness\": 3,\"location\": 4,\"check_in\": 3,\"value\": 4,\"rating\": 4.0}");
INSERT INTO `wp_commentmeta` VALUES("9", "25", "review_stars", "3");
INSERT INTO `wp_commentmeta` VALUES("10", "26", "review_stars", "{\"accuracy\": 4,\"communication\": 4,\"cleanliness\": 4,\"location\": 4,\"check_in\": 4,\"value\": 3,\"rating\": 4.0}");
INSERT INTO `wp_commentmeta` VALUES("11", "27", "review_stars", "{\"accuracy\": 5,\"communication\": 5,\"cleanliness\": 5,\"location\": 5,\"check_in\": 5,\"value\": 5,\"rating\": 5.0}");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "10", "amberdemo", "amberdemo@gmail.com", "", "127.0.0.1", "2015-11-17 15:08:55", "2015-11-17 15:08:55", "The flat was very clean and perfectly in line with the pictures, close to arsenal station and very quiet. We will return definitely. ", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "94", "amberdemo", "amberdemo@gmail.com", "", "127.0.0.1", "2015-11-17 15:07:24", "2015-11-17 15:07:24", "Their flat is beautiful and comfortable, and the set-up with private bathroom is excellent. Their neighborhood has loads of lovely cafes and restaurant within easy walking distance. I wish I could have stayed longer. If they are free, I would love to stay with them when next visiting Istanbul. YOU SHOULD STAY HERE. I cannot recommend their place highly enough. ", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "101", "amberdemo", "amberdemo@gmail.com", "", "127.0.0.1", "2015-11-17 15:07:40", "2015-11-17 15:07:40", "Few other considerations are in order: 1. The location is mediocre at best. Finding their place is a challenge; more importantly, its hillside location is hard on the legs, no matter who you are. Yes, it sits in a trendy, less touristy neighborhood, but the upcoming Karakoy district is also trendy, closer to the museums and the water,and a much, much easier walk. 2. The guest bed is not very comfortable and should be replaced. 3. While their rates are reasonable, an astute shopper will find a lot of 3 and 4 star Istanbul hotels in that same price range. ", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "107", "amberdemo", "amberdemo@gmail.com", "", "127.0.0.1", "2015-11-17 15:08:00", "2015-11-17 15:08:00", "My stay with Paul and Yvonne was quite nice. They were extremely welcoming and helpful, providing tons of information about their neighborhood and Istanbul in general. I would stay with them again, and hope to do so. Delightful people! ", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "145", "amberdemo", "amberdemo@gmail.com", "", "127.0.0.1", "2015-11-17 15:08:31", "2015-11-17 15:08:31", "The room was very comfortable, the shower pressure and heat was perfect, the bathroom very clean. The view from their back deck was the highlight for us- and they were very kind to share the view! We enjoyed some wine and Turkish sweets on the deck for our last night. Additionally, the neighborhood is perfect!! Every corner there is a bar or restaurant or someone squeezing fresh juice for you. I would highly recommend this place!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "190", "Loraine", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 10:54:13", "2015-04-21 10:54:13", "This site was very easy to use. I needed a place in NYC and found pone in my budget big enough for me and some friends. We paid on the website and everything worked out great!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "192", "Gina", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:42:21", "2015-04-21 11:42:21", "In the past, these types of services have been used largely by thrifty tourists looking for the cheapest place they can find in a particular city. Now, however, more and more business travelers and professionals are looking to WP Rentals for a unique and memorable experience.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "192", "Sophie", "wpestate@gmail.com", "", "5.13.107.187", "2015-04-21 11:42:53", "2015-04-21 11:42:53", "WP Rentals can benefit both hosts and travelers. Hosts get to meet people from around the world while making a little extra money, and travelers can often stay for less than the cost of a hotel room. In addition, many travelers enjoy accommodations that offer a different experience from standard hotels.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "200", "Laura", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:43:55", "2015-04-21 11:43:55", "WP Rentals can benefit both hosts and travelers. Hosts get to meet people from around the world while making a little extra money, and travelers can often stay for less than the cost of a hotel room. In addition, many travelers enjoy accommodations that offer a different experience from standard hotels.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "220", "Simone", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:00:32", "2015-04-21 11:00:32", "WP Rentals has been the best platform for me because of the people that I met, the money that i make, if any problem comes up costumer service is ALWAYS there. Literally the guys are trying their best! My profile has over 160 reviews and all my listings are book 3 months ahead!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "220", "Laura", "wpestate@gmail.com", "", "5.13.107.187", "2015-04-21 11:19:20", "2015-04-21 11:19:20", "In the past, these types of services have been used largely by thrifty tourists looking for the cheapest place they can find in a particular city. Now, however, more and more business travelers and professionals are looking to WP Rentals for a unique and memorable experience.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "220", "Simone", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:20:00", "2015-04-21 11:20:00", "WP Rentals can benefit both hosts and travelers. Hosts get to meet people from around the world while making a little extra money, and travelers can often stay for less than the cost of a hotel room. In addition, many travelers enjoy accommodations that offer a different experience from standard hotels.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "220", "Simone", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:23:03", "2015-04-21 11:23:03", "We want the 2015 WP Rentals to inspire, equip, and celebrate you. And we want to gather with the host community to learn how to do what we do better. Let’s make this year’s summit one to remember! Stay tuned as we reveal exciting details in the days to come.", "0", "1", "", "", "12", "0");
INSERT INTO `wp_comments` VALUES("15", "230", "Jenny", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:00:10", "2015-04-21 11:00:10", "WP Rentals has been the best platform for me because of the people that I met, the money that i make, if any problem comes up costumer service is ALWAYS there. Literally the guys are trying their best! My profile has over 160 reviews and all my listings are book 3 months ahead!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "230", "Laura", "wpestate@gmail.com", "", "5.13.107.187", "2015-04-21 11:17:52", "2015-04-21 11:17:52", "In the past, these types of services have been used largely by thrifty tourists looking for the cheapest place they can find in a particular city. Now, however, more and more business travelers and professionals are looking to WP Rentals for a unique and memorable experience.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "240", "Laura", "wpestate@gmail.com", "http://-", "5.13.107.187", "2015-04-21 10:58:46", "2015-04-21 10:58:46", "WP Rentals has been the best platform for me because of the people that I met, the money that i make, if any problem comes up costumer service is ALWAYS there. Literally the guys are trying their best! My profile has over 160 reviews and all my listings are book 3 months ahead!", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "240", "Simone", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:12:45", "2015-04-21 11:12:45", "WP Rentals can benefit both hosts and travelers. Hosts get to meet people from around the world while making a little extra money, and travelers can often stay for less than the cost of a hotel room. In addition, many travelers enjoy accommodations that offer a different experience from standard hotels.", "0", "1", "", "", "17", "0");
INSERT INTO `wp_comments` VALUES("19", "240", "Laura", "wpestate@gmail.com", "", "5.13.107.187", "2015-04-21 11:15:33", "2015-04-21 11:15:33", "In the past, these types of services have been used largely by thrifty tourists looking for the cheapest place they can find in a particular city. Now, however, more and more business travelers and professionals are looking to WP Rentals for a unique and memorable experience.", "0", "1", "", "", "18", "0");
INSERT INTO `wp_comments` VALUES("20", "240", "Laura", "wpestate@yahoo.com", "", "5.13.107.187", "2015-04-21 11:16:26", "2015-04-21 11:16:26", "WP Rentals can benefit both hosts and travelers. Hosts get to meet people from around the world while making a little extra money, and travelers can often stay for less than the cost of a hotel room. In addition, many travelers enjoy accommodations that offer a different experience from standard hotels.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "190", "www.Companyvakil.com", "RyanRuss56@dedi.trillania.com", "https://www.companyvakil.com/", "23.94.102.47", "2018-12-03 06:40:10", "2018-12-03 07:40:10", "Hellօ, Neat post. There\'s a problem along with yourr web site in internet \r\nexplorer, might chｅск thiѕ? IE noonethеless is the marketplace chief ɑnd a good component tto people wiol leave out your wonderfᥙⅼ writing because of this problem. https://www.companyvakil.com/", "0", "0", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "2085", "givaweb", "giva2web@gmail.com", "", "127.0.0.1", "2018-02-23 16:56:00", "2018-02-23 17:56:00", "بسیار عالی", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("23", "2085", "givaweb", "giva2web@gmail.com", "", "127.0.0.1", "2018-02-25 18:17:23", "2018-02-25 19:17:23", "عالی بود بسیار لذت بردم", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("24", "2585", "user-test", "marshal@gmail.com", "", "127.0.0.1", "2018-02-25 10:11:14", "2018-02-25 11:11:14", "بسیار عالی و حسابی لذت بردم", "0", "1", "", "comment", "0", "10");
INSERT INTO `wp_comments` VALUES("25", "2586", "admin", "givaaweb@gmail.com", "", "127.0.0.1", "2018-02-13 18:29:35", "2018-02-13 14:59:35", "بسیار عالی بود", "0", "1", "", "comment", "0", "1");
INSERT INTO `wp_comments` VALUES("26", "2588", "user-test", "marshal@gmail.com", "", "127.0.0.1", "2018-02-25 10:12:10", "2018-02-25 11:12:10", "بسیار عالی و خوش گذشت!", "0", "1", "", "comment", "0", "10");
INSERT INTO `wp_comments` VALUES("27", "2581", "Saber", "Saberkazemi2014@gmail.com", "", "127.0.0.1", "2019-01-10 12:56:43", "2019-01-10 09:26:43", "خوب", "0", "1", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10 (.NET CLR 3.5.30729)", "comment", "0", "2");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("7", "20181211_wprentals", "ae2c1f64c1a1f63a3242_20190112063522", "21", "2019-01-12 06:35:32", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-01-12 06:35:22\";s:7:\"Version\";s:5:\"1.3.2\";s:9:\"VersionWP\";s:5:\"5.0.3\";s:9:\"VersionDB\";s:6:\"5.6.41\";s:10:\"VersionPHP\";s:6:\"7.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:7;s:4:\"Name\";s:18:\"20181211_wprentals\";s:4:\"Hash\";s:35:\"ae2c1f64c1a1f63a3242_20190112063522\";s:8:\"NameHash\";s:54:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:87:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/tmp\";s:8:\"StoreURL\";s:62:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/\";s:8:\"ScanFile\";s:64:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";d:21;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":20:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:1;s:4:\"File\";s:66:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:70:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-01-12 06:35:22\";s:7:\"Version\";s:5:\"1.3.2\";s:9:\"VersionWP\";s:5:\"5.0.3\";s:9:\"VersionDB\";s:6:\"5.6.41\";s:10:\"VersionPHP\";s:6:\"7.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20181211_wprentals\";s:4:\"Hash\";s:35:\"ae2c1f64c1a1f63a3242_20190112063522\";s:8:\"NameHash\";s:54:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:87:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/tmp\";s:8:\"StoreURL\";s:62:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:68:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:62;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:67:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:155:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/tmp/20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:62;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:79:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-admin\";i:1;s:89:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads\";i:2;s:91:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/languages\";i:3;s:88:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/themes\";i:4;s:82:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:70:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2\";i:1;s:81:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content\";}}s:9:\"Installer\";r:85;s:8:\"Database\";r:97;s:13:\"BuildProgress\";r:112;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://jobifa.com/demo/wprentals-pack/wprentals2", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://jobifa.com/demo/wprentals-pack/wprentals2", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "wp-rentals", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "قالب وردپرس اجاره املاک از گروه گیواوب", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "giva@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:302:{s:13:\"properties/?$\";s:35:\"index.php?post_type=estate_property\";s:43:\"properties/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=estate_property&feed=$matches[1]\";s:38:\"properties/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=estate_property&feed=$matches[1]\";s:30:\"properties/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=estate_property&paged=$matches[1]\";s:9:\"owners/?$\";s:32:\"index.php?post_type=estate_agent\";s:39:\"owners/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=estate_agent&feed=$matches[1]\";s:34:\"owners/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=estate_agent&feed=$matches[1]\";s:26:\"owners/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=estate_agent&paged=$matches[1]\";s:11:\"bookings/?$\";s:36:\"index.php?post_type=wpestate_booking\";s:41:\"bookings/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wpestate_booking&feed=$matches[1]\";s:36:\"bookings/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wpestate_booking&feed=$matches[1]\";s:28:\"bookings/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=wpestate_booking&paged=$matches[1]\";s:10:\"invoice/?$\";s:36:\"index.php?post_type=wpestate_invoice\";s:40:\"invoice/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wpestate_invoice&feed=$matches[1]\";s:35:\"invoice/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wpestate_invoice&feed=$matches[1]\";s:27:\"invoice/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=wpestate_invoice&paged=$matches[1]\";s:10:\"package/?$\";s:38:\"index.php?post_type=membership_package\";s:40:\"package/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?post_type=membership_package&feed=$matches[1]\";s:35:\"package/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?post_type=membership_package&feed=$matches[1]\";s:27:\"package/page/([0-9]{1,})/?$\";s:56:\"index.php?post_type=membership_package&paged=$matches[1]\";s:10:\"message/?$\";s:36:\"index.php?post_type=wpestate_message\";s:40:\"message/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wpestate_message&feed=$matches[1]\";s:35:\"message/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=wpestate_message&feed=$matches[1]\";s:27:\"message/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=wpestate_message&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:16:\"custom-css-js/?$\";s:33:\"index.php?post_type=custom-css-js\";s:46:\"custom-css-js/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=custom-css-js&feed=$matches[1]\";s:41:\"custom-css-js/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=custom-css-js&feed=$matches[1]\";s:33:\"custom-css-js/page/([0-9]{1,})/?$\";s:51:\"index.php?post_type=custom-css-js&paged=$matches[1]\";s:38:\"properties/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"properties/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"properties/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"properties/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"properties/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"properties/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"properties/([^/]+)/embed/?$\";s:48:\"index.php?estate_property=$matches[1]&embed=true\";s:31:\"properties/([^/]+)/trackback/?$\";s:42:\"index.php?estate_property=$matches[1]&tb=1\";s:51:\"properties/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?estate_property=$matches[1]&feed=$matches[2]\";s:46:\"properties/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?estate_property=$matches[1]&feed=$matches[2]\";s:39:\"properties/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?estate_property=$matches[1]&paged=$matches[2]\";s:46:\"properties/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?estate_property=$matches[1]&cpage=$matches[2]\";s:35:\"properties/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?estate_property=$matches[1]&page=$matches[2]\";s:27:\"properties/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"properties/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"properties/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"properties/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"properties/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"properties/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:49:\"listings/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?property_category=$matches[1]&feed=$matches[2]\";s:44:\"listings/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?property_category=$matches[1]&feed=$matches[2]\";s:25:\"listings/([^/]+)/embed/?$\";s:50:\"index.php?property_category=$matches[1]&embed=true\";s:37:\"listings/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?property_category=$matches[1]&paged=$matches[2]\";s:19:\"listings/([^/]+)/?$\";s:39:\"index.php?property_category=$matches[1]\";s:47:\"action/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?property_action_category=$matches[1]&feed=$matches[2]\";s:42:\"action/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?property_action_category=$matches[1]&feed=$matches[2]\";s:23:\"action/([^/]+)/embed/?$\";s:57:\"index.php?property_action_category=$matches[1]&embed=true\";s:35:\"action/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?property_action_category=$matches[1]&paged=$matches[2]\";s:17:\"action/([^/]+)/?$\";s:46:\"index.php?property_action_category=$matches[1]\";s:45:\"city/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?property_city=$matches[1]&feed=$matches[2]\";s:40:\"city/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?property_city=$matches[1]&feed=$matches[2]\";s:21:\"city/([^/]+)/embed/?$\";s:46:\"index.php?property_city=$matches[1]&embed=true\";s:33:\"city/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?property_city=$matches[1]&paged=$matches[2]\";s:15:\"city/([^/]+)/?$\";s:35:\"index.php?property_city=$matches[1]\";s:45:\"area/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?property_area=$matches[1]&feed=$matches[2]\";s:40:\"area/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?property_area=$matches[1]&feed=$matches[2]\";s:21:\"area/([^/]+)/embed/?$\";s:46:\"index.php?property_area=$matches[1]&embed=true\";s:33:\"area/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?property_area=$matches[1]&paged=$matches[2]\";s:15:\"area/([^/]+)/?$\";s:35:\"index.php?property_area=$matches[1]\";s:34:\"owners/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"owners/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"owners/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"owners/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"owners/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"owners/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"owners/([^/]+)/embed/?$\";s:45:\"index.php?estate_agent=$matches[1]&embed=true\";s:27:\"owners/([^/]+)/trackback/?$\";s:39:\"index.php?estate_agent=$matches[1]&tb=1\";s:47:\"owners/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?estate_agent=$matches[1]&feed=$matches[2]\";s:42:\"owners/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?estate_agent=$matches[1]&feed=$matches[2]\";s:35:\"owners/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?estate_agent=$matches[1]&paged=$matches[2]\";s:42:\"owners/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?estate_agent=$matches[1]&cpage=$matches[2]\";s:31:\"owners/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?estate_agent=$matches[1]&page=$matches[2]\";s:23:\"owners/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"owners/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"owners/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"owners/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"owners/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"owners/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"bookings/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"bookings/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"bookings/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"bookings/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"bookings/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"bookings/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"bookings/([^/]+)/embed/?$\";s:49:\"index.php?wpestate_booking=$matches[1]&embed=true\";s:29:\"bookings/([^/]+)/trackback/?$\";s:43:\"index.php?wpestate_booking=$matches[1]&tb=1\";s:49:\"bookings/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpestate_booking=$matches[1]&feed=$matches[2]\";s:44:\"bookings/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpestate_booking=$matches[1]&feed=$matches[2]\";s:37:\"bookings/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?wpestate_booking=$matches[1]&paged=$matches[2]\";s:44:\"bookings/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?wpestate_booking=$matches[1]&cpage=$matches[2]\";s:33:\"bookings/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?wpestate_booking=$matches[1]&page=$matches[2]\";s:25:\"bookings/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"bookings/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"bookings/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"bookings/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"bookings/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"bookings/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"invoice/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"invoice/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"invoice/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"invoice/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"invoice/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"invoice/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"invoice/([^/]+)/embed/?$\";s:49:\"index.php?wpestate_invoice=$matches[1]&embed=true\";s:28:\"invoice/([^/]+)/trackback/?$\";s:43:\"index.php?wpestate_invoice=$matches[1]&tb=1\";s:48:\"invoice/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpestate_invoice=$matches[1]&feed=$matches[2]\";s:43:\"invoice/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpestate_invoice=$matches[1]&feed=$matches[2]\";s:36:\"invoice/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?wpestate_invoice=$matches[1]&paged=$matches[2]\";s:43:\"invoice/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?wpestate_invoice=$matches[1]&cpage=$matches[2]\";s:32:\"invoice/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?wpestate_invoice=$matches[1]&page=$matches[2]\";s:24:\"invoice/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"invoice/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"invoice/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"invoice/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"invoice/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"invoice/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"package/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"package/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"package/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"package/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"package/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"package/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"package/([^/]+)/embed/?$\";s:51:\"index.php?membership_package=$matches[1]&embed=true\";s:28:\"package/([^/]+)/trackback/?$\";s:45:\"index.php?membership_package=$matches[1]&tb=1\";s:48:\"package/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?membership_package=$matches[1]&feed=$matches[2]\";s:43:\"package/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?membership_package=$matches[1]&feed=$matches[2]\";s:36:\"package/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?membership_package=$matches[1]&paged=$matches[2]\";s:43:\"package/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?membership_package=$matches[1]&cpage=$matches[2]\";s:32:\"package/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?membership_package=$matches[1]&page=$matches[2]\";s:24:\"package/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"package/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"package/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"package/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"package/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"package/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"message/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"message/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"message/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"message/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"message/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"message/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"message/([^/]+)/embed/?$\";s:49:\"index.php?wpestate_message=$matches[1]&embed=true\";s:28:\"message/([^/]+)/trackback/?$\";s:43:\"index.php?wpestate_message=$matches[1]&tb=1\";s:48:\"message/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpestate_message=$matches[1]&feed=$matches[2]\";s:43:\"message/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?wpestate_message=$matches[1]&feed=$matches[2]\";s:36:\"message/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?wpestate_message=$matches[1]&paged=$matches[2]\";s:43:\"message/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?wpestate_message=$matches[1]&cpage=$matches[2]\";s:32:\"message/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?wpestate_message=$matches[1]&page=$matches[2]\";s:24:\"message/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"message/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"message/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"message/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"message/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"message/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"searches/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"searches/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"searches/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"searches/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"searches/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"searches/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"searches/([^/]+)/embed/?$\";s:48:\"index.php?wpestate_search=$matches[1]&embed=true\";s:29:\"searches/([^/]+)/trackback/?$\";s:42:\"index.php?wpestate_search=$matches[1]&tb=1\";s:37:\"searches/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?wpestate_search=$matches[1]&paged=$matches[2]\";s:44:\"searches/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?wpestate_search=$matches[1]&cpage=$matches[2]\";s:33:\"searches/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?wpestate_search=$matches[1]&page=$matches[2]\";s:25:\"searches/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"searches/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"searches/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"searches/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"searches/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"searches/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:41:\"custom-css-js/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"custom-css-js/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"custom-css-js/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"custom-css-js/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"custom-css-js/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"custom-css-js/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"custom-css-js/([^/]+)/embed/?$\";s:61:\"index.php?post_type=custom-css-js&name=$matches[1]&embed=true\";s:34:\"custom-css-js/([^/]+)/trackback/?$\";s:55:\"index.php?post_type=custom-css-js&name=$matches[1]&tb=1\";s:54:\"custom-css-js/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_type=custom-css-js&name=$matches[1]&feed=$matches[2]\";s:49:\"custom-css-js/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_type=custom-css-js&name=$matches[1]&feed=$matches[2]\";s:42:\"custom-css-js/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?post_type=custom-css-js&name=$matches[1]&paged=$matches[2]\";s:49:\"custom-css-js/([^/]+)/comment-page-([0-9]{1,})/?$\";s:68:\"index.php?post_type=custom-css-js&name=$matches[1]&cpage=$matches[2]\";s:38:\"custom-css-js/([^/]+)(?:/([0-9]+))?/?$\";s:67:\"index.php?post_type=custom-css-js&name=$matches[1]&page=$matches[2]\";s:30:\"custom-css-js/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"custom-css-js/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"custom-css-js/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"custom-css-js/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"custom-css-js/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"custom-css-js/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1745&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:13:{i:0;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:1;s:31:\"custom-css-js/custom-css-js.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";i:5;s:27:\"js_composer/js_composer.php\";i:6;s:23:\"loco-translate/loco.php\";i:7;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:8;s:23:\"revslider/revslider.php\";i:9;s:33:\"string-locator/string-locator.php\";i:10;s:41:\"wordpress-importer/wordpress-importer.php\";i:11;s:29:\"wp-parsidate/wp-parsidate.php\";i:12;s:29:\"wprental-sms/wprental-sms.php\";i:13;s:33:\"wprentals-core/wprentals-core.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:121:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/themes/wprentals-child-po/functions.php\";i:1;s:117:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/themes/wprentals-child-po/style.css\";i:2;s:115:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/themes/wprentals-child-po/rtl.css\";i:3;s:108:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/themes/wprentals/index.php\";i:4;s:115:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/themes/wprentals/header_media.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "wprentals", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "wprentals-child-po", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "43764", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "file", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:3:{i:1;a:3:{s:5:\"title\";s:16:\"ABOUT WP RENTALS\";s:4:\"text\";s:242:\"WP RENTALS is committed to delivering a high level of expertise, customer service, and attention to detail to the market of accommodation booking . \r\n\r\nWe built the most featured WordPress theme for such a project. Test and convince yourself.\";s:6:\"filter\";b:1;}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:84:\"قالب اجاره املاک wprentals ورژن 2.2 توسط گروه گیواوب\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:1:{s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:30:\"ewww_image_optimizer_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "1745", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "37965", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:88:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:42:\"vc_access_rules_post_types/estate_property\";b:1;s:39:\"vc_access_rules_post_types/estate_agent\";b:1;s:43:\"vc_access_rules_post_types/wpestate_booking\";b:1;s:43:\"vc_access_rules_post_types/wpestate_message\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:15:\"edit_custom_css\";b:1;s:15:\"read_custom_css\";b:1;s:17:\"delete_custom_css\";b:1;s:16:\"edit_custom_csss\";b:1;s:23:\"edit_others_custom_csss\";b:1;s:19:\"publish_custom_csss\";b:1;s:18:\"delete_custom_csss\";b:1;s:28:\"delete_published_custom_csss\";b:1;s:25:\"delete_others_custom_csss\";b:1;s:26:\"edit_published_custom_csss\";b:1;s:10:\"loco_admin\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:43:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:14:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:15:\"css_js_designer\";a:2:{s:4:\"name\";s:12:\"Web Designer\";s:12:\"capabilities\";a:10:{s:15:\"edit_custom_css\";b:1;s:15:\"read_custom_css\";b:1;s:17:\"delete_custom_css\";b:1;s:16:\"edit_custom_csss\";b:1;s:23:\"edit_others_custom_csss\";b:1;s:19:\"publish_custom_csss\";b:1;s:18:\"delete_custom_csss\";b:1;s:28:\"delete_published_custom_csss\";b:1;s:25:\"delete_others_custom_csss\";b:1;s:26:\"edit_published_custom_csss\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:2:{i:4;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:2:{i:4;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;s:9:\"show_date\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:2:{i:3;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:15:{i:0;s:23:\"wpestate_tweet_widget-2\";i:1;s:23:\"wpestate_tweet_widget-3\";i:2;s:25:\"wpestate_contact_widget-2\";i:3;s:24:\"wpestate_social_widget-2\";i:4;s:24:\"wpestate_social_widget-3\";i:5;s:33:\"wpestate_advanced_search_widget-2\";i:6;s:33:\"wpestate_advanced_search_widget-3\";i:7;s:33:\"wpestate_advanced_search_widget-4\";i:8;s:35:\"wpestate_multiple_currency_widget-2\";i:9;s:35:\"wpestate_multiple_currency_widget-3\";i:10;s:8:\"search-4\";i:11;s:12:\"categories-3\";i:12;s:14:\"recent-posts-4\";i:13;s:17:\"recent-comments-3\";i:14;s:6:\"text-1\";}s:19:\"primary-widget-area\";a:3:{i:0;s:23:\"wpestate_login_widget-2\";i:1;s:33:\"wpestate_advanced_search_widget-5\";i:2;s:31:\"wpestate_footer_latest_widget-2\";}s:21:\"secondary-widget-area\";a:0:{}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:24:\"top-bar-left-widget-area\";a:1:{i:0;s:6:\"text-2\";}s:25:\"top-bar-right-widget-area\";a:0:{}s:22:\"owner-page-widget-area\";a:0:{}s:36:\"splash-page_bottom-right-widget-area\";a:0:{}s:35:\"splash-page_bottom-left-widget-area\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:11:{i:1547275068;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1547276469;a:1:{s:25:\"event_wp_estate_sync_ical\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"hourlythree\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10800;}}}i:1547285169;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1547285193;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1547287269;a:2:{s:40:\"prefix_wpestate_cron_generate_pins_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:44:\"setup_wpestate_full_invoice_payment_reminder\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1547289040;a:1:{s:36:\"prefix_wp_estate_delete_orphan_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1547293076;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1547296546;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1547306954;a:1:{s:32:\"ewww_image_optimizer_site_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1547318080;a:1:{s:30:\"wpestate_check_for_users_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("120", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:14:\"giva@gmail.com\";s:7:\"version\";s:5:\"5.0.3\";s:9:\"timestamp\";i:1547069338;}", "no");
INSERT INTO `wp_options` VALUES("139", "theme_mods_twentysixteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1543658468;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("140", "current_theme", "WpRentals Child theme", "yes");
INSERT INTO `wp_options` VALUES("141", "theme_mods_wprentals", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:31;s:6:\"mobile\";i:31;s:11:\"footer_menu\";i:30;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1544628528;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:15:{i:0;s:23:\"wpestate_tweet_widget-2\";i:1;s:23:\"wpestate_tweet_widget-3\";i:2;s:25:\"wpestate_contact_widget-2\";i:3;s:24:\"wpestate_social_widget-2\";i:4;s:24:\"wpestate_social_widget-3\";i:5;s:33:\"wpestate_advanced_search_widget-2\";i:6;s:33:\"wpestate_advanced_search_widget-3\";i:7;s:33:\"wpestate_advanced_search_widget-4\";i:8;s:35:\"wpestate_multiple_currency_widget-2\";i:9;s:35:\"wpestate_multiple_currency_widget-3\";i:10;s:8:\"search-4\";i:11;s:12:\"categories-3\";i:12;s:14:\"recent-posts-4\";i:13;s:17:\"recent-comments-3\";i:14;s:6:\"text-1\";}s:19:\"primary-widget-area\";a:3:{i:0;s:23:\"wpestate_login_widget-2\";i:1;s:33:\"wpestate_advanced_search_widget-5\";i:2;s:31:\"wpestate_footer_latest_widget-2\";}s:21:\"secondary-widget-area\";a:0:{}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:24:\"top-bar-left-widget-area\";a:1:{i:0;s:6:\"text-2\";}s:25:\"top-bar-right-widget-area\";a:0:{}s:22:\"owner-page-widget-area\";a:0:{}s:36:\"splash-page_bottom-right-widget-area\";a:0:{}s:35:\"splash-page_bottom-left-widget-area\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("142", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("143", "wprentals_convert_to_redux_ammenities", "yes", "yes");
INSERT INTO `wp_options` VALUES("145", "activation_time", "1543658469", "yes");
INSERT INTO `wp_options` VALUES("150", "wp_estate_cache_notice", "yes", "yes");
INSERT INTO `wp_options` VALUES("151", "is_theme_activated", "is_active", "yes");
INSERT INTO `wp_options` VALUES("153", "wpestate_custom_fields_list", "a:5:{s:14:\"add_field_name\";a:7:{i:0;s:13:\"Check-in hour\";i:1;s:14:\"Check-Out hour\";i:2;s:13:\"Late Check-in\";i:3;s:17:\"Optional services\";i:4;s:18:\"Outdoor facilities\";i:5;s:12:\"Extra People\";i:6;s:12:\"Cancellation\";}s:15:\"add_field_label\";a:7:{i:0;s:26:\"زمان تحویل ملک\";i:1;s:26:\"زمان تخلیه ملک\";i:2;s:24:\"بازدید از ملک\";i:3;s:21:\"دسترسی محلی\";i:4;s:17:\"چشم انداز\";i:5;s:21:\"افراد اضافی\";i:6;s:21:\"لغو درخواست\";}s:15:\"add_field_order\";a:7:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:1:\"7\";}s:14:\"add_field_type\";a:7:{i:0;s:10:\"short text\";i:1;s:10:\"short text\";i:2;s:10:\"short text\";i:3;s:10:\"short text\";i:4;s:10:\"short text\";i:5;s:10:\"short text\";i:6;s:10:\"short text\";}s:18:\"add_dropdown_order\";a:7:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("154", "wprentals_convert_to_redux", "yes", "yes");
INSERT INTO `wp_options` VALUES("165", "vc_version", "5.6", "yes");
INSERT INTO `wp_options` VALUES("167", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("169", "widget_wpestate_tweet_widget", "a:4:{i:1;a:3:{s:5:\"title\";s:13:\"Latest Tweets\";s:10:\"twitter_id\";s:8:\"wpestate\";s:9:\"tweets_no\";s:1:\"3\";}i:2;a:3:{s:5:\"title\";s:13:\"Latest Tweets\";s:10:\"twitter_id\";s:8:\"wpestate\";s:9:\"tweets_no\";s:1:\"3\";}i:3;a:3:{s:5:\"title\";s:13:\"Latest Tweets\";s:10:\"twitter_id\";s:8:\"wpestate\";s:9:\"tweets_no\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("170", "widget_wpestate_facebook_widget", "a:2:{i:1;a:7:{s:5:\"title\";s:19:\"Find us on Facebook\";s:3:\"url\";s:37:\"https://www.facebook.com/envatomarket\";s:9:\"box_width\";s:3:\"373\";s:11:\"color_theme\";s:5:\"light\";s:5:\"faces\";s:2:\"on\";s:6:\"stream\";N;s:6:\"header\";N;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("171", "widget_wpestate_contact_widget", "a:3:{i:1;a:8:{s:5:\"title\";s:7:\"Contact\";s:12:\"address_info\";s:82:\"3755 Commercial St SE Salem, Corner with Sunny Boulevard, 3755 Commercial OR 97302\";s:8:\"phone_no\";s:14:\"(305) 555-4446\";s:6:\"fax_no\";s:0:\"\";s:5:\"email\";s:20:\"email@yourdomain.com\";s:5:\"skype\";s:0:\"\";s:11:\"website_url\";s:21:\"http://wprentals.org/\";s:16:\"website_url_text\";s:10:\"WP Rentals\";}i:2;a:8:{s:5:\"title\";s:7:\"Contact\";s:12:\"address_info\";s:82:\"3755 Commercial St SE Salem, Corner with Sunny Boulevard, 3755 Commercial OR 97302\";s:8:\"phone_no\";s:14:\"(305) 555-4446\";s:6:\"fax_no\";s:14:\"(305) 555-4446\";s:5:\"email\";s:20:\"email@yourdomain.com\";s:5:\"skype\";s:9:\"skypename\";s:11:\"website_url\";s:21:\"http://wprentals.org/\";s:16:\"website_url_text\";s:10:\"WP Rentals\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("172", "widget_wpestate_social_widget", "a:4:{i:1;a:15:{s:5:\"title\";s:13:\"Social Links:\";s:3:\"rss\";s:1:\"#\";s:8:\"facebook\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:5:\"email\";N;s:8:\"dribbble\";s:0:\"\";s:6:\"google\";s:1:\"#\";s:8:\"linkedIn\";s:1:\"#\";s:8:\"phone_no\";N;s:6:\"tumblr\";s:1:\"#\";s:9:\"pinterest\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";}i:2;a:15:{s:5:\"title\";s:13:\"Social Links:\";s:3:\"rss\";s:1:\"#\";s:8:\"facebook\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:5:\"email\";N;s:8:\"dribbble\";s:1:\"#\";s:6:\"google\";s:1:\"#\";s:8:\"linkedIn\";s:1:\"#\";s:8:\"phone_no\";N;s:6:\"tumblr\";s:1:\"#\";s:9:\"pinterest\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:5:\"vimeo\";s:1:\"#\";s:9:\"instagram\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";}i:3;a:15:{s:5:\"title\";s:13:\"Social Links:\";s:3:\"rss\";s:1:\"#\";s:8:\"facebook\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:5:\"email\";N;s:8:\"dribbble\";s:1:\"#\";s:6:\"google\";s:0:\"\";s:8:\"linkedIn\";s:0:\"\";s:8:\"phone_no\";N;s:6:\"tumblr\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("173", "widget_wpestate_featured_widget", "a:2:{i:1;a:2:{s:7:\"prop_id\";s:3:\"149\";s:11:\"second_line\";N;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("174", "widget_wpestate_footer_latest_widget", "a:3:{i:1;a:7:{s:5:\"title\";s:15:\"Latest Listings\";s:10:\"listing_no\";s:1:\"3\";s:24:\"adv_filter_search_action\";a:1:{i:0;s:3:\"all\";}s:26:\"adv_filter_search_category\";a:1:{i:0;s:3:\"all\";}s:23:\"current_adv_filter_city\";a:1:{i:0;s:3:\"all\";}s:23:\"current_adv_filter_area\";a:1:{i:0;s:3:\"all\";}s:18:\"show_featured_only\";s:2:\"no\";}i:2;a:7:{s:5:\"title\";s:33:\"آخرین آگهی های ملک\";s:10:\"listing_no\";s:1:\"1\";s:24:\"adv_filter_search_action\";N;s:26:\"adv_filter_search_category\";a:1:{i:0;s:3:\"all\";}s:23:\"current_adv_filter_city\";a:1:{i:0;s:3:\"all\";}s:23:\"current_adv_filter_area\";a:1:{i:0;s:3:\"all\";}s:18:\"show_featured_only\";s:3:\"yes\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("175", "widget_wpestate_advanced_search_widget", "a:6:{i:1;a:1:{s:5:\"title\";s:15:\"Advanced Search\";}i:2;a:1:{s:5:\"title\";s:15:\"Advanced Search\";}i:3;a:1:{s:5:\"title\";s:15:\"Advanced Search\";}i:4;a:1:{s:5:\"title\";s:15:\"Advanced Search\";}i:5;a:1:{s:5:\"title\";s:27:\"جستجوی پیشرفته\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("176", "widget_wpestate_login_widget", "a:3:{i:1;a:0:{}i:2;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("177", "widget_wpestate_social_widget_top", "a:2:{i:1;a:14:{s:3:\"rss\";s:0:\"\";s:8:\"facebook\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:5:\"email\";N;s:8:\"dribbble\";s:0:\"\";s:6:\"google\";s:1:\"#\";s:8:\"linkedIn\";s:1:\"#\";s:8:\"phone_no\";N;s:6:\"tumblr\";s:1:\"#\";s:9:\"pinterest\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:5:\"vimeo\";s:1:\"#\";s:9:\"instagram\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "widget_wpestate_multiple_currency_widget", "a:4:{i:1;a:1:{s:5:\"title\";s:15:\"Change Currency\";}i:2;a:1:{s:5:\"title\";s:15:\"Change Currency\";}i:3;a:1:{s:5:\"title\";s:15:\"Change Currency\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("179", "redux_version_upgraded_from", "3.6.5", "yes");
INSERT INTO `wp_options` VALUES("183", "wprentals_admin", "a:380:{s:8:\"last_tab\";s:2:\"49\";s:25:\"wp_estate_general_country\";s:26:\"Iran (Islamic Republic of)\";s:21:\"wp_estate_measure_sys\";s:0:\"\";s:26:\"wp_estate_enable_user_pass\";s:3:\"yes\";s:24:\"wp_estate_separate_users\";s:2:\"no\";s:22:\"wp_estate_publish_only\";s:0:\"\";s:23:\"wp_estate_delete_orphan\";s:3:\"yes\";s:19:\"wp_estate_date_lang\";s:2:\"fa\";s:31:\"wp_estate_google_analytics_code\";s:13:\"UA-67750538-2\";s:21:\"wp_estate_wide_status\";s:1:\"1\";s:17:\"wp_estate_prop_no\";s:1:\"6\";s:22:\"wp_estate_blog_sidebar\";s:10:\"no sidebar\";s:27:\"wp_estate_blog_sidebar_name\";s:19:\"primary-widget-area\";s:28:\"wp_estate_property_list_type\";s:1:\"1\";s:32:\"wp_estate_property_list_type_adv\";s:1:\"2\";s:23:\"wp_estate_favicon_image\";a:5:{s:3:\"url\";s:61:\"https://main.wprentals.org/wp-content/uploads/2015/08/fav.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"wp_estate_logo_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:32:\"wp_estate_transparent_logo_image\";a:5:{s:3:\"url\";s:74:\"https://main.wprentals.org/wp-content/uploads/2018/05/logo_transparent.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_mobile_logo_image\";a:5:{s:3:\"url\";s:74:\"https://main.wprentals.org/wp-content/uploads/2018/05/logo_transparent.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_logo_image_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:39:\"wp_estate_transparent_logo_image_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:34:\"wp_estate_mobile_logo_image_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:32:\"wp_estate_show_top_bar_user_menu\";s:3:\"yes\";s:34:\"wp_estate_show_top_bar_mobile_menu\";s:2:\"no\";s:21:\"wp_estate_show_submit\";s:3:\"yes\";s:33:\"wp_estate_show_top_bar_user_login\";s:3:\"yes\";s:29:\"wp_estate_show_menu_dashboard\";s:3:\"yes\";s:26:\"wp_estate_logo_header_type\";s:5:\"type1\";s:27:\"wp_estate_logo_header_align\";s:5:\"right\";s:21:\"wp_estate_header_type\";s:1:\"4\";s:26:\"wp_estate_user_header_type\";s:1:\"0\";s:34:\"wp_estate_global_revolution_slider\";s:0:\"\";s:23:\"wp_estate_global_header\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:24:\"wp_estate_paralax_header\";s:3:\"yes\";s:29:\"wp_estate_use_upload_tax_page\";s:3:\"yes\";s:21:\"wp_estate_wide_header\";s:2:\"no\";s:26:\"wp_estate_transparent_menu\";s:2:\"no\";s:34:\"wp_estate_transparent_menu_listing\";s:2:\"no\";s:27:\"wp_estate_footer_background\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:28:\"wp_estate_repeat_footer_back\";s:9:\"no repeat\";s:21:\"wp_estate_wide_footer\";s:2:\"no\";s:27:\"wp_estate_copyright_message\";s:76:\"فارسی سازی و بومی سازی توسط گروه گیوا givaweb@\";s:29:\"wp_estate_prices_th_separator\";s:1:\",\";s:29:\"wp_estate_currency_label_main\";s:10:\"تومان\";s:31:\"wp_estate_where_currency_symbol\";s:5:\"after\";s:25:\"wp_estate_currency_symbol\";s:3:\"IRR\";s:22:\"wp_estate_auto_curency\";s:2:\"no\";s:17:\"wpestate_currency\";a:4:{s:13:\"add_curr_name\";a:1:{i:0;s:1:\"1\";}s:14:\"add_curr_label\";a:1:{i:0;s:1:\"1\";}s:14:\"add_curr_value\";a:1:{i:0;s:0:\"\";}s:14:\"add_curr_order\";a:1:{i:0;s:1:\"1\";}}s:22:\"wp_estate_booking_type\";s:1:\"1\";s:23:\"wp_estate_setup_weekend\";s:1:\"0\";s:21:\"wp_estate_date_format\";s:1:\"0\";s:27:\"wp_estate_guest_dropdown_no\";s:1:\"7\";s:23:\"wp_estate_month_no_show\";s:2:\"12\";s:27:\"wpestate_custom_fields_list\";a:5:{s:14:\"add_field_name\";a:7:{i:0;s:13:\"Check-in hour\";i:1;s:14:\"Check-Out hour\";i:2;s:13:\"Late Check-in\";i:3;s:17:\"Optional services\";i:4;s:18:\"Outdoor facilities\";i:5;s:12:\"Extra People\";i:6;s:12:\"Cancellation\";}s:15:\"add_field_label\";a:7:{i:0;s:26:\"زمان تحویل ملک\";i:1;s:26:\"زمان تخلیه ملک\";i:2;s:24:\"بازدید از ملک\";i:3;s:21:\"دسترسی محلی\";i:4;s:17:\"چشم انداز\";i:5;s:21:\"افراد اضافی\";i:6;s:21:\"لغو درخواست\";}s:15:\"add_field_order\";a:7:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:1:\"7\";}s:14:\"add_field_type\";a:7:{i:0;s:10:\"short text\";i:1;s:10:\"short text\";i:2;s:10:\"short text\";i:3;s:10:\"short text\";i:4;s:10:\"short text\";i:5;s:10:\"short text\";i:6;s:10:\"short text\";}s:18:\"add_dropdown_order\";a:7:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";}}s:22:\"wp_estate_feature_list\";s:521:\"آشپزخانه اپن,\r\nاینترنت WIFI,\r\nمیز بیلیارد,\r\nتلویزیون,\r\nآیفون تصویری,\r\nآسانسور,\r\nشومینه,\r\nگرمایشی,\r\nسرمایشی,\r\nدرب ریموت دار,\r\nاستخر سرپوشیده,\r\nاستخر روباز,\r\nماشین رختشویی,\r\nجکوزی,\r\nخشک کن,\r\nسالن ورزش,\r\nپارکینگ,\r\nاینترنت داخلی,\r\nماهواره,\r\nتلویزیون کابلی,\r\nبالکن و تراس,\r\nتلفن,\r\nفضای باز,\r\nچیلر,\r\nکامپیوتر,\r\nفکس\";s:26:\"wp_estate_show_no_features\";s:2:\"no\";s:27:\"wp_estate_property_adr_text\";s:19:\"موقعیت ملک\";s:32:\"wp_estate_property_features_text\";s:14:\"امکانات\";s:35:\"wp_estate_property_description_text\";s:23:\"توضیحات آگهی\";s:31:\"wp_estate_property_details_text\";s:21:\"جزئیات آگهی\";s:29:\"wp_estate_property_price_text\";s:23:\"جزئیات اجاره\";s:21:\"wp_estate_status_list\";s:29:\"آگهی تایید شده,\r\n\";s:22:\"wp_estate_theme_slider\";a:2:{i:0;s:3:\"149\";i:1;s:3:\"137\";}s:29:\"wp_estate_theme_slider_manual\";s:0:\"\";s:22:\"wp_estate_slider_cycle\";s:4:\"4000\";s:27:\"wp_estate_theme_slider_type\";s:5:\"type1\";s:27:\"wp_estate_spash_header_type\";s:5:\"video\";s:31:\"wp_estate_splash_slider_gallery\";s:0:\"\";s:34:\"wp_estate_splash_slider_transition\";s:0:\"\";s:22:\"wp_estate_splash_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_splash_video_mp4\";a:5:{s:3:\"url\";s:63:\"https://main.wprentals.org/wp-content/uploads/2017/10/video.mp4\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_splash_video_webm\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_splash_video_ogv\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:32:\"wp_estate_splash_video_cover_img\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:30:\"wp_estate_splash_overlay_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:30:\"wp_estate_splash_overlay_color\";s:7:\"#0a0606\";s:32:\"wp_estate_splash_overlay_opacity\";s:3:\"0.6\";s:27:\"wp_estate_splash_page_title\";s:16:\"Home Splash Page\";s:30:\"wp_estate_splash_page_subtitle\";s:30:\"with background image or video\";s:31:\"wp_estate_splash_page_logo_link\";s:27:\"https://main.wprentals.org/\";s:22:\"wp_estate_company_name\";s:21:\"گیوا رنتالز\";s:20:\"wp_estate_co_address\";s:85:\"تهران، خیابان میرداماد، مجتمع کامپیوتر پایتخت\";s:19:\"wp_estate_email_adr\";s:17:\"givaweb@gmail.com\";s:29:\"wp_estate_duplicate_email_adr\";s:17:\"givaweb@gmail.com\";s:22:\"wp_estate_telephone_no\";s:14:\"(305) 555-4446\";s:19:\"wp_estate_mobile_no\";s:14:\"(305) 555-4555\";s:16:\"wp_estate_fax_ac\";s:14:\"(305) 555-4555\";s:18:\"wp_estate_skype_ac\";s:11:\"skypeidname\";s:21:\"wp_estate_hq_latitude\";s:9:\"40.781711\";s:22:\"wp_estate_hq_longitude\";s:10:\"-73.955927\";s:23:\"wp_estate_facebook_link\";s:33:\"https://www.facebook.com/wpestate\";s:22:\"wp_estate_twitter_link\";s:28:\"https://twitter.com/WPESTATE\";s:21:\"wp_estate_google_link\";s:55:\"https://plus.google.com/u/0/112306178370763368843/posts\";s:23:\"wp_estate_linkedin_link\";s:1:\"#\";s:24:\"wp_estate_pinterest_link\";s:1:\"#\";s:28:\"wp_estate_social_register_on\";s:2:\"no\";s:24:\"wp_estate_facebook_login\";s:3:\"yes\";s:22:\"wp_estate_facebook_api\";s:0:\"\";s:25:\"wp_estate_facebook_secret\";s:0:\"\";s:22:\"wp_estate_google_login\";s:3:\"yes\";s:26:\"wp_estate_google_oauth_api\";s:0:\"\";s:36:\"wp_estate_google_oauth_client_secret\";s:0:\"\";s:24:\"wp_estate_google_api_key\";s:0:\"\";s:21:\"wp_estate_yahoo_login\";s:3:\"yes\";s:30:\"wp_estate_twitter_consumer_key\";s:0:\"\";s:33:\"wp_estate_twitter_consumer_secret\";s:0:\"\";s:30:\"wp_estate_twitter_access_token\";s:0:\"\";s:31:\"wp_estate_twitter_access_secret\";s:0:\"\";s:28:\"wp_estate_twitter_cache_time\";s:0:\"\";s:21:\"wp_estate_kind_of_map\";s:1:\"1\";s:24:\"wp_estate_kind_of_places\";s:1:\"1\";s:17:\"wp_estate_readsys\";s:2:\"no\";s:22:\"wp_estate_map_max_pins\";s:2:\"30\";s:17:\"wp_estate_api_key\";s:39:\"AIzaSyDD5sf5vfb3inYl-DibniZlPZfwfzCk4bw\";s:24:\"wp_estate_mapbox_api_key\";s:0:\"\";s:24:\"wp_estate_algolia_app_id\";s:0:\"\";s:25:\"wp_estate_algolia_api_key\";s:0:\"\";s:26:\"wp_estate_general_latitude\";s:9:\"39.517193\";s:27:\"wp_estate_general_longitude\";s:10:\"-76.301010\";s:26:\"wp_estate_default_map_zoom\";s:1:\"5\";s:21:\"wp_estate_pin_cluster\";s:3:\"yes\";s:22:\"wp_estate_zoom_cluster\";s:1:\"8\";s:28:\"wp_estate_geolocation_radius\";s:4:\"1000\";s:20:\"wp_estate_min_height\";s:3:\"530\";s:20:\"wp_estate_max_height\";s:3:\"660\";s:18:\"wp_estate_keep_min\";s:2:\"no\";s:19:\"wp_estate_map_style\";s:2162:\"[\r\n    {\r\n        \\\"featureType\\\": \\\"administrative\\\",\r\n        \\\"elementType\\\": \\\"labels.text.fill\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"color\\\": \\\"#444444\\\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"administrative.country\\\",\r\n        \\\"elementType\\\": \\\"geometry.fill\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"visibility\\\": \\\"on\\\"\r\n            },\r\n            {\r\n                \\\"saturation\\\": \\\"5\\\"\r\n            },\r\n            {\r\n                \\\"lightness\\\": \\\"-11\\\"\r\n            },\r\n            {\r\n                \\\"weight\\\": \\\"0.01\\\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"landscape\\\",\r\n        \\\"elementType\\\": \\\"all\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"color\\\": \\\"#f2f2f2\\\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"poi\\\",\r\n        \\\"elementType\\\": \\\"all\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"visibility\\\": \\\"off\\\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"road\\\",\r\n        \\\"elementType\\\": \\\"all\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"saturation\\\": -100\r\n            },\r\n            {\r\n                \\\"lightness\\\": 45\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"road.highway\\\",\r\n        \\\"elementType\\\": \\\"all\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"visibility\\\": \\\"simplified\\\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"road.arterial\\\",\r\n        \\\"elementType\\\": \\\"labels.icon\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"visibility\\\": \\\"off\\\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"transit\\\",\r\n        \\\"elementType\\\": \\\"all\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"visibility\\\": \\\"off\\\"\r\n            }\r\n        ]\r\n    },\r\n    {\r\n        \\\"featureType\\\": \\\"water\\\",\r\n        \\\"elementType\\\": \\\"all\\\",\r\n        \\\"stylers\\\": [\r\n            {\r\n                \\\"color\\\": \\\"#91d5e4\\\"\r\n            },\r\n            {\r\n                \\\"visibility\\\": \\\"on\\\"\r\n            }\r\n        ]\r\n    }\r\n]\";s:24:\"wp_estate_use_price_pins\";s:2:\"no\";s:35:\"wp_estate_use_price_pins_full_price\";s:2:\"no\";s:22:\"wp_estate_private-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:21:\"wp_estate_shared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:46:\"wp_estate_d985d984daa9-d8a8d8a7d8b2d8b3d8a7d8b\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:21:\"wp_estate_entire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:43:\"wp_estate_d985d984daa9-d985d8b4d8aad8b1daa9\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:19:\"wp_estate_apartment\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"wp_estate_cabin\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"wp_estate_condos\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"wp_estate_house\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"wp_estate_dorm\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:13:\"wp_estate_b-b\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:22:\"wp_estate_d987d8aad984\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"wp_estate_villa\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:31:\"wp_estate_apartmentprivate-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_cabinprivate-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:28:\"wp_estate_condosprivate-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_houseprivate-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_dormprivate-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"wp_estate_b-bprivate-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:34:\"wp_estate_d987d8aad984private-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_villaprivate-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:30:\"wp_estate_apartmentshared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_cabinshared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_condosshared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_houseshared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"wp_estate_dormshared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:24:\"wp_estate_b-bshared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_d987d8aad984shared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_villashared-room\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:37:\"wp_estate_apartmentd985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_cabind985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:34:\"wp_estate_condosd985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_housed985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:32:\"wp_estate_dormd985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:31:\"wp_estate_b-bd985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:40:\"wp_estate_d987d8aad984d985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_villad985d984daa9-d8a8d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:30:\"wp_estate_apartmententire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_cabinentire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"wp_estate_condosentire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_houseentire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"wp_estate_dormentire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:24:\"wp_estate_b-bentire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_d987d8aad984entire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:26:\"wp_estate_villaentire-home\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:37:\"wp_estate_apartmentd985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_cabind985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:34:\"wp_estate_condosd985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_housed985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:32:\"wp_estate_dormd985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:31:\"wp_estate_b-bd985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:40:\"wp_estate_d987d8aad984d985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:33:\"wp_estate_villad985d984daa9-d985d\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:17:\"wp_estate_userpin\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:23:\"wp_estate_header_height\";s:0:\"\";s:30:\"wp_estate_sticky_header_height\";s:0:\"\";s:30:\"wp_estate_border_bottom_header\";s:0:\"\";s:36:\"wp_estate_border_bottom_header_color\";s:0:\"\";s:27:\"wp_estate_listing_page_type\";s:1:\"2\";s:30:\"wp_estate_use_custom_icon_area\";s:2:\"no\";s:35:\"wp_estate_use_custom_icon_font_size\";s:0:\"\";s:30:\"wp_estate_property_page_header\";a:4:{s:24:\"property_unit_field_name\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:25:\"property_unit_field_image\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:25:\"property_unit_field_label\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:16:\"unit_field_value\";a:5:{i:0;s:4:\"none\";i:1;s:4:\"none\";i:2;s:4:\"none\";i:3;s:4:\"none\";i:4;s:4:\"none\";}}s:27:\"wp_estate_listing_unit_type\";s:1:\"2\";s:26:\"wp_estate_prop_list_slider\";s:3:\"yes\";s:33:\"wp_estate_listing_unit_style_half\";s:1:\"2\";s:31:\"wp_estate_custom_listing_fields\";a:3:{s:15:\"unit_field_name\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:16:\"unit_field_label\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:16:\"unit_field_value\";a:4:{i:0;s:4:\"none\";i:1;s:4:\"none\";i:2;s:4:\"none\";i:3;s:4:\"none\";}}s:30:\"wp_estate_custom_icons_infobox\";s:2:\"no\";s:31:\"wp_estate_custom_infobox_fields\";a:2:{s:18:\"infobox_field_icon\";a:2:{i:0;s:0:\"\";i:1;s:0:\"\";}s:16:\"unit_field_value\";a:2:{i:0;s:4:\"none\";i:1;s:4:\"none\";}}s:24:\"wp_estate_on_child_theme\";s:0:\"\";s:20:\"wp_estate_main_color\";s:0:\"\";s:26:\"wp_estate_background_color\";s:0:\"\";s:32:\"wp_estate_breadcrumbs_font_color\";s:0:\"\";s:20:\"wp_estate_font_color\";s:0:\"\";s:20:\"wp_estate_link_color\";s:0:\"\";s:24:\"wp_estate_headings_color\";s:0:\"\";s:27:\"wp_estate_footer_back_color\";s:0:\"\";s:27:\"wp_estate_footer_font_color\";s:0:\"\";s:27:\"wp_estate_footer_copy_color\";s:0:\"\";s:30:\"wp_estate_sidebar_widget_color\";s:0:\"\";s:31:\"wp_estate_sidebar_heading_color\";s:0:\"\";s:29:\"wp_estate_sidebar2_font_color\";s:0:\"\";s:32:\"wp_estate_box_content_back_color\";s:0:\"\";s:34:\"wp_estate_box_content_border_color\";s:0:\"\";s:28:\"wp_estate_hover_button_color\";s:0:\"\";s:22:\"wp_estate_header_color\";s:0:\"\";s:22:\"wp_estate_top_bar_back\";s:0:\"\";s:22:\"wp_estate_top_bar_font\";s:0:\"\";s:25:\"wp_estate_menu_font_color\";s:0:\"\";s:35:\"wp_estate_top_menu_hover_font_color\";s:0:\"\";s:32:\"wp_estate_active_menu_font_color\";s:0:\"\";s:37:\"wp_estate_transparent_menu_font_color\";s:0:\"\";s:43:\"wp_estate_transparent_menu_hover_font_color\";s:0:\"\";s:32:\"wp_estate_sticky_menu_font_color\";s:0:\"\";s:26:\"wp_estate_menu_items_color\";s:0:\"\";s:30:\"wp_estate_menu_item_back_color\";s:0:\"\";s:31:\"wp_estate_menu_hover_font_color\";s:0:\"\";s:28:\"wp_estate_top_menu_font_size\";s:0:\"\";s:29:\"wp_estate_menu_item_font_size\";s:0:\"\";s:40:\"wp_estate_top_menu_hover_back_font_color\";s:0:\"\";s:29:\"wp_estate_top_menu_hover_type\";s:1:\"1\";s:20:\"wp_estate_custom_css\";s:45:\"#menu-item-28214{\r\ndisplay:none!important;\r\n}\";s:22:\"wp_estate_general_font\";s:0:\"\";s:30:\"wp_estate_headings_font_subset\";s:0:\"\";s:26:\"wp_estate_subject_new_user\";s:42:\"Your username and password on %website_url\";s:18:\"wp_estate_new_user\";s:203:\"Hi there,\r\nWelcome to %website_url ! You can login now using the below credentials:\r\nUsername:%user_login_register\r\nPassword: %user_pass_register\r\nIf you have any problems, please contact me.\r\nThank you!\";s:32:\"wp_estate_subject_admin_new_user\";s:21:\"New User Registration\";s:36:\"wp_estate_subject_purchase_activated\";s:27:\"Your purchase was activated\";s:28:\"wp_estate_purchase_activated\";s:82:\"Hi there,\r\nYour purchase on %website_url is activated! You should go check it out.\";s:40:\"wp_estate_subject_password_reset_request\";s:22:\"Password Reset Request\";s:34:\"wp_estate_subject_password_reseted\";s:23:\"Your Password was Reset\";s:34:\"wp_estate_subject_approved_listing\";s:25:\"Your listing was approved\";s:39:\"wp_estate_subject_admin_expired_listing\";s:49:\"Expired Listing sent for approval on %website_url\";s:34:\"wp_estate_subject_paid_submissions\";s:35:\"New Paid Submission on %website_url\";s:37:\"wp_estate_subject_featured_submission\";s:36:\"New Feature Upgrade on  %website_url\";s:36:\"wp_estate_subject_account_downgraded\";s:34:\"Account Downgraded on %website_url\";s:38:\"wp_estate_subject_membership_cancelled\";s:36:\"Membership Cancelled on %website_url\";s:38:\"wp_estate_subject_free_listing_expired\";s:36:\"Free Listing expired on %website_url\";s:40:\"wp_estate_subject_new_listing_submission\";s:38:\"New Listing Submission on %website_url\";s:35:\"wp_estate_subject_recurring_payment\";s:33:\"Recurring Payment on %website_url\";s:38:\"wp_estate_subject_membership_activated\";s:36:\"Membership Activated on %website_url\";s:38:\"wp_estate_subject_agent_update_profile\";s:14:\"Profile Update\";s:38:\"wp_estate_subject_bookingconfirmeduser\";s:33:\"Booking Confirmed on %website_url\";s:34:\"wp_estate_subject_bookingconfirmed\";s:33:\"Booking Confirmed on %website_url\";s:44:\"wp_estate_subject_bookingconfirmed_nodeposit\";s:33:\"Booking Confirmed on %website_url\";s:23:\"wp_estate_subject_inbox\";s:28:\"New Message on %website_url.\";s:25:\"wp_estate_subject_newbook\";s:36:\"New Booking Request on %website_url.\";s:27:\"wp_estate_subject_mynewbook\";s:36:\"You booked a period on %website_url.\";s:28:\"wp_estate_subject_newinvoice\";s:28:\"New Invoice on %website_url.\";s:31:\"wp_estate_subject_deletebooking\";s:40:\"Booking Request Rejected on %website_url\";s:35:\"wp_estate_subject_deletebookinguser\";s:41:\"Booking Request Cancelled on %website_url\";s:40:\"wp_estate_subject_deletebookingconfirmed\";s:41:\"Booking Period Cancelled on %website_url.\";s:35:\"wp_estate_subject_new_wire_transfer\";s:31:\"You ordered a new Wire Transfer\";s:41:\"wp_estate_subject_admin_new_wire_transfer\";s:36:\"Somebody ordered a new Wire Transfer\";s:39:\"wp_estate_subject_full_invoice_reminder\";s:24:\"Invoice payment reminder\";s:42:\"wp_estate_subject_new_user_id_verification\";s:24:\"New User ID verification\";s:34:\"wp_estate_new_user_id_verification\";s:147:\"A user added his User ID verification image on %website_url.\r\nUsername: %user_login.\r\nYou can check the verification status here: %user_profile_url\";s:21:\"wp_estate_use_captcha\";s:2:\"no\";s:26:\"wp_estate_recaptha_sitekey\";s:40:\"6LfneyYTAAAAAIpnhd5-QwOxcxCWLAJtqLFQeTtk\";s:28:\"wp_estate_recaptha_secretkey\";s:40:\"6LfneyYTAAAAAFV7u3jrpsaO0UBqjcCGU_f-J2AX\";s:24:\"wp_estate_yelp_client_id\";s:0:\"\";s:28:\"wp_estate_yelp_client_secret\";s:0:\"\";s:25:\"wp_estate_yelp_results_no\";s:0:\"\";s:27:\"wp_estate_yelp_dist_measure\";s:5:\"miles\";s:26:\"wp_estate_item_rental_type\";s:1:\"0\";s:27:\"wp_estate_show_guest_number\";s:3:\"yes\";s:31:\"wp_estate_show_city_drop_submit\";s:3:\"yes\";s:32:\"wp_estate_submission_page_fields\";a:35:{i:0;s:20:\"prop_category_submit\";i:1;s:27:\"prop_action_category_submit\";i:2;s:19:\"property_city_front\";i:3;s:19:\"property_area_front\";i:4;s:20:\"property_description\";i:5;s:14:\"property_price\";i:6;s:14:\"property_taxes\";i:7;s:23:\"property_price_per_week\";i:8;s:24:\"property_price_per_month\";i:9;s:18:\"price_per_weekeend\";i:10;s:12:\"cleaning_fee\";i:11;s:8:\"city_fee\";i:12;s:16:\"min_days_booking\";i:13;s:16:\"security_deposit\";i:14;s:18:\"early_bird_percent\";i:15;s:21:\"extra_price_per_guest\";i:16;s:19:\"checkin_change_over\";i:17;s:28:\"checkin_checkout_change_over\";i:18;s:13:\"extra_options\";i:19;s:13:\"custom_prices\";i:20;s:8:\"attachid\";i:21;s:14:\"embed_video_id\";i:22;s:16:\"embed_video_type\";i:23;s:13:\"property_size\";i:24;s:14:\"property_rooms\";i:25;s:17:\"property_bedrooms\";i:26;s:18:\"property_bathrooms\";i:27;s:16:\"property_address\";i:28;s:12:\"property_zip\";i:29;s:15:\"property_county\";i:30;s:14:\"property_state\";i:31;s:12:\"property_map\";i:32;s:17:\"property_latitude\";i:33;s:18:\"property_longitude\";i:34;s:19:\"google_camera_angle\";}s:23:\"wp_estate_category_main\";s:0:\"\";s:32:\"wp_estate_category_main_dropdown\";s:0:\"\";s:25:\"wp_estate_category_second\";s:0:\"\";s:34:\"wp_estate_category_second_dropdown\";s:0:\"\";s:32:\"wp_estate_item_description_label\";s:0:\"\";s:27:\"wp_estate_prop_image_number\";s:0:\"\";s:25:\"wp_estate_paid_submission\";s:10:\"membership\";s:23:\"wp_estate_free_mem_list\";s:2:\"10\";s:27:\"wp_estate_free_mem_list_unl\";s:0:\"\";s:24:\"wp_estate_free_feat_list\";s:1:\"2\";s:35:\"wp_estate_free_feat_list_expiration\";s:2:\"20\";s:26:\"wp_estate_price_submission\";s:1:\"1\";s:35:\"wp_estate_price_featured_submission\";s:1:\"2\";s:20:\"wp_estate_paypal_api\";s:4:\"live\";s:26:\"wp_estate_admin_submission\";s:3:\"yes\";s:28:\"wp_estate_submission_curency\";s:3:\"USD\";s:27:\"wp_estate_enable_direct_pay\";s:3:\"yes\";s:32:\"wp_estate_direct_payment_details\";s:145:\"لطفا وجه اجاره ملک را به شماره حساب 1235**** نزد بانک ملت به نام گیواوب واریز نمایید.\";s:35:\"wp_estate_submission_curency_custom\";s:10:\"تومان\";s:26:\"wp_estate_include_expenses\";s:2:\"no\";s:19:\"wp_estate_book_down\";s:2:\"50\";s:29:\"wp_estate_book_down_fixed_fee\";s:0:\"\";s:21:\"wp_estate_service_fee\";s:2:\"10\";s:31:\"wp_estate_service_fee_fixed_fee\";s:0:\"\";s:23:\"wp_estate_enable_paypal\";s:3:\"yes\";s:26:\"wp_estate_paypal_client_id\";s:36:\"e0316ea2-f2e6-11e8-927c-005056a205be\";s:30:\"wp_estate_paypal_client_secret\";s:0:\"\";s:26:\"wp_estate_paypal_rec_email\";s:0:\"\";s:23:\"wp_estate_enable_stripe\";s:2:\"no\";s:27:\"wp_estate_stripe_secret_key\";s:0:\"\";s:32:\"wp_estate_stripe_publishable_key\";s:0:\"\";s:33:\"wp_estate_show_adv_search_general\";s:3:\"yes\";s:32:\"wp_estate_show_adv_search_slider\";s:3:\"yes\";s:21:\"wp_estate_ondemandmap\";s:3:\"yes\";s:31:\"wp_estate_wpestate_autocomplete\";s:3:\"yes\";s:40:\"wp_estate_wpestate_autocomplete_use_list\";s:2:\"no\";s:25:\"wp_estate_show_empty_city\";s:2:\"no\";s:25:\"wp_estate_adv_search_type\";s:7:\"newtype\";s:31:\"wp_estate_show_slider_min_price\";s:1:\"0\";s:31:\"wp_estate_show_slider_max_price\";s:4:\"1000\";s:34:\"wp_estate_show_adv_search_extended\";s:2:\"no\";s:24:\"wp_estate_show_dropdowns\";s:2:\"no\";s:35:\"wp_estate_adv_search_label_for_form\";s:0:\"\";s:30:\"wp_estate_adv_search_fields_no\";s:1:\"3\";s:34:\"wp_estate_search_fields_no_per_row\";s:1:\"3\";s:19:\"wpestate_set_search\";a:4:{s:15:\"adv_search_what\";a:3:{i:0;s:8:\"Location\";i:1;s:8:\"Location\";i:2;s:8:\"Location\";}s:14:\"adv_search_how\";a:3:{i:0;s:5:\"equal\";i:1;s:5:\"equal\";i:2;s:5:\"equal\";}s:16:\"adv_search_label\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}s:18:\"search_field_label\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}}s:26:\"wp_estate_use_geo_location\";s:2:\"no\";s:28:\"wp_estate_geo_radius_measure\";s:5:\"miles\";s:24:\"wp_estate_initial_radius\";s:0:\"\";s:24:\"wp_estate_min_geo_radius\";s:0:\"\";s:24:\"wp_estate_max_geo_radius\";s:0:\"\";s:23:\"wp_estate_sticky_search\";s:2:\"no\";s:31:\"wp_estate_use_float_search_form\";s:3:\"yes\";s:24:\"wp_estate_float_form_top\";s:3:\"20%\";s:28:\"wp_estate_float_form_top_tax\";s:3:\"15%\";s:25:\"wp_estate_search_on_start\";s:2:\"no\";s:24:\"wp_estate_adv_back_color\";s:0:\"\";s:32:\"wp_estate_adv_back_color_opacity\";s:0:\"\";s:32:\"wp_estate_adv_search_back_button\";s:0:\"\";s:38:\"wp_estate_adv_search_back_hover_button\";s:0:\"\";s:23:\"wp_estate_rcapi_api_key\";s:0:\"\";s:30:\"wp_estate_rcapi_api_secret_key\";s:0:\"\";s:28:\"wp_estate_rcapi_api_username\";s:0:\"\";s:28:\"wp_estate_rcapi_api_password\";s:0:\"\";s:26:\"wp_estate_sms_verification\";s:3:\"yes\";s:25:\"wp_estate_twilio_phone_no\";s:9:\"100020400\";s:24:\"wp_estate_twilio_api_key\";s:0:\"\";s:27:\"wp_estate_twilio_auth_token\";s:0:\"\";s:20:\"wp_estate_validation\";s:57:\"کد تایید شماره موبایل شما: %apincode\";s:24:\"wp_estate_admin_new_user\";s:101:\"New user registration on %website_url.\r\nUsername: %user_login_register,\r\nE-mail: %user_email_register\";s:32:\"wp_estate_password_reset_request\";s:256:\"Someone requested that the password be reset for the following account:\r\n%website_url\r\nUsername: %username.\r\nIf this was a mistake, just ignore this email and nothing will happen. To reset your password, visit the following address:%reset_link,\r\nThank You!\";s:26:\"wp_estate_password_reseted\";s:152:\"Your new password for the account at: %website_url:\r\nUsername:%username,\r\nPassword:%user_pass\r\nYou can now login with your new password at: %website_url\";s:26:\"wp_estate_approved_listing\";s:131:\"Hi there,\r\nYour listing, %property_title was approved on %website_url ! The listing is: %property_url.\r\nYou should go check it out.\";s:31:\"wp_estate_admin_expired_listing\";s:142:\"Hi there,\r\nA user has re-submited a new property on %website_url ! You should go check it out.\r\nThis is the property title: %submission_title.\";s:26:\"wp_estate_paid_submissions\";s:87:\"Hi there,\r\nYou have a new paid submission on %website_url ! You should go check it out.\";s:29:\"wp_estate_featured_submission\";s:91:\"Hi there,\r\nYou have a new featured submission on %website_url ! You should go check it out.\";s:28:\"wp_estate_account_downgraded\";s:288:\"Hi there,\r\nYou downgraded your subscription on %website_url. Because your listings number was greater than what the actual package offers, we set the status of all your listings to expired. You will need to choose which listings you want live and send them again for approval.\r\nThank you!\";s:30:\"wp_estate_membership_cancelled\";s:236:\"Hi there,\r\nYour subscription on %website_url was cancelled because it expired or the recurring payment from the merchant was not processed. All your listings are no longer visible for our visitors but remain in your account.\r\nThank you.\";s:30:\"wp_estate_free_listing_expired\";s:114:\"Hi there,\r\nOne of your free listings on %website_url has expired. The listing is %expired_listing_url.\r\nThank you!\";s:32:\"wp_estate_new_listing_submission\";s:137:\"Hi there,\r\nA user has submited a new property on %website_url ! You should go check it out.This is the property title %new_listing_title!\";s:27:\"wp_estate_recurring_payment\";s:112:\"Hi there,\r\nWe charged your account on %merchant for a subscription on %website_url ! You should go check it out.\";s:30:\"wp_estate_membership_activated\";s:88:\"Hi there,\r\nYour new membership on %website_url is activated! You should go check it out.\";s:30:\"wp_estate_agent_update_profile\";s:68:\"A user updated his profile on %website_url.\r\nUsername: %user_profile\";s:30:\"wp_estate_bookingconfirmeduser\";s:155:\"Hi there,\r\nYour booking made on %website_url was confirmed! You can see all your reservations by logging in your account and visiting My Reservations page.\";s:26:\"wp_estate_bookingconfirmed\";s:284:\"Hi there,\r\nSomebody confirmed a booking on %website_url! You should go and check it out!Please remember that the confirmation is made based on the payment confirmation of a non-refundable fee of the total invoice cost, processed through %website_url and sent to website administrator.\";s:36:\"wp_estate_bookingconfirmed_nodeposit\";s:94:\"Hi there,\r\nYou confirmed a booking on %website_url! The booking was confirmed with no deposit!\";s:15:\"wp_estate_inbox\";s:109:\"Hi there,\r\nYou have a new message on %website_url! You should go and check it out!\r\nThe message is:\r\n%content\";s:17:\"wp_estate_newbook\";s:197:\"Hi there,\r\nYou have received a new booking request on %website_url ! Go to your account in Bookings page to see the request, issue the invoice or reject it!\r\nThe property is: %booking_property_link\";s:19:\"wp_estate_mynewbook\";s:179:\"Hi there,\r\nYou have booked a period for your own listing on %website_url ! The reservation will appear in your account, under My Bookings.\r\nThe property is: %booking_property_link\";s:20:\"wp_estate_newinvoice\";s:197:\"Hi there,\r\nAn invoice was generated for your booking request on %website_url ! A deposit will be required for booking to be confirmed. For more details check out your account, My Reservations page.\";s:23:\"wp_estate_deletebooking\";s:156:\"Hi there,\r\nOne of your booking requests sent on %website_url was rejected by the owner. The rejected reservation is automatically removed from your account.\";s:27:\"wp_estate_deletebookinguser\";s:150:\"Hi there,\r\nOne of the unconfirmed booking requests you received on %website_url was cancelled! The request is automatically deleted from your account!\";s:32:\"wp_estate_deletebookingconfirmed\";s:90:\"Hi there,\r\nOne of your confirmed bookings on %website_url was cancelled by property owner.\";s:27:\"wp_estate_new_wire_transfer\";s:255:\"We received your Wire Transfer payment request on %website_url !\r\nPlease follow the instructions below in order to start submitting properties as soon as possible.\r\nThe invoice number is: %invoice_no, Amount: %total_price.\r\nInstructions: %payment_details.\";s:33:\"wp_estate_admin_new_wire_transfer\";s:205:\"Hi there,\r\nYou received a new Wire Transfer payment request on %website_url.\r\nThe invoice number is: %invoice_no, Amount: %total_price.\r\nPlease wait until the payment is made to activate the user purchase.\";s:31:\"wp_estate_full_invoice_reminder\";s:208:\"Hi there,\r\nWe remind you that you need to fully pay the invoice no %invoice_id until %until_date. This invoice is for booking no %booking_id on property %property_title with the url %property_url.\r\nThank you.\";s:25:\"wp_estate_adv_search_what\";a:3:{i:0;s:8:\"Location\";i:1;s:8:\"Location\";i:2;s:8:\"Location\";}s:24:\"wp_estate_adv_search_how\";a:3:{i:0;s:5:\"equal\";i:1;s:5:\"equal\";i:2;s:5:\"equal\";}s:26:\"wp_estate_adv_search_label\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}s:28:\"wp_estate_search_field_label\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}s:33:\"wp_estate_adv_search_what_classic\";a:4:{i:0;s:8:\"Location\";i:1;s:8:\"check_in\";i:2;s:9:\"check_out\";i:3;s:8:\"guest_no\";}s:32:\"wp_estate_adv_search_how_classic\";a:4:{i:0;s:4:\"like\";i:1;s:4:\"like\";i:2;s:4:\"like\";i:3;s:7:\"greater\";}s:30:\"wp_estate_adv_search_what_half\";a:10:{i:0;s:8:\"Location\";i:1;s:8:\"check_in\";i:2;s:9:\"check_out\";i:3;s:8:\"guest_no\";i:4;s:14:\"property_rooms\";i:5;s:17:\"property_category\";i:6;s:24:\"property_action_category\";i:7;s:17:\"property_bedrooms\";i:8;s:18:\"property_bathrooms\";i:9;s:14:\"property_price\";}s:29:\"wp_estate_adv_search_how_half\";a:10:{i:0;s:4:\"like\";i:1;s:4:\"like\";i:2;s:4:\"like\";i:3;s:7:\"greater\";i:4;s:7:\"greater\";i:5;s:4:\"like\";i:6;s:4:\"like\";i:7;s:7:\"greater\";i:8;s:7:\"greater\";i:9;s:7:\"between\";}}", "yes");
INSERT INTO `wp_options` VALUES("184", "wprentals_admin-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1547274880;}", "yes");
INSERT INTO `wp_options` VALUES("187", "ewww_image_optimizer_background_optimization", "1", "yes");
INSERT INTO `wp_options` VALUES("191", "ewww_image_optimizer_disable_pngout", "1", "no");
INSERT INTO `wp_options` VALUES("192", "ewww_image_optimizer_optipng_level", "2", "no");
INSERT INTO `wp_options` VALUES("193", "ewww_image_optimizer_pngout_level", "2", "no");
INSERT INTO `wp_options` VALUES("194", "ewww_image_optimizer_jpegtran_copy", "1", "no");
INSERT INTO `wp_options` VALUES("195", "ewww_image_optimizer_jpg_level", "10", "no");
INSERT INTO `wp_options` VALUES("196", "ewww_image_optimizer_png_level", "10", "no");
INSERT INTO `wp_options` VALUES("197", "ewww_image_optimizer_gif_level", "10", "no");
INSERT INTO `wp_options` VALUES("198", "ewww_image_optimizer_pdf_level", "0", "no");
INSERT INTO `wp_options` VALUES("199", "ewww_image_optimizer_version", "453.0", "yes");
INSERT INTO `wp_options` VALUES("205", "revslider_servers", "a:10:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-a.tools\";i:4;s:16:\"themepunch.tools\";i:5;s:22:\"themepunch-ext-a.tools\";i:6;s:22:\"themepunch-ext-a.tools\";i:7;s:22:\"themepunch-ext-a.tools\";i:8;s:22:\"themepunch-ext-a.tools\";i:9;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("206", "revslider_server_refresh", "1546085427", "yes");
INSERT INTO `wp_options` VALUES("207", "revslider-update-check-short", "1547186973", "yes");
INSERT INTO `wp_options` VALUES("208", "revslider-templates-check", "1547014132", "yes");
INSERT INTO `wp_options` VALUES("213", "revslider-library-check", "1546343487", "yes");
INSERT INTO `wp_options` VALUES("214", "rs-library", "a:2:{s:7:\"objects\";a:169:{i:198;a:12:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:12:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:12:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:12:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:12:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:12:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:12:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:12:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:12:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:12:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:12:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:12:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:12:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:12:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:12:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:12:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:12:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:12:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:12:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:12:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:12:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:12:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:12:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:12:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:12:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:12:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:12:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:12:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:12:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:12:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:12:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:12:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:12:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Hole-punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:12:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:12:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:12:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:12:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:12:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:12:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:12:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:12:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:12:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:12:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:12:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:12:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:12:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:12:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:12:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:12:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:12:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:12:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:12:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:12:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:12:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:12:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:12:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:12:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:12:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:12:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:12:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:12:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:12:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:12:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:12:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:12:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:131;a:12:{s:2:\"id\";s:3:\"131\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:130;a:12:{s:2:\"id\";s:3:\"130\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:129;a:12:{s:2:\"id\";s:3:\"129\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:128;a:12:{s:2:\"id\";s:3:\"128\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:127;a:12:{s:2:\"id\";s:3:\"127\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:126;a:12:{s:2:\"id\";s:3:\"126\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:125;a:12:{s:2:\"id\";s:3:\"125\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:124;a:12:{s:2:\"id\";s:3:\"124\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:123;a:12:{s:2:\"id\";s:3:\"123\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:122;a:12:{s:2:\"id\";s:3:\"122\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:121;a:12:{s:2:\"id\";s:3:\"121\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"120\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:3:\"119\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:3:\"118\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:3:\"117\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:3:\"116\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:3:\"115\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:3:\"114\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:3:\"113\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:3:\"112\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:3:\"111\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:3:\"110\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:3:\"109\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:3:\"108\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:3:\"107\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:3:\"106\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:3:\"105\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:3:\"104\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:3:\"103\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:3:\"102\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:3:\"101\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:3:\"100\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"99\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"98\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"97\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"96\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"95\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"94\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"93\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"92\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"91\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"90\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"89\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"88\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"87\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"86\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"85\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"84\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"83\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"82\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"81\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"80\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"79\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"78\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"77\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"76\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"75\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"74\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"73\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"72\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"71\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"70\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"69\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"68\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"67\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"66\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"65\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"64\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"63\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"62\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:2:\"49\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:2:\"48\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:2:\"47\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:2:\"46\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:2:\"45\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:2:\"44\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:2:\"43\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:2:\"42\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:2:\"41\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:2:\"40\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:2:\"39\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:2:\"38\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:2:\"37\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:2:\"36\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:2:\"35\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:2:\"34\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:2:\"33\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:2:\"32\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:2:\"31\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:2:\"30\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:2:\"29\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:2:\"28\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:2:\"27\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:2:\"26\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:2:\"25\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:2:\"24\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:2:\"23\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:2:\"22\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:2:\"21\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:2:\"20\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:2:\"11\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:2:\"10\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:1:\"9\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:1:\"8\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}}s:4:\"tags\";a:13:{i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}}", "no");
INSERT INTO `wp_options` VALUES("215", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("216", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("217", "revslider_table_version", "1.0.6", "yes");
INSERT INTO `wp_options` VALUES("218", "revslider-global-settings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("219", "revslider_update_version", "5.2.5.5", "yes");
INSERT INTO `wp_options` VALUES("220", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("222", "bsf_force_check_extensions", "", "no");
INSERT INTO `wp_options` VALUES("223", "ultimate_row", "enable", "yes");
INSERT INTO `wp_options` VALUES("224", "ultimate_animation", "disable", "yes");
INSERT INTO `wp_options` VALUES("225", "ultimate_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("226", "ultimate_selected_google_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("227", "bsf_local_transient", "1547284221", "yes");
INSERT INTO `wp_options` VALUES("230", "bsf-updater-version", "1.22.57\r\n", "yes");
INSERT INTO `wp_options` VALUES("231", "brainstrom_products", "a:1:{s:7:\"plugins\";a:1:{i:6892199;a:32:{s:2:\"id\";s:7:\"6892199\";s:4:\"name\";s:41:\"Ultimate Addons for WPBakery Page Builder\";s:4:\"slug\";s:18:\"Ultimate_VC_Addons\";s:10:\"short_name\";s:22:\"Ultimate Addons For VC\";s:11:\"description\";s:153:\"The top seller new plugin of 2016. Install Ultimate with WPBakery Page Builder and you will probably have everything you need to build stunning websites.\";s:7:\"version\";s:6:\"3.17.0\";s:12:\"download_url\";s:22:\"Ultimate_VC_Addons.zip\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"tested\";s:3:\"5.0\";s:14:\"privacy_policy\";s:52:\"https://ultimate.brainstormforce.com/privacy-policy/\";s:16:\"terms_conditions\";s:58:\"https://ultimate.brainstormforce.com/terms-and-conditions/\";s:12:\"purchase_url\";s:74:\"https://codecanyon.net/cart/add_items?item_ids=6892199&ref=BrainstormForce\";s:13:\"changelog_url\";s:46:\"http://changelog.brainstormforce.com/ultimate/\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:4:\"true\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:5:\"false\";s:13:\"support_forum\";s:37:\"http://brainstormforce.freshdesk.com/\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/07/uavc.jpg\";s:32:\"show_on_register_licence_listing\";s:4:\"true\";s:15:\"show_on_listing\";s:4:\"true\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:7:\"6892199\";s:8:\"template\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:6:\"remote\";s:6:\"3.17.1\";s:12:\"purchase_key\";s:0:\"\";s:6:\"status\";s:0:\"\";s:7:\"message\";s:0:\"\";s:12:\"product_name\";s:41:\"Ultimate Addons for WPBakery Page Builder\";}}}", "yes");
INSERT INTO `wp_options` VALUES("233", "bsf_local_transient_bundled", "1546815854", "yes");
INSERT INTO `wp_options` VALUES("238", "bsf_skip_braisntorm_menu", "1", "no");
INSERT INTO `wp_options` VALUES("239", "ultimate_updater", "enabled", "yes");
INSERT INTO `wp_options` VALUES("240", "ultimate_constants", "a:3:{s:24:\"ULTIMATE_NO_UPDATE_CHECK\";b:0;s:28:\"ULTIMATE_NO_EDIT_PAGE_NOTICE\";b:1;s:30:\"ULTIMATE_NO_PLUGIN_PAGE_NOTICE\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("241", "ultimate_modules", "a:42:{i:0;s:18:\"ultimate_animation\";i:1;s:16:\"ultimate_buttons\";i:2;s:18:\"ultimate_countdown\";i:3;s:17:\"ultimate_flip_box\";i:4;s:20:\"ultimate_google_maps\";i:5;s:22:\"ultimate_google_trends\";i:6;s:17:\"ultimate_headings\";i:7;s:22:\"ultimate_icon_timeline\";i:8;s:17:\"ultimate_info_box\";i:9;s:20:\"ultimate_info_circle\";i:10;s:18:\"ultimate_info_list\";i:11;s:20:\"ultimate_info_tables\";i:12;s:28:\"ultimate_interactive_banners\";i:13;s:29:\"ultimate_interactive_banner_2\";i:14;s:15:\"ultimate_modals\";i:15;s:17:\"ultimate_parallax\";i:16;s:23:\"ultimate_pricing_tables\";i:17;s:15:\"ultimate_spacer\";i:18;s:22:\"ultimate_stats_counter\";i:19;s:20:\"ultimate_swatch_book\";i:20;s:14:\"ultimate_icons\";i:21;s:18:\"ultimate_list_icon\";i:22;s:17:\"ultimate_carousel\";i:23;s:18:\"ultimate_fancytext\";i:24;s:22:\"ultimate_highlight_box\";i:25;s:20:\"ultimate_info_banner\";i:26;s:15:\"ultimate_ihover\";i:27;s:16:\"ultimate_hotspot\";i:28;s:21:\"ultimate_video_banner\";i:29;s:11:\"woocomposer\";i:30;s:20:\"ultimate_dual_button\";i:31;s:13:\"ultimate_link\";i:32;s:19:\"ultimate_fancy_text\";i:33;s:23:\"ultimate_hightlight_box\";i:34;s:20:\"ultimate_content_box\";i:35;s:24:\"ultimate_image_separator\";i:36;s:27:\"ultimate_expandable_section\";i:37;s:12:\"ultimate_tab\";i:38;s:23:\"ultimate_sticky_section\";i:39;s:13:\"ultimate_team\";i:40;s:21:\"ultimate_range_slider\";i:41;s:15:\"ultimate_videos\";}", "yes");
INSERT INTO `wp_options` VALUES("243", "smile_fonts", "a:1:{s:8:\"Defaults\";a:4:{s:7:\"include\";s:20:\"smile_fonts/Defaults\";s:6:\"folder\";s:20:\"smile_fonts/Defaults\";s:5:\"style\";s:21:\"Defaults/Defaults.css\";s:6:\"config\";s:11:\"charmap.php\";}}", "yes");
INSERT INTO `wp_options` VALUES("262", "wpestate_autocomplete_data", "", "yes");
INSERT INTO `wp_options` VALUES("263", "wpestate_autocomplete_data_select", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("264", "wp_estate_token_expire", "1547274881", "yes");
INSERT INTO `wp_options` VALUES("265", "wp_estate_curent_token", "", "yes");
INSERT INTO `wp_options` VALUES("268", "wp_ewwwio_media_optimize_batch_a", "", "no");
INSERT INTO `wp_options` VALUES("274", "wp_ewwwio_media_optimize_batch_b", "", "no");
INSERT INTO `wp_options` VALUES("320", "wp_estate_feature_list", "آشپزخانه اپن,\r\nاینترنت WIFI,\r\nمیز بیلیارد,\r\nتلویزیون,\r\nآیفون تصویری,\r\nآسانسور,\r\nشومینه,\r\nگرمایشی,\r\nسرمایشی,\r\nدرب ریموت دار,\r\nاستخر سرپوشیده,\r\nاستخر روباز,\r\nماشین رختشویی,\r\nجکوزی,\r\nخشک کن,\r\nسالن ورزش,\r\nپارکینگ,\r\nاینترنت داخلی,\r\nماهواره,\r\nتلویزیون کابلی,\r\nبالکن و تراس,\r\nتلفن,\r\nفضای باز,\r\nچیلر,\r\nکامپیوتر,\r\nفکس", "yes");
INSERT INTO `wp_options` VALUES("396", "_sh_used_nonces", "a:1:{s:10:\"95557948eb\";i:1547276540;}", "yes");
INSERT INTO `wp_options` VALUES("399", "taxonomy_33", "a:1:{s:10:\"cityparent\";s:10:\"ضثقلل\";}", "yes");
INSERT INTO `wp_options` VALUES("630", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("631", "revslider-latest-version", "5.4.8.1", "yes");
INSERT INTO `wp_options` VALUES("632", "revslider-stable-version", "4.2", "yes");
INSERT INTO `wp_options` VALUES("633", "revslider-notices", "a:1:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.4.8.1\";s:4:\"text\";s:241:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=5481\" target=\"_blank\"><img src=\"//updates.themepunch-ext-a.tools/banners/revsliderbanner_5481.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.8.1 is out\" ></a>\";s:4:\"code\";s:11:\"TPRS5481-03\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("634", "revslider-dashboard", "O:8:\"stdClass\":1:{s:11:\"test-handle\";O:8:\"stdClass\":5:{s:12:\"version_from\";s:5:\"5.0.0\";s:10:\"version_to\";s:5:\"5.0.0\";s:5:\"order\";i:5;s:7:\"content\";s:181:\"<div class=\"rs-dash-widget\"><div class=\"rs-dash-title-wrap\"><div class=\"rs-dash-title\">your version is: {{current_version}}</div></div><div class=\"rs-dash-widget-inner\"></div></div>\";s:4:\"code\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("635", "revslider-addons", "O:8:\"stdClass\":26:{s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:71:\"//updates.themepunch-ext-a.tools/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"1.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-a.tools/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch-ext-a.tools/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch-ext-a.tools/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch-ext-a.tools/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch-ext-a.tools/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"1.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch-ext-a.tools/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:23:\"Display images in 360°\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch-ext-a.tools/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch-ext-a.tools/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:63:\"//updates.themepunch-ext-a.tools/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch-ext-a.tools/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch-ext-a.tools/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}}", "yes");
INSERT INTO `wp_options` VALUES("663", "theme_mods_wprentals-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:31;s:6:\"mobile\";i:31;s:11:\"footer_menu\";i:30;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1544267604;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-4\";i:1;s:12:\"categories-3\";i:2;s:14:\"recent-posts-4\";i:3;s:17:\"recent-comments-3\";i:4;s:6:\"text-2\";i:5;s:6:\"text-1\";}s:19:\"primary-widget-area\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"secondary-widget-area\";a:0:{}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:24:\"top-bar-left-widget-area\";a:0:{}s:25:\"top-bar-right-widget-area\";a:2:{i:0;s:14:\"recent-posts-3\";i:1;s:8:\"search-3\";}s:22:\"owner-page-widget-area\";a:0:{}s:36:\"splash-page_bottom-right-widget-area\";a:0:{}s:35:\"splash-page_bottom-left-widget-area\";a:0:{}}}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("665", "ewww_image_optimizer_allow_tracking", "1", "yes");
INSERT INTO `wp_options` VALUES("666", "ewww_image_optimizer_tracking_site_id", "cbca858c4d672c2fb60fd61888b0e6cd", "yes");
INSERT INTO `wp_options` VALUES("667", "ewww_image_optimizer_tracking_last_send", "1546616294", "yes");
INSERT INTO `wp_options` VALUES("668", "ewww_image_optimizer_tracking_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("688", "wp_estate_show_top_bar_user_login", "yes", "yes");
INSERT INTO `wp_options` VALUES("689", "wp_estate_show_top_bar_user_menu", "no", "yes");
INSERT INTO `wp_options` VALUES("690", "wp_estate_show_adv_search_general", "yes", "yes");
INSERT INTO `wp_options` VALUES("691", "wp_estate_currency_symbol", "$", "yes");
INSERT INTO `wp_options` VALUES("692", "wp_estate_where_currency_symbol", "before", "yes");
INSERT INTO `wp_options` VALUES("693", "wp_estate_measure_sys", "ft", "yes");
INSERT INTO `wp_options` VALUES("694", "wp_estate_facebook_login", "no", "yes");
INSERT INTO `wp_options` VALUES("695", "wp_estate_google_login", "no", "yes");
INSERT INTO `wp_options` VALUES("696", "wp_estate_yahoo_login", "no", "yes");
INSERT INTO `wp_options` VALUES("697", "wp_estate_social_register_on", "no", "yes");
INSERT INTO `wp_options` VALUES("698", "wp_estate_wide_status", "1", "yes");
INSERT INTO `wp_options` VALUES("699", "wp_estate_header_type", "4", "yes");
INSERT INTO `wp_options` VALUES("700", "wp_estate_user_header_type", "0", "yes");
INSERT INTO `wp_options` VALUES("701", "wp_estate_prop_no", "12", "yes");
INSERT INTO `wp_options` VALUES("702", "wp_estate_show_empty_city", "no", "yes");
INSERT INTO `wp_options` VALUES("703", "wp_estate_blog_sidebar", "right", "yes");
INSERT INTO `wp_options` VALUES("704", "wp_estate_blog_sidebar_name", "primary-widget-area", "yes");
INSERT INTO `wp_options` VALUES("705", "wp_estate_general_latitude", "40.781711", "yes");
INSERT INTO `wp_options` VALUES("706", "wp_estate_general_longitude", "-73.955927", "yes");
INSERT INTO `wp_options` VALUES("707", "wp_estate_default_map_zoom", "15", "yes");
INSERT INTO `wp_options` VALUES("708", "wp_estate_cache", "no", "yes");
INSERT INTO `wp_options` VALUES("709", "wp_estate_ondemandmap", "no", "yes");
INSERT INTO `wp_options` VALUES("710", "wp_estate_show_adv_search_map_close", "yes", "yes");
INSERT INTO `wp_options` VALUES("711", "wp_estate_pin_cluster", "yes", "yes");
INSERT INTO `wp_options` VALUES("712", "wp_estate_zoom_cluster", "10", "yes");
INSERT INTO `wp_options` VALUES("713", "wp_estate_hq_latitude", "40.781711", "yes");
INSERT INTO `wp_options` VALUES("714", "wp_estate_hq_longitude", "-73.955927", "yes");
INSERT INTO `wp_options` VALUES("715", "wp_estate_geolocation_radius", "1000", "yes");
INSERT INTO `wp_options` VALUES("716", "wp_estate_min_height", "550", "yes");
INSERT INTO `wp_options` VALUES("717", "wp_estate_max_height", "650", "yes");
INSERT INTO `wp_options` VALUES("718", "wp_estate_keep_min", "no", "yes");
INSERT INTO `wp_options` VALUES("719", "wp_estate_paid_submission", "no", "yes");
INSERT INTO `wp_options` VALUES("720", "wp_estate_admin_submission", "yes", "yes");
INSERT INTO `wp_options` VALUES("721", "wp_estate_price_submission", "0", "yes");
INSERT INTO `wp_options` VALUES("722", "wp_estate_price_featured_submission", "0", "yes");
INSERT INTO `wp_options` VALUES("723", "wp_estate_submission_curency", "USD", "yes");
INSERT INTO `wp_options` VALUES("724", "wp_estate_paypal_api", "sandbox", "yes");
INSERT INTO `wp_options` VALUES("725", "wp_estate_free_mem_list", "0", "yes");
INSERT INTO `wp_options` VALUES("726", "wp_estate_free_feat_list", "0", "yes");
INSERT INTO `wp_options` VALUES("727", "show_adv_search_slider", "yes", "yes");
INSERT INTO `wp_options` VALUES("728", "wp_estate_delete_orphan", "no", "yes");
INSERT INTO `wp_options` VALUES("729", "wp_estate_custom_fields", "a:7:{i:0;a:4:{i:0;s:13:\"Check-in hour\";i:1;s:13:\"Check-in hour\";i:2;s:10:\"short text\";i:3;i:1;}i:1;a:4:{i:0;s:14:\"Check-Out hour\";i:1;s:14:\"Check-Out hour\";i:2;s:10:\"short text\";i:3;i:2;}i:2;a:4:{i:0;s:13:\"Late Check-in\";i:1;s:13:\"Late Check-in\";i:2;s:10:\"short text\";i:3;i:3;}i:3;a:4:{i:0;s:17:\"Optional services\";i:1;s:17:\"Optional services\";i:2;s:10:\"short text\";i:3;i:4;}i:4;a:4:{i:0;s:18:\"Outdoor facilities\";i:1;s:18:\"Outdoor facilities\";i:2;s:10:\"short text\";i:3;i:5;}i:5;a:4:{i:0;s:12:\"Extra People\";i:1;s:12:\"Extra People\";i:2;s:10:\"short text\";i:3;i:6;}i:6;a:4:{i:0;s:12:\"Cancellation\";i:1;s:12:\"Cancellation\";i:2;s:10:\"short text\";i:3;i:7;}}", "yes");
INSERT INTO `wp_options` VALUES("730", "wp_estate_custom_advanced_search", "no", "yes");
INSERT INTO `wp_options` VALUES("731", "wp_estate_adv_search_type", "1", "yes");
INSERT INTO `wp_options` VALUES("732", "wp_estate_show_adv_search", "yes", "yes");
INSERT INTO `wp_options` VALUES("733", "wp_estate_cron_run", "1543921666", "yes");
INSERT INTO `wp_options` VALUES("734", "wp_estate_show_no_features", "yes", "yes");
INSERT INTO `wp_options` VALUES("735", "wp_estate_property_features_text", "Property Features", "yes");
INSERT INTO `wp_options` VALUES("736", "wp_estate_property_description_text", "Property Description", "yes");
INSERT INTO `wp_options` VALUES("737", "wp_estate_property_details_text", "Property Details ", "yes");
INSERT INTO `wp_options` VALUES("738", "wp_estate_status_list", "verified", "yes");
INSERT INTO `wp_options` VALUES("739", "wp_estate_slider_cycle", "0", "yes");
INSERT INTO `wp_options` VALUES("740", "wp_estate_show_save_search", "no", "yes");
INSERT INTO `wp_options` VALUES("741", "wp_estate_search_alert", "1", "yes");
INSERT INTO `wp_options` VALUES("742", "wp_estate_color_scheme", "no", "yes");
INSERT INTO `wp_options` VALUES("743", "wp_estate_show_g_search", "no", "yes");
INSERT INTO `wp_options` VALUES("744", "wp_estate_show_adv_search_extended", "no", "yes");
INSERT INTO `wp_options` VALUES("745", "wp_estate_readsys", "no", "yes");
INSERT INTO `wp_options` VALUES("746", "wp_estate_ssl_map", "no", "yes");
INSERT INTO `wp_options` VALUES("747", "wp_estate_enable_stripe", "no", "yes");
INSERT INTO `wp_options` VALUES("748", "wp_estate_enable_paypal", "no", "yes");
INSERT INTO `wp_options` VALUES("749", "wp_estate_enable_direct_pay", "no", "yes");
INSERT INTO `wp_options` VALUES("750", "wp_estate_logo_margin", "27", "yes");
INSERT INTO `wp_options` VALUES("751", "wp_estate_free_feat_list_expiration", "0", "yes");
INSERT INTO `wp_options` VALUES("752", "wp_estate_transparent_menu", "no", "yes");
INSERT INTO `wp_options` VALUES("753", "wp_estate_transparent_menu_listing", "no", "yes");
INSERT INTO `wp_options` VALUES("754", "wp_estate_date_lang", "en-GB", "yes");
INSERT INTO `wp_options` VALUES("755", "wp_estate_show_slider_min_price", "0", "yes");
INSERT INTO `wp_options` VALUES("756", "wp_estate_show_slider_max_price", "2500", "yes");
INSERT INTO `wp_options` VALUES("757", "wp_estate_listing_unit_type", "2", "yes");
INSERT INTO `wp_options` VALUES("758", "wp_estate_listing_page_type", "1", "yes");
INSERT INTO `wp_options` VALUES("759", "wp_estate_listing_unit_style_half", "1", "yes");
INSERT INTO `wp_options` VALUES("760", "wp_estate_auto_curency", "no", "yes");
INSERT INTO `wp_options` VALUES("761", "wp_estate_prop_list_slider", "no", "yes");
INSERT INTO `wp_options` VALUES("762", "wp_estate_separate_users", "no", "yes");
INSERT INTO `wp_options` VALUES("763", "wp_estate_publish_only", "", "yes");
INSERT INTO `wp_options` VALUES("764", "wp_estate_show_submit", "yes", "yes");
INSERT INTO `wp_options` VALUES("765", "wp_estate_setup_weekend", "0", "yes");
INSERT INTO `wp_options` VALUES("766", "wp_estate_use_captcha_status", "no", "yes");
INSERT INTO `wp_options` VALUES("767", "wp_estate_enable_user_pass", "no", "yes");
INSERT INTO `wp_options` VALUES("768", "wp_estate_logo_header_type", "type1", "yes");
INSERT INTO `wp_options` VALUES("769", "wp_estate_logo_header_align", "left", "yes");
INSERT INTO `wp_options` VALUES("770", "wp_estate_wide_header", "no", "yes");
INSERT INTO `wp_options` VALUES("771", "wp_estate_logo_header_select", "type2", "yes");
INSERT INTO `wp_options` VALUES("772", "wp_estate_wide_footer", "no", "yes");
INSERT INTO `wp_options` VALUES("773", "wp_estate_map_max_pins", "30", "yes");
INSERT INTO `wp_options` VALUES("774", "wp_estate_guest_dropdown_no", "15", "yes");
INSERT INTO `wp_options` VALUES("775", "wp_estate_month_no_show", "12", "yes");
INSERT INTO `wp_options` VALUES("776", "wp_estate_subject_agent_update_profile", "به روز رسانی مشخصات", "yes");
INSERT INTO `wp_options` VALUES("777", "wp_estate_agent_update_profile", "یک کاربر نمایه خود را در٪ website_url تغییر داد. \\ n نام کاربری:٪ user_login", "yes");
INSERT INTO `wp_options` VALUES("778", "wp_estate_subject_new_user_id_verification", "تأیید شناسه کاربر جدید", "yes");
INSERT INTO `wp_options` VALUES("779", "wp_estate_new_user_id_verification", "یک کاربر تایید تصویر کاربر ID خود را در٪ website_url اضافه کرد. \\ n نام کاربری:٪ user_login. \\ n شما می توانید وضعیت تأیید را در اینجا بررسی کنید:٪ user_profile_url", "yes");
INSERT INTO `wp_options` VALUES("780", "wp_estate_subject_password_reset_request", "درخواست بازنشانی رمز عبور", "yes");
INSERT INTO `wp_options` VALUES("781", "wp_estate_password_reset_request", "کسی درخواست کرد که گذرواژه برای حساب زیر بازنشانی شود: \\ n٪ website_url \\ n نام کاربری:٪ forgot_username. \\ n اگر این اشتباه بود، فقط این ایمیل را نادیده بگیرید و هیچ اتفاقی نخواهد افتاد. برای بازنشانی گذرواژه، از آدرس زیر دیدن کنید:٪ reset_link، \\ n از شما سپاسگزارم!", "yes");
INSERT INTO `wp_options` VALUES("782", "wp_estate_subject_password_reseted", "گذرواژه شما بازنشانی شد", "yes");
INSERT INTO `wp_options` VALUES("783", "wp_estate_password_reseted", "Your new password for the account at: %website_url: \nUsername:%username, \nPassword:%user_pass\nYou can now login with your new password at: %website_url", "yes");
INSERT INTO `wp_options` VALUES("784", "wp_estate_subject_purchase_activated", "خرید شما فعال شد", "yes");
INSERT INTO `wp_options` VALUES("785", "wp_estate_purchase_activated", "سلام، \\ n خرید شما در٪ website_url فعال شده است! شما باید چک کنید.", "yes");
INSERT INTO `wp_options` VALUES("786", "wp_estate_subject_approved_listing", "آگهی شما تایید شد", "yes");
INSERT INTO `wp_options` VALUES("787", "wp_estate_approved_listing", "سلام، \\ آگهی شما٪ property_title در٪ website_url تایید شد! فهرست:٪ property_url. \\ n شما باید آن را چک کنید.", "yes");
INSERT INTO `wp_options` VALUES("788", "wp_estate_subject_admin_new_user", "ثبت نام کاربر جدید", "yes");
INSERT INTO `wp_options` VALUES("789", "wp_estate_admin_new_user", "ثبت نام کاربر جدید در٪ site_url. \\ n نام کاربری:٪ user_login_register، \\ nEmail:٪ user_email_register", "yes");
INSERT INTO `wp_options` VALUES("790", "wp_estate_subject_new_user", "نام کاربری و رمز عبور شما در٪ website_url", "yes");
INSERT INTO `wp_options` VALUES("791", "wp_estate_new_user", "سلام، \\ n خوش آمدید به٪ web_url! شما می توانید با استفاده از اعتبارات زیر وارد شوید: \\ n نام کاربری:٪ user_login_register \\ nPassword:٪ user_pass_register \\ n اگر مشکلی دارید، لطفا با من تماس بگیرید. \\ n از شما سپاسگزارم!", "yes");
INSERT INTO `wp_options` VALUES("792", "wp_estate_subject_admin_expired_listing", "آگهی منقضی شده برای تأیید در٪ site_url ارسال شده است", "yes");
INSERT INTO `wp_options` VALUES("793", "wp_estate_admin_expired_listing", "سلام، \\ n کاربر یک اموال جدید را در٪ site_url قرار داده است! شما باید آن را چک کنید. \\ n این عنوان املاک است:٪ submit_title.", "yes");
INSERT INTO `wp_options` VALUES("794", "wp_estate_subject_paid_submissions", "پرداخت جدید پرداخت در٪ website_url", "yes");
INSERT INTO `wp_options` VALUES("795", "wp_estate_paid_submissions", "سلام، \\ n شما یک پیشنهاد جدید پرداخت شده در٪ website_url دارید! شما باید چک کنید.", "yes");
INSERT INTO `wp_options` VALUES("796", "wp_estate_subject_featured_submission", "ویژگی جدید در٪ website_url ارتقا دهید", "yes");
INSERT INTO `wp_options` VALUES("797", "wp_estate_featured_submission", "سلام، \\ n شما یک پیشنهاد جدید در٪ website_url دارید! شما باید چک کنید.", "yes");
INSERT INTO `wp_options` VALUES("798", "wp_estate_subject_account_downgraded", "حساب کاربری در٪ site_url کاهش یافته است", "yes");
INSERT INTO `wp_options` VALUES("799", "wp_estate_account_downgraded", "سلام، \\ n شما اشتراک خود را در٪ website_url کاهش دادید. از آنجا که تعداد آگهی های شما بیشتر از آنچه که بسته های واقعی ارائه می دهد، ما وضعیت تمام آگهی های شما را به پایان می رسانیم. شما باید آگهیی را که میخواهید به صورت زنده انتخاب کنید انتخاب کنید و دوباره آنها را برای تأیید ارسال کنید. \\ n از شما سپاسگزارم!", "yes");
INSERT INTO `wp_options` VALUES("800", "wp_estate_subject_membership_cancelled", "عضویت در٪ site_url لغو شد", "yes");
INSERT INTO `wp_options` VALUES("801", "wp_estate_membership_cancelled", "سلام، \\ n اشتراک شما در٪ website_url لغو شده بود زیرا آن زمان منقضی شده بود یا پرداخت تکراری از بازرگان پردازش نشد. همه آگهیهای شما دیگر برای بازدیدکنندگان ما قابل مشاهده نیستند اما در حساب شما باقی میمانند. \\ n از شما سپاسگزارم.", "yes");
INSERT INTO `wp_options` VALUES("802", "wp_estate_subject_membership_activated", "عضویت فعال در٪ website_url", "yes");
INSERT INTO `wp_options` VALUES("803", "wp_estate_membership_activated", "سلام، \\ n عضویت جدید شما در٪ website_url فعال شده است! شما باید چک کنید.", "yes");
INSERT INTO `wp_options` VALUES("804", "wp_estate_subject_free_listing_expired", "آگهی رایگان در٪ site_url منقضی شده است", "yes");
INSERT INTO `wp_options` VALUES("805", "wp_estate_free_listing_expired", "سلام، \\ n یکی از آگهیهای رایگان شما در٪ website_url منقضی شده است. فهرست٪ expired_listing_url است. \\ n از شما سپاسگزارم", "yes");
INSERT INTO `wp_options` VALUES("806", "wp_estate_subject_new_listing_submission", "ارسال مقاله جدید در٪ website_url", "yes");
INSERT INTO `wp_options` VALUES("807", "wp_estate_new_listing_submission", "سلام، \\ n کاربر یک property جدید را در٪ website_url قرار داده است! شما باید آن را چک کنید. این عنوان property new_listing_title است!", "yes");
INSERT INTO `wp_options` VALUES("808", "wp_estate_subject_listing_edit", "آگهی ویرایش شده در٪ website_url", "yes");
INSERT INTO `wp_options` VALUES("809", "wp_estate_listing_edit", "سلام، \\ n کاربر کاربر یکی از آگهی هایش را در٪ website_url ویرایش کرده است! شما باید چک کنید. نام املاک است:٪ editing_listing_title!", "yes");
INSERT INTO `wp_options` VALUES("810", "wp_estate_subject_recurring_payment", "پرداخت مجدد در٪ website_url", "yes");
INSERT INTO `wp_options` VALUES("811", "wp_estate_recurring_payment", "سلام، \\ n ما حساب شما را در٪ توزیع کننده برای اشتراک در٪ website_url اخطار دادیم! شما باید چک کنید.", "yes");
INSERT INTO `wp_options` VALUES("812", "wp_estate_subject_bookingconfirmeduser", "رزرو در٪ website_url تایید شده است", "yes");
INSERT INTO `wp_options` VALUES("813", "wp_estate_bookingconfirmeduser", "سلام، \\ n رزرو شما در٪ website_url تایید شد! شما می توانید تمام رزرو های خود را با ورود به حساب کاربری خود و بازدید از صفحه رزرو من مشاهده کنید.", "yes");
INSERT INTO `wp_options` VALUES("814", "wp_estate_subject_bookingconfirmed", "رزرو در٪ website_url تایید شده است", "yes");
INSERT INTO `wp_options` VALUES("815", "wp_estate_bookingconfirmed", "سلام، \\ n یک شخص یک رزرو را در٪ website_url تایید کرد! شما باید بروید و آن را چک کنید! لطفا به یاد داشته باشید که تایید بر اساس تایید پرداخت هزینه غیرقابل برگشت از کل هزینه صورتحساب، پردازش شده از طریق٪ web_url و ارسال به مدیر وب سایت است. ", "yes");
INSERT INTO `wp_options` VALUES("816", "wp_estate_subject_bookingconfirmed_nodeposit", "رزرو در٪ website_url تایید شده است", "yes");
INSERT INTO `wp_options` VALUES("817", "wp_estate_bookingconfirmed_nodeposit", "سلام، \\ n شما یک رزرو را در٪ website_url تایید کردید! رزرو بدون سپرده تایید شد!", "yes");
INSERT INTO `wp_options` VALUES("818", "wp_estate_subject_inbox", "پیام جدید در٪ website_url.", "yes");
INSERT INTO `wp_options` VALUES("819", "wp_estate_inbox", "سلام، \\ n شما یک پیام جدید در٪ website_url دارید! شما باید بروید و آن را چک کنید! \\ n پیام این است: \\ n٪ محتوای", "yes");
INSERT INTO `wp_options` VALUES("820", "wp_estate_subject_newbook", "درخواست رزرو جدید در٪ website_url.", "yes");
INSERT INTO `wp_options` VALUES("821", "wp_estate_newbook", "سلام، \\ n شما یک درخواست رزرو جدید در٪ website_url دریافت کرده اید! برو به حساب خود در صفحه Bookings برای دیدن درخواست، صدور فاکتور یا رد آن! \\ n اموال:٪ booking_property_link", "yes");
INSERT INTO `wp_options` VALUES("822", "wp_estate_subject_mynewbook", "یک دوره را در٪ site_url رزرو کردید.", "yes");
INSERT INTO `wp_options` VALUES("823", "wp_estate_mynewbook", "سلام، \\ n شما دوره ای را برای آگهی خود در٪ website_url رزرو کرده اید! رزرو در حساب کاربری شما، تحت My Bookings نمایش داده خواهد شد. \\ n اموال است:٪ booking_property_link", "yes");
INSERT INTO `wp_options` VALUES("824", "wp_estate_subject_newinvoice", "فاکتور جدید در٪ website_url.", "yes");
INSERT INTO `wp_options` VALUES("825", "wp_estate_newinvoice", "سلام، \\ n برای درخواست رزرو شما در٪ website_url صورت حساب تهیه شد! برای تأیید رزرو، سپرده لازم است. برای اطلاعات بیشتر، حساب خود را چک کنید، صفحه رزرو من.", "yes");
INSERT INTO `wp_options` VALUES("826", "wp_estate_subject_deletebooking", "درخواست رزرو در٪ site_url رد شد", "yes");
INSERT INTO `wp_options` VALUES("827", "wp_estate_deletebooking", "سلام، \\ n یکی از درخواست های رزرو شما ارسال شده در٪ website_url توسط مالک رد شد. رزرو رد شده به طور خودکار از حساب شما حذف می شود. ", "yes");
INSERT INTO `wp_options` VALUES("828", "wp_estate_subject_deletebookinguser", "درخواست رزرو لغو شده در٪ website_url", "yes");
INSERT INTO `wp_options` VALUES("829", "wp_estate_deletebookinguser", "سلام، \\ n یکی از درخواستهای تأیید نشده تأیید شده در٪ website_url لغو شد! درخواست به طور خودکار از حساب شما حذف می شود!", "yes");
INSERT INTO `wp_options` VALUES("830", "wp_estate_subject_deletebookingconfirmed", "مدت زمان رزرو در٪ website_url لغو شد.", "yes");
INSERT INTO `wp_options` VALUES("831", "wp_estate_deletebookingconfirmed", "سلام، \\ n یکی از رزروهای تایید شده شما در٪ website_url توسط صاحب ملک لغو شده است. ", "yes");
INSERT INTO `wp_options` VALUES("832", "wp_estate_subject_new_wire_transfer", "شما دستور Wire Transfer جدید را سفارش دادید", "yes");
INSERT INTO `wp_options` VALUES("833", "wp_estate_new_wire_transfer", "ما دریافت درخواست انتقال پرداخت Wire در٪ website_url! \\ n لطفا دستورالعمل های زیر را دنبال کنید تا شروع به ارسال خواص در اسرع وقت. \\ n شماره صورتحساب:٪ invoice_no، مقدار:٪ total_price. \\ n دستورالعمل:٪ payment_details.", "yes");
INSERT INTO `wp_options` VALUES("834", "wp_estate_subject_admin_new_wire_transfer", "کسی دستور داد یک انتقال Wire جدید", "yes");
INSERT INTO `wp_options` VALUES("835", "wp_estate_admin_new_wire_transfer", "سلام، \\ n شما درخواست پرداخت جدید انتقال Wire را در٪ website_url دریافت کرده اید. \\ n شماره صورتحساب:٪ invoice_no، مقدار:٪ total_price. \\ n لطفا صبر کنید تا پرداخت انجام شود تا خرید کاربر فعال شود.", "yes");
INSERT INTO `wp_options` VALUES("836", "wp_estate_subject_full_invoice_reminder", "یادآوری پرداخت صورتحساب", "yes");
INSERT INTO `wp_options` VALUES("837", "wp_estate_full_invoice_reminder", "سلام، \\ ما به شما یادآوری میکنیم که باید تا تاریخ٪ till_date فاکتور بدون٪ invoice_id را کاملا پرداخت کنید. این فاکتور برای رزرو٪٪ booking_id در property٪ property_title با url٪ property_url است. \\ n از شما سپاسگزارم.", "yes");
INSERT INTO `wp_options` VALUES("853", "revslider-valid-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("855", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("856", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("857", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("858", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("859", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("860", "wp_page_for_privacy_policy", "0", "yes");
INSERT INTO `wp_options` VALUES("861", "show_comments_cookies_opt_in", "", "yes");
INSERT INTO `wp_options` VALUES("862", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("872", "theme_mods_wprentals-child-po", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:31;s:6:\"mobile\";i:31;s:11:\"footer_menu\";i:30;}s:18:\"custom_css_post_id\";i:1998;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1544624147;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:15:{i:0;s:23:\"wpestate_tweet_widget-2\";i:1;s:23:\"wpestate_tweet_widget-3\";i:2;s:25:\"wpestate_contact_widget-2\";i:3;s:24:\"wpestate_social_widget-2\";i:4;s:24:\"wpestate_social_widget-3\";i:5;s:33:\"wpestate_advanced_search_widget-2\";i:6;s:33:\"wpestate_advanced_search_widget-3\";i:7;s:33:\"wpestate_advanced_search_widget-4\";i:8;s:35:\"wpestate_multiple_currency_widget-2\";i:9;s:35:\"wpestate_multiple_currency_widget-3\";i:10;s:8:\"search-4\";i:11;s:12:\"categories-3\";i:12;s:14:\"recent-posts-4\";i:13;s:17:\"recent-comments-3\";i:14;s:6:\"text-1\";}s:19:\"primary-widget-area\";a:3:{i:0;s:23:\"wpestate_login_widget-2\";i:1;s:33:\"wpestate_advanced_search_widget-5\";i:2;s:31:\"wpestate_footer_latest_widget-2\";}s:21:\"secondary-widget-area\";a:0:{}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:24:\"top-bar-left-widget-area\";a:1:{i:0;s:6:\"text-2\";}s:25:\"top-bar-right-widget-area\";a:0:{}s:22:\"owner-page-widget-area\";a:0:{}s:36:\"splash-page_bottom-right-widget-area\";a:0:{}s:35:\"splash-page_bottom-left-widget-area\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("928", "paypal_transfer", "a:1:{i:2;a:8:{s:14:\"paypal_execute\";N;s:12:\"paypal_token\";N;s:10:\"listing_id\";i:2581;s:10:\"is_booking\";i:1;s:10:\"invoice_id\";i:2909;s:10:\"booking_id\";i:2908;s:11:\"is_featured\";i:0;s:10:\"is_upgrade\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("1019", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("1033", "recently_activated", "a:1:{s:47:\"file-manager-advanced/file_manager_advanced.php\";i:1547271661;}", "yes");
INSERT INTO `wp_options` VALUES("1035", "ewww_image_optimizer_relative_migration_status", "done", "yes");
INSERT INTO `wp_options` VALUES("1043", "ewww_image_optimizer_metadata_remove", "1", "no");
INSERT INTO `wp_options` VALUES("1044", "exactdn_lossy", "1", "no");
INSERT INTO `wp_options` VALUES("1045", "exactdn_all_the_things", "1", "no");
INSERT INTO `wp_options` VALUES("1091", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1150", "taxonomy_8", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:89:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/08/9-300x187.jpg\";s:18:\"category_attach_id\";s:4:\"1901\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:17:\"property_category\";}", "yes");
INSERT INTO `wp_options` VALUES("1156", "taxonomy_27", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:103:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/demo511-400x314-300x236.jpg\";s:18:\"category_attach_id\";s:4:\"1974\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:17:\"property_category\";}", "yes");
INSERT INTO `wp_options` VALUES("1162", "taxonomy_14", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:90:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/08/10-300x188.jpg\";s:18:\"category_attach_id\";s:4:\"1902\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:17:\"property_category\";}", "yes");
INSERT INTO `wp_options` VALUES("1165", "taxonomy_15", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:89:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/08/8-300x222.jpg\";s:18:\"category_attach_id\";s:4:\"1899\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:17:\"property_category\";}", "yes");
INSERT INTO `wp_options` VALUES("1167", "taxonomy_20", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:97:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/holiday3-300x200.jpeg\";s:18:\"category_attach_id\";s:4:\"1908\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:17:\"property_category\";}", "yes");
INSERT INTO `wp_options` VALUES("1171", "taxonomy_10", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:89:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/08/5-300x200.jpg\";s:18:\"category_attach_id\";s:4:\"1897\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:17:\"property_category\";}", "yes");
INSERT INTO `wp_options` VALUES("1175", "taxonomy_34", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:99:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/holiday2-5-300x200.jpeg\";s:18:\"category_attach_id\";s:4:\"1907\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:17:\"property_category\";}", "yes");
INSERT INTO `wp_options` VALUES("1184", "taxonomy_11", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:142:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/screenshot-santorini.wprentals.org-2018.12.01-14-33-53-220x300.png\";s:18:\"category_attach_id\";s:4:\"1988\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_city\";}", "yes");
INSERT INTO `wp_options` VALUES("1186", "taxonomy_28", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:144:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/screenshot-santorini.wprentals.org-2018.12.01-14-31-02-1-220x300.png\";s:18:\"category_attach_id\";s:4:\"1989\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_city\";}", "yes");
INSERT INTO `wp_options` VALUES("1188", "taxonomy_23", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:144:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/screenshot-santorini.wprentals.org-2018.12.01-14-32-32-1-220x300.png\";s:18:\"category_attach_id\";s:4:\"1990\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_city\";}", "yes");
INSERT INTO `wp_options` VALUES("1190", "taxonomy_32", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:144:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/screenshot-santorini.wprentals.org-2018.12.01-14-31-57-1-220x300.png\";s:18:\"category_attach_id\";s:4:\"1993\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_city\";}", "yes");
INSERT INTO `wp_options` VALUES("1201", "taxonomy_12", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:142:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2015/04/screenshot-santorini.wprentals.org-2018.12.01-14-33-53-220x300.png\";s:18:\"category_attach_id\";s:4:\"1988\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_city\";}", "yes");
INSERT INTO `wp_options` VALUES("1468", "theme_mods_twentyseventeen", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:3:\"top\";i:31;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1544267609;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-4\";i:1;s:12:\"categories-3\";i:2;s:14:\"recent-posts-4\";i:3;s:17:\"recent-comments-3\";i:4;s:6:\"text-2\";i:5;s:6:\"text-1\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:2:{i:0;s:14:\"recent-posts-3\";i:1;s:8:\"search-3\";}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("1529", "wpp_settings", "a:17:{s:10:\"admin_lang\";s:6:\"enable\";s:9:\"user_lang\";s:6:\"enable\";s:12:\"submenu_move\";s:7:\"disable\";s:12:\"persian_date\";s:6:\"enable\";s:16:\"droidsans_editor\";s:7:\"disable\";s:15:\"droidsans_admin\";s:7:\"disable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:6:\"enable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:7:\"disable\";}", "yes");
INSERT INTO `wp_options` VALUES("1530", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1531", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1565", "ztjalali_options", "{\"force_timezone\":false,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":true,\"change_url_date_to_jalali\":true,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":true,\"change_content_number_to_persian\":true,\"change_excerpt_number_to_persian\":true,\"change_comment_number_to_persian\":true,\"change_commentcount_number_to_persian\":false,\"change_category_number_to_persian\":false,\"change_point_to_persian\":true,\"change_arabic_to_persian\":true,\"change_archive_title\":true,\"save_changes_in_db\":true,\"ztjalali_admin_style\":false,\"persian_planet\":true}", "yes");
INSERT INTO `wp_options` VALUES("1566", "ztjalali_version", "5.0.1", "yes");
INSERT INTO `wp_options` VALUES("1568", "widget_ztjalali_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1569", "widget_ztjalali_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1597", "wpjqp_datepicker", "", "yes");
INSERT INTO `wp_options` VALUES("1827", "rs_cache_overlay", "5.4.8", "yes");
INSERT INTO `wp_options` VALUES("1917", "ztjalali_do_activation", "1", "yes");
INSERT INTO `wp_options` VALUES("2132", "wpfa_nums", "on", "yes");
INSERT INTO `wp_options` VALUES("2249", "wpp_adminpanel_font_main", "Vazir", "yes");
INSERT INTO `wp_options` VALUES("2250", "wpp_adminpanel_font_h", "Vazir", "yes");
INSERT INTO `wp_options` VALUES("2251", "wpp_adminpanel_font_nav", "Vazir", "yes");
INSERT INTO `wp_options` VALUES("2252", "wpp_adminpanel_datepicker", "1", "yes");
INSERT INTO `wp_options` VALUES("3549", "taxonomy_35", "a:1:{s:10:\"cityparent\";s:14:\"کلاردشت\";}", "yes");
INSERT INTO `wp_options` VALUES("3550", "favorites2", "a:2:{i:0;i:137;i:1;i:101;}", "yes");
INSERT INTO `wp_options` VALUES("3751", "duplicator_settings", "a:12:{s:7:\"version\";s:5:\"1.3.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"active_package_id\";i:7;}", "yes");
INSERT INTO `wp_options` VALUES("3752", "duplicator_version_plugin", "1.3.2", "yes");
INSERT INTO `wp_options` VALUES("3753", "duplicator_ui_view_state", "a:2:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("3754", "duplicator_package_active", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-01-12 06:35:22\";s:7:\"Version\";s:5:\"1.3.2\";s:9:\"VersionWP\";s:5:\"5.0.3\";s:9:\"VersionDB\";s:6:\"5.6.41\";s:10:\"VersionPHP\";s:6:\"7.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20181211_wprentals\";s:4:\"Hash\";s:35:\"ae2c1f64c1a1f63a3242_20190112063522\";s:8:\"NameHash\";s:54:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:87:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/tmp\";s:8:\"StoreURL\";s:62:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/\";s:8:\"ScanFile\";s:64:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":20:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:1;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:70:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-01-12 06:35:22\";s:7:\"Version\";s:5:\"1.3.2\";s:9:\"VersionWP\";s:5:\"5.0.3\";s:9:\"VersionDB\";s:6:\"5.6.41\";s:10:\"VersionPHP\";s:6:\"7.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20181211_wprentals\";s:4:\"Hash\";s:35:\"ae2c1f64c1a1f63a3242_20190112063522\";s:8:\"NameHash\";s:54:\"20181211_wprentals_ae2c1f64c1a1f63a3242_20190112063522\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:87:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/tmp\";s:8:\"StoreURL\";s:62:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:62;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:62;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:62;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:79:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-admin\";i:1;s:89:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads\";i:2;s:91:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/languages\";i:3;s:88:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content/themes\";i:4;s:82:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:70:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2\";i:1;s:81:\"/home/realthemes/public_html/jobifa.com/demo/wprentals-pack/wprentals2/wp-content\";}}s:9:\"Installer\";r:85;s:8:\"Database\";r:97;s:13:\"BuildProgress\";r:111;}", "yes");
INSERT INTO `wp_options` VALUES("3813", "can_compress_scripts", "0", "no");
INSERT INTO `wp_options` VALUES("4223", "ccj__activation_time", "1544557371", "yes");
INSERT INTO `wp_options` VALUES("4224", "ccj__version", "3.22", "yes");
INSERT INTO `wp_options` VALUES("4371", "brainstrom_bundled_products", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4675", "taxonomy_37", "a:1:{s:10:\"cityparent\";s:6:\"Tehran\";}", "yes");
INSERT INTO `wp_options` VALUES("4742", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4743", "property_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4745", "property_city_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4750", "taxonomy_82", "a:1:{s:10:\"cityparent\";s:10:\"تهران\";}", "yes");
INSERT INTO `wp_options` VALUES("4792", "paypal_pack_transfer", "a:1:{i:1;a:3:{s:14:\"paypal_execute\";N;s:12:\"paypal_token\";N;s:7:\"pack_id\";i:613;}}", "yes");
INSERT INTO `wp_options` VALUES("5049", "loco_settings", "a:3:{s:1:\"c\";s:18:\"Loco_data_Settings\";s:1:\"v\";i:0;s:1:\"d\";a:12:{s:7:\"version\";s:5:\"2.2.0\";s:8:\"gen_hash\";b:1;s:9:\"use_fuzzy\";b:1;s:11:\"num_backups\";i:1;s:9:\"pot_alias\";a:3:{i:0;s:10:\"default.po\";i:1;s:8:\"en_US.po\";i:2;s:5:\"en.po\";}s:9:\"php_alias\";a:2:{i:0;s:3:\"php\";i:1;s:4:\"twig\";}s:9:\"jsx_alias\";a:0:{}s:10:\"fs_persist\";b:0;s:10:\"fs_protect\";i:1;s:12:\"max_php_size\";s:4:\"100K\";s:11:\"po_utf8_bom\";b:0;s:8:\"po_width\";s:2:\"79\";}}", "yes");
INSERT INTO `wp_options` VALUES("5097", "loco_recent", "a:3:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:3:{s:24:\"theme.wprentals-child-po\";i:1544737424;s:40:\"plugin.wprentals-core/wprentals-core.php\";i:1547271501;s:15:\"theme.wprentals\";i:1547274059;}}}", "no");
INSERT INTO `wp_options` VALUES("5406", "taxonomy_83", "a:1:{s:10:\"cityparent\";s:6:\"Tehran\";}", "yes");
INSERT INTO `wp_options` VALUES("5452", "ewww_image_optimizer_backup_files", "", "no");
INSERT INTO `wp_options` VALUES("5483", "taxonomy_84", "a:1:{s:10:\"cityparent\";s:21:\"فریدون کنار\";}", "yes");
INSERT INTO `wp_options` VALUES("5501", "taxonomy_85", "a:1:{s:10:\"cityparent\";s:21:\"فریدون کنار\";}", "yes");
INSERT INTO `wp_options` VALUES("5915", "taxonomy_86", "a:1:{s:10:\"cityparent\";s:10:\"تهران\";}", "yes");
INSERT INTO `wp_options` VALUES("5976", "custom-css-js-tree", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("6156", "taxonomy_87", "a:6:{s:10:\"cityparent\";s:16:\"سلمانشهر\";s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:105:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/12/demo442-600x456-1-300x228.jpg\";s:18:\"category_attach_id\";s:4:\"2818\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_area\";}", "yes");
INSERT INTO `wp_options` VALUES("6173", "taxonomy_88", "a:1:{s:10:\"cityparent\";s:10:\"تهران\";}", "yes");
INSERT INTO `wp_options` VALUES("6213", "taxonomy_89", "a:1:{s:10:\"cityparent\";s:10:\"رامسر\";}", "yes");
INSERT INTO `wp_options` VALUES("6408", "taxonomy_90", "a:1:{s:10:\"cityparent\";s:5:\"Masal\";}", "yes");
INSERT INTO `wp_options` VALUES("6571", "taxonomy_91", "a:1:{s:10:\"cityparent\";s:10:\"تهران\";}", "yes");
INSERT INTO `wp_options` VALUES("6587", "taxonomy_92", "a:1:{s:10:\"cityparent\";s:10:\"رامسر\";}", "yes");
INSERT INTO `wp_options` VALUES("6651", "taxonomy_93", "a:1:{s:10:\"cityparent\";s:12:\"بابلسر\";}", "yes");
INSERT INTO `wp_options` VALUES("8602", "taxonomy_94", "a:1:{s:10:\"cityparent\";s:12:\"بابلسر\";}", "yes");
INSERT INTO `wp_options` VALUES("8621", "taxonomy_95", "a:1:{s:10:\"cityparent\";s:10:\"تهران\";}", "yes");
INSERT INTO `wp_options` VALUES("8639", "taxonomy_96", "a:1:{s:10:\"cityparent\";s:6:\"Tehran\";}", "yes");
INSERT INTO `wp_options` VALUES("8657", "taxonomy_97", "a:1:{s:10:\"cityparent\";s:21:\"فریدون کنار\";}", "yes");
INSERT INTO `wp_options` VALUES("8675", "taxonomy_98", "a:1:{s:10:\"cityparent\";s:21:\"فریدون کنار\";}", "yes");
INSERT INTO `wp_options` VALUES("9967", "taxonomy_99", "a:1:{s:10:\"cityparent\";s:13:\"Bandar Anzali\";}", "yes");
INSERT INTO `wp_options` VALUES("11418", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("11419", "rs-templates", "a:2:{s:6:\"slider\";a:233:{i:0;a:20:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:20:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:20:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:20:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:439:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:20:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:20:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:20:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:20:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:20:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:20:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:20:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:440:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:20:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:20:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:20:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:20:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:20:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:20:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:20:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:447:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:20:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:20:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:20:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:20:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:20:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:20:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:20:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:346:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:20:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:20:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:20:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:20:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:436:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:20:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:20:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:20:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:20:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:20:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:20:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:20:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:630:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:20:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:20:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:20:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:20:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:518:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:20:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:20:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:20:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:323:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:20:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:316:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:20:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:20:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:443:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:20:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:20:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:20:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:20:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:20:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:20:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:691:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:20:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:693:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:20:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:532:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:20:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:543:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:20:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:661:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:20:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:20:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:20:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:20:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:20:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:20:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:20:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:20:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:441:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:20:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:447:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:20:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:572:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/revslider-doc/add-on-whiteboard/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:20:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:516:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:23:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:23:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:23:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:23:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:23:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:448:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:23:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:23:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:23:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:23:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:23:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:23:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:23:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:23:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:23:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:23:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:23:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:20:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:20:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:20:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:20:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:23:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:23:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:23:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:23:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:23:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:23:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:23:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:23:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:20:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:20:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:23:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:23:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:23:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:23:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:23:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:20:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:20:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:20:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:303:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:23:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:913:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:23:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:23:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:23:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:20:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:426:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/revslider-doc/add-on-typewriter/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:20:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:23:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:23:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:23:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:23:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:23:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:23:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:23:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:23:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:23:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:23:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:23:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:23:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:23:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:23:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:23:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:23:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:23:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:23:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:23:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:23:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:568:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:20:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:343:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:20:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:341:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:20:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:23:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:20:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:164:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:20:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:468:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:20:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:20:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:463:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:20:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:421:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:20:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:190:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:20:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:20:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:190:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:20:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:20:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/filmstrip-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:191:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:145;a:20:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/space-opera-presentation/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:20:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/website-intro-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:20:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/minimal-mask-showcase/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:20:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:20:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:150;a:20:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:151;a:23:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:152;a:23:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:153;a:23:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:154;a:23:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:155;a:23:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:156;a:23:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:157;a:23:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:158;a:23:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:159;a:23:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:160;a:23:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:161;a:23:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:162;a:23:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:163;a:23:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:164;a:23:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:165;a:23:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:166;a:20:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:358:\"<span class=\"ttm_content\">How to install <a href=\"https://revolution.themepunch.com/direct-customer-benefits/#addoninstall\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:167;a:20:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:20:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/overexposure-transition-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:358:\"<span class=\"ttm_content\">How to install <a href=\"https://revolution.themepunch.com/direct-customer-benefits/#addoninstall\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:20:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/parallax-scroll/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:170;a:23:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:171;a:23:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:172;a:23:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:173;a:23:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:174;a:23:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:175;a:23:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:176;a:23:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:177;a:23:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:178;a:23:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:179;a:20:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:20:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:176:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:20:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:372:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:20:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:359:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:201;a:20:{s:2:\"id\";s:3:\"210\";s:5:\"title\";s:21:\"Cryptocurrency Prices\";s:5:\"alias\";s:12:\"cryptoslider\";s:3:\"zip\";s:16:\"cryptoslider.zip\";s:3:\"uid\";s:32:\"c4b02210387f11946223977e940d9e9e\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";s:7:\"preview\";s:95:\"https://revolution.themepunch.com/cryptocurrency-wordpress-price-api-bitcoin-ethereum-litecoin/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:209:\"<span class=\"ttm_content\">This Template can show live, animated cryptocurrency prices. More than 1300 currencies are supported, getting prices via the cryptocompare API.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:436:\"<span class=\"ttm_content\">Please refer to the \"Custom JavaScript\" section of this sliders settings, for info on how to modify currencies. Provide a class to the row / column / group where the currency text elements are located in.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:202;a:23:{s:2:\"id\";s:3:\"211\";s:5:\"title\";s:18:\"Immersion One Page\";s:5:\"alias\";s:26:\"immersion-one-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"immersion-one-page-package\";s:3:\"img\";s:31:\"packages/immersion_overview.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:351:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"},{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:203;a:23:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:23:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:23:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:23:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:23:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:23:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:20:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:343:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:210;a:23:{s:2:\"id\";s:3:\"219\";s:5:\"title\";s:19:\"Clear View Magazine\";s:5:\"alias\";s:27:\"clear-view-magazine-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"clear-view-magazine-package\";s:3:\"img\";s:41:\"packages/clear_view_magazine_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:211;a:23:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:212;a:23:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:213;a:23:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:214;a:23:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:215;a:23:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:216;a:23:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:217;a:23:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:218;a:23:{s:2:\"id\";s:3:\"227\";s:5:\"title\";s:20:\"Clear View Post Page\";s:5:\"alias\";s:28:\"clear-view-post-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"clear-view-post-page-package\";s:3:\"img\";s:42:\"packages/clear_view_post_page_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:219;a:23:{s:2:\"id\";s:3:\"228\";s:5:\"title\";s:22:\"Clear View Single Menu\";s:5:\"alias\";s:22:\"clear-view-single-menu\";s:3:\"zip\";s:32:\"packs/clear-view-single-menu.zip\";s:3:\"uid\";s:32:\"1e80f81982f8a4ea763482d4fa99d321\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:220;a:23:{s:2:\"id\";s:3:\"229\";s:5:\"title\";s:24:\"Clear View Single Header\";s:5:\"alias\";s:24:\"clear-view-single-header\";s:3:\"zip\";s:34:\"packs/clear-view-single-header.zip\";s:3:\"uid\";s:32:\"c8d717627be6cd5e70922ab609694dbf\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:221;a:23:{s:2:\"id\";s:3:\"230\";s:5:\"title\";s:23:\"Clear View Single Media\";s:5:\"alias\";s:23:\"clear-view-single-media\";s:3:\"zip\";s:33:\"packs/clear-view-single-media.zip\";s:3:\"uid\";s:32:\"c480368ded2a64f0cdd44f1674213814\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:222;a:23:{s:2:\"id\";s:3:\"231\";s:5:\"title\";s:22:\"Clear View Single More\";s:5:\"alias\";s:22:\"clear-view-single-more\";s:3:\"zip\";s:32:\"packs/clear-view-single-more.zip\";s:3:\"uid\";s:32:\"9c693190df26218366d1f77e10cf550a\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:223;a:23:{s:2:\"id\";s:3:\"232\";s:5:\"title\";s:25:\"Clear View Single Contact\";s:5:\"alias\";s:25:\"clear-view-single-contact\";s:3:\"zip\";s:35:\"packs/clear-view-single-contact.zip\";s:3:\"uid\";s:32:\"73c0a889f2b654a87b5aba1ff76fbc5c\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:224;a:20:{s:2:\"id\";s:3:\"233\";s:5:\"title\";s:18:\"Clean Landing Page\";s:5:\"alias\";s:16:\"cleanlandingpage\";s:3:\"zip\";s:20:\"cleanlandingpage.zip\";s:3:\"uid\";s:32:\"727a3680d312f22c6a5998ebdb9afe52\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/clean-landing-page-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:225;a:20:{s:2:\"id\";s:3:\"234\";s:5:\"title\";s:9:\"Clear Cut\";s:5:\"alias\";s:8:\"clearcut\";s:3:\"zip\";s:12:\"clearcut.zip\";s:3:\"uid\";s:32:\"07f43c00e9b4d3057a03cdb3385ad2b7\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/clear-cut-portfolio-website-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:240:\"<span class=\"ttm_content\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:226;a:23:{s:2:\"id\";s:3:\"235\";s:5:\"title\";s:22:\"Wonderstruck One-Pager\";s:5:\"alias\";s:30:\"wonderstruck-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"wonderstruck-one-pager-package\";s:3:\"img\";s:44:\"packages/wonderstruck-one-pager-overview.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:227;a:23:{s:2:\"id\";s:3:\"236\";s:5:\"title\";s:17:\"Wonderstruck Menu\";s:5:\"alias\";s:17:\"wonderstruck_menu\";s:3:\"zip\";s:27:\"packs/wonderstruck_menu.zip\";s:3:\"uid\";s:32:\"0a976e9aaae59c4f795b38f59f5a08d8\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:228;a:23:{s:2:\"id\";s:3:\"237\";s:5:\"title\";s:19:\"Wonderstruck Header\";s:5:\"alias\";s:19:\"wonderstruck_header\";s:3:\"zip\";s:29:\"packs/wonderstruck_header.zip\";s:3:\"uid\";s:32:\"e1379f77a902960a0ce12d44d85a9e0a\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:229;a:23:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:18:\"Wonderstruck About\";s:5:\"alias\";s:18:\"wonderstruck_about\";s:3:\"zip\";s:28:\"packs/wonderstruck_about.zip\";s:3:\"uid\";s:32:\"d207fb140fd328acc3038300ea52082a\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:230;a:23:{s:2:\"id\";s:3:\"239\";s:5:\"title\";s:18:\"Wonderstruck Works\";s:5:\"alias\";s:18:\"wonderstruck-works\";s:3:\"zip\";s:28:\"packs/wonderstruck-works.zip\";s:3:\"uid\";s:32:\"4476935097e27d92454b0011b7700c1d\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:231;a:23:{s:2:\"id\";s:3:\"240\";s:5:\"title\";s:20:\"Wonderstruck Contact\";s:5:\"alias\";s:20:\"wonderstruck-contact\";s:3:\"zip\";s:30:\"packs/wonderstruck-contact.zip\";s:3:\"uid\";s:32:\"9e4911521f77bce2b8efa40f4c2adc22\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:232;a:20:{s:2:\"id\";s:3:\"241\";s:5:\"title\";s:12:\"Bubble Morph\";s:5:\"alias\";s:11:\"bubblemorph\";s:3:\"zip\";s:15:\"bubblemorph.zip\";s:3:\"uid\";s:32:\"1102d6f5460ab82cb612cbe9f1d9514b\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/bubble-morph-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:188:\"<span class=\"ttm_content\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:233;a:20:{s:2:\"id\";s:3:\"242\";s:5:\"title\";s:16:\"Distortion AddOn\";s:5:\"alias\";s:15:\"distortionaddon\";s:3:\"zip\";s:19:\"distortionaddon.zip\";s:3:\"uid\";s:32:\"0ad46c9929bb2fa6316f1e6ced301aaf\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/distortion-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:193:\"[{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:234;a:20:{s:2:\"id\";s:3:\"243\";s:5:\"title\";s:10:\"Club Flyer\";s:5:\"alias\";s:9:\"clubflyer\";s:3:\"zip\";s:13:\"clubflyer.zip\";s:3:\"uid\";s:32:\"dab73b9904d0e643a35b0475980998bd\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/club-flyer-landing-page-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:198:\"[{\"path\":\"revslider-explodinglayers-addon\\/revslider-explodinglayers-addon.php\",\"name\":\"Exploding Layers AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:235;a:20:{s:2:\"id\";s:3:\"244\";s:5:\"title\";s:16:\"Paintbrush AddOn\";s:5:\"alias\";s:15:\"paintbrushaddon\";s:3:\"zip\";s:19:\"paintbrushaddon.zip\";s:3:\"uid\";s:32:\"c85c48a6742b4bf72a2590cc1b50f6a0\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/paintbrush-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:236;a:23:{s:2:\"id\";s:3:\"245\";s:5:\"title\";s:18:\"Parallax One-Pager\";s:5:\"alias\";s:26:\"parallax-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"parallax-one-pager-package\";s:3:\"img\";s:39:\"packages/parallax-one-pager-package.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:237;a:23:{s:2:\"id\";s:3:\"246\";s:5:\"title\";s:15:\"Parallax Header\";s:5:\"alias\";s:15:\"parallax_header\";s:3:\"zip\";s:25:\"packs/parallax_header.zip\";s:3:\"uid\";s:32:\"32bf4a0f5136853bd6bd366275a7a60b\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:238;a:23:{s:2:\"id\";s:3:\"247\";s:5:\"title\";s:16:\"Parallax Content\";s:5:\"alias\";s:16:\"parallax_content\";s:3:\"zip\";s:26:\"packs/parallax_content.zip\";s:3:\"uid\";s:32:\"a25c5fb8f74757476ab4dc038e56f90d\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:239;a:23:{s:2:\"id\";s:3:\"248\";s:5:\"title\";s:15:\"Parallax Footer\";s:5:\"alias\";s:15:\"parallax_footer\";s:3:\"zip\";s:25:\"packs/parallax_footer.zip\";s:3:\"uid\";s:32:\"665dff9ea6eaf162a2a1f160f51a9ddb\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:240;a:23:{s:2:\"id\";s:3:\"249\";s:5:\"title\";s:18:\"Le Chef Restaurant\";s:5:\"alias\";s:18:\"le-chef-restaurant\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"le-chef-restaurant-package\";s:3:\"img\";s:39:\"packages/le-chef-restaurant-package.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;N;}s:14:\"plugin_require\";s:186:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:241;a:23:{s:2:\"id\";s:3:\"250\";s:5:\"title\";s:12:\"Le Chef Menu\";s:5:\"alias\";s:12:\"le-chef-menu\";s:3:\"zip\";s:22:\"packs/le-chef-menu.zip\";s:3:\"uid\";s:32:\"2f2a6a333431fefe4a7b3b6a982b2ff5\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:242;a:23:{s:2:\"id\";s:3:\"251\";s:5:\"title\";s:14:\"Le Chef Header\";s:5:\"alias\";s:14:\"le-chef-header\";s:3:\"zip\";s:24:\"packs/le-chef-header.zip\";s:3:\"uid\";s:32:\"06450ca3be5a4a8959f3752ab974e574\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:243;a:23:{s:2:\"id\";s:3:\"252\";s:5:\"title\";s:18:\"Le Chef Philosophy\";s:5:\"alias\";s:18:\"le-chef-philosophy\";s:3:\"zip\";s:28:\"packs/le-chef-philosophy.zip\";s:3:\"uid\";s:32:\"a532fd029addeb18106e751409b8e20a\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:244;a:23:{s:2:\"id\";s:3:\"253\";s:5:\"title\";s:12:\"Le Chef Food\";s:5:\"alias\";s:12:\"le-chef-food\";s:3:\"zip\";s:22:\"packs/le-chef-food.zip\";s:3:\"uid\";s:32:\"cd4b6a2cb5de2dd20a0e8ba0c35451df\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:245;a:23:{s:2:\"id\";s:3:\"254\";s:5:\"title\";s:16:\"Le Chef La Carte\";s:5:\"alias\";s:16:\"le-chef-la-carte\";s:3:\"zip\";s:26:\"packs/le-chef-la-carte.zip\";s:3:\"uid\";s:32:\"6f312749679c3ba52c41189a6b8bf729\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:246;a:23:{s:2:\"id\";s:3:\"255\";s:5:\"title\";s:14:\"Le Chef Footer\";s:5:\"alias\";s:14:\"le-chef-footer\";s:3:\"zip\";s:24:\"packs/le-chef-footer.zip\";s:3:\"uid\";s:32:\"12fc241e8e5b9e5df9758c43448e2907\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:247;a:20:{s:2:\"id\";s:3:\"256\";s:5:\"title\";s:20:\"News Magazine Slider\";s:5:\"alias\";s:20:\"news-magazine-slider\";s:3:\"zip\";s:24:\"news-magazine-slider.zip\";s:3:\"uid\";s:32:\"31f2c1506babb1fef459401f051d2d52\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/news-magazine-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:248;a:20:{s:2:\"id\";s:3:\"257\";s:5:\"title\";s:18:\"Real Estate Slider\";s:5:\"alias\";s:18:\"real-estate-slider\";s:3:\"zip\";s:22:\"real-estate-slider.zip\";s:3:\"uid\";s:32:\"739ce6336e46815094387c9448e6c804\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/real-estate-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:249;a:20:{s:2:\"id\";s:3:\"258\";s:5:\"title\";s:14:\"Fashion Header\";s:5:\"alias\";s:14:\"fashion-header\";s:3:\"zip\";s:18:\"fashion-header.zip\";s:3:\"uid\";s:32:\"24ece4e7f4d31cd90377c62abbd9e25a\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/fashion-shop-header-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:254:\"<span class=\"ttm_content\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \"Bubble Morph\" effect makes this module stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:250;a:20:{s:2:\"id\";s:3:\"259\";s:5:\"title\";s:14:\"Seasonal Offer\";s:5:\"alias\";s:13:\"seasonaloffer\";s:3:\"zip\";s:17:\"seasonaloffer.zip\";s:3:\"uid\";s:32:\"caf2f17f8fd64f2f89dcb3c8dd238457\";s:3:\"img\";s:24:\"seasonaloffer/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/seasonal-offer-christmas-header-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">Use the Seasonal Offer Header to promote special offers in the holiday season, or just to add some snowy christmas spirit to your website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:197:\"<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:164:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}}s:6:\"slides\";a:236:{s:16:\"classic-carousel\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"classic-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"classic-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"classic-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"classic-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"classic-carousel/slide5.jpg\";}}s:13:\"classicslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"classicslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"classicslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"classicslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"classicslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:24:\"classicslider/slide5.jpg\";}}s:11:\"contenttabs\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contenttabs/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contenttabs/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contenttabs/slide3.jpg\";}}s:13:\"facebook-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"facebook-feed/slide1.jpg\";}}s:7:\"fashion\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"fashion/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"fashion/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"fashion/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"fashion/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"fashion/slide5.jpg\";}}s:14:\"flickr-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"flickr-gallery/slide1.jpg\";}}s:3:\"gym\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"gym/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:14:\"gym/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:14:\"gym/slide3.jpg\";}}s:18:\"highlight-carousel\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-carousel/slide4.jpg\";}}s:18:\"highlight-showcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-showcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-showcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-showcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-showcase/slide4.jpg\";}}s:10:\"image-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"imagehero/slide1.jpg\";}}s:13:\"insta-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"insta-gallery/slide1.jpg\";}}s:19:\"levanorestaurantbar\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"levanorestaurantbar/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"levanorestaurantbar/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"levanorestaurantbar/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:30:\"levanorestaurantbar/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:30:\"levanorestaurantbar/slide5.jpg\";}}s:11:\"mainfeature\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"mainfeature/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"mainfeature/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"mainfeature/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"mainfeature/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"mainfeature/slide7.jpg\";}}s:17:\"media-gallery-two\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"media-gallery-two/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"media-gallery-two/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"media-gallery-two/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"media-gallery-two/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"media-gallery-two/slide6.jpg\";}}s:23:\"media-carousel-autoplay\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide6.jpg\";}}s:21:\"news-background-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"news-bg-video/slide1.jpg\";}}s:12:\"news-gallery\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"news-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"news-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"news-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"news-gallery/slide4.jpg\";}}s:23:\"news-gallery-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"news-gallery-post-based/slide1.jpg\";}}s:9:\"news-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"news-hero/slide1.jpg\";}}s:10:\"news-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"news-video/slide1.jpg\";}}s:15:\"newsletter-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"newsletter-hero/slide1.jpg\";}}s:10:\"notgeneric\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"notgeneric/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"notgeneric/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"notgeneric/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"notgeneric/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"notgeneric/slide5.jpg\";}}s:11:\"photography\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"photography/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"photography/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"photography/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"photography/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:22:\"photography/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:22:\"photography/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"photography/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:22:\"photography/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:22:\"photography/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:23:\"photography/slide10.jpg\";}}s:20:\"photography-carousel\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"photography-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"photography-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"photography-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"photography-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:31:\"photography-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:31:\"photography-carousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:31:\"photography-carousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:31:\"photography-carousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:31:\"photography-carousel/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:32:\"photography-carousel/slide10.jpg\";}}s:16:\"search-form-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"search-form-hero/slide1.jpg\";}}s:16:\"showcasecarousel\";a:9:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"showcasecarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"showcasecarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"showcasecarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"showcasecarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"showcasecarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:27:\"showcasecarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:27:\"showcasecarousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:27:\"showcasecarousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:27:\"showcasecarousel/slide9.jpg\";}}s:11:\"sports-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"sportshero/slide1.jpg\";}}s:12:\"twitter-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"twitter-feed/slide1.jpg\";}}s:13:\"vimeo-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"vimeo-gallery/slide1.jpg\";}}s:9:\"vimeohero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"vimeohero/slide1.jpg\";}}s:16:\"web-product-dark\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"web-product-dark/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"web-product-dark/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"web-product-dark/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"web-product-dark/slide4.jpg\";}}s:21:\"web-product-dark-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"web-product-dark-hero/slide1.jpg\";}}s:22:\"web-product-light-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"web-product-light-hero/slide1.jpg\";}}s:15:\"webproductlight\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"webproductlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"webproductlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"webproductlight/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"webproductlight/slide4.jpg\";}}s:15:\"youtube-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"youtube-gallery/slide1.jpg\";}}s:11:\"youtubehero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"youtubehero/slide1.jpg\";}}s:13:\"scroll-effect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"scrolleffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"scrolleffect/slide3.jpg\";}}s:12:\"content-zoom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contentzoom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contentzoom/slide3.jpg\";}}s:13:\"food-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"foodcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"foodcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"foodcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"foodcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"foodcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"foodcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"foodcarousel/slide7.jpg\";}}s:14:\"rotating-words\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";}}s:22:\"travel-static-captions\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"travel-static-captions/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"travel-static-captions/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:33:\"travel-static-captions/slide4.jpg\";}}s:7:\"concept\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"concept/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"concept/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"concept/slide3.jpg\";}}s:17:\"fullscreen-button\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"fullscreen-button/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"fullscreen-button/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"fullscreen-button/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"fullscreen-button/slide5.jpg\";}}s:15:\"creativefreedom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"creativefreedom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"creativefreedom/slide3.jpg\";}}s:13:\"parallaxscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";}}s:15:\"slidingoverlays\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"slidingoverlays/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"slidingoverlays/slide3.jpg\";}}s:25:\"web-product-light-hero-3d\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";}}s:6:\"woobig\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";}}s:16:\"woocommercesmall\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";}}s:10:\"finedining\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";}}s:12:\"agency-intro\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";}}s:7:\"ourteam\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"ourteam/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"ourteam/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"ourteam/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"ourteam/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"ourteam/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:18:\"ourteam/slide7.jpg\";}}s:17:\"our-team-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"ourteamcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"ourteamcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"ourteamcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"ourteamcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"ourteamcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:26:\"ourteamcarousel/slide7.jpg\";}}s:13:\"betteryoutube\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"betteryoutube/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"betteryoutube/slide3.jpg\";}}s:19:\"agencywebsiteheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"agencywebsiteheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"agencywebsiteheader/slide3.jpg\";}}s:10:\"comingsoon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"comingsoon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"comingsoon/slide3.jpg\";}}s:9:\"snowscene\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowscene/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowscene/slide3.jpg\";}}s:8:\"rockband\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";}}s:16:\"sleeklandingpage\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"sleeklandingpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"sleeklandingpage/slide3.jpg\";}}s:14:\"applandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";}}s:9:\"deskscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";}}s:15:\"cleannewsslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"cleannewsslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"cleannewsslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"cleannewsslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"cleannewsslider/slide5.jpg\";}}s:12:\"imagegallery\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"imagegallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"imagegallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"imagegallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"imagegallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"imagegallery/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"imagegallery/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:23:\"imagegallery/slide8.jpg\";}}s:19:\"standard-wp-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";}}s:21:\"clean-news-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";}}s:21:\"interactivewhiteboard\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"interactivewhiteboard/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"interactivewhiteboard/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"interactivewhiteboard/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:32:\"interactivewhiteboard/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:32:\"interactivewhiteboard/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:32:\"interactivewhiteboard/slide8.jpg\";}}s:10:\"innovation\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"innovation/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"innovation/slide3.jpg\";}}s:24:\"dark-fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";}}s:21:\"dark-fullsite-block-1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";}}s:27:\"dark-fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide2.jpg\";}}s:30:\"dark-fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide2.jpg\";}}s:30:\"dark-fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide5.jpg\";}}s:34:\"dark-fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";}}s:29:\"dark-fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";}}s:28:\"dark-fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";}}s:19:\"fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";}}s:15:\"fullsite-block1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";}}s:22:\"fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide2.jpg\";}}s:25:\"fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide2.jpg\";}}s:25:\"fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide5.jpg\";}}s:29:\"fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";}}s:24:\"fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";}}s:23:\"fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";}}s:11:\"techjournal\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"techjournal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"techjournal/slide3.jpg\";}}s:13:\"cardealership\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"cardealership/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"cardealership/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"cardealership/slide4.jpg\";}}s:14:\"fullscreenmenu\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fullscreenmenu/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fullscreenmenu/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"fullscreenmenu/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"fullscreenmenu/slide5.jpg\";}}s:17:\"creativefrontpage\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"creativefrontpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"creativefrontpage/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"creativefrontpage/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"creativefrontpage/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"creativefrontpage/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:28:\"creativefrontpage/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:28:\"creativefrontpage/slide8.jpg\";}}s:19:\"websitebuilder-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";}}s:19:\"websitebuilder-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";}}s:22:\"websitebuilder-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";}}s:23:\"websitebuilder-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";}}s:23:\"websitebuilder-discover\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"websitebuilder-discover/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"websitebuilder-discover/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"websitebuilder-discover/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"websitebuilder-discover/slide5.jpg\";}}s:21:\"websitebuilder-slider\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"websitebuilder-slider/slide2.jpg\";}}s:27:\"websitebuilder-calltoaction\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";}}s:21:\"websitebuilder-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";}}s:13:\"focusparallax\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"focusparallax/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"focusparallax/slide3.jpg\";}}s:7:\"duotone\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"duotone/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"duotone/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"duotone/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"duotone/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"duotone/slide6.jpg\";}}s:6:\"r_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";}}s:5:\"rhero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";}}s:7:\"r_about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";}}s:10:\"r_products\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"r_products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"r_products/slide3.jpg\";}}s:6:\"r_info\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";}}s:17:\"inspirationheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";}}s:13:\"magazineposts\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"magazineposts/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"magazineposts/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"magazineposts/slide4.jpg\";}}s:17:\"explorationheader\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"explorationheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"explorationheader/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"explorationheader/slide4.jpg\";}}s:16:\"typewritereffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"typewritereffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"typewritereffect/slide3.jpg\";}}s:15:\"blendmodeheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";}}s:17:\"themeplicity_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";}}s:19:\"themeplicity_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";}}s:18:\"themeplicity_offer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";}}s:21:\"themeplicity_whatwedo\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";}}s:21:\"themeplicity_projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"themeplicity_projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"themeplicity_projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"themeplicity_projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:32:\"themeplicity_projects/slide5.jpg\";s:3:\"img\";s:7:\"Slide 5\";}}s:23:\"themeplicity_whatsgreat\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";}}s:19:\"themeplicity_tables\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";}}s:24:\"themeplicity_contactform\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";}}s:19:\"themeplicity_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";}}s:17:\"NiceAndClean_Menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";}}s:19:\"NiceAndClean_Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";}}s:21:\"NiceAndClean_Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";}}s:18:\"NiceAndClean_About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";}}s:18:\"niceandclean_video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";}}s:23:\"niceandclean_highlights\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";}}s:21:\"NiceAndClean_Projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide5.jpg\";}}s:23:\"niceandclean_textblocks\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";}}s:20:\"niceandclean_callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";}}s:19:\"niceandclean_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";}}s:3:\"80s\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"80s/slide1.jpg\";}}s:10:\"blurslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"blurslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"blurslider/slide3.jpg\";}}s:15:\"ComingSoonAddon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";}}s:9:\"snowaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowaddon/slide3.jpg\";}}s:19:\"particle-effect-one\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"particle-effect-one/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"particle-effect-one/slide3.jpg\";}}s:19:\"particle-effect-two\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";}}s:21:\"particle-effect-three\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";}}s:15:\"portfolioviewer\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"portfolioviewer/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"portfolioviewer/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"portfolioviewer/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"portfolioviewer/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"portfolioviewer/slide6.jpg\";}}s:11:\"appshowcase\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";}}s:13:\"gravitydesign\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";}}s:12:\"404errorpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";}}s:15:\"carouselgallery\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"carouselgallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"carouselgallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"carouselgallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"carouselgallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"carouselgallery/slide6.jpg\";}}s:9:\"filmstrip\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"filmstrip/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"filmstrip/slide3.jpg\";}}s:10:\"spaceopera\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"spaceopera/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"spaceopera/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"spaceopera/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"spaceopera/slide5.jpg\";}}s:12:\"websiteintro\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"websiteintro/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"websiteintro/slide3.jpg\";}}s:12:\"maskshowcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"maskshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"maskshowcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"maskshowcase/slide4.jpg\";}}s:18:\"parallaxzoomslices\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"parallaxzoomslices/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"parallaxzoomslices/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"parallaxzoomslices/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:29:\"parallaxzoomslices/slide5.jpg\";}}s:20:\"doubleexposureeffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"doubleexposureeffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"doubleexposureeffect/slide3.jpg\";}}s:22:\"mountainparallaxheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";}}s:12:\"goodnewsmenu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";}}s:14:\"goodnewsheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"goodnewsheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"goodnewsheader/slide3.jpg\";}}s:16:\"goodnewswhatshot\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";}}s:16:\"goodnewsfeatured\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";}}s:17:\"goodnewsspotlight\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"goodnewsspotlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"goodnewsspotlight/slide3.jpg\";}}s:16:\"goodnewscarousel\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"goodnewscarousel/slide2.jpg\";}}s:15:\"goodnewscallout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";}}s:14:\"goodnewsfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";}}s:16:\"goodnewsmenuback\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";}}s:18:\"goodnewsblogheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";}}s:19:\"goodnewsblogcontent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";}}s:20:\"goodnewstestimonials\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"goodnewstestimonials/slide2.jpg\";}}s:18:\"goodnewsblogfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";}}s:17:\"beforeafterslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"beforeafterslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"beforeafterslider/slide3.jpg\";}}s:15:\"productshowcase\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"productshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"productshowcase/slide3.jpg\";}}s:22:\"overexposuretransition\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"overexposuretransition/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"overexposuretransition/slide3.jpg\";}}s:14:\"parallaxscroll\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";}}s:11:\"techco-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";}}s:13:\"techco-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";}}s:12:\"techco-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";}}s:15:\"techco-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";}}s:12:\"techco-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";}}s:13:\"techco-prices\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";}}s:19:\"techco-testimonials\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"techco-testimonials/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"techco-testimonials/slide3.jpg\";}}s:13:\"techco-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";}}s:7:\"weather\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"weather/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"weather/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"weather/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"weather/slide4.jpg\";}}s:11:\"360panorama\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"360panorama/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"360panorama/slide3.jpg\";}}s:14:\"duotone-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"duotone-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"duotone-add-on/slide3.jpg\";}}s:13:\"reveal-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"reveal-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"reveal-add-on/slide3.jpg\";}}s:16:\"band-tour-poster\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/band-tour-poster/slide1.png\";}}s:14:\"brewery-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide3.png\";}}s:9:\"burgerbar\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide3.png\";}}s:19:\"burger-bar-portrait\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide3.png\";}}s:8:\"car-rent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"smartcontent/car-rent/slide1.png\";}}s:6:\"coffee\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"smartcontent/coffee/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"smartcontent/coffee/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"smartcontent/coffee/slide3.png\";}}s:14:\"holiday-advert\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/holiday-advert/slide1.png\";}}s:18:\"iphone-cases-light\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:42:\"smartcontent/iphone-cases-light/slide1.png\";}}s:7:\"medical\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"smartcontent/medical/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"smartcontent/medical/slide2.png\";}}s:13:\"mexican-grill\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide3.png\";}}s:20:\"mobile-retail-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide3.png\";}}s:14:\"money-exchange\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide3.png\";}}s:28:\"restaurant-menu-first-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-first-screen/slide1.png\";}}s:29:\"restaurant-menu-second-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:53:\"smartcontent/restaurant-menu-second-screen/slide1.png\";}}s:28:\"restaurant-menu-third-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-third-screen/slide1.png\";}}s:11:\"shoes-store\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide3.png\";}}s:20:\"supermarket-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide3.png\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide4.png\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide5.png\";}}s:16:\"travel-insurance\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/travel-insurance/slide1.png\";}}s:12:\"cryptoslider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"cryptoslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"cryptoslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"cryptoslider/slide4.jpg\";}}s:16:\"immersion_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";}}s:19:\"immersion-mountains\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";}}s:17:\"immersion-product\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";}}s:16:\"immersion-design\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";}}s:21:\"immersion-photography\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";}}s:14:\"immersion-grid\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";}}s:11:\"funkyslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"funkyslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"funkyslider/slide3.jpg\";}}s:14:\"clearview_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";}}s:16:\"clearview_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";}}s:17:\"clearview_mission\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";}}s:17:\"clear-view-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"clear-view-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"clear-view-slider/slide3.jpg\";}}s:15:\"clear-view-news\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";}}s:18:\"clear-view-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";}}s:18:\"clear-view-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";}}s:22:\"clear-view-single-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";}}s:24:\"clear-view-single-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";}}s:23:\"clear-view-single-media\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";}}s:22:\"clear-view-single-more\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";}}s:25:\"clear-view-single-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";}}s:16:\"cleanlandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";}}s:8:\"clearcut\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:19:\"clearcut/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:19:\"clearcut/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:19:\"clearcut/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:19:\"clearcut/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:19:\"clearcut/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:19:\"clearcut/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:19:\"clearcut/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:19:\"clearcut/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:20:\"clearcut/slide10.jpg\";}}s:17:\"wonderstruck_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";}}s:19:\"wonderstruck_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";}}s:18:\"wonderstruck_about\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"wonderstruck_about/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"wonderstruck_about/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"wonderstruck_about/slide4.jpg\";}}s:18:\"wonderstruck-works\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";}}s:20:\"wonderstruck-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";}}s:11:\"bubblemorph\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"bubblemorph/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"bubblemorph/slide3.jpg\";}}s:15:\"distortionaddon\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"distortionaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"distortionaddon/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"distortionaddon/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"distortionaddon/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"distortionaddon/slide6.jpg\";}}s:9:\"clubflyer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";}}s:15:\"paintbrushaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"paintbrushaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"paintbrushaddon/slide3.jpg\";}}s:15:\"parallax_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";}}s:16:\"parallax_content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";}}s:15:\"parallax_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";}}s:12:\"le-chef-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";}}s:14:\"le-chef-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"le-chef-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"le-chef-header/slide3.jpg\";}}s:18:\"le-chef-philosophy\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";}}s:12:\"le-chef-food\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";}}s:16:\"le-chef-la-carte\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";}}s:14:\"le-chef-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";}}s:20:\"news-magazine-slider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"news-magazine-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"news-magazine-slider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"news-magazine-slider/slide4.jpg\";}}s:18:\"real-estate-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"real-estate-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"real-estate-slider/slide3.jpg\";}}s:14:\"fashion-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fashion-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fashion-header/slide3.jpg\";}}s:13:\"seasonaloffer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"seasonaloffer/slide1.jpg\";}}}}", "no");
INSERT INTO `wp_options` VALUES("12075", "taxonomy_100", "a:1:{s:10:\"cityparent\";s:10:\"تهران\";}", "yes");
INSERT INTO `wp_options` VALUES("12339", "ewww_image_optimizer_bulk_attachments", "", "no");
INSERT INTO `wp_options` VALUES("12340", "ewww_image_optimizer_flag_attachments", "", "no");
INSERT INTO `wp_options` VALUES("12341", "ewww_image_optimizer_ngg_attachments", "", "no");
INSERT INTO `wp_options` VALUES("12342", "duplicator_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("12343", "_transient_timeout__redux_activation_redirect", "1547274961", "no");
INSERT INTO `wp_options` VALUES("12344", "_transient__redux_activation_redirect", "1", "no");
INSERT INTO `wp_options` VALUES("12345", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.0.3.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.0.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.0.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.0.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.0.3\";s:7:\"version\";s:5:\"5.0.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1547242928;s:15:\"version_checked\";s:5:\"5.0.3\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("12558", "_transient_timeout_select2-css_style_cdn_is_up", "1547273299", "no");
INSERT INTO `wp_options` VALUES("12559", "_transient_select2-css_style_cdn_is_up", "1", "no");
INSERT INTO `wp_options` VALUES("12560", "_transient_timeout_select2-js_script_cdn_is_up", "1547273299", "no");
INSERT INTO `wp_options` VALUES("12561", "_transient_select2-js_script_cdn_is_up", "1", "no");
INSERT INTO `wp_options` VALUES("12562", "_transient_timeout_ace-editor-js_script_cdn_is_up", "1547273300", "no");
INSERT INTO `wp_options` VALUES("12563", "_transient_ace-editor-js_script_cdn_is_up", "1", "no");
INSERT INTO `wp_options` VALUES("12608", "_transient_loco_po_e576242d1268f202b17faf7783e6c1a1", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:41:\"languages/plugins/wprentals-core-fa_IR.po\";s:5:\"bytes\";i:537593;s:5:\"mtime\";i:1547223567;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2412;s:1:\"p\";i:2383;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12609", "_transient_loco_po_fbf6143819d83822243c6a29f00187bb", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:74:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework.pot\";s:5:\"bytes\";i:42449;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:334;s:1:\"p\";i:0;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12610", "_transient_loco_po_2c4c7db66f5cabeb3b610c643a28f521", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:86:\"plugins/wprentals-core/admin/redux-framework/inc/themecheck/lang/themeforest-check.pot\";s:5:\"bytes\";i:918;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2;s:1:\"p\";i:0;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12611", "_transient_loco_po_90e87da7f8f554273266cf3982c2ecf2", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:76:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-fi.mo\";s:5:\"bytes\";i:4727;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:67;s:1:\"p\";i:67;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12612", "_transient_loco_po_59bf0be49062d7a47863b1f38f70d642", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-bg_BG.mo\";s:5:\"bytes\";i:8567;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:94;s:1:\"p\";i:94;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12613", "_transient_loco_po_7f544c18ca9145edb395a674d2524531", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:76:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-hr.mo\";s:5:\"bytes\";i:9230;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:111;s:1:\"p\";i:111;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12614", "_transient_loco_po_49a6de56f6d26c4b8f602ed5073ca14d", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-es_ES.mo\";s:5:\"bytes\";i:19313;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:243;s:1:\"p\";i:243;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12615", "_transient_loco_po_f2ff7699fababecb0900f236c2da0a7d", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-hi_IN.mo\";s:5:\"bytes\";i:9105;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:94;s:1:\"p\";i:94;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12616", "_transient_loco_po_df66116cea521e7f5bce6b8ebb3108a1", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-sl_SI.mo\";s:5:\"bytes\";i:4548;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:73;s:1:\"p\";i:73;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12617", "_transient_loco_po_0da3b644579b94305e01ba4afc37381e", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-sk_SK.mo\";s:5:\"bytes\";i:7898;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:78;s:1:\"p\";i:78;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12618", "_transient_loco_po_fac2e2b6c7d5d0ed905a7360fece3493", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-bn_BD.mo\";s:5:\"bytes\";i:6761;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:58;s:1:\"p\";i:58;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12619", "_transient_loco_po_01510fbf62ec814a35f74458a8fbf63b", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-fa_IR.mo\";s:5:\"bytes\";i:12907;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:151;s:1:\"p\";i:151;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12620", "_transient_loco_po_38dc8d2065b00ef6488009f9891d1f10", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-pt_PT.mo\";s:5:\"bytes\";i:7081;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:117;s:1:\"p\";i:117;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12621", "_transient_loco_po_2281ce3752a8b4c1e3c9b8205508618a", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-tr_TR.mo\";s:5:\"bytes\";i:15990;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:183;s:1:\"p\";i:183;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12622", "_transient_loco_po_d5f1b7d7279532166ab3a1cd3f0814e0", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-nb_NO.mo\";s:5:\"bytes\";i:15527;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:175;s:1:\"p\";i:175;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12623", "_transient_loco_po_d23932b1eb7f031182f98d0c4bf47e00", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-id_ID.mo\";s:5:\"bytes\";i:9333;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:119;s:1:\"p\";i:119;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12624", "_transient_loco_po_45e11392426645af5abacacb2eb35d60", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-cs_CZ.mo\";s:5:\"bytes\";i:15819;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:177;s:1:\"p\";i:177;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12625", "_transient_loco_po_e50d09881024c9cc42e0ec5de18990bf", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-nl_NL.mo\";s:5:\"bytes\";i:12002;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:167;s:1:\"p\";i:167;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12626", "_transient_loco_po_92402d38a2f76c590a11e7a9df4438c8", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:76:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-th.mo\";s:5:\"bytes\";i:8686;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:98;s:1:\"p\";i:98;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12627", "_transient_loco_po_1c526d5a3c730b65690408a53785abc2", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:76:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-el.mo\";s:5:\"bytes\";i:18378;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:159;s:1:\"p\";i:159;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12628", "_transient_loco_po_7f66f8ac18d9ed41e400b54cc4f5002d", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-pl_PL.mo\";s:5:\"bytes\";i:18965;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:228;s:1:\"p\";i:228;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12629", "_transient_loco_po_4dded69c4612f62a399188d25535d6ef", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:76:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-ar.mo\";s:5:\"bytes\";i:17301;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:170;s:1:\"p\";i:170;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12630", "_transient_loco_po_e9302082e2da11cdaf8572098da968ec", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-he_IL.mo\";s:5:\"bytes\";i:10520;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:122;s:1:\"p\";i:122;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12631", "_transient_loco_po_6fb8f0de9b1a046a7a9759d405076150", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-it_IT.mo\";s:5:\"bytes\";i:15287;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:181;s:1:\"p\";i:181;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12632", "_transient_loco_po_297955e6f20255f26237e769bf8b3581", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-da_DK.mo\";s:5:\"bytes\";i:5001;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:83;s:1:\"p\";i:83;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12633", "_transient_loco_po_571c991c3a665f86c2862a8797efbb24", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:4:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-lt_LT.mo\";s:5:\"bytes\";i:0;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("12634", "_transient_loco_po_91574fed1b4f4396ccd346ac6dba8e68", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-fr_FR.mo\";s:5:\"bytes\";i:39336;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:330;s:1:\"p\";i:330;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12635", "_transient_loco_po_5b391910bf325c4f499a183c65ec60c6", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:76:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-km.mo\";s:5:\"bytes\";i:7971;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:95;s:1:\"p\";i:95;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12636", "_transient_loco_po_b4ba4fcf87ecc3f3e6ca6d8b799325da", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-ne_NP.mo\";s:5:\"bytes\";i:13557;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:108;s:1:\"p\";i:108;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12637", "_transient_loco_po_5936b7d724d33d1a1088801067a44ef8", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-ro_RO.mo\";s:5:\"bytes\";i:16678;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:181;s:1:\"p\";i:181;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12638", "_transient_loco_po_a1b5b9264c7c7611a979e22782b1526a", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-de_DE.mo\";s:5:\"bytes\";i:14510;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:168;s:1:\"p\";i:168;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12639", "_transient_loco_po_21d58c96d99b27ab97ab2ca724c56d4e", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-hu_HU.mo\";s:5:\"bytes\";i:7996;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:109;s:1:\"p\";i:109;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12640", "_transient_loco_po_0acb6e0e2f6b7bba8f3352f426e7fa12", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-zh_CN.mo\";s:5:\"bytes\";i:14324;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:187;s:1:\"p\";i:187;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12641", "_transient_loco_po_bf9d7af8eb6d0041d60ab3c8cb7fba7c", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-es_MX.mo\";s:5:\"bytes\";i:6325;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:70;s:1:\"p\";i:70;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12642", "_transient_loco_po_eb792cca7619b8d2cd6508214eb76060", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-ru_RU.mo\";s:5:\"bytes\";i:48364;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:330;s:1:\"p\";i:330;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12643", "_transient_loco_po_ae643b17eeb85c34904a4a8f8ea84525", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-pt_BR.mo\";s:5:\"bytes\";i:16478;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:186;s:1:\"p\";i:186;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12644", "_transient_loco_po_2013bfeff50e3053bcb56b0f52728cc8", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:76:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-ja.mo\";s:5:\"bytes\";i:15820;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:173;s:1:\"p\";i:173;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12645", "_transient_loco_po_87f94008dca06a6d9da458d2424b05c7", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:79:\"plugins/wprentals-core/admin/redux-framework/languages/redux-framework-sv_SE.mo\";s:5:\"bytes\";i:13181;s:5:\"mtime\";i:1547186069;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:152;s:1:\"p\";i:152;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12669", "_transient_timeout_wpestate_get_template_link_terms_conditions.php", "1547274580", "no");
INSERT INTO `wp_options` VALUES("12670", "_transient_wpestate_get_template_link_terms_conditions.php", "http://jobifa.com/demo/wprentals-pack/wprentals2/terms-and-conditions/", "no");
INSERT INTO `wp_options` VALUES("12673", "_transient_timeout_wpestate_get_template_link_compare_listings.php", "1547274580", "no");
INSERT INTO `wp_options` VALUES("12674", "_transient_wpestate_get_template_link_compare_listings.php", "", "no");
INSERT INTO `wp_options` VALUES("12682", "_transient_timeout_wpestate_markerstaxonomy_property_area_%da%a9%d8%b1%d8%ac-%d8%aa%d9%87%d8%b1%d8%a7%d9%86_prop_6paged_1_maxpins30_offset_0_prop_featured", "1547207138", "no");
INSERT INTO `wp_options` VALUES("12683", "_transient_wpestate_markerstaxonomy_property_area_%da%a9%d8%b1%d8%ac-%d8%aa%d9%87%d8%b1%d8%a7%d9%86_prop_6paged_1_maxpins30_offset_0_prop_featured", "a:1:{i:0;a:21:{i:0;s:156:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%AF%D8%B1%20%D9%85%D9%86%D8%B7%D9%82%D9%87%20%D9%BE%D8%A7%D8%B3%D8%AF%D8%A7%D8%B1%D8%A7%D9%86\";i:1;s:13:\"39.2838253476\";i:2;s:14:\"-76.5767669678\";i:3;i:1;i:4;s:112:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2015%2F04%2F33-400x314.jpg\";i:5;s:41:\"%2023%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:4:\"dorm\";i:7;s:11:\"shared-room\";i:8;s:15:\"dormshared-room\";i:9;s:103:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fwest-town-3rd-floor-dorm%2F\";i:10;i:149;i:11;s:50:\"%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:12;s:81:\"%25da%25a9%25d8%25b1%25d8%25ac-%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:13;i:23;i:14;s:1:\"1\";i:15;s:1:\"1\";i:16;s:3:\"250\";i:17;s:42:\"%D8%AE%D9%88%D8%A7%D8%A8%DA%AF%D8%A7%D9%87\";i:18;s:57:\"%D8%A7%D8%B7%D8%A7%D9%82%20%D9%85%D8%B4%D8%AA%D8%B1%DA%A9\";i:19;s:6:\"normal\";i:20;s:13:\"23 تومان\";}}", "no");
INSERT INTO `wp_options` VALUES("12686", "_site_transient_timeout_browser_fe67d2a27d7121c4d70e8cbcf904f89d", "1547798437", "no");
INSERT INTO `wp_options` VALUES("12687", "_site_transient_browser_fe67d2a27d7121c4d70e8cbcf904f89d", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"71.0.3578.98\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("12694", "_site_transient_timeout_community-events-e7cb8bb0c30e831dc8a633697bc95fb3", "1547236846", "no");
INSERT INTO `wp_options` VALUES("12695", "_site_transient_community-events-e7cb8bb0c30e831dc8a633697bc95fb3", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"5.209.235.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("12696", "_transient_timeout_bsf_check_product_updates", "1547444421", "no");
INSERT INTO `wp_options` VALUES("12697", "_transient_bsf_check_product_updates", "1", "no");
INSERT INTO `wp_options` VALUES("12702", "_transient_timeout_plugin_slugs", "1547358062", "no");
INSERT INTO `wp_options` VALUES("12703", "_transient_plugin_slugs", "a:17:{i:0;s:19:\"akismet/akismet.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";i:3;s:47:\"file-manager-advanced/file_manager_advanced.php\";i:4;s:9:\"hello.php\";i:5;s:23:\"loco-translate/loco.php\";i:6;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:7;s:31:\"custom-css-js/custom-css-js.php\";i:8;s:23:\"revslider/revslider.php\";i:9;s:33:\"string-locator/string-locator.php\";i:10;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:11;s:41:\"wordpress-importer/wordpress-importer.php\";i:12;s:23:\"wp-jalali/wp-jalali.php\";i:13;s:29:\"wp-parsidate/wp-parsidate.php\";i:14;s:27:\"js_composer/js_composer.php\";i:15;s:33:\"wprentals-core/wprentals-core.php\";i:16;s:29:\"wprental-sms/wprental-sms.php\";}", "no");
INSERT INTO `wp_options` VALUES("12729", "_transient_loco_po_3f74ebbb8162afb55cddbf6599066d88", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:35:\"languages/themes/wprentals-fa_IR.po\";s:5:\"bytes\";i:200602;s:5:\"mtime\";i:1547200352;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2021;s:1:\"p\";i:2019;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12730", "_transient_loco_po_95eabef469f9419c7691a6f943e63852", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:39:\"themes/wprentals/languages/wprentals.po\";s:5:\"bytes\";i:384516;s:5:\"mtime\";i:1547186727;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2029;s:1:\"p\";i:0;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12733", "_transient_timeout_wpestate_markerstaxonomy_property_category_apartment_prop_6paged_1_maxpins30_offset_0_prop_featured", "1547214237", "no");
INSERT INTO `wp_options` VALUES("12734", "_transient_wpestate_markerstaxonomy_property_category_apartment_prop_6paged_1_maxpins30_offset_0_prop_featured", "a:4:{i:0;a:21:{i:0;s:144:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%DB%8C%DA%A9%20%D9%88%D8%A7%D8%AD%D8%AF%20%D8%A2%D9%BE%D8%A7%D8%B1%D8%AA%D9%85%D8%A7%DB%8C%20%D8%B4%DB%8C%DA%A9\";i:1;s:9:\"35.810977\";i:2;s:9:\"51.411411\";i:3;i:1;i:4;s:111:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F08%2F4-400x314.jpg\";i:5;s:6:\"%20%20\";i:6;s:9:\"apartment\";i:7;s:11:\"entire-home\";i:8;s:20:\"apartmententire-home\";i:9;s:303:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2F%25d8%25a7%25d8%25ac%25d8%25a7%25d8%25b1%25d9%2587-%25db%258c%25da%25a9-%25d9%2588%25d8%25a7%25d8%25ad%25d8%25af-%25d8%25a2%25d9%25be%25d8%25a7%25d8%25b1%25d8%25aa%25d9%2585%25d8%25a7%25db%258c-%25d8%25b4%25db%258c%25da%25a9%2F\";i:10;i:2579;i:11;s:50:\"%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:12;s:121:\"%25d9%2581%25d8%25b1%25d9%2585%25d8%25a7%25d9%2586%25db%258c%25d9%2587-%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:13;i:0;i:14;s:1:\"1\";i:15;s:1:\"1\";i:16;s:2:\"95\";i:17;s:48:\"%D8%A2%D9%BE%D8%A7%D8%B1%D8%AA%D9%85%D8%A7%D9%86\";i:18;s:51:\"%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:6:\"normal\";i:20;s:12:\"0 تومان\";}i:1;a:21:{i:0;s:159:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%20%D9%85%D9%86%D8%B7%D9%82%D9%87%20%D8%B3%D8%B9%D8%A7%D8%AF%D8%AA%20%D8%A2%D8%A8%D8%A7%D8%AF\";i:1;s:1:\"0\";i:2;s:1:\"0\";i:3;i:2;i:4;s:131:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F12%2Fdemo5114-2-5-1024x576-400x314.jpg\";i:5;s:42:\"%20250%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:9:\"apartment\";i:7;s:132:\"%25d9%2585%25d9%2584%25da%25a9-%25d8%25a8%25d8%25a7%25d8%25b2%25d8%25b3%25d8%25a7%25d8%25b2%25db%258c-%25d8%25b4%25d8%25af%25d9%2587\";i:8;s:27:\"apartmentd985d984daa9-d8a8d\";i:9;s:324:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2F%25d8%25a7%25d8%25ac%25d8%25a7%25d8%25b1%25d9%2587-%25d9%2585%25d9%2584%25da%25a9-%25d8%25af%25d8%25b1-%25d9%2585%25d9%2586%25d8%25b7%25d9%2582%25d9%2587-%25d8%25b3%25d8%25b9%25d8%25a7%25d8%25af%25d8%25aa-%25d8%25a2%25d8%25a8%25d8%25a7%25d8%25af%2F\";i:10;i:2323;i:11;s:6:\"tehran\";i:12;s:91:\"%25d8%25b3%25d8%25b9%25d8%25a7%25d8%25af%25d8%25aa-%25d8%25a2%25d8%25a8%25d8%25a7%25d8%25af\";i:13;i:250;i:14;s:1:\"4\";i:15;s:1:\"1\";i:16;s:3:\"250\";i:17;s:48:\"%D8%A2%D9%BE%D8%A7%D8%B1%D8%AA%D9%85%D8%A7%D9%86\";i:18;s:84:\"%D9%85%D9%84%DA%A9%20%D8%A8%D8%A7%D8%B2%D8%B3%D8%A7%D8%B2%DB%8C%20%D8%B4%D8%AF%D9%87\";i:19;s:0:\"\";i:20;s:14:\"250 تومان\";}i:2;a:21:{i:0;s:171:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%AF%D8%B1%20%D9%81%D8%B1%D9%85%D8%A7%D9%86%DB%8C%D9%87%20%D8%AE%20%D8%B9%D8%B3%DA%AF%D8%B1%DB%8C%D8%A7%D9%86\";i:1;s:13:\"38.9029232243\";i:2;s:14:\"-77.0193099976\";i:3;i:3;i:4;s:111:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F08%2F6-400x314.jpg\";i:5;s:41:\"%2025%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:9:\"apartment\";i:7;s:11:\"entire-home\";i:8;s:20:\"apartmententire-home\";i:9;s:106:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fcozy-house-in-the-sunnyside%2F\";i:10;i:94;i:11;s:9:\"ferikenar\";i:12;s:14:\"wesley-heights\";i:13;i:25;i:14;s:1:\"1\";i:15;s:1:\"2\";i:16;s:3:\"750\";i:17;s:48:\"%D8%A2%D9%BE%D8%A7%D8%B1%D8%AA%D9%85%D8%A7%D9%86\";i:18;s:51:\"%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:6:\"normal\";i:20;s:13:\"25 تومان\";}i:3;a:21:{i:0;s:198:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%AF%D8%B1%20%D9%81%D8%B1%D8%AC%D8%A7%D9%85%20%D8%AE%20%D8%AD%DB%8C%D8%AF%D8%B1%D8%AE%D8%A7%D9%86%DB%8C%20%D8%B4%D9%85%D8%A7%D9%84%DB%8C\";i:1;s:13:\"38.8909367934\";i:2;s:14:\"-76.9592446089\";i:3;i:4;i:4;s:118:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F12%2Fdemo19-400x314-1.jpg\";i:5;s:41:\"%2038%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:9:\"apartment\";i:7;s:11:\"entire-home\";i:8;s:20:\"apartmententire-home\";i:9;s:97:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fdowntown-apartment%2F\";i:10;i:10;i:11;s:9:\"ferikenar\";i:12;s:162:\"%25d9%2584%25d9%2588%25d8%25a7%25d8%25b3%25d8%25a7%25d9%2586-%25d9%2581%25d8%25b1%25db%258c%25d8%25af%25d9%2588%25d9%2586-%25da%25a9%25d9%2586%25d8%25a7%25d8%25b1\";i:13;i:38;i:14;s:1:\"1\";i:15;s:1:\"2\";i:16;s:2:\"50\";i:17;s:48:\"%D8%A2%D9%BE%D8%A7%D8%B1%D8%AA%D9%85%D8%A7%D9%86\";i:18;s:51:\"%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:6:\"normal\";i:20;s:13:\"38 تومان\";}}", "no");
INSERT INTO `wp_options` VALUES("12764", "_transient_timeout_wpestate_markerstaxonomy_property_category_dorm_prop_6paged_1_maxpins30_offset_0_prop_featured", "1547218311", "no");
INSERT INTO `wp_options` VALUES("12765", "_transient_wpestate_markerstaxonomy_property_category_dorm_prop_6paged_1_maxpins30_offset_0_prop_featured", "a:3:{i:0;a:21:{i:0;s:165:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D8%A7%D8%B7%D8%A7%D9%82%20%D8%A7%D8%B2%20%DB%8C%DA%A9%20%D9%88%D8%A7%D8%AD%D8%AF%20%D8%A2%D9%BE%D8%A7%D8%B1%D8%AA%D9%85%D8%A7%D9%86\";i:1;s:13:\"39.2838253476\";i:2;s:14:\"-76.5767669678\";i:3;i:1;i:4;s:135:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F12%2FMTEyLTEuanBn_1457546855-1-400x314.jpg\";i:5;s:41:\"%2045%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:4:\"dorm\";i:7;s:11:\"shared-room\";i:8;s:15:\"dormshared-room\";i:9;s:334:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2F%25d8%25a7%25d8%25ac%25d8%25a7%25d8%25b1%25d9%2587-%25d8%25a7%25d8%25b7%25d8%25a7%25d9%2582-%25d8%25a7%25d8%25b2-%25db%258c%25da%25a9-%25d9%2588%25d8%25a7%25d8%25ad%25d8%25af-%25d8%25a2%25d9%25be%25d8%25a7%25d8%25b1%25d8%25aa%25d9%2585%25d8%25a7%25d9%2586%2F\";i:10;i:2588;i:11;s:50:\"%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:12;s:131:\"%25d8%25a7%25d8%25b3%25d9%2584%25d8%25a7%25d9%2585%25d8%25b4%25d9%2587%25d8%25b1-%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:13;i:45;i:14;s:1:\"1\";i:15;s:1:\"1\";i:16;s:3:\"250\";i:17;s:42:\"%D8%AE%D9%88%D8%A7%D8%A8%DA%AF%D8%A7%D9%87\";i:18;s:57:\"%D8%A7%D8%B7%D8%A7%D9%82%20%D9%85%D8%B4%D8%AA%D8%B1%DA%A9\";i:19;s:6:\"normal\";i:20;s:13:\"45 تومان\";}i:1;a:21:{i:0;s:156:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%AF%D8%B1%20%D9%85%D9%86%D8%B7%D9%82%D9%87%20%D9%BE%D8%A7%D8%B3%D8%AF%D8%A7%D8%B1%D8%A7%D9%86\";i:1;s:13:\"39.2838253476\";i:2;s:14:\"-76.5767669678\";i:3;i:2;i:4;s:112:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2015%2F04%2F33-400x314.jpg\";i:5;s:41:\"%2023%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:4:\"dorm\";i:7;s:11:\"shared-room\";i:8;s:15:\"dormshared-room\";i:9;s:103:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fwest-town-3rd-floor-dorm%2F\";i:10;i:149;i:11;s:50:\"%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:12;s:81:\"%25da%25a9%25d8%25b1%25d8%25ac-%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:13;i:23;i:14;s:1:\"1\";i:15;s:1:\"1\";i:16;s:3:\"250\";i:17;s:42:\"%D8%AE%D9%88%D8%A7%D8%A8%DA%AF%D8%A7%D9%87\";i:18;s:57:\"%D8%A7%D8%B7%D8%A7%D9%82%20%D9%85%D8%B4%D8%AA%D8%B1%DA%A9\";i:19;s:6:\"normal\";i:20;s:13:\"23 تومان\";}i:2;a:21:{i:0;s:105:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%AF%D8%B1%20%D9%86%D8%A7%D8%B1%D9%85%DA%A9\";i:1;s:13:\"39.3100537903\";i:2;s:14:\"-76.6572225094\";i:3;i:3;i:4;s:119:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2015%2F04%2Fholiday3-400x314.jpeg\";i:5;s:41:\"%2025%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:4:\"dorm\";i:7;s:11:\"shared-room\";i:8;s:15:\"dormshared-room\";i:9;s:102:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fsunny-dorm-in-west-town%2F\";i:10;i:145;i:11;s:7:\"thehran\";i:12;s:9:\"arlington\";i:13;i:25;i:14;s:1:\"1\";i:15;s:1:\"2\";i:16;s:3:\"500\";i:17;s:42:\"%D8%AE%D9%88%D8%A7%D8%A8%DA%AF%D8%A7%D9%87\";i:18;s:57:\"%D8%A7%D8%B7%D8%A7%D9%82%20%D9%85%D8%B4%D8%AA%D8%B1%DA%A9\";i:19;s:6:\"normal\";i:20;s:13:\"25 تومان\";}}", "no");
INSERT INTO `wp_options` VALUES("12768", "_transient_timeout_wpestate_markerstaxonomy_property_category_cabin_prop_6paged_1_maxpins30_offset_0_prop_featured", "1547218588", "no");
INSERT INTO `wp_options` VALUES("12769", "_transient_wpestate_markerstaxonomy_property_category_cabin_prop_6paged_1_maxpins30_offset_0_prop_featured", "a:2:{i:0;a:21:{i:0;s:216:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D8%A7%D8%B7%D8%A7%D9%82%20%D9%85%D8%B3%DA%A9%D9%88%D9%86%DB%8C%20%D8%AA%D9%85%D8%A7%D9%85%20%D9%85%D8%A8%D9%84%D9%87%20%D8%AF%D8%B1%20%D9%BE%D8%A7%D8%B3%D8%AF%D8%A7%D8%B1%D8%A7%D9%86\";i:1;s:10:\"42.2814816\";i:2;s:11:\"-71.0956488\";i:3;i:1;i:4;s:127:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F12%2Fdemo442-600x456-1-400x314.jpg\";i:5;s:41:\"%2065%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:5:\"cabin\";i:7;s:12:\"private-room\";i:8;s:17:\"cabinprivate-room\";i:9;s:102:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fvictorian-bed-breakfast%2F\";i:10;i:115;i:11;s:50:\"%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:12;s:111:\"%25d9%2584%25d9%2588%25d8%25a7%25d8%25b3%25d8%25a7%25d9%2586-%25d8%25aa%25d9%2587%25d8%25b1%25d8%25a7%25d9%2586\";i:13;i:65;i:14;s:1:\"1\";i:15;s:1:\"2\";i:16;s:3:\"450\";i:17;s:24:\"%D8%A7%D8%B7%D8%A7%D9%82\";i:18;s:57:\"%D8%A7%D8%B7%D8%A7%D9%82%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:78:\"%D8%A2%DA%AF%D9%87%DB%8C%20%D8%AA%D8%A7%DB%8C%DB%8C%D8%AF%20%D8%B4%D8%AF%D9%87\";i:20;s:13:\"65 تومان\";}i:1;a:21:{i:0;s:204:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%AF%D8%B1%20%DA%A9%D8%A7%D9%85%D8%B1%D8%A7%D9%86%DB%8C%D9%87%20%D8%B4%D9%85%D8%A7%D9%84%DB%8C%20%DA%A9%20%D8%B4%DB%8C%D8%A8%D8%A7%D9%86%DB%8C\";i:1;s:13:\"39.9467266106\";i:2;s:13:\"-75.166053772\";i:3;i:2;i:4;s:111:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F08%2F4-400x314.jpg\";i:5;s:41:\"%2059%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:5:\"cabin\";i:7;s:11:\"entire-home\";i:8;s:16:\"cabinentire-home\";i:9;s:110:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fsummerlin-cabin-perfect-holiday%2F\";i:10;i:124;i:11;s:12:\"philadelphia\";i:12;s:10:\"brightwood\";i:13;i:59;i:14;s:1:\"2\";i:15;s:1:\"6\";i:16;s:3:\"750\";i:17;s:24:\"%D8%A7%D8%B7%D8%A7%D9%82\";i:18;s:51:\"%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:6:\"normal\";i:20;s:13:\"59 تومان\";}}", "no");
INSERT INTO `wp_options` VALUES("12793", "taxonomy_26", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:102:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/12/demo29-400x314-300x236.jpg\";s:18:\"category_attach_id\";s:4:\"2824\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:24:\"property_action_category\";}", "yes");
INSERT INTO `wp_options` VALUES("12803", "_transient_loco_po_030f1dfb32431a92c53e2d4b1ab5d8c8", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:44:\"themes/wprentals-child-po/languages/fr_FR.po\";s:5:\"bytes\";i:532893;s:5:\"mtime\";i:1539600976;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2527;s:1:\"p\";i:927;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12804", "_transient_loco_po_e7feac0e665a1b4c9d8dc06be103009a", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:44:\"themes/wprentals-child-po/languages/en_US.po\";s:5:\"bytes\";i:496674;s:5:\"mtime\";i:1539600977;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2527;s:1:\"p\";i:33;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12805", "_transient_loco_po_43ab65c34930b46668d6794694be1b49", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:44:\"themes/wprentals-child-po/languages/es_CO.po\";s:5:\"bytes\";i:530022;s:5:\"mtime\";i:1539600976;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2527;s:1:\"p\";i:977;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12806", "_transient_loco_po_9a8f1bae25511389895a547c24f9bfda", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:44:\"themes/wprentals-child-po/languages/ro_RO.po\";s:5:\"bytes\";i:633583;s:5:\"mtime\";i:1539600975;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2527;s:1:\"p\";i:1184;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12807", "_transient_loco_po_153a91a14453eeacb3742d4576a453b0", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:44:\"themes/wprentals-child-po/languages/tr_TR.po\";s:5:\"bytes\";i:660633;s:5:\"mtime\";i:1539600974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2527;s:1:\"p\";i:1440;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12808", "_transient_loco_po_a53266418004afb16c3ecd79ea9be590", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:44:\"themes/wprentals-child-po/languages/it_IT.po\";s:5:\"bytes\";i:666174;s:5:\"mtime\";i:1539600975;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2527;s:1:\"p\";i:1439;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12809", "_transient_loco_po_083e0ba9ebe24efc56264920db6c2cef", "a:3:{s:1:\"c\";s:21:\"Loco_gettext_Metadata\";s:1:\"v\";i:0;s:1:\"d\";a:5:{s:5:\"rpath\";s:48:\"themes/wprentals-child-po/languages/wprentals.po\";s:5:\"bytes\";i:495955;s:5:\"mtime\";i:1539600974;s:5:\"valid\";b:1;s:5:\"stats\";a:3:{s:1:\"t\";i:2527;s:1:\"p\";i:0;s:1:\"f\";i:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("12814", "_transient_timeout_wpestate_taxonomy_listtaxonomy_property_city_ramsar_prop_6paged_1", "1547214902", "no");
INSERT INTO `wp_options` VALUES("12815", "_transient_wpestate_taxonomy_listtaxonomy_property_city_ramsar_prop_6paged_1", "O:8:\"WP_Query\":49:{s:5:\"query\";a:8:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:1;s:14:\"posts_per_page\";i:6;s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:10:\"meta_value\";s:5:\"order\";s:4:\"DESC\";s:9:\"tax_query\";a:2:{s:8:\"relation\";s:3:\"AND\";i:0;a:3:{s:8:\"taxonomy\";s:13:\"property_city\";s:5:\"field\";s:4:\"slug\";s:5:\"terms\";s:6:\"ramsar\";}}}s:10:\"query_vars\";a:69:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:1;s:14:\"posts_per_page\";i:6;s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:10:\"meta_value\";s:5:\"order\";s:4:\"DESC\";s:9:\"tax_query\";a:2:{s:8:\"relation\";s:3:\"AND\";i:0;a:3:{s:8:\"taxonomy\";s:13:\"property_city\";s:5:\"field\";s:4:\"slug\";s:5:\"terms\";s:6:\"ramsar\";}}s:5:\"error\";s:0:\"\";s:1:\"m\";s:0:\"\";s:1:\"p\";i:0;s:11:\"post_parent\";s:0:\"\";s:7:\"subpost\";s:0:\"\";s:10:\"subpost_id\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:13:\"attachment_id\";i:0;s:4:\"name\";s:0:\"\";s:6:\"static\";s:0:\"\";s:8:\"pagename\";s:0:\"\";s:7:\"page_id\";i:0;s:6:\"second\";s:0:\"\";s:6:\"minute\";s:0:\"\";s:4:\"hour\";s:0:\"\";s:3:\"day\";i:0;s:8:\"monthnum\";i:0;s:4:\"year\";i:0;s:1:\"w\";i:0;s:13:\"category_name\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:3:\"cat\";s:0:\"\";s:6:\"tag_id\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"author_name\";s:0:\"\";s:4:\"feed\";s:0:\"\";s:2:\"tb\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:7:\"preview\";s:0:\"\";s:1:\"s\";s:0:\"\";s:8:\"sentence\";s:0:\"\";s:5:\"title\";s:0:\"\";s:6:\"fields\";s:0:\"\";s:10:\"menu_order\";s:0:\"\";s:5:\"embed\";s:0:\"\";s:12:\"category__in\";a:0:{}s:16:\"category__not_in\";a:0:{}s:13:\"category__and\";a:0:{}s:8:\"post__in\";a:0:{}s:12:\"post__not_in\";a:0:{}s:13:\"post_name__in\";a:0:{}s:7:\"tag__in\";a:0:{}s:11:\"tag__not_in\";a:0:{}s:8:\"tag__and\";a:0:{}s:12:\"tag_slug__in\";a:0:{}s:13:\"tag_slug__and\";a:0:{}s:15:\"post_parent__in\";a:0:{}s:19:\"post_parent__not_in\";a:0:{}s:10:\"author__in\";a:0:{}s:14:\"author__not_in\";a:0:{}s:19:\"ignore_sticky_posts\";b:0;s:16:\"suppress_filters\";b:0;s:13:\"cache_results\";b:1;s:22:\"update_post_term_cache\";b:1;s:19:\"lazy_load_term_meta\";b:1;s:22:\"update_post_meta_cache\";b:1;s:8:\"nopaging\";b:0;s:17:\"comments_per_page\";s:2:\"50\";s:13:\"no_found_rows\";b:0;s:8:\"taxonomy\";s:13:\"property_city\";s:4:\"term\";s:6:\"ramsar\";}s:9:\"tax_query\";O:12:\"WP_Tax_Query\":6:{s:7:\"queries\";a:2:{s:8:\"relation\";s:3:\"AND\";i:0;a:5:{s:8:\"taxonomy\";s:13:\"property_city\";s:5:\"terms\";a:1:{i:0;s:6:\"ramsar\";}s:5:\"field\";s:4:\"slug\";s:8:\"operator\";s:2:\"IN\";s:16:\"include_children\";b:1;}}s:8:\"relation\";s:3:\"AND\";s:16:\"\0*\0table_aliases\";a:1:{i:0;s:21:\"wp_term_relationships\";}s:13:\"queried_terms\";a:1:{s:13:\"property_city\";a:2:{s:5:\"terms\";a:1:{i:0;s:6:\"ramsar\";}s:5:\"field\";s:4:\"slug\";}}s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";}s:10:\"meta_query\";O:13:\"WP_Meta_Query\":9:{s:7:\"queries\";a:2:{i:0;a:1:{s:3:\"key\";s:13:\"prop_featured\";}s:8:\"relation\";s:2:\"OR\";}s:8:\"relation\";s:3:\"AND\";s:10:\"meta_table\";s:11:\"wp_postmeta\";s:14:\"meta_id_column\";s:7:\"post_id\";s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";s:16:\"\0*\0table_aliases\";a:1:{i:0;s:11:\"wp_postmeta\";}s:10:\"\0*\0clauses\";a:1:{s:11:\"wp_postmeta\";a:4:{s:3:\"key\";s:13:\"prop_featured\";s:7:\"compare\";s:1:\"=\";s:5:\"alias\";s:11:\"wp_postmeta\";s:4:\"cast\";s:4:\"CHAR\";}}s:18:\"\0*\0has_or_relation\";b:0;}s:10:\"date_query\";b:0;s:7:\"request\";s:491:\"SELECT SQL_CALC_FOUND_ROWS  wp_posts.ID FROM wp_posts  LEFT JOIN wp_term_relationships ON (wp_posts.ID = wp_term_relationships.object_id) INNER JOIN wp_postmeta ON ( wp_posts.ID = wp_postmeta.post_id ) WHERE 1=1  AND ( \n  wp_term_relationships.term_taxonomy_id IN (23)\n) AND ( \n  wp_postmeta.meta_key = \'prop_featured\'\n) AND wp_posts.post_type = \'estate_property\' AND ((wp_posts.post_status = \'publish\')) GROUP BY wp_posts.ID ORDER BY wp_postmeta.meta_value DESC, wp_posts.ID DESC LIMIT 0, 6\";s:5:\"posts\";a:4:{i:0;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2583;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 14:06:21\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 14:06:21\";s:12:\"post_content\";s:387:\"قیمت اعلام شده مربوط به روزهای عادی و تا سقف ظرفیت نرمال میباشد و قیمت در روز های آخر هفته، تعطیلات، مناسبت ها، ایام نوروز و یا نفرات بیش از ظرفیت نرمال، افزایش می یابد. این مجتمع ویلایی مشتمل بر ۸ ویلای دوخوابه است.\";s:10:\"post_title\";s:52:\"اجاره ویلا در ارتفاعات رامسر\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:148:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7-%d8%af%d8%b1-%d8%a7%d8%b1%d8%aa%d9%81%d8%a7%d8%b9%d8%a7%d8%aa-%d8%b1%d8%a7%d9%85%d8%b3%d8%b1\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-17 07:59:58\";s:17:\"post_modified_gmt\";s:19:\"2018-12-17 04:29:58\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=115\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:1;O:7:\"WP_Post\":24:{s:2:\"ID\";i:141;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 09:49:37\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 09:49:37\";s:12:\"post_content\";s:1512:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nبسیاری از حمل و نقل عمومی:\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:54:\"اجاره سوئیت ساحلی شیک تریپلکس\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:21:\"modern-spacious-villa\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:33:55\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 11:03:55\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=141\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:2;O:7:\"WP_Post\":24:{s:2:\"ID\";i:133;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 09:31:41\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 09:31:41\";s:12:\"post_content\";s:834:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:52:\"اجاره ویلا سوپرلوکس در رامسر\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:26:\"terrace-condo-penn-station\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-05 09:08:48\";s:17:\"post_modified_gmt\";s:19:\"2018-12-05 10:08:48\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=133\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:3;O:7:\"WP_Post\":24:{s:2:\"ID\";i:129;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 09:22:05\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 09:22:05\";s:12:\"post_content\";s:1512:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nبسیاری از حمل و نقل عمومی:\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:48:\"اجاره یک واحد آپارتمای شیک\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:16:\"2-bedrooms-condo\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:08:56\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 10:38:56\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=129\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}}s:10:\"post_count\";i:4;s:12:\"current_post\";i:-1;s:11:\"in_the_loop\";b:0;s:4:\"post\";r:133;s:13:\"comment_count\";i:0;s:15:\"current_comment\";i:-1;s:11:\"found_posts\";s:1:\"4\";s:13:\"max_num_pages\";d:1;s:21:\"max_num_comment_pages\";i:0;s:9:\"is_single\";b:0;s:10:\"is_preview\";b:0;s:7:\"is_page\";b:0;s:10:\"is_archive\";b:1;s:7:\"is_date\";b:0;s:7:\"is_year\";b:0;s:8:\"is_month\";b:0;s:6:\"is_day\";b:0;s:7:\"is_time\";b:0;s:9:\"is_author\";b:0;s:11:\"is_category\";b:0;s:6:\"is_tag\";b:0;s:6:\"is_tax\";b:1;s:9:\"is_search\";b:0;s:7:\"is_feed\";b:0;s:15:\"is_comment_feed\";b:0;s:12:\"is_trackback\";b:0;s:7:\"is_home\";b:0;s:6:\"is_404\";b:0;s:8:\"is_embed\";b:0;s:8:\"is_paged\";b:0;s:8:\"is_admin\";b:0;s:13:\"is_attachment\";b:0;s:11:\"is_singular\";b:0;s:9:\"is_robots\";b:0;s:13:\"is_posts_page\";b:0;s:20:\"is_post_type_archive\";b:1;s:25:\"\0WP_Query\0query_vars_hash\";s:32:\"8307a5076ae87c96a3e763cf6ce2e172\";s:28:\"\0WP_Query\0query_vars_changed\";b:0;s:17:\"thumbnails_cached\";b:0;s:19:\"\0WP_Query\0stopwords\";N;s:23:\"\0WP_Query\0compat_fields\";a:2:{i:0;s:15:\"query_vars_hash\";i:1;s:18:\"query_vars_changed\";}s:24:\"\0WP_Query\0compat_methods\";a:2:{i:0;s:16:\"init_query_flags\";i:1;s:15:\"parse_tax_query\";}}", "no");
INSERT INTO `wp_options` VALUES("12816", "_transient_timeout_wpestate_markerstaxonomy_property_city_ramsar_prop_6paged_1_maxpins30_offset_0_prop_featured", "1547228342", "no");
INSERT INTO `wp_options` VALUES("12817", "_transient_wpestate_markerstaxonomy_property_city_ramsar_prop_6paged_1_maxpins30_offset_0_prop_featured", "a:4:{i:0;a:21:{i:0;s:156:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%AF%D8%B1%20%D8%A7%D8%B1%D8%AA%D9%81%D8%A7%D8%B9%D8%A7%D8%AA%20%D8%B1%D8%A7%D9%85%D8%B3%D8%B1\";i:1;s:10:\"42.2814816\";i:2;s:11:\"-71.0956488\";i:3;i:1;i:4;s:117:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F12%2Fslide-1-400x314.jpg\";i:5;s:42:\"%20350%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:5:\"villa\";i:7;s:11:\"entire-home\";i:8;s:16:\"villaentire-home\";i:9;s:323:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2F%25d8%25a7%25d8%25ac%25d8%25a7%25d8%25b1%25d9%2587-%25d9%2588%25db%258c%25d9%2584%25d8%25a7-%25d8%25af%25d8%25b1-%25d8%25a7%25d8%25b1%25d8%25aa%25d9%2581%25d8%25a7%25d8%25b9%25d8%25a7%25d8%25aa-%25d8%25b1%25d8%25a7%25d9%2585%25d8%25b3%25d8%25b1%2F\";i:10;i:2583;i:11;s:6:\"ramsar\";i:12;s:102:\"%25d9%2585%25d8%25aa%25d9%2584-%25d9%2582%25d9%2588-%25d8%25b1%25d8%25a7%25d9%2585%25d8%25b3%25d8%25b1\";i:13;i:350;i:14;s:1:\"1\";i:15;s:1:\"1\";i:16;s:3:\"450\";i:17;s:24:\"%D9%88%DB%8C%D9%84%D8%A7\";i:18;s:51:\"%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:6:\"normal\";i:20;s:14:\"350 تومان\";}i:1;a:21:{i:0;s:162:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D8%B3%D9%88%D8%A6%DB%8C%D8%AA%20%D8%B3%D8%A7%D8%AD%D9%84%DB%8C%20%D8%B4%DB%8C%DA%A9%20%D8%AA%D8%B1%DB%8C%D9%BE%D9%84%DA%A9%D8%B3\";i:1;s:10:\"40.7184746\";i:2;s:11:\"-73.9882516\";i:3;i:2;i:4;s:112:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F08%2F10-400x314.jpg\";i:5;s:42:\"%20159%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:5:\"villa\";i:7;s:11:\"entire-home\";i:8;s:16:\"villaentire-home\";i:9;s:100:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fmodern-spacious-villa%2F\";i:10;i:141;i:11;s:6:\"ramsar\";i:12;s:9:\"east-side\";i:13;i:159;i:14;s:1:\"2\";i:15;s:1:\"5\";i:16;s:5:\"2,500\";i:17;s:24:\"%D9%88%DB%8C%D9%84%D8%A7\";i:18;s:51:\"%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:6:\"normal\";i:20;s:14:\"159 تومان\";}i:2;a:21:{i:0;s:156:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%D9%88%DB%8C%D9%84%D8%A7%20%D8%B3%D9%88%D9%BE%D8%B1%D9%84%D9%88%DA%A9%D8%B3%20%D8%AF%D8%B1%20%D8%B1%D8%A7%D9%85%D8%B3%D8%B1\";i:1;s:10:\"40.7274893\";i:2;s:11:\"-73.9950182\";i:3;i:3;i:4;s:155:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2015%2F04%2FGreek.Villas-Villa-Pegados-4-2-e1543737817258-400x314.jpg\";i:5;s:42:\"%20200%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:5:\"villa\";i:7;s:11:\"entire-home\";i:8;s:16:\"villaentire-home\";i:9;s:105:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2Fterrace-condo-penn-station%2F\";i:10;i:133;i:11;s:6:\"ramsar\";i:12;s:0:\"\";i:13;i:200;i:14;s:1:\"2\";i:15;s:1:\"8\";i:16;s:5:\"1,200\";i:17;s:24:\"%D9%88%DB%8C%D9%84%D8%A7\";i:18;s:51:\"%D9%85%D9%84%DA%A9%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:78:\"%D8%A2%DA%AF%D9%87%DB%8C%20%D8%AA%D8%A7%DB%8C%DB%8C%D8%AF%20%D8%B4%D8%AF%D9%87\";i:20;s:14:\"200 تومان\";}i:3;a:21:{i:0;s:144:\"%D8%A7%D8%AC%D8%A7%D8%B1%D9%87%20%DB%8C%DA%A9%20%D9%88%D8%A7%D8%AD%D8%AF%20%D8%A2%D9%BE%D8%A7%D8%B1%D8%AA%D9%85%D8%A7%DB%8C%20%D8%B4%DB%8C%DA%A9\";i:1;s:13:\"40.7099546663\";i:2;s:14:\"-74.0066957474\";i:3;i:4;i:4;s:111:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fwp-content%2Fuploads%2F2018%2F08%2F6-400x314.jpg\";i:5;s:42:\"%20150%20%D8%AA%D9%88%D9%85%D8%A7%D9%86%20\";i:6;s:6:\"condos\";i:7;s:12:\"private-room\";i:8;s:18:\"condosprivate-room\";i:9;s:95:\"http%3A%2F%2Fjobifa.com%2Fdemo%2Fwprentals-pack%2Fwprentals2%2Fproperties%2F2-bedrooms-condo%2F\";i:10;i:129;i:11;s:6:\"ramsar\";i:12;s:9:\"manhattan\";i:13;i:150;i:14;s:1:\"2\";i:15;s:1:\"7\";i:16;s:5:\"1,000\";i:17;s:51:\"%D9%BE%D9%86%D8%AA%20%D9%87%D8%A7%D9%88%D9%88%D8%B3\";i:18;s:57:\"%D8%A7%D8%B7%D8%A7%D9%82%20%D8%AF%D8%B1%D8%A8%D8%B3%D8%AA\";i:19;s:6:\"normal\";i:20;s:14:\"150 تومان\";}}", "no");
INSERT INTO `wp_options` VALUES("12854", "taxonomy_19", "a:6:{s:10:\"cityparent\";s:10:\"Alexandria\";s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:104:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/12/demo38-400x314-2-300x236.jpg\";s:18:\"category_attach_id\";s:4:\"2828\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_area\";}", "yes");
INSERT INTO `wp_options` VALUES("12857", "taxonomy_25", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:102:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/12/demo19-400x314-300x236.jpg\";s:18:\"category_attach_id\";s:4:\"2819\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:24:\"property_action_category\";}", "yes");
INSERT INTO `wp_options` VALUES("12858", "property_action_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("12859", "taxonomy_18", "a:5:{s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:97:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/12/6-400x314-300x236.jpg\";s:18:\"category_attach_id\";s:4:\"2815\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:24:\"property_action_category\";}", "yes");
INSERT INTO `wp_options` VALUES("12862", "taxonomy_21", "a:6:{s:10:\"cityparent\";s:10:\"تهران\";s:7:\"pagetax\";s:0:\"\";s:23:\"category_featured_image\";s:242:\"http://jobifa.com/demo/wprentals-pack/wprentals2/wp-content/uploads/2018/12/cool-living-room-decor-2015-design-black-arch-lamp-stylish-ceiling-light-shiny-flooring-living-room-decoration-2015-modern-living-room-design-2015-400x314-300x236.jpg\";s:18:\"category_attach_id\";s:4:\"2826\";s:16:\"category_tagline\";s:0:\"\";s:12:\"category_tax\";s:13:\"property_area\";}", "yes");
INSERT INTO `wp_options` VALUES("12891", "_transient_timeout_wpestate_recent_posts_pictures_query_estate_property_____3_no_no", "1547247625", "no");
INSERT INTO `wp_options` VALUES("12892", "_transient_wpestate_recent_posts_pictures_query_estate_property_____3_no_no", "O:8:\"WP_Query\":49:{s:5:\"query\";a:9:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:0;s:14:\"posts_per_page\";s:1:\"3\";s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:10:\"meta_value\";s:5:\"order\";s:4:\"DESC\";s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}}s:10:\"query_vars\";a:68:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:0;s:14:\"posts_per_page\";i:3;s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:10:\"meta_value\";s:5:\"order\";s:4:\"DESC\";s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:5:\"error\";s:0:\"\";s:1:\"m\";s:0:\"\";s:1:\"p\";i:0;s:11:\"post_parent\";s:0:\"\";s:7:\"subpost\";s:0:\"\";s:10:\"subpost_id\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:13:\"attachment_id\";i:0;s:4:\"name\";s:0:\"\";s:6:\"static\";s:0:\"\";s:8:\"pagename\";s:0:\"\";s:7:\"page_id\";i:0;s:6:\"second\";s:0:\"\";s:6:\"minute\";s:0:\"\";s:4:\"hour\";s:0:\"\";s:3:\"day\";i:0;s:8:\"monthnum\";i:0;s:4:\"year\";i:0;s:1:\"w\";i:0;s:13:\"category_name\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:3:\"cat\";s:0:\"\";s:6:\"tag_id\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"author_name\";s:0:\"\";s:4:\"feed\";s:0:\"\";s:2:\"tb\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:7:\"preview\";s:0:\"\";s:1:\"s\";s:0:\"\";s:8:\"sentence\";s:0:\"\";s:5:\"title\";s:0:\"\";s:6:\"fields\";s:0:\"\";s:10:\"menu_order\";s:0:\"\";s:5:\"embed\";s:0:\"\";s:12:\"category__in\";a:0:{}s:16:\"category__not_in\";a:0:{}s:13:\"category__and\";a:0:{}s:8:\"post__in\";a:0:{}s:12:\"post__not_in\";a:0:{}s:13:\"post_name__in\";a:0:{}s:7:\"tag__in\";a:0:{}s:11:\"tag__not_in\";a:0:{}s:8:\"tag__and\";a:0:{}s:12:\"tag_slug__in\";a:0:{}s:13:\"tag_slug__and\";a:0:{}s:15:\"post_parent__in\";a:0:{}s:19:\"post_parent__not_in\";a:0:{}s:10:\"author__in\";a:0:{}s:14:\"author__not_in\";a:0:{}s:19:\"ignore_sticky_posts\";b:0;s:16:\"suppress_filters\";b:0;s:13:\"cache_results\";b:1;s:22:\"update_post_term_cache\";b:1;s:19:\"lazy_load_term_meta\";b:1;s:22:\"update_post_meta_cache\";b:1;s:8:\"nopaging\";b:0;s:17:\"comments_per_page\";s:2:\"50\";s:13:\"no_found_rows\";b:0;}s:9:\"tax_query\";O:12:\"WP_Tax_Query\":6:{s:7:\"queries\";a:0:{}s:8:\"relation\";s:3:\"AND\";s:16:\"\0*\0table_aliases\";a:0:{}s:13:\"queried_terms\";a:0:{}s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";}s:10:\"meta_query\";O:13:\"WP_Meta_Query\":9:{s:7:\"queries\";a:2:{i:0;a:1:{s:3:\"key\";s:13:\"prop_featured\";}s:8:\"relation\";s:2:\"OR\";}s:8:\"relation\";s:3:\"AND\";s:10:\"meta_table\";s:11:\"wp_postmeta\";s:14:\"meta_id_column\";s:7:\"post_id\";s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";s:16:\"\0*\0table_aliases\";a:1:{i:0;s:11:\"wp_postmeta\";}s:10:\"\0*\0clauses\";a:1:{s:11:\"wp_postmeta\";a:4:{s:3:\"key\";s:13:\"prop_featured\";s:7:\"compare\";s:1:\"=\";s:5:\"alias\";s:11:\"wp_postmeta\";s:4:\"cast\";s:4:\"CHAR\";}}s:18:\"\0*\0has_or_relation\";b:0;}s:10:\"date_query\";b:0;s:7:\"request\";s:350:\"SELECT SQL_CALC_FOUND_ROWS  wp_posts.ID FROM wp_posts  INNER JOIN wp_postmeta ON ( wp_posts.ID = wp_postmeta.post_id ) WHERE 1=1  AND ( \n  wp_postmeta.meta_key = \'prop_featured\'\n) AND wp_posts.post_type = \'estate_property\' AND ((wp_posts.post_status = \'publish\')) GROUP BY wp_posts.ID ORDER BY wp_postmeta.meta_value DESC, wp_posts.ID DESC LIMIT 0, 3\";s:5:\"posts\";a:3:{i:0;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2581;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 12:08:38\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 12:08:38\";s:12:\"post_content\";s:832:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:56:\"اجاره ویلا ساحلی در فریدونکنار\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:160:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7-%d8%b3%d8%a7%d8%ad%d9%84%db%8c-%d8%af%d8%b1-%d9%81%d8%b1%db%8c%d8%af%d9%88%d9%86%da%a9%d9%86%d8%a7%d8%b1\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 11:55:14\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 08:25:14\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=107\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"1\";s:6:\"filter\";s:3:\"raw\";}i:1;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2580;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 11:43:45\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 11:43:45\";s:12:\"post_content\";s:499:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:54:\"اجاره سوئیت ساحلی شیک تریپلکس\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:154:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%b3%d9%88%d8%a6%db%8c%d8%aa-%d8%b3%d8%a7%d8%ad%d9%84%db%8c-%d8%b4%db%8c%da%a9-%d8%aa%d8%b1%db%8c%d9%be%d9%84%da%a9%d8%b3\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-30 10:42:21\";s:17:\"post_modified_gmt\";s:19:\"2018-12-30 07:12:21\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=101\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:2;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2579;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-14 10:14:51\";s:13:\"post_date_gmt\";s:19:\"2015-04-14 10:14:51\";s:12:\"post_content\";s:1512:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nبسیاری از حمل و نقل عمومی:\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:48:\"اجاره یک واحد آپارتمای شیک\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:136:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%db%8c%da%a9-%d9%88%d8%a7%d8%ad%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%db%8c-%d8%b4%db%8c%da%a9\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:05:07\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 10:35:07\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:63:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=10\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}}s:10:\"post_count\";i:3;s:12:\"current_post\";i:-1;s:11:\"in_the_loop\";b:0;s:4:\"post\";r:118;s:13:\"comment_count\";i:0;s:15:\"current_comment\";i:-1;s:11:\"found_posts\";s:2:\"25\";s:13:\"max_num_pages\";d:9;s:21:\"max_num_comment_pages\";i:0;s:9:\"is_single\";b:0;s:10:\"is_preview\";b:0;s:7:\"is_page\";b:0;s:10:\"is_archive\";b:1;s:7:\"is_date\";b:0;s:7:\"is_year\";b:0;s:8:\"is_month\";b:0;s:6:\"is_day\";b:0;s:7:\"is_time\";b:0;s:9:\"is_author\";b:0;s:11:\"is_category\";b:0;s:6:\"is_tag\";b:0;s:6:\"is_tax\";b:0;s:9:\"is_search\";b:0;s:7:\"is_feed\";b:0;s:15:\"is_comment_feed\";b:0;s:12:\"is_trackback\";b:0;s:7:\"is_home\";b:0;s:6:\"is_404\";b:0;s:8:\"is_embed\";b:0;s:8:\"is_paged\";b:0;s:8:\"is_admin\";b:0;s:13:\"is_attachment\";b:0;s:11:\"is_singular\";b:0;s:9:\"is_robots\";b:0;s:13:\"is_posts_page\";b:0;s:20:\"is_post_type_archive\";b:1;s:25:\"\0WP_Query\0query_vars_hash\";s:32:\"7aac5b3d86751e9f5c8a5bf944ef53fd\";s:28:\"\0WP_Query\0query_vars_changed\";b:0;s:17:\"thumbnails_cached\";b:0;s:19:\"\0WP_Query\0stopwords\";N;s:23:\"\0WP_Query\0compat_fields\";a:2:{i:0;s:15:\"query_vars_hash\";i:1;s:18:\"query_vars_changed\";}s:24:\"\0WP_Query\0compat_methods\";a:2:{i:0;s:16:\"init_query_flags\";i:1;s:15:\"parse_tax_query\";}}", "no");
INSERT INTO `wp_options` VALUES("12904", "ccj_settings", "a:3:{s:16:\"ccj_htmlentities\";b:0;s:17:\"ccj_htmlentities2\";b:0;s:8:\"add_role\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("12910", "_transient_timeout_wpestate_recent_posts_pictures_query_estate_property_____3_no_yes", "1547251166", "no");
INSERT INTO `wp_options` VALUES("12911", "_transient_wpestate_recent_posts_pictures_query_estate_property_____3_no_yes", "O:8:\"WP_Query\":49:{s:5:\"query\";a:9:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:0;s:14:\"posts_per_page\";s:1:\"3\";s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:4:\"rand\";s:5:\"order\";s:4:\"DESC\";s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}}s:10:\"query_vars\";a:68:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:0;s:14:\"posts_per_page\";i:3;s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:4:\"rand\";s:5:\"order\";s:0:\"\";s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:5:\"error\";s:0:\"\";s:1:\"m\";s:0:\"\";s:1:\"p\";i:0;s:11:\"post_parent\";s:0:\"\";s:7:\"subpost\";s:0:\"\";s:10:\"subpost_id\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:13:\"attachment_id\";i:0;s:4:\"name\";s:0:\"\";s:6:\"static\";s:0:\"\";s:8:\"pagename\";s:0:\"\";s:7:\"page_id\";i:0;s:6:\"second\";s:0:\"\";s:6:\"minute\";s:0:\"\";s:4:\"hour\";s:0:\"\";s:3:\"day\";i:0;s:8:\"monthnum\";i:0;s:4:\"year\";i:0;s:1:\"w\";i:0;s:13:\"category_name\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:3:\"cat\";s:0:\"\";s:6:\"tag_id\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"author_name\";s:0:\"\";s:4:\"feed\";s:0:\"\";s:2:\"tb\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:7:\"preview\";s:0:\"\";s:1:\"s\";s:0:\"\";s:8:\"sentence\";s:0:\"\";s:5:\"title\";s:0:\"\";s:6:\"fields\";s:0:\"\";s:10:\"menu_order\";s:0:\"\";s:5:\"embed\";s:0:\"\";s:12:\"category__in\";a:0:{}s:16:\"category__not_in\";a:0:{}s:13:\"category__and\";a:0:{}s:8:\"post__in\";a:0:{}s:12:\"post__not_in\";a:0:{}s:13:\"post_name__in\";a:0:{}s:7:\"tag__in\";a:0:{}s:11:\"tag__not_in\";a:0:{}s:8:\"tag__and\";a:0:{}s:12:\"tag_slug__in\";a:0:{}s:13:\"tag_slug__and\";a:0:{}s:15:\"post_parent__in\";a:0:{}s:19:\"post_parent__not_in\";a:0:{}s:10:\"author__in\";a:0:{}s:14:\"author__not_in\";a:0:{}s:19:\"ignore_sticky_posts\";b:0;s:16:\"suppress_filters\";b:0;s:13:\"cache_results\";b:1;s:22:\"update_post_term_cache\";b:1;s:19:\"lazy_load_term_meta\";b:1;s:22:\"update_post_meta_cache\";b:1;s:8:\"nopaging\";b:0;s:17:\"comments_per_page\";s:2:\"50\";s:13:\"no_found_rows\";b:0;}s:9:\"tax_query\";O:12:\"WP_Tax_Query\":6:{s:7:\"queries\";a:0:{}s:8:\"relation\";s:3:\"AND\";s:16:\"\0*\0table_aliases\";a:0:{}s:13:\"queried_terms\";a:0:{}s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";}s:10:\"meta_query\";O:13:\"WP_Meta_Query\":9:{s:7:\"queries\";a:2:{i:0;a:1:{s:3:\"key\";s:13:\"prop_featured\";}s:8:\"relation\";s:2:\"OR\";}s:8:\"relation\";s:3:\"AND\";s:10:\"meta_table\";s:11:\"wp_postmeta\";s:14:\"meta_id_column\";s:7:\"post_id\";s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";s:16:\"\0*\0table_aliases\";a:1:{i:0;s:11:\"wp_postmeta\";}s:10:\"\0*\0clauses\";a:1:{s:11:\"wp_postmeta\";a:4:{s:3:\"key\";s:13:\"prop_featured\";s:7:\"compare\";s:1:\"=\";s:5:\"alias\";s:11:\"wp_postmeta\";s:4:\"cast\";s:4:\"CHAR\";}}s:18:\"\0*\0has_or_relation\";b:0;}s:10:\"date_query\";b:0;s:7:\"request\";s:311:\"SELECT SQL_CALC_FOUND_ROWS  wp_posts.ID FROM wp_posts  INNER JOIN wp_postmeta ON ( wp_posts.ID = wp_postmeta.post_id ) WHERE 1=1  AND ( \n  wp_postmeta.meta_key = \'prop_featured\'\n) AND wp_posts.post_type = \'estate_property\' AND ((wp_posts.post_status = \'publish\')) GROUP BY wp_posts.ID ORDER BY RAND() LIMIT 0, 3\";s:5:\"posts\";a:3:{i:0;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2581;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 12:08:38\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 12:08:38\";s:12:\"post_content\";s:832:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:56:\"اجاره ویلا ساحلی در فریدونکنار\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:160:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7-%d8%b3%d8%a7%d8%ad%d9%84%db%8c-%d8%af%d8%b1-%d9%81%d8%b1%db%8c%d8%af%d9%88%d9%86%da%a9%d9%86%d8%a7%d8%b1\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 11:55:14\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 08:25:14\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=107\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"1\";s:6:\"filter\";s:3:\"raw\";}i:1;O:7:\"WP_Post\":24:{s:2:\"ID\";i:149;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 10:07:19\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 10:07:19\";s:12:\"post_content\";s:1504:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nبسیاری از حمل و نقل عمومی:\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:52:\"اجاره ویلا در منطقه پاسداران\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:24:\"west-town-3rd-floor-dorm\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2019-01-10 10:21:16\";s:17:\"post_modified_gmt\";s:19:\"2019-01-10 06:51:16\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=149\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:2;O:7:\"WP_Post\":24:{s:2:\"ID\";i:141;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 09:49:37\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 09:49:37\";s:12:\"post_content\";s:1512:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nبسیاری از حمل و نقل عمومی:\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:54:\"اجاره سوئیت ساحلی شیک تریپلکس\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:21:\"modern-spacious-villa\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:33:55\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 11:03:55\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=141\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}}s:10:\"post_count\";i:3;s:12:\"current_post\";i:-1;s:11:\"in_the_loop\";b:0;s:4:\"post\";r:118;s:13:\"comment_count\";i:0;s:15:\"current_comment\";i:-1;s:11:\"found_posts\";s:2:\"25\";s:13:\"max_num_pages\";d:9;s:21:\"max_num_comment_pages\";i:0;s:9:\"is_single\";b:0;s:10:\"is_preview\";b:0;s:7:\"is_page\";b:0;s:10:\"is_archive\";b:1;s:7:\"is_date\";b:0;s:7:\"is_year\";b:0;s:8:\"is_month\";b:0;s:6:\"is_day\";b:0;s:7:\"is_time\";b:0;s:9:\"is_author\";b:0;s:11:\"is_category\";b:0;s:6:\"is_tag\";b:0;s:6:\"is_tax\";b:0;s:9:\"is_search\";b:0;s:7:\"is_feed\";b:0;s:15:\"is_comment_feed\";b:0;s:12:\"is_trackback\";b:0;s:7:\"is_home\";b:0;s:6:\"is_404\";b:0;s:8:\"is_embed\";b:0;s:8:\"is_paged\";b:0;s:8:\"is_admin\";b:0;s:13:\"is_attachment\";b:0;s:11:\"is_singular\";b:0;s:9:\"is_robots\";b:0;s:13:\"is_posts_page\";b:0;s:20:\"is_post_type_archive\";b:1;s:25:\"\0WP_Query\0query_vars_hash\";s:32:\"ece1247ce3aba381d2e19b63086d5704\";s:28:\"\0WP_Query\0query_vars_changed\";b:0;s:17:\"thumbnails_cached\";b:0;s:19:\"\0WP_Query\0stopwords\";N;s:23:\"\0WP_Query\0compat_fields\";a:2:{i:0;s:15:\"query_vars_hash\";i:1;s:18:\"query_vars_changed\";}s:24:\"\0WP_Query\0compat_methods\";a:2:{i:0;s:16:\"init_query_flags\";i:1;s:15:\"parse_tax_query\";}}", "no");
INSERT INTO `wp_options` VALUES("12912", "_transient_timeout_wpestate_list_items_by_id_149,141,137", "1547251166", "no");
INSERT INTO `wp_options` VALUES("12913", "_transient_wpestate_list_items_by_id_149,141,137", "O:8:\"WP_Query\":49:{s:5:\"query\";a:5:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:14:\"posts_per_page\";i:3;s:7:\"orderby\";s:8:\"post__in\";s:8:\"post__in\";a:3:{i:0;s:3:\"149\";i:1;s:3:\"141\";i:2;s:3:\"137\";}}s:10:\"query_vars\";a:66:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:14:\"posts_per_page\";i:3;s:7:\"orderby\";s:8:\"post__in\";s:8:\"post__in\";a:3:{i:0;s:3:\"149\";i:1;s:3:\"141\";i:2;s:3:\"137\";}s:5:\"error\";s:0:\"\";s:1:\"m\";s:0:\"\";s:1:\"p\";i:0;s:11:\"post_parent\";s:0:\"\";s:7:\"subpost\";s:0:\"\";s:10:\"subpost_id\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:13:\"attachment_id\";i:0;s:4:\"name\";s:0:\"\";s:6:\"static\";s:0:\"\";s:8:\"pagename\";s:0:\"\";s:7:\"page_id\";i:0;s:6:\"second\";s:0:\"\";s:6:\"minute\";s:0:\"\";s:4:\"hour\";s:0:\"\";s:3:\"day\";i:0;s:8:\"monthnum\";i:0;s:4:\"year\";i:0;s:1:\"w\";i:0;s:13:\"category_name\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:3:\"cat\";s:0:\"\";s:6:\"tag_id\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"author_name\";s:0:\"\";s:4:\"feed\";s:0:\"\";s:2:\"tb\";s:0:\"\";s:5:\"paged\";i:0;s:8:\"meta_key\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:7:\"preview\";s:0:\"\";s:1:\"s\";s:0:\"\";s:8:\"sentence\";s:0:\"\";s:5:\"title\";s:0:\"\";s:6:\"fields\";s:0:\"\";s:10:\"menu_order\";s:0:\"\";s:5:\"embed\";s:0:\"\";s:12:\"category__in\";a:0:{}s:16:\"category__not_in\";a:0:{}s:13:\"category__and\";a:0:{}s:12:\"post__not_in\";a:0:{}s:13:\"post_name__in\";a:0:{}s:7:\"tag__in\";a:0:{}s:11:\"tag__not_in\";a:0:{}s:8:\"tag__and\";a:0:{}s:12:\"tag_slug__in\";a:0:{}s:13:\"tag_slug__and\";a:0:{}s:15:\"post_parent__in\";a:0:{}s:19:\"post_parent__not_in\";a:0:{}s:10:\"author__in\";a:0:{}s:14:\"author__not_in\";a:0:{}s:19:\"ignore_sticky_posts\";b:0;s:16:\"suppress_filters\";b:0;s:13:\"cache_results\";b:1;s:22:\"update_post_term_cache\";b:1;s:19:\"lazy_load_term_meta\";b:1;s:22:\"update_post_meta_cache\";b:1;s:8:\"nopaging\";b:0;s:17:\"comments_per_page\";s:2:\"50\";s:13:\"no_found_rows\";b:0;s:5:\"order\";s:4:\"DESC\";}s:9:\"tax_query\";O:12:\"WP_Tax_Query\":6:{s:7:\"queries\";a:0:{}s:8:\"relation\";s:3:\"AND\";s:16:\"\0*\0table_aliases\";a:0:{}s:13:\"queried_terms\";a:0:{}s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";}s:10:\"meta_query\";O:13:\"WP_Meta_Query\":9:{s:7:\"queries\";a:0:{}s:8:\"relation\";N;s:10:\"meta_table\";N;s:14:\"meta_id_column\";N;s:13:\"primary_table\";N;s:17:\"primary_id_column\";N;s:16:\"\0*\0table_aliases\";a:0:{}s:10:\"\0*\0clauses\";a:0:{}s:18:\"\0*\0has_or_relation\";b:0;}s:10:\"date_query\";b:0;s:7:\"request\";s:237:\"SELECT SQL_CALC_FOUND_ROWS  wp_posts.ID FROM wp_posts  WHERE 1=1  AND wp_posts.ID IN (149,141,137) AND wp_posts.post_type = \'estate_property\' AND ((wp_posts.post_status = \'publish\'))  ORDER BY FIELD( wp_posts.ID, 149,141,137 ) LIMIT 0, 3\";s:5:\"posts\";a:3:{i:0;O:7:\"WP_Post\":24:{s:2:\"ID\";i:149;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 10:07:19\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 10:07:19\";s:12:\"post_content\";s:1504:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nبسیاری از حمل و نقل عمومی:\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:52:\"اجاره ویلا در منطقه پاسداران\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:24:\"west-town-3rd-floor-dorm\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2019-01-10 10:21:16\";s:17:\"post_modified_gmt\";s:19:\"2019-01-10 06:51:16\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=149\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:1;O:7:\"WP_Post\":24:{s:2:\"ID\";i:141;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 09:49:37\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 09:49:37\";s:12:\"post_content\";s:1512:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nبسیاری از حمل و نقل عمومی:\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:54:\"اجاره سوئیت ساحلی شیک تریپلکس\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:21:\"modern-spacious-villa\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:33:55\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 11:03:55\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=141\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:2;O:7:\"WP_Post\":24:{s:2:\"ID\";i:137;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 09:41:41\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 09:41:41\";s:12:\"post_content\";s:834:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:52:\"اجاره ویلا در فریدونکار مبله\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:26:\"huge-sunny-villa-east-side\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:08:28\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 10:38:28\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=137\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}}s:10:\"post_count\";i:3;s:12:\"current_post\";i:-1;s:11:\"in_the_loop\";b:0;s:4:\"post\";r:101;s:13:\"comment_count\";i:0;s:15:\"current_comment\";i:-1;s:11:\"found_posts\";s:1:\"3\";s:13:\"max_num_pages\";d:1;s:21:\"max_num_comment_pages\";i:0;s:9:\"is_single\";b:0;s:10:\"is_preview\";b:0;s:7:\"is_page\";b:0;s:10:\"is_archive\";b:1;s:7:\"is_date\";b:0;s:7:\"is_year\";b:0;s:8:\"is_month\";b:0;s:6:\"is_day\";b:0;s:7:\"is_time\";b:0;s:9:\"is_author\";b:0;s:11:\"is_category\";b:0;s:6:\"is_tag\";b:0;s:6:\"is_tax\";b:0;s:9:\"is_search\";b:0;s:7:\"is_feed\";b:0;s:15:\"is_comment_feed\";b:0;s:12:\"is_trackback\";b:0;s:7:\"is_home\";b:0;s:6:\"is_404\";b:0;s:8:\"is_embed\";b:0;s:8:\"is_paged\";b:0;s:8:\"is_admin\";b:0;s:13:\"is_attachment\";b:0;s:11:\"is_singular\";b:0;s:9:\"is_robots\";b:0;s:13:\"is_posts_page\";b:0;s:20:\"is_post_type_archive\";b:1;s:25:\"\0WP_Query\0query_vars_hash\";s:32:\"7a454fb6e4b4f3a03aa8031d12f08067\";s:28:\"\0WP_Query\0query_vars_changed\";b:0;s:17:\"thumbnails_cached\";b:0;s:19:\"\0WP_Query\0stopwords\";N;s:23:\"\0WP_Query\0compat_fields\";a:2:{i:0;s:15:\"query_vars_hash\";i:1;s:18:\"query_vars_changed\";}s:24:\"\0WP_Query\0compat_methods\";a:2:{i:0;s:16:\"init_query_flags\";i:1;s:15:\"parse_tax_query\";}}", "no");
INSERT INTO `wp_options` VALUES("12914", "_transient_timeout_wpestate_recent_posts_pictures_query_estate_property_____8_no_no", "1547251166", "no");
INSERT INTO `wp_options` VALUES("12915", "_transient_wpestate_recent_posts_pictures_query_estate_property_____8_no_no", "O:8:\"WP_Query\":49:{s:5:\"query\";a:9:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:0;s:14:\"posts_per_page\";s:1:\"8\";s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:10:\"meta_value\";s:5:\"order\";s:4:\"DESC\";s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}}s:10:\"query_vars\";a:68:{s:9:\"post_type\";s:15:\"estate_property\";s:11:\"post_status\";s:7:\"publish\";s:5:\"paged\";i:0;s:14:\"posts_per_page\";i:8;s:8:\"meta_key\";s:13:\"prop_featured\";s:7:\"orderby\";s:10:\"meta_value\";s:5:\"order\";s:4:\"DESC\";s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:4:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:5:\"error\";s:0:\"\";s:1:\"m\";s:0:\"\";s:1:\"p\";i:0;s:11:\"post_parent\";s:0:\"\";s:7:\"subpost\";s:0:\"\";s:10:\"subpost_id\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:13:\"attachment_id\";i:0;s:4:\"name\";s:0:\"\";s:6:\"static\";s:0:\"\";s:8:\"pagename\";s:0:\"\";s:7:\"page_id\";i:0;s:6:\"second\";s:0:\"\";s:6:\"minute\";s:0:\"\";s:4:\"hour\";s:0:\"\";s:3:\"day\";i:0;s:8:\"monthnum\";i:0;s:4:\"year\";i:0;s:1:\"w\";i:0;s:13:\"category_name\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:3:\"cat\";s:0:\"\";s:6:\"tag_id\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"author_name\";s:0:\"\";s:4:\"feed\";s:0:\"\";s:2:\"tb\";s:0:\"\";s:10:\"meta_value\";s:0:\"\";s:7:\"preview\";s:0:\"\";s:1:\"s\";s:0:\"\";s:8:\"sentence\";s:0:\"\";s:5:\"title\";s:0:\"\";s:6:\"fields\";s:0:\"\";s:10:\"menu_order\";s:0:\"\";s:5:\"embed\";s:0:\"\";s:12:\"category__in\";a:0:{}s:16:\"category__not_in\";a:0:{}s:13:\"category__and\";a:0:{}s:8:\"post__in\";a:0:{}s:12:\"post__not_in\";a:0:{}s:13:\"post_name__in\";a:0:{}s:7:\"tag__in\";a:0:{}s:11:\"tag__not_in\";a:0:{}s:8:\"tag__and\";a:0:{}s:12:\"tag_slug__in\";a:0:{}s:13:\"tag_slug__and\";a:0:{}s:15:\"post_parent__in\";a:0:{}s:19:\"post_parent__not_in\";a:0:{}s:10:\"author__in\";a:0:{}s:14:\"author__not_in\";a:0:{}s:19:\"ignore_sticky_posts\";b:0;s:16:\"suppress_filters\";b:0;s:13:\"cache_results\";b:1;s:22:\"update_post_term_cache\";b:1;s:19:\"lazy_load_term_meta\";b:1;s:22:\"update_post_meta_cache\";b:1;s:8:\"nopaging\";b:0;s:17:\"comments_per_page\";s:2:\"50\";s:13:\"no_found_rows\";b:0;}s:9:\"tax_query\";O:12:\"WP_Tax_Query\":6:{s:7:\"queries\";a:0:{}s:8:\"relation\";s:3:\"AND\";s:16:\"\0*\0table_aliases\";a:0:{}s:13:\"queried_terms\";a:0:{}s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";}s:10:\"meta_query\";O:13:\"WP_Meta_Query\":9:{s:7:\"queries\";a:2:{i:0;a:1:{s:3:\"key\";s:13:\"prop_featured\";}s:8:\"relation\";s:2:\"OR\";}s:8:\"relation\";s:3:\"AND\";s:10:\"meta_table\";s:11:\"wp_postmeta\";s:14:\"meta_id_column\";s:7:\"post_id\";s:13:\"primary_table\";s:8:\"wp_posts\";s:17:\"primary_id_column\";s:2:\"ID\";s:16:\"\0*\0table_aliases\";a:1:{i:0;s:11:\"wp_postmeta\";}s:10:\"\0*\0clauses\";a:1:{s:11:\"wp_postmeta\";a:4:{s:3:\"key\";s:13:\"prop_featured\";s:7:\"compare\";s:1:\"=\";s:5:\"alias\";s:11:\"wp_postmeta\";s:4:\"cast\";s:4:\"CHAR\";}}s:18:\"\0*\0has_or_relation\";b:0;}s:10:\"date_query\";b:0;s:7:\"request\";s:350:\"SELECT SQL_CALC_FOUND_ROWS  wp_posts.ID FROM wp_posts  INNER JOIN wp_postmeta ON ( wp_posts.ID = wp_postmeta.post_id ) WHERE 1=1  AND ( \n  wp_postmeta.meta_key = \'prop_featured\'\n) AND wp_posts.post_type = \'estate_property\' AND ((wp_posts.post_status = \'publish\')) GROUP BY wp_posts.ID ORDER BY wp_postmeta.meta_value DESC, wp_posts.ID DESC LIMIT 0, 8\";s:5:\"posts\";a:8:{i:0;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2581;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 12:08:38\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 12:08:38\";s:12:\"post_content\";s:832:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:56:\"اجاره ویلا ساحلی در فریدونکنار\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:160:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d9%88%db%8c%d9%84%d8%a7-%d8%b3%d8%a7%d8%ad%d9%84%db%8c-%d8%af%d8%b1-%d9%81%d8%b1%db%8c%d8%af%d9%88%d9%86%da%a9%d9%86%d8%a7%d8%b1\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 11:55:14\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 08:25:14\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=107\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"1\";s:6:\"filter\";s:3:\"raw\";}i:1;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2580;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 11:43:45\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 11:43:45\";s:12:\"post_content\";s:499:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:54:\"اجاره سوئیت ساحلی شیک تریپلکس\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:154:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%b3%d9%88%d8%a6%db%8c%d8%aa-%d8%b3%d8%a7%d8%ad%d9%84%db%8c-%d8%b4%db%8c%da%a9-%d8%aa%d8%b1%db%8c%d9%be%d9%84%da%a9%d8%b3\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-30 10:42:21\";s:17:\"post_modified_gmt\";s:19:\"2018-12-30 07:12:21\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=101\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:2;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2579;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-14 10:14:51\";s:13:\"post_date_gmt\";s:19:\"2015-04-14 10:14:51\";s:12:\"post_content\";s:1512:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nبسیاری از حمل و نقل عمومی:\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:48:\"اجاره یک واحد آپارتمای شیک\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:136:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%db%8c%da%a9-%d9%88%d8%a7%d8%ad%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%db%8c-%d8%b4%db%8c%da%a9\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:05:07\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 10:35:07\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:63:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=10\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:3;O:7:\"WP_Post\":24:{s:2:\"ID\";i:137;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 09:41:41\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 09:41:41\";s:12:\"post_content\";s:834:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:52:\"اجاره ویلا در فریدونکار مبله\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:26:\"huge-sunny-villa-east-side\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:08:28\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 10:38:28\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=137\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:4;O:7:\"WP_Post\":24:{s:2:\"ID\";i:119;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 14:15:03\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 14:15:03\";s:12:\"post_content\";s:834:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:66:\"اجاره خانه کاملا مبله در الهیه تهران\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:28:\"beautiful-cabin-simple-price\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-05 11:03:46\";s:17:\"post_modified_gmt\";s:19:\"2018-12-05 12:03:46\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=119\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:5;O:7:\"WP_Post\":24:{s:2:\"ID\";i:115;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 14:06:21\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 14:06:21\";s:12:\"post_content\";s:832:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\n\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\";s:10:\"post_title\";s:72:\"اجاره اطاق مسکونی تمام مبله در پاسداران\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:23:\"victorian-bed-breakfast\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-28 21:00:04\";s:17:\"post_modified_gmt\";s:19:\"2018-12-28 17:30:04\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=115\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:6;O:7:\"WP_Post\":24:{s:2:\"ID\";i:107;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-15 12:08:38\";s:13:\"post_date_gmt\";s:19:\"2015-04-15 12:08:38\";s:12:\"post_content\";s:1512:\"لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nلورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.\r\n\r\nبسیاری از حمل و نقل عمومی:\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\r\n*صفحه گرافیکی خود را صفحه‌آرایی می‌کنند تا مرحله طراحی و صفحه‌بندی را به پایان برند.\";s:10:\"post_title\";s:51:\"اجاره ویلا در فرمانیه خ لادن\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:4:\"open\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:30:\"sunny-2-bedrooms-in-the-haight\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-16 14:16:38\";s:17:\"post_modified_gmt\";s:19:\"2018-12-16 10:46:38\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=107\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"0\";s:6:\"filter\";s:3:\"raw\";}i:7;O:7:\"WP_Post\":24:{s:2:\"ID\";i:2588;s:11:\"post_author\";s:1:\"1\";s:9:\"post_date\";s:19:\"2015-04-16 10:07:19\";s:13:\"post_date_gmt\";s:19:\"2015-04-16 10:07:19\";s:12:\"post_content\";s:587:\"لورم ایپسوم یا طرح‌نما (به انگلیسی: Lorem ipsum) به متنی آزمایشی و بی‌معنی در صنعت چاپ، صفحه‌آرایی و طراحی گرافیک گفته می‌شود. طراح گرافیک از این متن به عنوان عنصری از ترکیب بندی برای پر کردن صفحه و ارایه اولیه شکل ظاهری و کلی طرح سفارش گرفته شده استفاده می نماید، تا از نظر گرافیکی نشانگر چگونگی نوع و اندازه فونت و ظاهر متن باشد.\";s:10:\"post_title\";s:55:\"اجاره اطاق از یک واحد آپارتمان\";s:12:\"post_excerpt\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:14:\"comment_status\";s:4:\"open\";s:11:\"ping_status\";s:6:\"closed\";s:13:\"post_password\";s:0:\"\";s:9:\"post_name\";s:155:\"%d8%a7%d8%ac%d8%a7%d8%b1%d9%87-%d8%a7%d8%b7%d8%a7%d9%82-%d8%a7%d8%b2-%db%8c%da%a9-%d9%88%d8%a7%d8%ad%d8%af-%d8%a2%d9%be%d8%a7%d8%b1%d8%aa%d9%85%d8%a7%d9%86\";s:7:\"to_ping\";s:0:\"\";s:6:\"pinged\";s:0:\"\";s:13:\"post_modified\";s:19:\"2018-12-17 07:52:13\";s:17:\"post_modified_gmt\";s:19:\"2018-12-17 04:22:13\";s:21:\"post_content_filtered\";s:0:\"\";s:11:\"post_parent\";i:0;s:4:\"guid\";s:64:\"http://demo1.wprentals.org/?post_type=estate_property&#038;p=149\";s:10:\"menu_order\";i:0;s:9:\"post_type\";s:15:\"estate_property\";s:14:\"post_mime_type\";s:0:\"\";s:13:\"comment_count\";s:1:\"1\";s:6:\"filter\";s:3:\"raw\";}}s:10:\"post_count\";i:8;s:12:\"current_post\";i:-1;s:11:\"in_the_loop\";b:0;s:4:\"post\";r:118;s:13:\"comment_count\";i:0;s:15:\"current_comment\";i:-1;s:11:\"found_posts\";s:2:\"25\";s:13:\"max_num_pages\";d:4;s:21:\"max_num_comment_pages\";i:0;s:9:\"is_single\";b:0;s:10:\"is_preview\";b:0;s:7:\"is_page\";b:0;s:10:\"is_archive\";b:1;s:7:\"is_date\";b:0;s:7:\"is_year\";b:0;s:8:\"is_month\";b:0;s:6:\"is_day\";b:0;s:7:\"is_time\";b:0;s:9:\"is_author\";b:0;s:11:\"is_category\";b:0;s:6:\"is_tag\";b:0;s:6:\"is_tax\";b:0;s:9:\"is_search\";b:0;s:7:\"is_feed\";b:0;s:15:\"is_comment_feed\";b:0;s:12:\"is_trackback\";b:0;s:7:\"is_home\";b:0;s:6:\"is_404\";b:0;s:8:\"is_embed\";b:0;s:8:\"is_paged\";b:0;s:8:\"is_admin\";b:0;s:13:\"is_attachment\";b:0;s:11:\"is_singular\";b:0;s:9:\"is_robots\";b:0;s:13:\"is_posts_page\";b:0;s:20:\"is_post_type_archive\";b:1;s:25:\"\0WP_Query\0query_vars_hash\";s:32:\"ffec633bc2b446578a03ba3c9d84558e\";s:28:\"\0WP_Query\0query_vars_changed\";b:0;s:17:\"thumbnails_cached\";b:0;s:19:\"\0WP_Query\0stopwords\";N;s:23:\"\0WP_Query\0compat_fields\";a:2:{i:0;s:15:\"query_vars_hash\";i:1;s:18:\"query_vars_changed\";}s:24:\"\0WP_Query\0compat_methods\";a:2:{i:0;s:16:\"init_query_flags\";i:1;s:15:\"parse_tax_query\";}}", "no");
INSERT INTO `wp_options` VALUES("12916", "_site_transient_timeout_browser_8689a6d889b430723559d3e9ae450e00", "1547841590", "no");
INSERT INTO `wp_options` VALUES("12917", "_site_transient_browser_8689a6d889b430723559d3e9ae450e00", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"60.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("12918", "_site_transient_timeout_community-events-136e65755c6bdecf012f39dab0e0d199", "1547279996", "no");
INSERT INTO `wp_options` VALUES("12919", "_site_transient_community-events-136e65755c6bdecf012f39dab0e0d199", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"83.123.195.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("12924", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1547248291", "no");
INSERT INTO `wp_options` VALUES("12925", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4539;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:3210;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2605;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2464;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1900;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1709;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1695;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1462;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1420;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1420;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1417;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1348;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1287;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1277;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1128;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1086;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1068;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1044;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:966;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:910;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:841;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:827;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:816;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:752;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:720;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:710;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:704;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:701;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:692;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:682;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:676;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:673;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:654;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:648;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:636;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:632;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:622;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:612;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:611;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:607;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:575;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:561;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:554;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:552;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:551;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:543;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:528;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:522;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:521;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:521;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:515;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:506;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:500;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:491;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:490;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:486;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:468;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:468;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:462;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:455;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:451;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:450;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:448;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:429;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:429;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:424;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:419;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:417;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:412;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:399;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:393;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:392;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:382;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:377;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:376;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:374;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:373;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:373;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:360;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:358;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:357;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:353;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:350;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:346;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:343;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:341;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:339;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:335;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:322;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:319;}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";i:318;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:315;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:314;}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";i:311;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:309;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:306;}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";i:306;}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";i:304;}s:6:\"author\";a:3:{s:4:\"name\";s:6:\"author\";s:4:\"slug\";s:6:\"author\";s:5:\"count\";i:303;}s:7:\"adsense\";a:3:{s:4:\"name\";s:7:\"adsense\";s:4:\"slug\";s:7:\"adsense\";s:5:\"count\";i:303;}}", "no");
INSERT INTO `wp_options` VALUES("12927", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1547271660;s:7:\"checked\";a:17:{s:19:\"akismet/akismet.php\";s:3:\"4.1\";s:25:\"duplicator/duplicator.php\";s:5:\"1.3.2\";s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:5:\"4.5.3\";s:47:\"file-manager-advanced/file_manager_advanced.php\";s:3:\"2.2\";s:9:\"hello.php\";s:3:\"1.6\";s:23:\"loco-translate/loco.php\";s:5:\"2.2.0\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:5:\"2.5.1\";s:31:\"custom-css-js/custom-css-js.php\";s:4:\"3.22\";s:23:\"revslider/revslider.php\";s:5:\"5.4.8\";s:33:\"string-locator/string-locator.php\";s:5:\"2.3.1\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:6:\"3.17.0\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.6.4\";s:23:\"wp-jalali/wp-jalali.php\";s:5:\"5.0.1\";s:29:\"wp-parsidate/wp-parsidate.php\";s:5:\"2.3.4\";s:27:\"js_composer/js_composer.php\";s:3:\"5.6\";s:33:\"wprentals-core/wprentals-core.php\";s:3:\"2.2\";s:29:\"wprental-sms/wprental-sms.php\";s:3:\"1.0\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:12:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"4.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.4.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.3.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}}s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:34:\"w.org/plugins/ewww-image-optimizer\";s:4:\"slug\";s:20:\"ewww-image-optimizer\";s:6:\"plugin\";s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:11:\"new_version\";s:5:\"4.5.3\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/ewww-image-optimizer/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/ewww-image-optimizer.4.5.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/ewww-image-optimizer/assets/icon-256x256.png?rev=1582276\";s:2:\"1x\";s:73:\"https://ps.w.org/ewww-image-optimizer/assets/icon-128x128.png?rev=1582276\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/ewww-image-optimizer/assets/banner-1544x500.jpg?rev=1582276\";s:2:\"1x\";s:75:\"https://ps.w.org/ewww-image-optimizer/assets/banner-772x250.jpg?rev=1582276\";}s:11:\"banners_rtl\";a:0:{}}s:47:\"file-manager-advanced/file_manager_advanced.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:35:\"w.org/plugins/file-manager-advanced\";s:4:\"slug\";s:21:\"file-manager-advanced\";s:6:\"plugin\";s:47:\"file-manager-advanced/file_manager_advanced.php\";s:11:\"new_version\";s:3:\"2.2\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/file-manager-advanced/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/file-manager-advanced.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:74:\"https://ps.w.org/file-manager-advanced/assets/icon-128x128.png?rev=1947474\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/file-manager-advanced/assets/banner-772x250.png?rev=1787731\";}s:11:\"banners_rtl\";a:0:{}}s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"loco-translate/loco.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/loco-translate\";s:4:\"slug\";s:14:\"loco-translate\";s:6:\"plugin\";s:23:\"loco-translate/loco.php\";s:11:\"new_version\";s:5:\"2.2.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/loco-translate/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/loco-translate.2.2.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-256x256.png?rev=1000676\";s:2:\"1x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-128x128.png?rev=1000676\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/loco-translate/assets/banner-772x250.jpg?rev=745046\";}s:11:\"banners_rtl\";a:0:{}}s:47:\"one-click-demo-import/one-click-demo-import.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:35:\"w.org/plugins/one-click-demo-import\";s:4:\"slug\";s:21:\"one-click-demo-import\";s:6:\"plugin\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:11:\"new_version\";s:5:\"2.5.1\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/one-click-demo-import/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/one-click-demo-import.2.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-256x256.png?rev=1694310\";s:2:\"1x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-128x128.png?rev=1694310\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/one-click-demo-import/assets/banner-1544x500.png?rev=1694310\";s:2:\"1x\";s:76:\"https://ps.w.org/one-click-demo-import/assets/banner-772x250.png?rev=1694310\";}s:11:\"banners_rtl\";a:0:{}}s:31:\"custom-css-js/custom-css-js.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/custom-css-js\";s:4:\"slug\";s:13:\"custom-css-js\";s:6:\"plugin\";s:31:\"custom-css-js/custom-css-js.php\";s:11:\"new_version\";s:4:\"3.22\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/custom-css-js/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/custom-css-js.3.22.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/custom-css-js/assets/icon-128x128.png?rev=1303730\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/custom-css-js/assets/banner-1544x500.png?rev=1770945\";s:2:\"1x\";s:68:\"https://ps.w.org/custom-css-js/assets/banner-772x250.png?rev=1303730\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"string-locator/string-locator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/string-locator\";s:4:\"slug\";s:14:\"string-locator\";s:6:\"plugin\";s:33:\"string-locator/string-locator.php\";s:11:\"new_version\";s:5:\"2.3.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/string-locator/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/string-locator.2.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/string-locator/assets/icon-256x256.png?rev=1352230\";s:2:\"1x\";s:67:\"https://ps.w.org/string-locator/assets/icon-128x128.png?rev=1352234\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/string-locator/assets/banner-1544x500.png?rev=928605\";s:2:\"1x\";s:68:\"https://ps.w.org/string-locator/assets/banner-772x250.png?rev=928605\";}s:11:\"banners_rtl\";a:0:{}}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:32:\"w.org/plugins/wordpress-importer\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/wordpress-importer/assets/icon-256x256.png?rev=1908375\";s:2:\"1x\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";s:3:\"svg\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"wp-jalali/wp-jalali.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/wp-jalali\";s:4:\"slug\";s:9:\"wp-jalali\";s:6:\"plugin\";s:23:\"wp-jalali/wp-jalali.php\";s:11:\"new_version\";s:5:\"5.0.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wp-jalali/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wp-jalali.5.0.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:61:\"https://ps.w.org/wp-jalali/assets/icon-256x256.png?rev=983015\";s:2:\"1x\";s:61:\"https://ps.w.org/wp-jalali/assets/icon-128x128.png?rev=983015\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:63:\"https://ps.w.org/wp-jalali/assets/banner-772x250.png?rev=982617\";}s:11:\"banners_rtl\";a:0:{}}s:29:\"wp-parsidate/wp-parsidate.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:26:\"w.org/plugins/wp-parsidate\";s:4:\"slug\";s:12:\"wp-parsidate\";s:6:\"plugin\";s:29:\"wp-parsidate/wp-parsidate.php\";s:11:\"new_version\";s:5:\"2.3.4\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-parsidate/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/wp-parsidate.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";s:3:\"svg\";s:57:\"https://ps.w.org/wp-parsidate/assets/icon.svg?rev=1036248\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/wp-parsidate/assets/banner-772x250.jpg?rev=1218577\";}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO `wp_options` VALUES("12928", "_site_transient_timeout_browser_0ac1f9240df96b3586c220faef490724", "1547842376", "no");
INSERT INTO `wp_options` VALUES("12929", "_site_transient_browser_0ac1f9240df96b3586c220faef490724", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"71.0.3578.98\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("12930", "_transient_timeout_feed_9bb54f090b06ea0b52a1a293dcf1b99e", "1547280779", "no");
INSERT INTO `wp_options` VALUES("12931", "_transient_feed_9bb54f090b06ea0b52a1a293dcf1b99e", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"سیاره وردپرس ایران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"http://wp-planet.ir\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jan 2019 15:25:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=4.9.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"آموزش رفع خطای حافظه PHP در وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"http://wp-planet.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d8%b1%d9%81%d8%b9-%d8%ae%d8%b7%d8%a7%db%8c-%d8%ad%d8%a7%d9%81%d8%b8%d9%87-php-%d8%af%d8%b1-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jan 2019 11:00:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:180:\"http://wp-planet.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d8%b1%d9%81%d8%b9-%d8%ae%d8%b7%d8%a7%db%8c-%d8%ad%d8%a7%d9%81%d8%b8%d9%87-php-%d8%af%d8%b1-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1130:\"&#1583;&#1608;&#1587;&#1578;&#1575;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740; &#1575;&#1711;&#1585; &#1607;&#1606;&#1711;&#1575;&#1605; &#1606;&#1589;&#1576; &#1740;&#1705; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1608; &#1740;&#1575; &#1575;&#1662;&#1604;&#1608;&#1583; &#1740;&#1705; &#1601;&#1575;&#1740;&#1604; &#1576;&#1575; &#1582;&#1591;&#1575;&#1740; &#1586;&#1740;&#1585; &#1576;&#1585;&#1582;&#1608;&#1585;&#1583; &#1705;&#1585;&#1583;&#1740;&#1583;: Fatal error: Allowed memory size of 33554432 bytes exhausted (tried to allocate 2348617 bytes) in /home4/xxx/public_html/wp-includes/plugin.php on line xxx &#1576;&#1585;&#1575;&#1740; &#1585;&#1601;&#1593; &#1582;&#1591;&#1575; &#1605;&#1585;&#1575;&#1581;&#1604; &#1586;&#1740;&#1585; &#1585;&#1575; &#1576;&#1607; &#1591;&#1608;&#1585; &#1583;&#1602;&#1740;&#1602; &#1575;&#1606;&#1580;&#1575;&#1605; &#1583;&#1607;&#1740;&#1583;. ( &#1605;&#1585;&#1575;&#1581;&#1604; &#1586;&#1740;&#1585; &#1576;&#1585;&#1575;&#1740; &#1575;&#1601;&#1586;&#1575;&#1740;&#1588; &#1601;&#1590;&#1575;&#1740; &#1581;&#1575;&#1601;&#1592;&#1607; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1851:\"<p>&#1583;&#1608;&#1587;&#1578;&#1575;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740; &#1575;&#1711;&#1585; &#1607;&#1606;&#1711;&#1575;&#1605; &#1606;&#1589;&#1576; &#1740;&#1705; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1608; &#1740;&#1575; &#1575;&#1662;&#1604;&#1608;&#1583; &#1740;&#1705; &#1601;&#1575;&#1740;&#1604; &#1576;&#1575; &#1582;&#1591;&#1575;&#1740; &#1586;&#1740;&#1585; &#1576;&#1585;&#1582;&#1608;&#1585;&#1583; &#1705;&#1585;&#1583;&#1740;&#1583;: Fatal error: Allowed memory size of 33554432 bytes exhausted (tried to allocate 2348617 bytes) in /home4/xxx/public_html/wp-includes/plugin.php on line xxx &#1576;&#1585;&#1575;&#1740; &#1585;&#1601;&#1593; &#1582;&#1591;&#1575; &#1605;&#1585;&#1575;&#1581;&#1604; &#1586;&#1740;&#1585; &#1585;&#1575; &#1576;&#1607; &#1591;&#1608;&#1585; &#1583;&#1602;&#1740;&#1602; &#1575;&#1606;&#1580;&#1575;&#1605; &#1583;&#1607;&#1740;&#1583;. ( &#1605;&#1585;&#1575;&#1581;&#1604; &#1586;&#1740;&#1585; &#1576;&#1585;&#1575;&#1740; &#1575;&#1601;&#1586;&#1575;&#1740;&#1588; &#1601;&#1590;&#1575;&#1740; &#1581;&#1575;&#1601;&#1592;&#1607; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3331/%D8%A7%D9%85%D9%88%D8%B2%D8%B4-%D8%B1%D9%81%D8%B9-%D8%AE%D8%B7%D8%A7%DB%8C-%D8%AD%D8%A7%D9%81%D8%B8%D9%87-php-%D8%AF%D8%B1-%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3/\">&#1570;&#1605;&#1608;&#1586;&#1588; &#1585;&#1601;&#1593; &#1582;&#1591;&#1575;&#1740; &#1581;&#1575;&#1601;&#1592;&#1607; PHP &#1583;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"افزایش سئو وردپرس با افزونه Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:173:\"http://wp-planet.ir/%d8%a7%d9%81%d8%b2%d8%a7%db%8c%d8%b4-%d8%b3%d8%a6%d9%88-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d8%a7-%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-yoast-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jan 2019 01:00:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:173:\"http://wp-planet.ir/%d8%a7%d9%81%d8%b2%d8%a7%db%8c%d8%b4-%d8%b3%d8%a6%d9%88-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d8%a7-%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-yoast-seo/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1508:\"&#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1576;&#1740;&#1606; &#1587;&#1740;&#1587;&#1578;&#1605; &#1607;&#1575;&#1740; &#1605;&#1583;&#1740;&#1585;&#1740;&#1578; &#1605;&#1581;&#1578;&#1608;&#1575; &#1575;&#1586; &#1587;&#1574;&#1608; &#1605;&#1606;&#1575;&#1587;&#1576;&#1740; &#1576;&#1585;&#1582;&#1608;&#1585;&#1583;&#1575;&#1585; &#1575;&#1587;&#1578; &#1705;&#1607; &#1576;&#1607; &#1605;&#1585;&#1608;&#1585; &#1608; &#1576;&#1575; &#1576;&#1585;&#1608;&#1586;&#1585;&#1587;&#1575;&#1606;&#1740; &#1607;&#1575;&#1740; &#1605;&#1582;&#1578;&#1604;&#1601; &#1576;&#1585; &#1602;&#1583;&#1585;&#1578; &#1570;&#1606; &#1606;&#1740;&#1586; &#1575;&#1601;&#1586;&#1608;&#1583;&#1607; &#1588;&#1583;&#1607; &#1575;&#1587;&#1578; &#1575;&#1605;&#1575; &#1576;&#1607; &#1583;&#1604;&#1575;&#1740;&#1604; &#1605;&#1582;&#1578;&#1604;&#1601; &#1575;&#1740;&#1606; &#1585;&#1608;&#1606;&#1583; &#1607;&#1585;&#1711;&#1586; &#1575;&#1586; &#1740;&#1705; &#1581;&#1583; &#1582;&#1575;&#1589; &#1601;&#1585;&#1575;&#1578;&#1585; &#1606;&#1585;&#1601;&#1578;&#1607; &#1575;&#1587;&#1578;&#1548; &#1576;&#1607; &#1607;&#1605;&#1740;&#1606; &#1583;&#1604;&#1740;&#1604; &#1605;&#1583;&#1740;&#1585;&#1575;&#1606; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1607;&#1575; &#1576;&#1585;&#1575;&#1740; &#1576;&#1607;&#1740;&#1606;&#1607; &#1587;&#1575;&#1586;&#1740; &#1587;&#1575;&#1740;&#1578; &#1607;&#1605;&#1575;&#1606;&#1606;&#1583; &#1575;&#1705;&#1579;&#1585;&#1607;&#1575; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2213:\"<p>&#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1576;&#1740;&#1606; &#1587;&#1740;&#1587;&#1578;&#1605; &#1607;&#1575;&#1740; &#1605;&#1583;&#1740;&#1585;&#1740;&#1578; &#1605;&#1581;&#1578;&#1608;&#1575; &#1575;&#1586; &#1587;&#1574;&#1608; &#1605;&#1606;&#1575;&#1587;&#1576;&#1740; &#1576;&#1585;&#1582;&#1608;&#1585;&#1583;&#1575;&#1585; &#1575;&#1587;&#1578; &#1705;&#1607; &#1576;&#1607; &#1605;&#1585;&#1608;&#1585; &#1608; &#1576;&#1575; &#1576;&#1585;&#1608;&#1586;&#1585;&#1587;&#1575;&#1606;&#1740; &#1607;&#1575;&#1740; &#1605;&#1582;&#1578;&#1604;&#1601; &#1576;&#1585; &#1602;&#1583;&#1585;&#1578; &#1570;&#1606; &#1606;&#1740;&#1586; &#1575;&#1601;&#1586;&#1608;&#1583;&#1607; &#1588;&#1583;&#1607; &#1575;&#1587;&#1578; &#1575;&#1605;&#1575; &#1576;&#1607; &#1583;&#1604;&#1575;&#1740;&#1604; &#1605;&#1582;&#1578;&#1604;&#1601; &#1575;&#1740;&#1606; &#1585;&#1608;&#1606;&#1583; &#1607;&#1585;&#1711;&#1586; &#1575;&#1586; &#1740;&#1705; &#1581;&#1583; &#1582;&#1575;&#1589; &#1601;&#1585;&#1575;&#1578;&#1585; &#1606;&#1585;&#1601;&#1578;&#1607; &#1575;&#1587;&#1578;&#1548; &#1576;&#1607; &#1607;&#1605;&#1740;&#1606; &#1583;&#1604;&#1740;&#1604; &#1605;&#1583;&#1740;&#1585;&#1575;&#1606; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1607;&#1575; &#1576;&#1585;&#1575;&#1740; &#1576;&#1607;&#1740;&#1606;&#1607; &#1587;&#1575;&#1586;&#1740; &#1587;&#1575;&#1740;&#1578; &#1607;&#1605;&#1575;&#1606;&#1606;&#1583; &#1575;&#1705;&#1579;&#1585;&#1607;&#1575; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3427/%D8%A7%D9%81%D8%B2%D8%A7%DB%8C%D8%B4-%D8%B3%D8%A6%D9%88-%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3-%D8%A8%D8%A7-%D8%A7%D9%81%D8%B2%D9%88%D9%86%D9%87-yoast-seo/\">&#1575;&#1601;&#1586;&#1575;&#1740;&#1588; &#1587;&#1574;&#1608; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; Yoast SEO</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"افزایش سئو وردپرس با پیکربندی صحیح افزونه های سئو\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"http://wp-planet.ir/%d8%a7%d9%81%d8%b2%d8%a7%db%8c%d8%b4-%d8%b3%d8%a6%d9%88-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d8%a7-%d9%be%db%8c%da%a9%d8%b1%d8%a8%d9%86%d8%af%db%8c-%d8%b5%d8%ad%db%8c%d8%ad-%d8%a7%d9%81%d8%b2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Jan 2019 11:00:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"http://wp-planet.ir/%d8%a7%d9%81%d8%b2%d8%a7%db%8c%d8%b4-%d8%b3%d8%a6%d9%88-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d8%a7-%d9%be%db%8c%da%a9%d8%b1%d8%a8%d9%86%d8%af%db%8c-%d8%b5%d8%ad%db%8c%d8%ad-%d8%a7%d9%81%d8%b2/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1355:\"&#1740;&#1705;&#1740; &#1575;&#1586; &#1575;&#1589;&#1604;&#1740; &#1578;&#1585;&#1740;&#1606; &#1608; &#1605;&#1581;&#1608;&#1585;&#1740; &#1578;&#1585;&#1740;&#1606; &#1576;&#1582;&#1588; &#1607;&#1575;&#1740; &#1607;&#1585; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1575;&#1593;&#1605; &#1575;&#1586; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740; &#1576;&#1608;&#1583;&#1606; &#1740;&#1575; &#1606;&#1576;&#1608;&#1583;&#1606; &#1548; &#1605;&#1576;&#1581;&#1579; &#1587;&#1574;&#1608;&#1740; &#1570;&#1606; &#1605;&#1740; &#1576;&#1575;&#1588;&#1583; . &#1583;&#1585; &#1576;&#1585;&#1582;&#1740; &#1605;&#1608;&#1575;&#1585;&#1583; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1605;&#1740; &#1588;&#1608;&#1583; &#1705;&#1607; &#1576;&#1607; &#1583;&#1604;&#1740;&#1604; &#1593;&#1583;&#1605; &#1662;&#1740;&#1705;&#1585;&#1576;&#1606;&#1583;&#1740; &#1589;&#1581;&#1740;&#1581; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1607;&#1575;&#1740; &#1587;&#1574;&#1608; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#160;&#1548; &#1606;&#1578;&#1575;&#1740;&#1580; &#1605;&#1593;&#1705;&#1608;&#1587;&#1740; &#1585;&#1582; &#1583;&#1575;&#1583;&#1607; &#1705;&#1607; &#1576;&#1575;&#1593;&#1579; &#1575;&#1601;&#1578; &#1587;&#1574;&#1608; &#1587;&#1575;&#1740;&#1578; &#1606;&#1740;&#1586; &#1605;&#1740; &#1588;&#1608;&#1583; . [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2228:\"<p>&#1740;&#1705;&#1740; &#1575;&#1586; &#1575;&#1589;&#1604;&#1740; &#1578;&#1585;&#1740;&#1606; &#1608; &#1605;&#1581;&#1608;&#1585;&#1740; &#1578;&#1585;&#1740;&#1606; &#1576;&#1582;&#1588; &#1607;&#1575;&#1740; &#1607;&#1585; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1575;&#1593;&#1605; &#1575;&#1586; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740; &#1576;&#1608;&#1583;&#1606; &#1740;&#1575; &#1606;&#1576;&#1608;&#1583;&#1606; &#1548; &#1605;&#1576;&#1581;&#1579; &#1587;&#1574;&#1608;&#1740; &#1570;&#1606; &#1605;&#1740; &#1576;&#1575;&#1588;&#1583; . &#1583;&#1585; &#1576;&#1585;&#1582;&#1740; &#1605;&#1608;&#1575;&#1585;&#1583; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1605;&#1740; &#1588;&#1608;&#1583; &#1705;&#1607; &#1576;&#1607; &#1583;&#1604;&#1740;&#1604; &#1593;&#1583;&#1605; &#1662;&#1740;&#1705;&#1585;&#1576;&#1606;&#1583;&#1740; &#1589;&#1581;&#1740;&#1581; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1607;&#1575;&#1740; &#1587;&#1574;&#1608; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&nbsp;&#1548; &#1606;&#1578;&#1575;&#1740;&#1580; &#1605;&#1593;&#1705;&#1608;&#1587;&#1740; &#1585;&#1582; &#1583;&#1575;&#1583;&#1607; &#1705;&#1607; &#1576;&#1575;&#1593;&#1579; &#1575;&#1601;&#1578; &#1587;&#1574;&#1608; &#1587;&#1575;&#1740;&#1578; &#1606;&#1740;&#1586; &#1605;&#1740; &#1588;&#1608;&#1583; . [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3453/%D8%A7%D9%81%D8%B2%D8%A7%DB%8C%D8%B4-%D8%B3%D8%A6%D9%88-%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3-%D8%A8%D8%A7-%D9%BE%DB%8C%DA%A9%D8%B1%D8%A8%D9%86%D8%AF%DB%8C-%D8%B5%D8%AD%DB%8C%D8%AD-%D8%A7%D9%81%D8%B2-4/\">&#1575;&#1601;&#1586;&#1575;&#1740;&#1588; &#1587;&#1574;&#1608; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575; &#1662;&#1740;&#1705;&#1585;&#1576;&#1606;&#1583;&#1740; &#1589;&#1581;&#1740;&#1581; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1607;&#1575;&#1740; &#1587;&#1574;&#1608;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"یادگیری سطح دسترسی یا مجوز فایل های وردپرس ، یکبار برای همیشه\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:220:\"http://wp-planet.ir/%db%8c%d8%a7%d8%af%da%af%db%8c%d8%b1%db%8c-%d8%b3%d8%b7%d8%ad-%d8%af%d8%b3%d8%aa%d8%b1%d8%b3%db%8c-%db%8c%d8%a7-%d9%85%d8%ac%d9%88%d8%b2-%d9%81%d8%a7%db%8c%d9%84-%d9%87%d8%a7%db%8c-%d9%88%d8%b1%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Jan 2019 07:00:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:220:\"http://wp-planet.ir/%db%8c%d8%a7%d8%af%da%af%db%8c%d8%b1%db%8c-%d8%b3%d8%b7%d8%ad-%d8%af%d8%b3%d8%aa%d8%b1%d8%b3%db%8c-%db%8c%d8%a7-%d9%85%d8%ac%d9%88%d8%b2-%d9%81%d8%a7%db%8c%d9%84-%d9%87%d8%a7%db%8c-%d9%88%d8%b1%d8%af/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1433:\"&#1587;&#1591;&#1581; &#1583;&#1587;&#1578;&#1585;&#1587;&#1740; &#1601;&#1575;&#1740;&#1604; &#1607;&#1575; &#1608; &#1662;&#1608;&#1588;&#1607; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1606;&#1602;&#1588; &#1575;&#1587;&#1575;&#1587;&#1740; &#1583;&#1585; &#1575;&#1605;&#1606;&#1740;&#1578; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740; &#1588;&#1605;&#1575; &#1585;&#1575; &#1576;&#1585; &#1593;&#1607;&#1583;&#1607; &#1583;&#1575;&#1585;&#1606;&#1583; . &#1607;&#1605;&#1740;&#1588;&#1607; &#1578;&#1606;&#1592;&#1740;&#1605; &#1587;&#1591;&#1581; &#1583;&#1587;&#1578;&#1585;&#1587;&#1740; &#1601;&#1575;&#1740;&#1604; &#1607;&#1575; &#1608; &#1662;&#1608;&#1588;&#1607; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575;&#1740;&#1583; &#1576;&#1607; &#1593;&#1606;&#1608;&#1575;&#1606; &#1575;&#1608;&#1604;&#1740;&#1606; &#1705;&#1575;&#1585; &#1576;&#1593;&#1583; &#1575;&#1586; &#1606;&#1589;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1606;&#1592;&#1585; &#1711;&#1585;&#1601;&#1578;&#1607; &#1588;&#1608;&#1583; . &#1583;&#1575;&#1588;&#1578;&#1606; &#1587;&#1591;&#1581; &#1583;&#1587;&#1578;&#1585;&#1587;&#1740; &#1606;&#1575;&#1605;&#1606;&#1575;&#1587;&#1576; &#1576;&#1585;&#1575;&#1740; &#1740;&#1705; &#1601;&#1575;&#1740;&#1604; &#1740;&#1575; &#1740;&#1705; &#1662;&#1608;&#1588;&#1607; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2371:\"<p>&#1587;&#1591;&#1581; &#1583;&#1587;&#1578;&#1585;&#1587;&#1740; &#1601;&#1575;&#1740;&#1604; &#1607;&#1575; &#1608; &#1662;&#1608;&#1588;&#1607; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1606;&#1602;&#1588; &#1575;&#1587;&#1575;&#1587;&#1740; &#1583;&#1585; &#1575;&#1605;&#1606;&#1740;&#1578; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740; &#1588;&#1605;&#1575; &#1585;&#1575; &#1576;&#1585; &#1593;&#1607;&#1583;&#1607; &#1583;&#1575;&#1585;&#1606;&#1583; . &#1607;&#1605;&#1740;&#1588;&#1607; &#1578;&#1606;&#1592;&#1740;&#1605; &#1587;&#1591;&#1581; &#1583;&#1587;&#1578;&#1585;&#1587;&#1740; &#1601;&#1575;&#1740;&#1604; &#1607;&#1575; &#1608; &#1662;&#1608;&#1588;&#1607; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575;&#1740;&#1583; &#1576;&#1607; &#1593;&#1606;&#1608;&#1575;&#1606; &#1575;&#1608;&#1604;&#1740;&#1606; &#1705;&#1575;&#1585; &#1576;&#1593;&#1583; &#1575;&#1586; &#1606;&#1589;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1606;&#1592;&#1585; &#1711;&#1585;&#1601;&#1578;&#1607; &#1588;&#1608;&#1583; . &#1583;&#1575;&#1588;&#1578;&#1606; &#1587;&#1591;&#1581; &#1583;&#1587;&#1578;&#1585;&#1587;&#1740; &#1606;&#1575;&#1605;&#1606;&#1575;&#1587;&#1576; &#1576;&#1585;&#1575;&#1740; &#1740;&#1705; &#1601;&#1575;&#1740;&#1604; &#1740;&#1575; &#1740;&#1705; &#1662;&#1608;&#1588;&#1607; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/2074/%DB%8C%D8%A7%D8%AF%DA%AF%DB%8C%D8%B1%DB%8C-%D8%B3%D8%B7%D8%AD-%D8%AF%D8%B3%D8%AA%D8%B1%D8%B3%DB%8C-%DB%8C%D8%A7-%D9%85%D8%AC%D9%88%D8%B2-%D9%81%D8%A7%DB%8C%D9%84-%D9%87%D8%A7%DB%8C-%D9%88%D8%B1%D8%AF/\">&#1740;&#1575;&#1583;&#1711;&#1740;&#1585;&#1740; &#1587;&#1591;&#1581; &#1583;&#1587;&#1578;&#1585;&#1587;&#1740; &#1740;&#1575; &#1605;&#1580;&#1608;&#1586; &#1601;&#1575;&#1740;&#1604; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1548; &#1740;&#1705;&#1576;&#1575;&#1585; &#1576;&#1585;&#1575;&#1740; &#1607;&#1605;&#1740;&#1588;&#1607;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"ایجاد نسخه پشتیبان از بانک اطلاعاتی وردپرس به صورت دستی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"http://wp-planet.ir/%d8%a7%db%8c%d8%ac%d8%a7%d8%af-%d9%86%d8%b3%d8%ae%d9%87-%d9%be%d8%b4%d8%aa%db%8c%d8%a8%d8%a7%d9%86-%d8%a7%d8%b2-%d8%a8%d8%a7%d9%86%da%a9-%d8%a7%d8%b7%d9%84%d8%a7%d8%b9%d8%a7%d8%aa%db%8c-%d9%88%d8%b1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Jan 2019 05:00:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"http://wp-planet.ir/%d8%a7%db%8c%d8%ac%d8%a7%d8%af-%d9%86%d8%b3%d8%ae%d9%87-%d9%be%d8%b4%d8%aa%db%8c%d8%a8%d8%a7%d9%86-%d8%a7%d8%b2-%d8%a8%d8%a7%d9%86%da%a9-%d8%a7%d8%b7%d9%84%d8%a7%d8%b9%d8%a7%d8%aa%db%8c-%d9%88%d8%b1/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1341:\"&#1740;&#1705;&#1740; &#1575;&#1586; &#160;&#1576;&#1582;&#1588; &#1607;&#1575;&#1740; &#1576;&#1587;&#1740;&#1575;&#1585; &#1581;&#1587;&#1575;&#1587; &#1608; &#1605;&#1607;&#1605; &#1607;&#1585; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1608; &#1605;&#1582;&#1589;&#1608;&#1589;&#1575;&#1611; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1548; &#1576;&#1575;&#1606;&#1705; &#1575;&#1591;&#1604;&#1575;&#1593;&#1575;&#1578;&#1740; &#1570;&#1606; &#1605;&#1740; &#1576;&#1575;&#1588;&#1583; . &#1575;&#1740;&#1606; &#1576;&#1582;&#1588; &#1607;&#1605; &#1605;&#1575;&#1606;&#1606;&#1583; &#1607;&#1585; &#1605;&#1608;&#1580;&#1608;&#1583;&#1740;&#1578; &#1583;&#1740;&#1711;&#1585;&#1740; &#1583;&#1585; &#1583;&#1606;&#1740;&#1575;&#1740; &#1605;&#1580;&#1575;&#1586;&#1740; &#1575;&#1586; &#1570;&#1587;&#1740;&#1576; &#1583;&#1585; &#1575;&#1605;&#1575;&#1606; &#1606;&#1740;&#1587;&#1578; . &#1662;&#1587; &#1576;&#1575;&#1740;&#1583; &#1576;&#1585;&#1575;&#1740; &#1580;&#1604;&#1608;&#1711;&#1740;&#1585;&#1740; &#1575;&#1586; &#1589;&#1583;&#1605;&#1607; &#1583;&#1740;&#1583;&#1606; &#1608; &#1576;&#1575;&#1586;&#1740;&#1575;&#1576;&#1740; &#1570;&#1606; &#1576;&#1593;&#1583; &#1575;&#1586; &#1570;&#1587;&#1740;&#1576; &#1607;&#1575;&#1740; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2248:\"<p>&#1740;&#1705;&#1740; &#1575;&#1586; &nbsp;&#1576;&#1582;&#1588; &#1607;&#1575;&#1740; &#1576;&#1587;&#1740;&#1575;&#1585; &#1581;&#1587;&#1575;&#1587; &#1608; &#1605;&#1607;&#1605; &#1607;&#1585; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1608; &#1605;&#1582;&#1589;&#1608;&#1589;&#1575;&#1611; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1548; &#1576;&#1575;&#1606;&#1705; &#1575;&#1591;&#1604;&#1575;&#1593;&#1575;&#1578;&#1740; &#1570;&#1606; &#1605;&#1740; &#1576;&#1575;&#1588;&#1583; . &#1575;&#1740;&#1606; &#1576;&#1582;&#1588; &#1607;&#1605; &#1605;&#1575;&#1606;&#1606;&#1583; &#1607;&#1585; &#1605;&#1608;&#1580;&#1608;&#1583;&#1740;&#1578; &#1583;&#1740;&#1711;&#1585;&#1740; &#1583;&#1585; &#1583;&#1606;&#1740;&#1575;&#1740; &#1605;&#1580;&#1575;&#1586;&#1740; &#1575;&#1586; &#1570;&#1587;&#1740;&#1576; &#1583;&#1585; &#1575;&#1605;&#1575;&#1606; &#1606;&#1740;&#1587;&#1578; . &#1662;&#1587; &#1576;&#1575;&#1740;&#1583; &#1576;&#1585;&#1575;&#1740; &#1580;&#1604;&#1608;&#1711;&#1740;&#1585;&#1740; &#1575;&#1586; &#1589;&#1583;&#1605;&#1607; &#1583;&#1740;&#1583;&#1606; &#1608; &#1576;&#1575;&#1586;&#1740;&#1575;&#1576;&#1740; &#1570;&#1606; &#1576;&#1593;&#1583; &#1575;&#1586; &#1570;&#1587;&#1740;&#1576; &#1607;&#1575;&#1740; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/2100/%D8%A7%DB%8C%D8%AC%D8%A7%D8%AF-%D9%86%D8%B3%D8%AE%D9%87-%D9%BE%D8%B4%D8%AA%DB%8C%D8%A8%D8%A7%D9%86-%D8%A7%D8%B2-%D8%A8%D8%A7%D9%86%DA%A9-%D8%A7%D8%B7%D9%84%D8%A7%D8%B9%D8%A7%D8%AA%DB%8C-%D9%88%D8%B1/\">&#1575;&#1740;&#1580;&#1575;&#1583; &#1606;&#1587;&#1582;&#1607; &#1662;&#1588;&#1578;&#1740;&#1576;&#1575;&#1606; &#1575;&#1586; &#1576;&#1575;&#1606;&#1705; &#1575;&#1591;&#1604;&#1575;&#1593;&#1575;&#1578;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1607; &#1589;&#1608;&#1585;&#1578; &#1583;&#1587;&#1578;&#1740;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"افزونه AddToAny وردپرس برای اشتراک گذاری در شبکه های اجتماعی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:216:\"http://wp-planet.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-addtoany-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d8%b1%d8%a7%db%8c-%d8%a7%d8%b4%d8%aa%d8%b1%d8%a7%da%a9-%da%af%d8%b0%d8%a7%d8%b1%db%8c-%d8%af%d8%b1-%d8%b4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Jan 2019 01:00:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:216:\"http://wp-planet.ir/%d8%a7%d9%81%d8%b2%d9%88%d9%86%d9%87-addtoany-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d8%b1%d8%a7%db%8c-%d8%a7%d8%b4%d8%aa%d8%b1%d8%a7%da%a9-%da%af%d8%b0%d8%a7%d8%b1%db%8c-%d8%af%d8%b1-%d8%b4/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1545:\"&#1575;&#1588;&#1578;&#1585;&#1575;&#1705; &#1711;&#1584;&#1575;&#1585;&#1740; &#1605;&#1591;&#1575;&#1604;&#1576; &#1583;&#1585; &#1588;&#1576;&#1705;&#1607; &#1607;&#1575;&#1740; &#1575;&#1580;&#1578;&#1605;&#1575;&#1593;&#1740; &#1583;&#1585; &#1575;&#1601;&#1586;&#1575;&#1740;&#1588; &#1576;&#1575;&#1586;&#1583;&#1740;&#1583; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1607;&#1575; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1583; &#1576;&#1587;&#1740;&#1575;&#1585; &#1605;&#1608;&#1579;&#1585; &#1576;&#1575;&#1588;&#1583;. &#1575;&#1605;&#1575; &#1576;&#1585;&#1575;&#1740; &#1575;&#1740;&#1606;&#1705;&#1607; &#1740;&#1705; &#1605;&#1581;&#1578;&#1608;&#1575; &#1583;&#1585; &#1588;&#1576;&#1705;&#1607; &#1607;&#1575;&#1740; &#1575;&#1580;&#1578;&#1605;&#1575;&#1593;&#1740; &#1576;&#1607; &#1575;&#1588;&#1578;&#1585;&#1575;&#1705; &#1711;&#1584;&#1575;&#1588;&#1578;&#1607; &#1588;&#1608;&#1583; &#1605;&#1608;&#1575;&#1585;&#1583;&#1740; &#1607;&#1587;&#1578;&#1606;&#1583; &#1705;&#1607; &#1576;&#1575;&#1740;&#1583; &#1585;&#1593;&#1575;&#1740;&#1578; &#1588;&#1608;&#1583; &#1608; &#1740;&#1705;&#1740; &#1575;&#1586; &#1570;&#1606;&#1607;&#1575; &#1608;&#1580;&#1608;&#1583; &#1583;&#1705;&#1605;&#1607; &#1607;&#1575;&#1740; &#1576;&#1607; &#1575;&#1588;&#1578;&#1585;&#1575;&#1705; &#1711;&#1584;&#1575;&#1585;&#1740; &#1575;&#1587;&#1578;. &#1576;&#1575; &#1575;&#1740;&#1606;&#1705;&#1607; &#1605;&#1581;&#1578;&#1608;&#1575; &#1583;&#1585; &#1576;&#1607; &#1575;&#1588;&#1578;&#1585;&#1575;&#1705; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2436:\"<p>&#1575;&#1588;&#1578;&#1585;&#1575;&#1705; &#1711;&#1584;&#1575;&#1585;&#1740; &#1605;&#1591;&#1575;&#1604;&#1576; &#1583;&#1585; &#1588;&#1576;&#1705;&#1607; &#1607;&#1575;&#1740; &#1575;&#1580;&#1578;&#1605;&#1575;&#1593;&#1740; &#1583;&#1585; &#1575;&#1601;&#1586;&#1575;&#1740;&#1588; &#1576;&#1575;&#1586;&#1583;&#1740;&#1583; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1607;&#1575; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1583; &#1576;&#1587;&#1740;&#1575;&#1585; &#1605;&#1608;&#1579;&#1585; &#1576;&#1575;&#1588;&#1583;. &#1575;&#1605;&#1575; &#1576;&#1585;&#1575;&#1740; &#1575;&#1740;&#1606;&#1705;&#1607; &#1740;&#1705; &#1605;&#1581;&#1578;&#1608;&#1575; &#1583;&#1585; &#1588;&#1576;&#1705;&#1607; &#1607;&#1575;&#1740; &#1575;&#1580;&#1578;&#1605;&#1575;&#1593;&#1740; &#1576;&#1607; &#1575;&#1588;&#1578;&#1585;&#1575;&#1705; &#1711;&#1584;&#1575;&#1588;&#1578;&#1607; &#1588;&#1608;&#1583; &#1605;&#1608;&#1575;&#1585;&#1583;&#1740; &#1607;&#1587;&#1578;&#1606;&#1583; &#1705;&#1607; &#1576;&#1575;&#1740;&#1583; &#1585;&#1593;&#1575;&#1740;&#1578; &#1588;&#1608;&#1583; &#1608; &#1740;&#1705;&#1740; &#1575;&#1586; &#1570;&#1606;&#1607;&#1575; &#1608;&#1580;&#1608;&#1583; &#1583;&#1705;&#1605;&#1607; &#1607;&#1575;&#1740; &#1576;&#1607; &#1575;&#1588;&#1578;&#1585;&#1575;&#1705; &#1711;&#1584;&#1575;&#1585;&#1740; &#1575;&#1587;&#1578;. &#1576;&#1575; &#1575;&#1740;&#1606;&#1705;&#1607; &#1605;&#1581;&#1578;&#1608;&#1575; &#1583;&#1585; &#1576;&#1607; &#1575;&#1588;&#1578;&#1585;&#1575;&#1705; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3351/%D8%A7%D9%81%D8%B2%D9%88%D9%86%D9%87-addtoany-%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3-%D8%A8%D8%B1%D8%A7%DB%8C-%D8%A7%D8%B4%D8%AA%D8%B1%D8%A7%DA%A9-%DA%AF%D8%B0%D8%A7%D8%B1%DB%8C-%D8%AF%D8%B1-%D8%B4/\">&#1575;&#1601;&#1586;&#1608;&#1606;&#1607; AddToAny &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1585;&#1575;&#1740; &#1575;&#1588;&#1578;&#1585;&#1575;&#1705; &#1711;&#1584;&#1575;&#1585;&#1740; &#1583;&#1585; &#1588;&#1576;&#1705;&#1607; &#1607;&#1575;&#1740; &#1575;&#1580;&#1578;&#1605;&#1575;&#1593;&#1740;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"آموزش نمایش تعداد دفعات بازدید و نظرات یک مطلب در وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"http://wp-planet.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%aa%d8%b9%d8%af%d8%a7%d8%af-%d8%af%d9%81%d8%b9%d8%a7%d8%aa-%d8%a8%d8%a7%d8%b2%d8%af%db%8c%d8%af-%d9%88-%d9%86%d8%b8%d8%b1%d8%a7%d8%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Jan 2019 07:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"http://wp-planet.ir/%d8%a2%d9%85%d9%88%d8%b2%d8%b4-%d9%86%d9%85%d8%a7%db%8c%d8%b4-%d8%aa%d8%b9%d8%af%d8%a7%d8%af-%d8%af%d9%81%d8%b9%d8%a7%d8%aa-%d8%a8%d8%a7%d8%b2%d8%af%db%8c%d8%af-%d9%88-%d9%86%d8%b8%d8%b1%d8%a7%d8%aa/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1463:\"&#1606;&#1605;&#1575;&#1740;&#1588; &#1570;&#1605;&#1575;&#1585; &#1740;&#1705; &#1605;&#1591;&#1604;&#1576; ( &#1576;&#1575;&#1586;&#1583;&#1740;&#1583; &#1608; &#1606;&#1592;&#1585;&#1575;&#1578;) &#1576;&#1607;&#1578;&#1585;&#1740;&#1606; &#1575;&#1576;&#1586;&#1575;&#1585; &#1576;&#1585;&#1575;&#1740; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1606;&#1578;&#1740;&#1580;&#1607; &#1605;&#1591;&#1604;&#1576; &#1588;&#1605;&#1575; &#1605;&#1740; &#1576;&#1575;&#1588;&#1583;. &#1608; &#1575;&#1586; &#1575;&#1740;&#1606; &#1591;&#1585;&#1740;&#1602; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583; &#1576;&#1601;&#1607;&#1605;&#1740;&#1583; &#1670;&#1607; &#1605;&#1591;&#1604;&#1576;&#1740; &#1575;&#1586; &#1588;&#1605;&#1575; &#1662;&#1585; &#1576;&#1575;&#1586;&#1583;&#1740;&#1583;&#1578;&#1585; &#1576;&#1608;&#1583;&#1607; &#1608; &#1605;&#1608;&#1585;&#1583; &#1578;&#1608;&#1580;&#1607; &#1602;&#1585;&#1575;&#1585; &#1711;&#1585;&#1601;&#1578;&#1607; &#1608; &#1607;&#1605;&#1670;&#1606;&#1740;&#1606; &#1578;&#1593;&#1583;&#1575;&#1583; &#1606;&#1592;&#1585;&#1575;&#1578;&#1740; &#1705;&#1607; &#1576;&#1585;&#1575;&#1740; &#1570;&#1606; &#1605;&#1591;&#1604;&#1576; &#1606;&#1608;&#1588;&#1578;&#1607; &#1588;&#1583;&#1607; &#1575;&#1587;&#1578; &#1585;&#1575; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1705;&#1606;&#1740;&#1583;. &#1583;&#1585; &#1575;&#1740;&#1606; &#1602;&#1587;&#1605;&#1578; &#1705;&#1583; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2371:\"<p>&#1606;&#1605;&#1575;&#1740;&#1588; &#1570;&#1605;&#1575;&#1585; &#1740;&#1705; &#1605;&#1591;&#1604;&#1576; ( &#1576;&#1575;&#1586;&#1583;&#1740;&#1583; &#1608; &#1606;&#1592;&#1585;&#1575;&#1578;) &#1576;&#1607;&#1578;&#1585;&#1740;&#1606; &#1575;&#1576;&#1586;&#1575;&#1585; &#1576;&#1585;&#1575;&#1740; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1606;&#1578;&#1740;&#1580;&#1607; &#1605;&#1591;&#1604;&#1576; &#1588;&#1605;&#1575; &#1605;&#1740; &#1576;&#1575;&#1588;&#1583;. &#1608; &#1575;&#1586; &#1575;&#1740;&#1606; &#1591;&#1585;&#1740;&#1602; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583; &#1576;&#1601;&#1607;&#1605;&#1740;&#1583; &#1670;&#1607; &#1605;&#1591;&#1604;&#1576;&#1740; &#1575;&#1586; &#1588;&#1605;&#1575; &#1662;&#1585; &#1576;&#1575;&#1586;&#1583;&#1740;&#1583;&#1578;&#1585; &#1576;&#1608;&#1583;&#1607; &#1608; &#1605;&#1608;&#1585;&#1583; &#1578;&#1608;&#1580;&#1607; &#1602;&#1585;&#1575;&#1585; &#1711;&#1585;&#1601;&#1578;&#1607; &#1608; &#1607;&#1605;&#1670;&#1606;&#1740;&#1606; &#1578;&#1593;&#1583;&#1575;&#1583; &#1606;&#1592;&#1585;&#1575;&#1578;&#1740; &#1705;&#1607; &#1576;&#1585;&#1575;&#1740; &#1570;&#1606; &#1605;&#1591;&#1604;&#1576; &#1606;&#1608;&#1588;&#1578;&#1607; &#1588;&#1583;&#1607; &#1575;&#1587;&#1578; &#1585;&#1575; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1705;&#1606;&#1740;&#1583;. &#1583;&#1585; &#1575;&#1740;&#1606; &#1602;&#1587;&#1605;&#1578; &#1705;&#1583; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3364/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D9%86%D9%85%D8%A7%DB%8C%D8%B4-%D8%AA%D8%B9%D8%AF%D8%A7%D8%AF-%D8%AF%D9%81%D8%B9%D8%A7%D8%AA-%D8%A8%D8%A7%D8%B2%D8%AF%DB%8C%D8%AF-%D9%88-%D9%86%D8%B8%D8%B1%D8%A7%D8%AA/\">&#1570;&#1605;&#1608;&#1586;&#1588; &#1606;&#1605;&#1575;&#1740;&#1588; &#1578;&#1593;&#1583;&#1575;&#1583; &#1583;&#1601;&#1593;&#1575;&#1578; &#1576;&#1575;&#1586;&#1583;&#1740;&#1583; &#1608; &#1606;&#1592;&#1585;&#1575;&#1578; &#1740;&#1705; &#1605;&#1591;&#1604;&#1576; &#1583;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"غیرفعال کردن یا حذف گزینه های مرتب سازی محصول در ووکامرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:220:\"http://wp-planet.ir/%d8%ba%db%8c%d8%b1%d9%81%d8%b9%d8%a7%d9%84-%da%a9%d8%b1%d8%af%d9%86-%db%8c%d8%a7-%d8%ad%d8%b0%d9%81-%da%af%d8%b2%db%8c%d9%86%d9%87-%d9%87%d8%a7%db%8c-%d9%85%d8%b1%d8%aa%d8%a8-%d8%b3%d8%a7%d8%b2%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Jan 2019 01:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:220:\"http://wp-planet.ir/%d8%ba%db%8c%d8%b1%d9%81%d8%b9%d8%a7%d9%84-%da%a9%d8%b1%d8%af%d9%86-%db%8c%d8%a7-%d8%ad%d8%b0%d9%81-%da%af%d8%b2%db%8c%d9%86%d9%87-%d9%87%d8%a7%db%8c-%d9%85%d8%b1%d8%aa%d8%a8-%d8%b3%d8%a7%d8%b2%db%8c/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1515:\"&#1588;&#1575;&#1740;&#1583; &#1588;&#1605;&#1575; &#1583;&#1585; &#1601;&#1585;&#1608;&#1588;&#1711;&#1575;&#1607; &#1575;&#1740;&#1606;&#1578;&#1585;&#1606;&#1578;&#1740; &#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587; &#1582;&#1608;&#1583; &#1548;&#160;&#1606;&#1740;&#1575;&#1586;&#1740; &#1576;&#1607; &#1711;&#1586;&#1740;&#1606;&#1607; &#1607;&#1575;&#1740; &#1605;&#1585;&#1578;&#1576; &#1587;&#1575;&#1586;&#1740; &#1605;&#1581;&#1589;&#1608;&#1604;&#1575;&#1578; &#1606;&#1583;&#1575;&#1588;&#1578;&#1607; &#1576;&#1575;&#1588;&#1740;&#1583; . &#1583;&#1585; &#1578;&#1589;&#1608;&#1740;&#1585; &#1586;&#1740;&#1585; &#1740;&#1705; &#1606;&#1605;&#1608;&#1606;&#1607; &#1575;&#1586; &#1605;&#1585;&#1578;&#1576; &#1587;&#1575;&#1586;&#1740; &#1605;&#1581;&#1589;&#1608;&#1604;&#1575;&#1578; &#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587; &#1585;&#1575; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1605;&#1740; &#1705;&#1606;&#1740;&#1583; &#160;: &#1575;&#1711;&#1585; &#1605;&#1740; &#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1575;&#1740;&#1606; &#1605;&#1608;&#1585;&#1583; &#1585;&#1575; &#1581;&#1584;&#1601; &#1608; &#1740;&#1575; &#1594;&#1740;&#1585;&#1601;&#1593;&#1575;&#1604; &#1705;&#1606;&#1740;&#1583; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583; &#1576;&#1607; &#1585;&#1575;&#1581;&#1578;&#1740; &#1608; &#1578;&#1606;&#1607;&#1575; &#1576;&#1575; &#1575;&#1590;&#1575;&#1601;&#1607; &#1705;&#1585;&#1583;&#1606; &#1705;&#1583; &#1586;&#1740;&#1585; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2424:\"<p>&#1588;&#1575;&#1740;&#1583; &#1588;&#1605;&#1575; &#1583;&#1585; &#1601;&#1585;&#1608;&#1588;&#1711;&#1575;&#1607; &#1575;&#1740;&#1606;&#1578;&#1585;&#1606;&#1578;&#1740; &#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587; &#1582;&#1608;&#1583; &#1548;&nbsp;&#1606;&#1740;&#1575;&#1586;&#1740; &#1576;&#1607; &#1711;&#1586;&#1740;&#1606;&#1607; &#1607;&#1575;&#1740; &#1605;&#1585;&#1578;&#1576; &#1587;&#1575;&#1586;&#1740; &#1605;&#1581;&#1589;&#1608;&#1604;&#1575;&#1578; &#1606;&#1583;&#1575;&#1588;&#1578;&#1607; &#1576;&#1575;&#1588;&#1740;&#1583; . &#1583;&#1585; &#1578;&#1589;&#1608;&#1740;&#1585; &#1586;&#1740;&#1585; &#1740;&#1705; &#1606;&#1605;&#1608;&#1606;&#1607; &#1575;&#1586; &#1605;&#1585;&#1578;&#1576; &#1587;&#1575;&#1586;&#1740; &#1605;&#1581;&#1589;&#1608;&#1604;&#1575;&#1578; &#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587; &#1585;&#1575; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1605;&#1740; &#1705;&#1606;&#1740;&#1583; &nbsp;: &#1575;&#1711;&#1585; &#1605;&#1740; &#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1575;&#1740;&#1606; &#1605;&#1608;&#1585;&#1583; &#1585;&#1575; &#1581;&#1584;&#1601; &#1608; &#1740;&#1575; &#1594;&#1740;&#1585;&#1601;&#1593;&#1575;&#1604; &#1705;&#1606;&#1740;&#1583; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583; &#1576;&#1607; &#1585;&#1575;&#1581;&#1578;&#1740; &#1608; &#1578;&#1606;&#1607;&#1575; &#1576;&#1575; &#1575;&#1590;&#1575;&#1601;&#1607; &#1705;&#1585;&#1583;&#1606; &#1705;&#1583; &#1586;&#1740;&#1585; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3360/%D8%BA%DB%8C%D8%B1%D9%81%D8%B9%D8%A7%D9%84-%DA%A9%D8%B1%D8%AF%D9%86-%DB%8C%D8%A7-%D8%AD%D8%B0%D9%81-%DA%AF%D8%B2%DB%8C%D9%86%D9%87-%D9%87%D8%A7%DB%8C-%D9%85%D8%B1%D8%AA%D8%A8-%D8%B3%D8%A7%D8%B2%DB%8C/\">&#1594;&#1740;&#1585;&#1601;&#1593;&#1575;&#1604; &#1705;&#1585;&#1583;&#1606; &#1740;&#1575; &#1581;&#1584;&#1601; &#1711;&#1586;&#1740;&#1606;&#1607; &#1607;&#1575;&#1740; &#1605;&#1585;&#1578;&#1576; &#1587;&#1575;&#1586;&#1740; &#1605;&#1581;&#1589;&#1608;&#1604; &#1583;&#1585; &#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"تغییر متن ” ادامه مطلب ” در وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:176:\"http://wp-planet.ir/%d8%aa%d8%ba%db%8c%db%8c%d8%b1-%d9%85%d8%aa%d9%86-%d8%a7%d8%af%d8%a7%d9%85%d9%87-%d9%85%d8%b7%d9%84%d8%a8-%d8%af%d8%b1-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 06 Jan 2019 01:00:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:176:\"http://wp-planet.ir/%d8%aa%d8%ba%db%8c%db%8c%d8%b1-%d9%85%d8%aa%d9%86-%d8%a7%d8%af%d8%a7%d9%85%d9%87-%d9%85%d8%b7%d9%84%d8%a8-%d8%af%d8%b1-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1355:\"&#1583;&#1585; &#1575;&#1705;&#1579;&#1585; &#1662;&#1608;&#1587;&#1578;&#1607; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1585;&#1575;&#1740; &#1606;&#1605;&#1575;&#1740;&#1588; &#1740;&#1705; &#1604;&#1740;&#1606;&#1705; &#1576;&#1607; &#1605;&#1578;&#1606; &#1705;&#1575;&#1605;&#1604; &#1662;&#1587;&#1578; &#1575;&#1586; &#1593;&#1576;&#1575;&#1585;&#1575;&#1578;&#1740; &#1605;&#1575;&#1606;&#1606;&#1583; : &#8221; &#1575;&#1583;&#1575;&#1605;&#1607; &#1605;&#1591;&#1604;&#1576; &#8221; &#1740;&#1575; &#8221; &#1575;&#1583;&#1575;&#1605;&#1607; &#1606;&#1608;&#1588;&#1578;&#1607; &#8221; &#1740;&#1575; &#8221; &#1576;&#1740;&#1588;&#1578;&#1585; &#1576;&#1582;&#1608;&#1575;&#1606;&#1740;&#1583; &#8221; &#1575;&#1587;&#1578;&#1602;&#1575;&#1583;&#1607; &#1605;&#1740; &#1588;&#1608;&#1583; . &#1605;&#1605;&#1705;&#1606; &#1575;&#1587;&#1578; &#1588;&#1605;&#1575; &#1576;&#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1575;&#1740;&#1606; &#1605;&#1578;&#1606; &#1585;&#1575; &#1583;&#1585; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1582;&#1608;&#1583; &#1548; &#1578;&#1594;&#1740;&#1740;&#1585; &#1583;&#1607;&#1740;&#1583; . &#1576;&#1585;&#1575;&#1740; &#1575;&#1740;&#1606;&#1705;&#1575;&#1585; &#1705;&#1575;&#1601;&#1740;&#1587;&#1578; &#1705;&#1583; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2094:\"<p>&#1583;&#1585; &#1575;&#1705;&#1579;&#1585; &#1662;&#1608;&#1587;&#1578;&#1607; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1585;&#1575;&#1740; &#1606;&#1605;&#1575;&#1740;&#1588; &#1740;&#1705; &#1604;&#1740;&#1606;&#1705; &#1576;&#1607; &#1605;&#1578;&#1606; &#1705;&#1575;&#1605;&#1604; &#1662;&#1587;&#1578; &#1575;&#1586; &#1593;&#1576;&#1575;&#1585;&#1575;&#1578;&#1740; &#1605;&#1575;&#1606;&#1606;&#1583; : &#8221; &#1575;&#1583;&#1575;&#1605;&#1607; &#1605;&#1591;&#1604;&#1576; &#8221; &#1740;&#1575; &#8221; &#1575;&#1583;&#1575;&#1605;&#1607; &#1606;&#1608;&#1588;&#1578;&#1607; &#8221; &#1740;&#1575; &#8221; &#1576;&#1740;&#1588;&#1578;&#1585; &#1576;&#1582;&#1608;&#1575;&#1606;&#1740;&#1583; &#8221; &#1575;&#1587;&#1578;&#1602;&#1575;&#1583;&#1607; &#1605;&#1740; &#1588;&#1608;&#1583; . &#1605;&#1605;&#1705;&#1606; &#1575;&#1587;&#1578; &#1588;&#1605;&#1575; &#1576;&#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1575;&#1740;&#1606; &#1605;&#1578;&#1606; &#1585;&#1575; &#1583;&#1585; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1582;&#1608;&#1583; &#1548; &#1578;&#1594;&#1740;&#1740;&#1585; &#1583;&#1607;&#1740;&#1583; . &#1576;&#1585;&#1575;&#1740; &#1575;&#1740;&#1606;&#1705;&#1575;&#1585; &#1705;&#1575;&#1601;&#1740;&#1587;&#1578; &#1705;&#1583; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3512/%D8%AA%D8%BA%DB%8C%DB%8C%D8%B1-%D9%85%D8%AA%D9%86-%D8%A7%D8%AF%D8%A7%D9%85%D9%87-%D9%85%D8%B7%D9%84%D8%A8-%D8%AF%D8%B1-%D9%88%D8%B1%D8%AF%D9%BE%D8%B1%D8%B3/\">&#1578;&#1594;&#1740;&#1740;&#1585; &#1605;&#1578;&#1606; &rdquo; &#1575;&#1583;&#1575;&#1605;&#1607; &#1605;&#1591;&#1604;&#1576; &rdquo; &#1583;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"تغییر متن “سپاسگزاریم از اینکه سایت خود را با وردپرس ساخته‌اید” در وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:207:\"http://wp-planet.ir/%d8%aa%d8%ba%db%8c%db%8c%d8%b1-%d9%85%d8%aa%d9%86-%d8%b3%d9%be%d8%a7%d8%b3%da%af%d8%b2%d8%a7%d8%b1%db%8c%d9%85-%d8%a7%d8%b2-%d8%a7%db%8c%d9%86%da%a9%d9%87-%d8%b3%d8%a7%db%8c%d8%aa-%d8%ae/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 05 Jan 2019 11:00:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"دسته‌بندی نشده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:207:\"http://wp-planet.ir/%d8%aa%d8%ba%db%8c%db%8c%d8%b1-%d9%85%d8%aa%d9%86-%d8%b3%d9%be%d8%a7%d8%b3%da%af%d8%b2%d8%a7%d8%b1%db%8c%d9%85-%d8%a7%d8%b2-%d8%a7%db%8c%d9%86%da%a9%d9%87-%d8%b3%d8%a7%db%8c%d8%aa-%d8%ae/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1496:\"&#1588;&#1575;&#1740;&#1583; &#1575;&#1586; &#1662;&#1740;&#1594;&#1575;&#1605; &#8220;&#1587;&#1662;&#1575;&#1587;&#1711;&#1586;&#1575;&#1585;&#1740;&#1605; &#1575;&#1586; &#1575;&#1740;&#1606;&#1705;&#1607; &#1587;&#1575;&#1740;&#1578; &#1582;&#1608;&#1583; &#1585;&#1575; &#1576;&#1575; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1587;&#1575;&#1582;&#1578;&#1607;&#8204;&#1575;&#1740;&#1583;&#8221; &#1582;&#1587;&#1578;&#1607; &#1588;&#1583;&#1607; &#1575;&#1740;&#1583; &#1548; &#1670;&#1608;&#1606; &#1570;&#1606; &#1585;&#1575; &#1583;&#1585; &#1607;&#1605;&#1607; &#1589;&#1601;&#1581;&#1575;&#1578; &#1605;&#1583;&#1740;&#1585;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1605;&#1740; &#1705;&#1606;&#1740;&#1583; . &#1740;&#1575; &#1588;&#1575;&#1740;&#1583; &#1576;&#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1605;&#1578;&#1606;&#1740; &#1583;&#1604;&#1582;&#1608;&#1575;&#1607; &#1585;&#1575; &#1576;&#1585;&#1575;&#1740; &#1740;&#1705;&#1740; &#1575;&#1586; &#1605;&#1588;&#1578;&#1585;&#1740;&#1575;&#1606; &#1582;&#1608;&#1583; &#1585;&#1575; &#1583;&#1585; &#1662;&#1575;&#1740;&#1740;&#1606; &#1589;&#1601;&#1581;&#1575;&#1578; &#1605;&#1583;&#1740;&#1585;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1585;&#1575; &#1606;&#1588;&#1575;&#1606; &#1583;&#1607;&#1740;&#1583; . &#1583;&#1585; &#1575;&#1740;&#1606; &#1570;&#1605;&#1608;&#1586;&#1588; &#1576;&#1607; &#1588;&#1605;&#1575; [&#8230;] [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2509:\"<p>&#1588;&#1575;&#1740;&#1583; &#1575;&#1586; &#1662;&#1740;&#1594;&#1575;&#1605; &#8220;&#1587;&#1662;&#1575;&#1587;&#1711;&#1586;&#1575;&#1585;&#1740;&#1605; &#1575;&#1586; &#1575;&#1740;&#1606;&#1705;&#1607; &#1587;&#1575;&#1740;&#1578; &#1582;&#1608;&#1583; &#1585;&#1575; &#1576;&#1575; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1587;&#1575;&#1582;&#1578;&#1607;&zwnj;&#1575;&#1740;&#1583;&#8221; &#1582;&#1587;&#1578;&#1607; &#1588;&#1583;&#1607; &#1575;&#1740;&#1583; &#1548; &#1670;&#1608;&#1606; &#1570;&#1606; &#1585;&#1575; &#1583;&#1585; &#1607;&#1605;&#1607; &#1589;&#1601;&#1581;&#1575;&#1578; &#1605;&#1583;&#1740;&#1585;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1605;&#1588;&#1575;&#1607;&#1583;&#1607; &#1605;&#1740; &#1705;&#1606;&#1740;&#1583; . &#1740;&#1575; &#1588;&#1575;&#1740;&#1583; &#1576;&#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1605;&#1578;&#1606;&#1740; &#1583;&#1604;&#1582;&#1608;&#1575;&#1607; &#1585;&#1575; &#1576;&#1585;&#1575;&#1740; &#1740;&#1705;&#1740; &#1575;&#1586; &#1605;&#1588;&#1578;&#1585;&#1740;&#1575;&#1606; &#1582;&#1608;&#1583; &#1585;&#1575; &#1583;&#1585; &#1662;&#1575;&#1740;&#1740;&#1606; &#1589;&#1601;&#1581;&#1575;&#1578; &#1605;&#1583;&#1740;&#1585;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1585;&#1575; &#1606;&#1588;&#1575;&#1606; &#1583;&#1607;&#1740;&#1583; . &#1583;&#1585; &#1575;&#1740;&#1606; &#1570;&#1605;&#1608;&#1586;&#1588; &#1576;&#1607; &#1588;&#1605;&#1575; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wprahnama.com/3485/%D8%AA%D8%BA%DB%8C%DB%8C%D8%B1-%D9%85%D8%AA%D9%86-%D8%B3%D9%BE%D8%A7%D8%B3%DA%AF%D8%B2%D8%A7%D8%B1%DB%8C%D9%85-%D8%A7%D8%B2-%D8%A7%DB%8C%D9%86%DA%A9%D9%87-%D8%B3%D8%A7%DB%8C%D8%AA-%D8%AE%D9%88%D8%AF/\">&#1578;&#1594;&#1740;&#1740;&#1585; &#1605;&#1578;&#1606; &ldquo;&#1587;&#1662;&#1575;&#1587;&#1711;&#1586;&#1575;&#1585;&#1740;&#1605; &#1575;&#1586; &#1575;&#1740;&#1606;&#1705;&#1607; &#1587;&#1575;&#1740;&#1578; &#1582;&#1608;&#1583; &#1585;&#1575; &#1576;&#1575; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1587;&#1575;&#1582;&#1578;&#1607;&zwnj;&#1575;&#1740;&#1583;&rdquo; &#1583;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wprahnama.com/\">&#1585;&#1575;&#1607;&#1606;&#1605;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:25:\"http://wp-planet.ir/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:7:{s:4:\"date\";s:29:\"Fri, 11 Jan 2019 20:12:58 GMT\";s:6:\"server\";s:6:\"Apache\";s:12:\"x-robots-tag\";s:15:\"noindex, follow\";s:4:\"link\";s:56:\"<http://wp-planet.ir/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"last-modified\";s:29:\"Thu, 10 Jan 2019 15:25:48 GMT\";s:4:\"etag\";s:34:\"\"c849e9a683f3efa93103c0fa15bcbb02\"\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";}}s:5:\"build\";s:14:\"20190111055427\";}", "no");
INSERT INTO `wp_options` VALUES("12932", "_transient_timeout_feed_mod_9bb54f090b06ea0b52a1a293dcf1b99e", "1547280779", "no");
INSERT INTO `wp_options` VALUES("12933", "_transient_feed_mod_9bb54f090b06ea0b52a1a293dcf1b99e", "1547237579", "no");
INSERT INTO `wp_options` VALUES("12934", "_site_transient_timeout_community-events-52a20a79ab06335d7dca1c2f0ed8d5e6", "1547280783", "no");
INSERT INTO `wp_options` VALUES("12935", "_site_transient_community-events-52a20a79ab06335d7dca1c2f0ed8d5e6", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"192.119.12.0\";}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:50:\"2019 - Intro to WordPress 5.0 and Help Desk Night!\";s:3:\"url\";s:71:\"https://www.meetup.com/Lehigh-Valley-WordPress-Meetup/events/257757200/\";s:6:\"meetup\";s:30:\"Lehigh Valley WordPress Meetup\";s:10:\"meetup_url\";s:54:\"https://www.meetup.com/Lehigh-Valley-WordPress-Meetup/\";s:4:\"date\";s:19:\"2019-01-10 18:30:00\";s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Bethlehem, PA, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:40.6123400000000032150637707673013210296630859375;s:9:\"longitude\";d:-75.3718199999999995952748577110469341278076171875;}}i:1;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:67:\"Help Desk - Bring Your Laptop, Yourself and Your WordPress Problems\";s:3:\"url\";s:67:\"https://www.meetup.com/WordPress-Montclair-Meetup/events/257089220/\";s:6:\"meetup\";s:26:\"WordPress Montclair Meetup\";s:10:\"meetup_url\";s:50:\"https://www.meetup.com/WordPress-Montclair-Meetup/\";s:4:\"date\";s:19:\"2019-01-14 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:14:\"Montclair, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:40.8112789999999989731804816983640193939208984375;s:9:\"longitude\";d:-74.219345000000004120010999031364917755126953125;}}i:2;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:37:\"Building a WordPress Plugin: Workshop\";s:3:\"url\";s:53:\"https://www.meetup.com/WordPressNYC/events/257902261/\";s:6:\"meetup\";s:26:\"WordPress NYC Meetup Group\";s:10:\"meetup_url\";s:36:\"https://www.meetup.com/WordPressNYC/\";s:4:\"date\";s:19:\"2019-01-15 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:17:\"New York, NY, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:40.756900000000001682565198279917240142822265625;s:9:\"longitude\";d:-73.9900300000000044065018300898373126983642578125;}}i:3;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:31:\"WordPress Professionals Hangout\";s:3:\"url\";s:67:\"https://www.meetup.com/WordPress-Montclair-Meetup/events/257190583/\";s:6:\"meetup\";s:26:\"WordPress Montclair Meetup\";s:10:\"meetup_url\";s:50:\"https://www.meetup.com/WordPress-Montclair-Meetup/\";s:4:\"date\";s:19:\"2019-01-21 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:14:\"Montclair, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:40.8112789999999989731804816983640193939208984375;s:9:\"longitude\";d:-74.219345000000004120010999031364917755126953125;}}i:4;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:18:\"Help Desk Evening!\";s:3:\"url\";s:76:\"https://www.meetup.com/Philadelphia-WordPress-Meetup-Group/events/257815050/\";s:6:\"meetup\";s:35:\"Philadelphia WordPress Meetup Group\";s:10:\"meetup_url\";s:59:\"https://www.meetup.com/Philadelphia-WordPress-Meetup-Group/\";s:4:\"date\";s:19:\"2019-01-22 18:30:00\";s:8:\"location\";a:4:{s:8:\"location\";s:21:\"Philadelphia, PA, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:39.94954700000000258341970038600265979766845703125;s:9:\"longitude\";d:-75.1681439999999980727807269431650638580322265625;}}}}", "no");
INSERT INTO `wp_options` VALUES("12936", "_transient_timeout_feed_1e2ffee29b94cfb5d3816e721235f11e", "1547280783", "no");
INSERT INTO `wp_options` VALUES("12937", "_transient_feed_1e2ffee29b94cfb5d3816e721235f11e", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://wp-persian.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"وبگاه (وب سایت) رسمی پروژه وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Thu, 09 Aug 2018 16:01:04 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.1-alpha-44556\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۹٫۸\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1397/05/18/wp-persian-498/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Aug 2018 16:01:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=470\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۹٫۸ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۹٫۸ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۹٫۱\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/10/24/wp-persian-491/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 14 Jan 2018 15:24:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=466\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:199:\"وردپرس فارسی ۴٫۹٫۱ منتشر شد. ترجمه این نگارش بدون نظارت مستقیم گروه وردپرس فارسی و توسط کاربران انجام شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"<p>وردپرس فارسی ۴٫۹٫۱ منتشر شد.</p>\n<p>ترجمه این نگارش بدون نظارت مستقیم گروه وردپرس فارسی و توسط کاربران انجام شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۸٫۲\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/07/14/wp-persian-482/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2017 08:29:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=464\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۸٫۲ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۸٫۲ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۸٫۱\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/06/09/wp-persian-481/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 31 Aug 2017 09:55:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=461\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۸٫۱ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۸٫۱ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"وردپرس فارسی ۴٫۸ نگارش استاد «آی‌محمد یوسفی»\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://wp-persian.com/1396/03/19/wp-persian-48/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Jun 2017 16:13:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=458\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:576:\"وردپرس فارسی ۴٫۸ منتشر شد. این نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «آی‌محمد یوسفی» است. می‌توانید نگارش جدید وردپرس فارسی را از این بخش دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید. توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:816:\"<p>وردپرس فارسی ۴٫۸ منتشر شد.<br />\nاین نگارش از وردپرس فارسی با افتخار مزیّن به نام استاد گرانقدر موسیقی ایران، «<a href=\"https://fa.wikipedia.org/wiki/%D8%A2%DB%8C%E2%80%8C%D9%85%D8%AD%D9%85%D8%AF_%DB%8C%D9%88%D8%B3%D9%81%DB%8C\">آی‌محمد یوسفی</a>» است.</p>\n<p>می‌توانید نگارش جدید وردپرس فارسی را از <a href=\"http://wp-persian.com/download/\">این بخش</a> دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.<br />\n<em>توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۷٫۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/03/17/wp-persian-475/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jun 2017 17:58:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=456\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۷٫۵ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۷٫۵ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۷٫۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/02/06/wp-persian-474/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Apr 2017 15:41:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=454\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"وردپرس فارسی ۴٫۷٫۴ منتشر شد. در این نگارش چند مشکل کوچک برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"<p>وردپرس فارسی ۴٫۷٫۴ منتشر شد. در این نگارش چند مشکل کوچک برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۷٫۳\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1396/01/05/wp-persian-473/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Mar 2017 08:58:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=452\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"وردپرس فارسی ۴٫۷٫۳ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"<p>وردپرس فارسی ۴٫۷٫۳ منتشر شد. در این نگارش چند مشکل امنیتی برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۷٫۲\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1395/11/08/wp-persian-472/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jan 2017 22:07:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=450\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"وردپرس فارسی ۴٫۷٫۲ منتشر شد. در این نگارش چند مشکل امنیتی مهم برطرف شده است.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"<p>وردپرس فارسی ۴٫۷٫۲ منتشر شد. در این نگارش چند مشکل امنیتی مهم برطرف شده است.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"وردپرس فارسی ۴٫۷٫۱\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wp-persian.com/1395/10/29/wp-persian-471/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jan 2017 15:14:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wp-persian.com/?p=448\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:549:\"وردپرس فارسی ۴٫۷٫۱ منتشر شد. در این نگارش چند مشکل امنیتی مهم برطرف شده است. می‌توانید نگارش جدید وردپرس فارسی را از این بخش دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید. توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد. در صورتی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"گناهکار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:820:\"<p>وردپرس فارسی ۴٫۷٫۱ منتشر شد. در این نگارش چند مشکل امنیتی مهم برطرف شده است.</p>\n<p>می‌توانید نگارش جدید وردپرس فارسی را از <a href=\"http://wp-persian.com/download/\">این بخش</a> دریافت٬ یا به‌صورت خودکار از بخش مدیریت سایت خود٬ به‌روز نمایید.<br />\n<em>توجه داشته باشید که پیغام به‌روزرسانی در بخش مدیریت سایت شما باید مربوط به وردپرس فارسی (fa_IR) باشد.</em><br />\nدر صورتی که پس از به‌روزرسانی خودکار برخی عناصر متحرک بخش مدیریت از کار افتادند، وردپرس را به‌صورت دستی به‌روز کنید.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:27:\"http://wp-persian.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:4:\"date\";s:29:\"Fri, 11 Jan 2019 20:13:02 GMT\";s:6:\"server\";s:6:\"Apache\";s:12:\"x-powered-by\";s:10:\"PHP/5.6.39\";s:4:\"link\";s:58:\"<http://wp-persian.com/wp-json/>; rel=\"https://api.w.org/\"\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:13:\"last-modified\";s:29:\"Thu, 09 Aug 2018 16:01:04 GMT\";s:4:\"etag\";s:34:\"\"51bcc1d43f0902edc606cecb2a954741\"\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";}}s:5:\"build\";s:14:\"20190111055427\";}", "no");
INSERT INTO `wp_options` VALUES("12938", "_transient_timeout_feed_mod_1e2ffee29b94cfb5d3816e721235f11e", "1547280783", "no");
INSERT INTO `wp_options` VALUES("12939", "_transient_feed_mod_1e2ffee29b94cfb5d3816e721235f11e", "1547237583", "no");
INSERT INTO `wp_options` VALUES("12940", "_transient_timeout_feed_6e55088afd2e29d2b4908108b4529d92", "1547280784", "no");
INSERT INTO `wp_options` VALUES("12941", "_transient_feed_6e55088afd2e29d2b4908108b4529d92", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:94:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"وردپرس فارسی » سیاره\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wp-persian.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"سیاره وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Thu, 03 Jan 2019 08:41:17 +0330	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.1-alpha-44382\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:25:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"ویدیو پنجمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/10/13/257155/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Jan 2019 08:41:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:29:\"ویدئوهای رویداد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=252\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:572:\"<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/wordpress-meetup5-video/\">&#1608;&#1740;&#1583;&#1740;&#1608; &#1662;&#1606;&#1580;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:75:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"گزارش پنجمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/10/12/257159/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Jan 2019 14:44:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:13:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:21:\"Iran WordPress Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"irwpmeetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:13:\"tehran meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:23:\"میتاپ وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"میتاپ تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"همایش وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:23:\"وردکمپ ایران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:38:\"برگزاری میتاپ وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:9;a:5:{s:4:\"data\";s:25:\"دورهمی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:10;a:5:{s:4:\"data\";s:23:\"دیدار وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:11;a:5:{s:4:\"data\";s:25:\"رویداد وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:12;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=224\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2312:\"<p>&#1662;&#1606;&#1580;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606; &#1583;&#1585; &#1578;&#1575;&#1585;&#1740;&#1582; &#1783; &#1583;&#1740;&#8204;&#1605;&#1575;&#1607; &#1777;&#1779;&#1785;&#1783; &#1583;&#1585; &#1605;&#1580;&#1605;&#1608;&#1593;&#1607; &#1570;&#1578;&#1740; &#1575;&#1585;&#1578;&#1576;&#1575;&#1591; &#1705;&#1740;&#1588; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585; &#1588;&#1583;. &#1605;&#1740;&#1578;&#1575;&#1662; &#1583;&#1585; &#1575;&#1740;&#1606; &#1583;&#1608;&#1585;&#1607; &#1607;&#1605; &#1576;&#1575; &#1575;&#1587;&#1578;&#1602;&#1576;&#1575;&#1604; &#1576;&#1740;&#8204;&#1606;&#1592;&#1740;&#1585; &#1593;&#1604;&#1575;&#1602;&#1605;&#1606;&#1583;&#1575;&#1606; &#1576;&#1607; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1605;&#1608;&#1575;&#1580;&#1607; &#1576;&#1608;&#1583; . &#1575;&#1606;&#1578;&#1592;&#1575;&#1585; &#1605;&#1740;&#8204;&#1585;&#1608;&#1583; &#1705;&#1607; &#1588;&#1575;&#1607;&#1583;&#1581;&#1590;&#1608;&#1585; &#1576;&#1740;&#1588;&#1578;&#1585; &#1588;&#1605;&#1575; &#1593;&#1586;&#1740;&#1586;&#1575;&#1606; &#1583;&#1585; &#1605;&#1740;&#1578;&#1575;&#1662;&#8204;&#1607;&#1575;&#1740; &#1576;&#1593;&#1583; &#1576;&#1575;&#1588;&#1740;&#1605;. &#1570;&#1602;&#1575;&#1740; &#1587;&#1593;&#1740;&#1583; &#1601;&#1585;&#1583; &#1576;&#1575; &#1589;&#1581;&#1576;&#1578; &#1583;&#1585;&#1576;&#1575;&#1585;&#1607; &#1575;&#1607;&#1583;&#1575;&#1601; &#1605;&#1740;&#1578;&#1575;&#1662; (&#1576;&#1585;&#1711;&#1586;&#1575;&#1585;&#1740; wordcamp &#1583;&#1585; &#1587;&#1575;&#1604; &#1570;&#1740;&#1606;&#1583;&#1607;&#1548; &#1578;&#1608;&#1587;&#1593;&#1607; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/5th-wordpress-meetup-report/\">&#1711;&#1586;&#1575;&#1585;&#1588; &#1662;&#1606;&#1580;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"گزارش چهارمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/10/01/257163/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Dec 2018 16:18:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"میتاپ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"میتاپ وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:38:\"چهارمین میتاپ وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:23:\"وردکمپ ایران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:25:\"دورهمی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:25:\"رویداد وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=169\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2398:\"<p>&#1670;&#1607;&#1575;&#1585;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1785; &#1570;&#1584;&#1585; &#1785;&#1783; &#1587;&#1575;&#1593;&#1578; &#1777;&#1776; &#1589;&#1576;&#1581; &#1583;&#1585; &#1605;&#1580;&#1605;&#1608;&#1593;&#1607; &#1570;&#1578;&#1740; &#1575;&#1585;&#1578;&#1576;&#1575;&#1591; &#1705;&#1740;&#1588; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585; &#1588;&#1583;. &#1575;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1607;&#1605; &#1605;&#1575;&#1606;&#1606;&#1583; &#1587;&#1607; &#1605;&#1740;&#1578;&#1575;&#1662; &#1602;&#1576;&#1604; &#1588;&#1575;&#1607;&#1583; &#1581;&#1590;&#1608;&#1585; &#1593;&#1604;&#1575;&#1602;&#1607;&#8204;&#1605;&#1606;&#1583;&#1575;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1607;&#1585; &#1586;&#1605;&#1740;&#1606;&#1607;&#8204;&#1575;&#1740; (&#1578;&#1608;&#1587;&#1593;&#1607; &#1583;&#1607;&#1606;&#1583;&#1607;&#8204;&#1548; &#1591;&#1585;&#1575;&#1581;&#1548; &#1705;&#1575;&#1585;&#1576;&#1585;&#1575;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1608;&#1581;&#1578;&#1740; &#1583;&#1575;&#1606;&#1588;&#1580;&#1608;&#1740;&#1575;&#1606;) &#1576;&#1608;&#1583;. &#1605;&#1740;&#1578;&#1575;&#1662; &#1576;&#1575; &#1589;&#1581;&#1576;&#1578;&#8204;&#1607;&#1575;&#1740; &#1570;&#1594;&#1575;&#1586;&#1740;&#1606; &#1570;&#1602;&#1575;&#1740; &#1587;&#1593;&#1740;&#1583;&#8204;&#8204; &#1601;&#1585;&#1583; &#1576;&#1575; &#1578;&#1571;&#1705;&#1740;&#1583; &#1576;&#1585; &#1575;&#1607;&#1583;&#1575;&#1601; &#1605;&#1740;&#1578;&#1575;&#1662; &#1705;&#1607; &#1578;&#1588;&#1705;&#1740;&#1604; &#1580;&#1575;&#1605;&#1593;&#1607;&#8204;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740;&#1548; &#1605;&#1591;&#1585;&#1581; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/fourth-wordpress-meetup-report/\">&#1711;&#1586;&#1575;&#1585;&#1588; &#1670;&#1607;&#1575;&#1585;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"ویدیو چهارمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/09/29/257166/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Dec 2018 07:24:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:29:\"ویدئوهای رویداد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=189\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:579:\"<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/wordpress-meetup4-video/\">&#1608;&#1740;&#1583;&#1740;&#1608; &#1670;&#1607;&#1575;&#1585;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"ویدیو سومین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/09/29/257168/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Dec 2018 07:22:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:29:\"ویدئوهای رویداد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=187\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:565:\"<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/wordpress-meetup3-video/\">&#1608;&#1740;&#1583;&#1740;&#1608; &#1587;&#1608;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"ویدیو دومین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/09/29/257170/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Dec 2018 07:20:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:29:\"ویدئوهای رویداد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=183\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:565:\"<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/wordpress-meetup2-video/\">&#1608;&#1740;&#1583;&#1740;&#1608; &#1583;&#1608;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"ویدیو اولین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/09/18/257172/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 09 Dec 2018 19:33:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:29:\"ویدئوهای رویداد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=178\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:565:\"<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/wordpress-meetup1-video/\">&#1608;&#1740;&#1583;&#1740;&#1608; &#1575;&#1608;&#1604;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"گزارش سومین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/09/01/257174/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Nov 2018 14:58:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpmeetup.ir/?p=130\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2241:\"<p>&#1587;&#1608;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1607;&#1605; &#1583;&#1585; &#1578;&#1575;&#1585;&#1740;&#1582; &#1778;&#1781; &#1570;&#1576;&#1575;&#1606; &#1785;&#1783; &#1587;&#1575;&#1593;&#1578; &#1777;&#1780; &#1583;&#1585; &#1605;&#1580;&#1605;&#1608;&#1593;&#1607; &#1587;&#1740;&#1606;&#1583;&#1575;&#1583; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585; &#1588;&#1583; &#1608; &#1605;&#1575;&#1606;&#1606;&#1583; &#1583;&#1608; &#1605;&#1740;&#1578;&#1575;&#1662; &#1602;&#1576;&#1604; &#1576;&#1575; &#1575;&#1587;&#1578;&#1602;&#1576;&#1575;&#1604; &#1705;&#1575;&#1585;&#1576;&#1585;&#1575;&#1606; &#1608; &#1578;&#1608;&#1587;&#1593;&#1607; &#1583;&#1607;&#1606;&#1583;&#1711;&#1575;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1585;&#1608;&#1576;&#1607;&#8204;&#1585;&#1608; &#1588;&#1583;. &#1575;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1576;&#1575; &#1589;&#1576;&#1581;&#1578;&#8204;&#1607;&#1575;&#1740; &#1587;&#1593;&#1740;&#1583; &#1601;&#1585;&#1583; &#1608; &#1605;&#1589;&#1591;&#1601;&#1740; &#1589;&#1608;&#1601;&#1740; &#1588;&#1585;&#1608;&#1593; &#1588;&#1583; &#1705;&#1607; &#1583;&#1585; &#1605;&#1608;&#1585;&#1583; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585;&#1740; &#1605;&#1740;&#1578;&#1575;&#1662;&#8204;&#1607;&#1575; &#1608; &#1575;&#1585;&#1575;&#1574;&#1607;&#8204;&#1607;&#1575;&#1740; &#1570;&#1606; &#1606;&#1705;&#1575;&#1578;&#1740; &#1585;&#1575; &#1576;&#1607; &#1588;&#1585;&#1705;&#1578;&#8204;&#1705;&#1606;&#1606;&#1583;&#1711;&#1575;&#1606; &#1578;&#1608;&#1590;&#1740;&#1581; &#1583;&#1575;&#1583;&#1606;&#1583;. [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/third-wordpress-meetup-report/\">&#1711;&#1586;&#1575;&#1585;&#1588; &#1587;&#1608;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"گزارش دومین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/08/20/257176/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 11 Nov 2018 15:49:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:23:\"میتاپ وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"همایش وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:23:\"وردکمپ ایران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:34:\"دومین میتاپ وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:25:\"دورهمی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://wpmeetup.ir/?p=92\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2193:\"<p>&#1583;&#1608;&#1605;&#1610;&#1606; &#1605;&#1610;&#1578;&#1575;&#1662; &#1587;&#1575;&#1604; &#1641;&#1639; &#1583;&#1585; &#1585;&#1608;&#1586;&#1607; &#1580;&#1605;&#1593;&#1607; &#1633;&#1633; &#1570;&#1576;&#1575;&#1606; &#1587;&#1575;&#1593;&#1578; &#1633;&#1632; &#1589;&#1576;&#1581; &#1576;&#1575; &#1581;&#1590;&#1608;&#1585; &#1578;&#1593;&#1583;&#1575;&#1583;&#1609; &#1575;&#1586; &#1578;&#1608;&#1587;&#1593;&#1607;&#8204;&#1583;&#1607;&#1606;&#1583;&#1711;&#1575;&#1606; &#1608; &#1603;&#1575;&#1585;&#1576;&#1585;&#1575;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1605;&#1580;&#1605;&#1608;&#1593;&#1607; &#1587;&#1610;&#1606;&#1583;&#1575;&#1583; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585; &#1588;&#1583;. &#1587;&#1593;&#1610;&#1583; &#1601;&#1585;&#1583; &#1570;&#1594;&#1575;&#1586;&#1603;&#1606;&#1606;&#1583;&#1607; &#1583;&#1608;&#1605;&#1610;&#1606; &#1605;&#1610;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1608;&#1583; .&#1583;&#1585; &#1589;&#1581;&#1576;&#1578;&#8204;&#1607;&#1575;&#1609; &#1570;&#1594;&#1575;&#1586;&#1610;&#1606; &#1582;&#1608;&#1583; &#1582;&#1576;&#1585; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585;&#1609; &#1605;&#1610;&#1578;&#1575;&#1662;&#8204;&#1607;&#1575; &#1607;&#1585; &#1583;&#1608; &#1607;&#1601;&#1578;&#1607; &#1610;&#1705; &#1576;&#1575;&#1585; &#1578;&#1575; &#1662;&#1575;&#1610;&#1575;&#1606; &#1587;&#1575;&#1604; &#1641;&#1639; &#1585;&#1575; &#1583;&#1575;&#1583; &#1608; &#1583;&#1585; &#1575;&#1583;&#1575;&#1605;&#1607; &#1575;&#1590;&#1575;&#1601;&#1607; &#1603;&#1585;&#1583; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/second-wordpress-meetup-report/\">&#1711;&#1586;&#1575;&#1585;&#1588; &#1583;&#1608;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"برگزاری دومین میتاپ وردپرس در تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1397/08/06/257178/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 28 Oct 2018 13:40:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:38:\"اخبار برگزاری رویداد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://wpmeetup.ir/?p=62\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2013:\"<p>&#1576;&#1593;&#1583; &#1575;&#1586; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585;&#1740; &#1575;&#1608;&#1604;&#1740;&#1606; &#1583;&#1608;&#1585;&#1607; &#1605;&#1740;&#1578;&#1575;&#1662;&#1548; &#1583;&#1608;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1578;&#1607;&#1585;&#1575;&#1606; &#1583;&#1585; &#1585;&#1608;&#1586; &#1580;&#1605;&#1593;&#1607; &#1777;&#1777; &#1570;&#1576;&#1575;&#1606; &#1777;&#1779;&#1785;&#1783; &#1575;&#1586; &#1587;&#1575;&#1593;&#1578; &#1777;&#1776; &#1589;&#1576;&#1581; &#1578;&#1575; &#1777;&#1778; &#1592;&#1607;&#1585; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585; &#1605;&#1740; &#1588;&#1608;&#1583;. &#1583;&#1585; &#1575;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1605;&#1575; &#1583;&#1585; &#1605;&#1608;&#1585;&#1583; &#1593;&#1606;&#1575;&#1608;&#1740;&#1606; &#1586;&#1740;&#1585; &#1589;&#1581;&#1576;&#1578; &#1605;&#1740; &#1705;&#1606;&#1740;&#1605; : &#8211; &#1705;&#1587;&#1576; &#1608; &#1705;&#1575;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#8211; &#1575;&#1605;&#1606;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1570;&#1583;&#1585;&#1587; &#1605;&#1581;&#1604; &#1576;&#1585;&#1711;&#1586;&#1575;&#1585;&#1740; : &#1578;&#1607;&#1585;&#1575;&#1606; &#8211; &#1588;&#1740;&#1582; &#1576;&#1607;&#1575;&#1740;&#1740; &#1580;&#1606;&#1608;&#1576;&#1740; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/second-wordpress-meetup/\">&#1576;&#1585;&#1711;&#1586;&#1575;&#1585;&#1740; &#1583;&#1608;&#1605;&#1740;&#1606; &#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1578;&#1607;&#1585;&#1575;&#1606;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://wpmeetup.ir/\">&#1605;&#1740;&#1578;&#1575;&#1662; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"سعید فرد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:60:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"متوقف کردن قابلیت Heartbeat در وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/12/14/257092/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Mar 2018 09:15:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Hearbeat\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:6:\"planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:28:\"وبلاگ سورن دیتا\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:23:\"آموزش وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:34:\"افزایش سرعت وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:30:\"افزایش سرعت سایت\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://sorendata.com/?p=496\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1099:\"<p>&#1583;&#1585;&#1606;&#1587;&#1582;&#1607; 3.6 &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1575;&#1605;&#1705;&#1575;&#1606;&#1740; &#1576;&#1607; &#1606;&#1575;&#1605; Heartbeat &#1605;&#1593;&#1585;&#1601;&#1740; &#1588;&#1583;. Heartbeat &#1576;&#1607; &#1605;&#1585;&#1608;&#1585;&#1711;&#1585; &#1575;&#1740;&#1606; &#1575;&#1605;&#1705;&#1575;&#1606; &#1585;&#1575; &#1605;&#1740;&#8204;&#1583;&#1607;&#1583; &#1586;&#1605;&#1575;&#1606;&#1740; &#1705;&#1607; &#1583;&#1585; &#1662;&#1740;&#1588;&#1582;&#1608;&#1575;&#1606; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://sorendata.com/blog/stop-heartbeat-api-in-wordpress/\">&#1605;&#1578;&#1608;&#1602;&#1601; &#1705;&#1585;&#1583;&#1606; &#1602;&#1575;&#1576;&#1604;&#1740;&#1578; Heartbeat &#1583;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://sorendata.com/\">&#1587;&#1608;&#1585;&#1606; &#1583;&#1740;&#1578;&#1575;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"مسعود گلچین\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:57:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"۵ روش ساده برای افزایش سرعت وبسایت های وردپرسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/11/07/257071/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 27 Jan 2018 06:53:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:28:\"وبلاگ سورن دیتا\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:23:\"آموزش وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:34:\"افزایش سرعت وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:30:\"افزایش سرعت سایت\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://sorendata.com/?p=448\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1193:\"<p>&#1576;&#1607; &#1591;&#1608;&#1585; &#1605;&#1740;&#1575;&#1606;&#1711;&#1740;&#1606; &#1607;&#1585; &#1705;&#1575;&#1585;&#1576;&#1585; &#1578;&#1606;&#1607;&#1575; &#1779; &#1579;&#1575;&#1606;&#1740;&#1607; &#1576;&#1585;&#1575;&#1740; &#1576;&#1575;&#1585;&#1711;&#1586;&#1575;&#1585;&#1740; &#1740;&#1705; &#1589;&#1601;&#1581;&#1607; &#1608;&#1576; &#1589;&#1576;&#1585; &#1605;&#1740;&#8204;&#1705;&#1606;&#1583; &#1608; &#1583;&#1585; &#1589;&#1608;&#1585;&#1578;&#1740; &#1705;&#1607; &#1575;&#1740;&#1606; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://sorendata.com/blog/5-ways-to-speed-up-your-wordpress-website/\">&#1781; &#1585;&#1608;&#1588; &#1587;&#1575;&#1583;&#1607; &#1576;&#1585;&#1575;&#1740; &#1575;&#1601;&#1586;&#1575;&#1740;&#1588; &#1587;&#1585;&#1593;&#1578; &#1608;&#1576;&#1587;&#1575;&#1740;&#1578; &#1607;&#1575;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://sorendata.com/\">&#1587;&#1608;&#1585;&#1606; &#1583;&#1740;&#1578;&#1575;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"مسعود گلچین\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:60:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"قالب وردپرس Rasputin فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/29/257068/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Jan 2018 08:05:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:34:\"قالب وبلاگی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:34:\"قالب وردپرس وبلاگی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:34:\"قالب وردپرس رایگان\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:34:\"قالب رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"پوسته وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:34:\"دانلود قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=126061\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:798:\"&#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; Rasputin &#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; rasputin &#1585;&#1575;&#1740;&#1711;&#1575;&#1606; &#1608; &#1705;&#1575;&#1605;&#1604;&#1575; &#1601;&#1575;&#1585;&#1587;&#1740; &#1588;&#1583;&#1607; &#1578;&#1608;&#1587;&#1591; &#1578;&#1740;&#1605; &#1605;&#1740;&#1607;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1575;&#1587;&#1578;. &#1575;&#1740;&#1606; &#1602;&#1575;&#1604;&#1576; &#1583;&#1575;&#1585;&#1575;&#1740; &#1740;&#1705; &#1575;&#1587;&#1604;&#1575;&#1740;&#1583;&#1585; &#1583;&#1585; &#1589;&#1601;&#1581;&#1607; &#1575;&#1589;&#1604;&#1740; &#1605;&#1740; &#1576;&#1575;&#1588;&#1583; &#1705;&#1607; &#1588;&#1605;&#1575; &#1576;&#1607; &#1607;&#1585; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"مریم زارع\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:60:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"قالب وردپرس Winter فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/27/257064/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Jan 2018 11:25:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:34:\"قالب وبلاگی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:34:\"قالب وردپرس وبلاگی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:34:\"قالب وردپرس رایگان\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:34:\"قالب رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"پوسته وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:34:\"دانلود قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=125581\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:815:\"&#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; Winter &#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; Winter &#1585;&#1575;&#1740;&#1711;&#1575;&#1606; &#1608; &#1705;&#1575;&#1605;&#1604;&#1575; &#1601;&#1575;&#1585;&#1587;&#1740; &#1588;&#1583;&#1607; &#1578;&#1608;&#1587;&#1591; &#1578;&#1740;&#1605; &#1605;&#1740;&#1607;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1575;&#1587;&#1578;. &#1575;&#1740;&#1606; &#1740;&#1705; &#1602;&#1575;&#1604;&#1576; &#1583;&#1585; &#1670;&#1575;&#1585;&#1670;&#1608;&#1576; &#1570;&#1605;&#1608;&#1586;&#1588;&#1740; &#1575;&#1587;&#1578; &#1705;&#1607; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583; &#1605;&#1581;&#1578;&#1608;&#1575;&#1740; &#1582;&#1608;&#1583; &#1585;&#1575; &#1583;&#1585; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"مریم زارع\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:53:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n\n		\n				\n									\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"امنیت وردپرس :‌ چگونه کاربران را مجبور به ورود مجدد کنیم؟\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/14/257041/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Jan 2018 12:31:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:28:\"وبلاگ سورن دیتا\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:23:\"آموزش وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:23:\"امنیت وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://sorendata.com/?p=401\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1428:\"<p>&#1578;&#1575; &#1581;&#1575;&#1604;&#1575; &#1588;&#1583;&#1607; &#1575;&#1587;&#1578; &#1705;&#1607; &#1576;&#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1578;&#1605;&#1575;&#1605;&#1740; &#1705;&#1575;&#1585;&#1576;&#1585;&#1575;&#1606; &#1608;&#1576;&#1587;&#1575;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740;&#8204;&#1578;&#1575;&#1606; &#1576;&#1583;&#1604;&#1575;&#1740;&#1604; &#1605;&#1582;&#1578;&#1604;&#1601;&#1740; &#1605;&#1575;&#1606;&#1606;&#1583; &#1575;&#1605;&#1606;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1548; &#1607;&#1705;&#8204;&#1588;&#1583;&#1606; &#1608; &#8230; &#1575;&#1586; &#1575;&#1705;&#1575;&#1606;&#1578;&#8204;&#1588;&#1575;&#1606; [&#8230;]</p>\n<p>&#1606;&#1608;&#1588;&#1578;&#1607; <a rel=\"nofollow\" href=\"https://sorendata.com/blog/how-to-force-logout-all-users-in-wordpress-with-salts-keys/\">&#1670;&#1711;&#1608;&#1606;&#1607; &#1583;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1705;&#1575;&#1585;&#1576;&#1585;&#1575;&#1606; &#1585;&#1575; &#1605;&#1580;&#1576;&#1608;&#1585; &#1576;&#1607; &#1608;&#1585;&#1608;&#1583; &#1605;&#1580;&#1583;&#1583; &#1705;&#1606;&#1740;&#1605;&#1567;</a> &#1575;&#1608;&#1604;&#1740;&#1606; &#1576;&#1575;&#1585; &#1583;&#1585; <a rel=\"nofollow\" href=\"https://sorendata.com/\">&#1587;&#1608;&#1585;&#1606; &#1583;&#1740;&#1578;&#1575;</a>. &#1662;&#1583;&#1740;&#1583;&#1575;&#1585; &#1588;&#1583;.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"مسعود گلچین\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:57:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"ابزارک های کاربردی وردپرس با SiteOrigin Widgets Bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/13/257034/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Jan 2018 09:09:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:45:\"مجموعه ابزارک های وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:49:\"آموزش افزونه SiteOrigin Widgets Bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:32:\"ابزارک های وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:43:\"ابزارک های اضافی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=119223\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:852:\"&#1575;&#1576;&#1586;&#1575;&#1585;&#1705; &#1607;&#1575;&#1740; &#1705;&#1575;&#1585;&#1576;&#1585;&#1583;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575; SiteOrigin Widgets Bundle &#1575;&#1740;&#1606; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1583;&#1575;&#1585;&#1575;&#1740; &#1740;&#1705; &#1605;&#1580;&#1605;&#1608;&#1593;&#1607; &#1575;&#1576;&#1586;&#1575;&#1585;&#1705; &#1575;&#1587;&#1578; &#1705;&#1607; &#1605;&#1740;&#1578;&#1608;&#1575;&#1606;&#1740;&#1583;&#160; &#1575;&#1576;&#1586;&#1575;&#1585;&#1705; &#1607;&#1575; &#1585;&#1575; &#1583;&#1585; &#1587;&#1575;&#1740;&#1578; &#1608; &#1576;&#1582;&#1588; &#1587;&#1575;&#1740;&#1583;&#1576;&#1575;&#1585; &#1582;&#1608;&#1583; &#1575;&#1587;&#1578;&#1601;&#1575;&#1583;&#1607; &#1608; &#1587;&#1601;&#1575;&#1585;&#1588; &#1587;&#1575;&#1586;&#1740; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"فاطمه همایون\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:60:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"فرم ورود آژاکسی وردپرس با Login With Ajax\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/12/257028/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Jan 2018 07:10:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:28:\"فرم ورود آژاکسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:26:\"ورود ajax وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:34:\"ورود آژاکسی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:39:\"ورود آژاکسی در وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:34:\"افزونه ورود آژاکسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=122510\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:745:\"&#1601;&#1585;&#1605; &#1608;&#1585;&#1608;&#1583; &#1570;&#1688;&#1575;&#1705;&#1587;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575; Login With Ajax &#1575;&#1605;&#1585;&#1608;&#1586;&#1607; &#1583;&#1740;&#1711;&#1585; &#1575;&#1705;&#1579;&#1585; &#1608;&#1576;&#1587;&#1575;&#1740;&#1578; &#1607;&#1575; &#1608; &#1593;&#1605;&#1604;&#1740;&#1575;&#1578; &#1607;&#1575;&#1740;&#1740; &#1705;&#1607; &#1576;&#1575; &#1601;&#1585;&#1605; &#1607;&#1575; &#1587;&#1585; &#1608; &#1705;&#1575;&#1585; &#1583;&#1575;&#1585;&#1606;&#1583;&#1548; &#1576;&#1607; &#1589;&#1608;&#1585;&#1578; &#1570;&#1688;&#1575;&#1705;&#1587;&#1740; &#1575;&#1606;&#1580;&#1575;&#1605; &#1605;&#1740; &#1588;&#1608;&#1606;&#1583;&#1548; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"محمد قاسمی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:54:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"ورود مدیر به حساب های کاربری وردپرس با User Switching\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/09/257021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Dec 2017 06:57:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:57:\"ورود مدیر به حساب کاربری وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:41:\"ورود به کاربران وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:48:\"ورود به حساب کاربری وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=121831\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:843:\"&#1608;&#1585;&#1608;&#1583; &#1605;&#1583;&#1740;&#1585; &#1576;&#1607; &#1581;&#1587;&#1575;&#1576; &#1607;&#1575;&#1740; &#1705;&#1575;&#1585;&#1576;&#1585;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575; User Switching &#1588;&#1575;&#1740;&#1583; &#1576;&#1585;&#1575;&#1740; &#1588;&#1605;&#1575; &#1575;&#1578;&#1601;&#1575;&#1602; &#1575;&#1601;&#1578;&#1575;&#1583;&#1607; &#1576;&#1575;&#1588;&#1583; &#1576;&#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1662;&#1606;&#1604; &#1705;&#1575;&#1585;&#1576;&#1585;&#1740; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578;&#1578;&#1575;&#1606; &#1585;&#1575; &#1605;&#1581;&#1705; &#1576;&#1586;&#1606;&#1740;&#1583; &#1608; &#1576;&#1576;&#1740;&#1606;&#1740;&#1583; &#1576;&#1607; &#1593;&#1606;&#1608;&#1575;&#1606; &#1740;&#1705; &#1705;&#1575;&#1585;&#1576;&#1585; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"محمد قاسمی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:57:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"تغییر پیوندهای یکتای نویسندگان وردپرس با Edit Author Slug\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/07/257012/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Dec 2017 06:59:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:27:\"نویسنده وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:38:\"آرشیو نویسنده وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:42:\"تغییر url نویسنده وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:47:\"تغییر آدرس نویسنده وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=120742\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:928:\"&#1578;&#1594;&#1740;&#1740;&#1585; &#1662;&#1740;&#1608;&#1606;&#1583;&#1607;&#1575;&#1740; &#1740;&#1705;&#1578;&#1575;&#1740; &#1606;&#1608;&#1740;&#1587;&#1606;&#1583;&#1711;&#1575;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575; Edit Author Slug &#1578;&#1608;&#1587;&#1591; &#1575;&#1740;&#1606; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583; &#1662;&#1740;&#1608;&#1606;&#1583; &#1740;&#1705;&#1578;&#1575;&#1607;&#1575;&#1740; &#1606;&#1608;&#1740;&#1587;&#1606;&#1583;&#1711;&#1575;&#1606; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587;&#1740; &#1582;&#1608;&#1583; &#1585;&#1575; &#1578;&#1594;&#1740;&#1740;&#1585; &#1583;&#1607;&#1740;&#1583; &#1740;&#1575; &#1606;&#1575;&#1605; &#1606;&#1608;&#1740;&#1587;&#1606;&#1583;&#1607; &#1585;&#1575; &#1607;&#1605; &#1578;&#1594;&#1740;&#1740;&#1585; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"محمد قاسمی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"نمایش نمونه کارها با افزونه نمونه کار وردپرس Portfolio Post Type\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/06/257014/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Dec 2017 07:08:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:166:\"افزونه نمونه کارها، ایجاد نمونه کارها در وردپرس، نمونه کارهای وردپرس، پست تایپ نمونه کارها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=119033\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:829:\"&#1606;&#1605;&#1575;&#1740;&#1588; &#1606;&#1605;&#1608;&#1606;&#1607; &#1705;&#1575;&#1585;&#1607;&#1575; &#1576;&#1575; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1606;&#1605;&#1608;&#1606;&#1607; &#1705;&#1575;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; Portfolio Post Type &#1588;&#1575;&#1740;&#1583; &#1576;&#1582;&#1608;&#1575;&#1607;&#1740;&#1583; &#1606;&#1605;&#1608;&#1606;&#1607; &#1705;&#1575;&#1585;&#1607;&#1575;&#1740; &#1582;&#1608;&#1583;&#1578;&#1575;&#1606; &#1585;&#1575; &#1583;&#1585; &#1587;&#1575;&#1740;&#1578;&#1578;&#1575;&#1606; &#1606;&#1605;&#1575;&#1740;&#1588; &#1583;&#1607;&#1740;&#1583;. &#1581;&#1578;&#1605;&#1575; &#1583;&#1585; &#1602;&#1575;&#1604;&#1576; &#1607;&#1575;&#1740; &#1581;&#1585;&#1601;&#1607; &#1576;&#1575; &#1606;&#1575;&#1605; Portfolio &#1740;&#1575; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"محمد قاسمی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:57:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"نمایش پستهای محبوب در وردپرس با Top 10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/03/256999/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 24 Dec 2017 09:37:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:50:\"نمایش محبوب ترین پست وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:34:\"نمایش پستهای محبوب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:30:\"پست محبوب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:30:\"آموزش افزونه Top 10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=118218\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:845:\"&#1606;&#1605;&#1575;&#1740;&#1588; &#1662;&#1587;&#1578;&#1607;&#1575;&#1740; &#1605;&#1581;&#1576;&#1608;&#1576; &#1583;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1583;&#1585; &#1575;&#1705;&#1579;&#1585; &#1587;&#1575;&#1740;&#1578; &#1607;&#1575; &#1605;&#1740; &#1576;&#1740;&#1606;&#1740;&#1583; &#1705;&#1607; &#1662;&#1587;&#1578;&#1607;&#1575;&#1740; &#1605;&#1581;&#1576;&#1608;&#1576; &#1585;&#1575; &#1576;&#1607; &#1589;&#1608;&#1585;&#1578; &#1740;&#1705; &#1604;&#1740;&#1587;&#1578; &#1583;&#1585; &#1587;&#1575;&#1740;&#1578; &#1582;&#1608;&#1583; &#1606;&#1605;&#1575;&#1740;&#1588; &#1605;&#1740;&#1583;&#1607;&#1606;&#1583;. &#1576;&#1607; &#1591;&#1608;&#1585; &#1662;&#1740;&#1588; &#1601;&#1585;&#1590; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1606;&#1605;&#1740;&#1578;&#1608;&#1575;&#1606;&#1583; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"فاطمه همایون\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:60:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"غیر فعال کردن XML-RPC وردپرس برای امنیت بیشتر\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/03/257001/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 24 Dec 2017 07:17:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:8:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"مشکل xml rpc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:38:\"مشکل امنیتی api وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:23:\"امنیت وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:32:\"غیر فعال کردن xml rpc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:40:\"غیرفعال کردن api وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=118375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1148:\"&#1594;&#1740;&#1585; &#1601;&#1593;&#1575;&#1604; &#1705;&#1585;&#1583;&#1606; XML-RPC &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1585;&#1575;&#1740; &#1575;&#1605;&#1606;&#1740;&#1578; &#1576;&#1740;&#1588;&#1578;&#1585; &#1578;&#1608;&#1587;&#1591; &#1575;&#1740;&#1606; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583; &#1585;&#1575;&#1576;&#1591; &#1576;&#1585;&#1606;&#1575;&#1605;&#1607;&#8204;&#1606;&#1608;&#1740;&#1587;&#1740; &#1606;&#1585;&#1605;&#8204;&#1575;&#1601;&#1586;&#1575;&#1585; &#1705;&#1575;&#1585;&#1576;&#1585;&#1583;&#1740; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; (XML-RPC) &#1585;&#1575; &#1594;&#1740;&#1585; &#1601;&#1593;&#1575;&#1604; &#1705;&#1606;&#1740;&#1583;. &#1585;&#1575;&#1576;&#1591; &#1576;&#1585;&#1606;&#1575;&#1605;&#1607;&#8204;&#1606;&#1608;&#1740;&#1587;&#1740; &#1606;&#1585;&#1605;&#8204;&#1575;&#1601;&#1586;&#1575;&#1585; &#1705;&#1575;&#1585;&#1576;&#1585;&#1583;&#1740; &#1670;&#1740;&#1587;&#1578;&#1567; &#1585;&#1575;&#1576;&#1591; &#1576;&#1585;&#1606;&#1575;&#1605;&#1607;&#8204;&#1606;&#1608;&#1740;&#1587;&#1740; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"محمد قاسمی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"بهبود بخشیدن جستجوگر وردپرس با Search Everything\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/10/02/256995/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Dec 2017 10:04:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:25:\"افزونه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:38:\"افزونه رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:155:\"جستجوگر حرفه ای وردپرس، جستجوی وردپرس، جستجوی پیشرفته وردپرس،افزونه سرچ برای وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=117679\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:945:\"&#1576;&#1607;&#1576;&#1608;&#1583; &#1576;&#1582;&#1588;&#1740;&#1583;&#1606; &#1580;&#1587;&#1578;&#1580;&#1608;&#1711;&#1585; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1576;&#1575; Search Everything &#1576;&#1575; &#1575;&#1587;&#1578;&#1601;&#1575;&#1583;&#1607; &#1575;&#1586; &#1575;&#1740;&#1606; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; &#1605;&#1740; &#1578;&#1608;&#1575;&#1606;&#1740;&#1583;&#1548; &#1593;&#1605;&#1604;&#1705;&#1585;&#1583; &#1580;&#1587;&#1578;&#1580;&#1608;&#1711;&#1585; &#1662;&#1740;&#1588; &#1601;&#1585;&#1590; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1608;&#1576; &#1587;&#1575;&#1740;&#1578; &#1582;&#1608;&#1583; &#1585;&#1575; &#1576;&#1583;&#1608;&#1606; &#1578;&#1594;&#1740;&#1740;&#1585;&#1575;&#1578; &#1583;&#1585; &#1705;&#1583;&#1606;&#1608;&#1740;&#1587;&#1740; &#1602;&#1575;&#1604;&#1576;&#1548; &#1576;&#1607;&#1576;&#1608;&#1583; &#1576;&#1576;&#1582;&#1588;&#1740;&#1583;. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"محمد قاسمی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:63:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"قالب وردپرس آشپزی Bistro فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/09/30/256990/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Dec 2017 06:56:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:34:\"قالب وبلاگی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:21:\"قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:34:\"قالب وردپرس وبلاگی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:34:\"قالب وردپرس رایگان\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:32:\"قالب آشپزی وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:34:\"قالب رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:23:\"پوسته وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:34:\"دانلود قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=118225\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:865:\"&#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1570;&#1588;&#1662;&#1586;&#1740; Bistro &#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; Bistro &#1585;&#1575;&#1740;&#1711;&#1575;&#1606; &#1740;&#1705; &#1602;&#1575;&#1604;&#1576; &#1705;&#1575;&#1605;&#1604;&#1575; &#1601;&#1575;&#1585;&#1587;&#1740; &#1588;&#1583;&#1607; &#1578;&#1608;&#1587;&#1591; &#1578;&#1740;&#1605; &#1605;&#1740;&#1607;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1575;&#1587;&#1578;.&#160;&#1575;&#1740;&#1606; &#1602;&#1575;&#1604;&#1576; &#1583;&#1585; &#1670;&#1575;&#1585;&#1670;&#1608;&#1576; &#1576;&#1608;&#1578; &#1575;&#1587;&#1578;&#1585;&#1662; 3 &#1587;&#1575;&#1582;&#1578;&#1607; &#1588;&#1583;&#1607; &#1575;&#1587;&#1578;. &#1575;&#1740;&#1606; &#1602;&#1575;&#1604;&#1576; &#1576;&#1585;&#1575;&#1740; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"مریم زارع\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:57:\"\n		\n		\n				\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n				\n						\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"قالب وردپرس کاریابی Gander فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://planet.wp-persian.com/1396/09/29/256988/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 20 Dec 2017 08:27:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:21:\"قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:34:\"قالب وردپرس رایگان\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:32:\"قالب وردپرس شرکتی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:34:\"قالب رایگان وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:23:\"پوسته وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:34:\"دانلود قالب وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://mihanwp.com/?p=118505\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:851:\"&#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1705;&#1575;&#1585;&#1740;&#1575;&#1576;&#1740; Gander &#1602;&#1575;&#1604;&#1576; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; Gander &#1585;&#1575;&#1740;&#1711;&#1575;&#1606; &#1608; &#1705;&#1575;&#1605;&#1604;&#1575; &#1601;&#1575;&#1585;&#1587;&#1740;&#160; &#1576;&#1608;&#1583;&#1607; &#1608; &#1585;&#1575;&#1587;&#1578; &#1670;&#1740;&#1606; &#1588;&#1583;&#1607; &#1578;&#1608;&#1587;&#1591; &#1578;&#1740;&#1605; &#1605;&#1740;&#1607;&#1606; &#1608;&#1585;&#1583;&#1662;&#1585;&#1587; &#1575;&#1587;&#1578;.&#1575;&#1740;&#1606; &#1602;&#1575;&#1604;&#1576; &#1583;&#1585; &#1670;&#1575;&#1585;&#1670;&#1608;&#1576; &#1576;&#1608;&#1578; &#1575;&#1587;&#1578;&#1585;&#1662; 3 &#1587;&#1575;&#1582;&#1578;&#1607; &#1588;&#1583;&#1607;. &#1575;&#1740;&#1606; [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:0:\"\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"مریم زارع\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:44:\"http://feeds.feedburner.com/wordpress/planet\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:16:\"wordpress/planet\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:10:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"bZMAHZjInaGUAS4maUsNB4bROb8\";s:13:\"last-modified\";s:29:\"Fri, 11 Jan 2019 20:09:15 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Fri, 11 Jan 2019 20:13:04 GMT\";s:7:\"expires\";s:29:\"Fri, 11 Jan 2019 20:13:04 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";}}s:5:\"build\";s:14:\"20190111055427\";}", "no");
INSERT INTO `wp_options` VALUES("12942", "_transient_timeout_feed_mod_6e55088afd2e29d2b4908108b4529d92", "1547280784", "no");
INSERT INTO `wp_options` VALUES("12943", "_transient_feed_mod_6e55088afd2e29d2b4908108b4529d92", "1547237584", "no");
INSERT INTO `wp_options` VALUES("12944", "_transient_timeout_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "1547280784", "no");
INSERT INTO `wp_options` VALUES("12945", "_transient_dash_v2_ccb55a4e4b351a220e50ef4117d7dc27", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wp-persian.com/1397/05/18/wp-persian-498/\'>وردپرس فارسی ۴٫۹٫۸</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://planet.wp-persian.com/1397/10/13/257155/\'>ویدیو پنجمین میتاپ وردپرس تهران</a></li><li><a class=\'rsswidget\' href=\'http://planet.wp-persian.com/1397/10/12/257159/\'>گزارش پنجمین میتاپ وردپرس تهران</a></li><li><a class=\'rsswidget\' href=\'http://planet.wp-persian.com/1397/10/01/257163/\'>گزارش چهارمین میتاپ وردپرس تهران</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("12946", "_site_transient_timeout_popular_importers_4c7669ff96edecabe4fc7902efe5a15b", "1547410408", "no");
INSERT INTO `wp_options` VALUES("12947", "_site_transient_popular_importers_4c7669ff96edecabe4fc7902efe5a15b", "a:2:{s:9:\"importers\";a:8:{s:7:\"blogger\";a:4:{s:4:\"name\";s:7:\"Blogger\";s:11:\"description\";s:54:\"Import posts, comments, and users from a Blogger blog.\";s:11:\"plugin-slug\";s:16:\"blogger-importer\";s:11:\"importer-id\";s:7:\"blogger\";}s:9:\"wpcat2tag\";a:4:{s:4:\"name\";s:29:\"Categories and Tags Converter\";s:11:\"description\";s:71:\"Convert existing categories to tags or tags to categories, selectively.\";s:11:\"plugin-slug\";s:18:\"wpcat2tag-importer\";s:11:\"importer-id\";s:10:\"wp-cat2tag\";}s:11:\"livejournal\";a:4:{s:4:\"name\";s:11:\"LiveJournal\";s:11:\"description\";s:46:\"Import posts from LiveJournal using their API.\";s:11:\"plugin-slug\";s:20:\"livejournal-importer\";s:11:\"importer-id\";s:11:\"livejournal\";}s:11:\"movabletype\";a:4:{s:4:\"name\";s:24:\"Movable Type and TypePad\";s:11:\"description\";s:62:\"Import posts and comments from a Movable Type or TypePad blog.\";s:11:\"plugin-slug\";s:20:\"movabletype-importer\";s:11:\"importer-id\";s:2:\"mt\";}s:4:\"opml\";a:4:{s:4:\"name\";s:8:\"Blogroll\";s:11:\"description\";s:28:\"Import links in OPML format.\";s:11:\"plugin-slug\";s:13:\"opml-importer\";s:11:\"importer-id\";s:4:\"opml\";}s:3:\"rss\";a:4:{s:4:\"name\";s:3:\"RSS\";s:11:\"description\";s:30:\"Import posts from an RSS feed.\";s:11:\"plugin-slug\";s:12:\"rss-importer\";s:11:\"importer-id\";s:3:\"rss\";}s:6:\"tumblr\";a:4:{s:4:\"name\";s:6:\"Tumblr\";s:11:\"description\";s:53:\"Import posts &amp; media from Tumblr using their API.\";s:11:\"plugin-slug\";s:15:\"tumblr-importer\";s:11:\"importer-id\";s:6:\"tumblr\";}s:9:\"wordpress\";a:4:{s:4:\"name\";s:9:\"WordPress\";s:11:\"description\";s:96:\"Import posts, pages, comments, custom fields, categories, and tags from a WordPress export file.\";s:11:\"plugin-slug\";s:18:\"wordpress-importer\";s:11:\"importer-id\";s:9:\"wordpress\";}}s:10:\"translated\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("12948", "string-locator-search-overview", "s:328:\"O:8:\"stdClass\":5:{s:9:\"scan_path\";O:8:\"stdClass\":3:{s:4:\"path\";s:98:\"/home/realthemes/public_html/jobifa.com/demo/wpr