<?php
/**
 * Source file was changed on the Tue Sep 6 16:23:37 2022 +0200
 */

namespace WP_Rocket\Engine\AccelerateWp;

use WP_Rocket\Event_Management\Subscriber_Interface;

/**
 * Subscriber for the AccelerateWP
 */
class Subscriber implements Subscriber_Interface {
	/**
	 * Sentry
	 *
	 * @var Sentry
	 */
	private $sentry;

	/**
	 * Constructor
	 *
	 * @param Sentry $sentry Sentry instance.
	 */
	public function __construct( Sentry $sentry ) {
		$this->sentry = $sentry;
	}

	/**
	 * Return an array of events that this subscriber wants to listen to.
	 *
	 * @return array
	 * @since  3.4
	 */
	public static function get_subscribed_events() {
		return [
			'rocketcdn_accelerate_wp_set_error'         => [ 'debug', 10, 6 ],
			'rocketcdn_accelerate_wp_set_error_handler' => 'set_error_handler',
			'rocketcdn_accelerate_wp_restore_error_handler' => 'restore_error_handler',
		];
	}

	/**
	 * Send error.
	 *
	 * @param int         $errno number.
	 * @param string      $errstr message.
	 * @param string|null $errfile file.
	 * @param int|null    $errline line.
	 * @param array       $extra params.
	 * @param array       $tags tags.
	 *
	 * @return void
	 */
	public function debug( $errno, $errstr, $errfile = null, $errline = null, $extra = [], $tags = [] ) {
		$this->sentry->error( $errno, $errstr, $errfile, $errline, $extra, $tags );
	}

	/**
	 * Custom error handler.
	 *
	 * @param int         $errno number.
	 * @param string      $errstr message.
	 * @param string|null $errfile file.
	 * @param int|null    $errline line.
	 *
	 * @return void
	 */
	public function custom_error_handler( $errno, $errstr, $errfile = null, $errline = null ) {
		$this->sentry->error( $errno, $errstr, $errfile, $errline, [], [] );
	}

	/**
	 * Set error handler.
	 *
	 * @return void
	 */
	public function set_error_handler() {
		set_error_handler( // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_set_error_handler
			[
				$this,
				'custom_error_handler',
			]
			);
	}

	/**
	 * Restore error handler.
	 *
	 * @return void
	 */
	public function restore_error_handler() {
		restore_error_handler();
	}
}
