<?php

/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 7.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

?>

<div class="wrapper">
	<?php if (ot_get_option('logo_shop_barsa')) : ?>
		<div class="logo-checkout"><a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>"><img src="<?php echo ot_get_option('logo_shop_barsa'); ?>" alt="">
			</a></div><?php endif ?>
	<div class="sign-panels">
		<?php do_action('woocommerce_before_customer_login_form'); ?>
		<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) : ?>
			<div class="login">
			<?php endif; ?>

			<h2><?php esc_html_e('Login to account', 'denver'); ?></h2>

			<form class="woocommerce-form woocommerce-form-login login" method="post">

				<?php do_action('woocommerce_login_form_start'); ?>

				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php esc_html_e('Username or email address', 'woocommerce'); ?>" name="username" id="username" autocomplete="username" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine 
																																																																																				?>
				</p>
				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<input class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php esc_html_e('Password', 'woocommerce'); ?>" type="password" name="password" id="password" autocomplete="current-password" />
				</p>

				<?php do_action('woocommerce_login_form'); ?>

				<p class="label_checbox">
					<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="remember" value="forever">
					<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme" for="remember"><span><?php esc_html_e('Remember me', 'woocommerce'); ?></span></label>
				</p>
				<div class="submit_login">
					<?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
					<button type="submit" class="btn-signin" name="login" value="<?php esc_attr_e('Log in', 'woocommerce'); ?>"><?php esc_html_e('Log in', 'woocommerce'); ?></button>
				</div>
				<div class="woocommerce-LostPassword lost_password">
					<a href="javascript:void(0)" class="btn-reset btn-fade"><?php esc_html_e('forgot my password', 'denver'); ?></a>
				</div>

				<?php do_action('woocommerce_login_form_end'); ?>

			</form>
			<div class="sign__up"><?php esc_html_e('Are you a new user?', 'denver'); ?>
				<a href="javascript:void(0)" class="btn-member btn-fade"><?php esc_html_e('register', 'denver'); ?></a>
			</div>
			<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) : ?>
			</div>
			<div class="signup">

				<h2><?php esc_html_e('Register', 'woocommerce'); ?></h2>

				<form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action('woocommerce_register_form_tag'); ?>>

					<?php do_action('woocommerce_register_form_start'); ?>

					<?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>

						<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
							<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php esc_html_e('Username', 'woocommerce'); ?> " name="username" id="reg_username" autocomplete="username" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine 
																																																																																			?>
						</p>

					<?php endif; ?>

					<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
						<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php esc_html_e('Email address', 'woocommerce'); ?>" name="email" id="reg_email" autocomplete="email" value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine 
																																																																																?>
					</p>

					<?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>

						<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
							<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php esc_html_e('Password', 'woocommerce'); ?>" name="password" id="reg_password" autocomplete="new-password" />
						</p>

					<?php else : ?>

						<p><?php esc_html_e('A password will be sent to your email address.', 'woocommerce'); ?></p>

					<?php endif; ?>

					<?php do_action('woocommerce_register_form'); ?>

					<p class="woocommerce-FormRow form-row">
						<?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
						<button type="submit" class="btn-signin" name="register" value="<?php esc_attr_e('Register', 'woocommerce'); ?>"><?php esc_html_e('Register', 'woocommerce'); ?></button>
					</p>
					<?php do_action('woocommerce_register_form_end'); ?>

				</form>
				<div class="sign__up">
					<?php echo ' قبلا در ', bloginfo('name'), ' ثبت نام کرده اید؟  '; ?>
					<a href="javascript:void(0)" class="btn-login-woo btn-fade">وارد شوید</a>
				</div>
			</div>


			<div class="recover-password">
				<form method="post" class="woocommerce-ResetPassword lost_reset_password">

					<p><?php echo apply_filters('woocommerce_lost_password_message', esc_html__('Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'woocommerce')); ?></p><?php // @codingStandardsIgnoreLine 
																																																														?>

					<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
						<input class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php esc_html_e('Username or email', 'woocommerce'); ?>" type="text" name="user_login" id="user_login" autocomplete="username" />
					</p>

					<div class="clear"></div>

					<?php do_action('woocommerce_lostpassword_form'); ?>

					<p class="woocommerce-form-row form-row">
						<input type="hidden" name="wc_reset_password" value="true" />
						<button type="submit" class="woocommerce-Button button btn-signin" value="<?php esc_attr_e('Reset password', 'woocommerce'); ?>"><?php esc_html_e('Reset password', 'woocommerce'); ?></button>

					</p>
					<?php wp_nonce_field('lost_password', 'woocommerce-lost-password-nonce'); ?>
				</form>
				<div class="sign__up">
					<a href="javascript:void(0)" class="btn-login-woo btn-fade">بازگشت به فرم ورود</a>
				</div>
			</div>
	</div>
</div>
<footer class="footer_my_account">
	<div class="lin-footer"></div>
	<div class="container checkout_display">
		<div class="footer-checkout">
		<?php if ( has_nav_menu( 'footer-my-account' ) ) : ?>
      <div class="menu_my-account"><?php wp_nav_menu(array('theme_location' => 'footer-my-account')); ?></div>
      <?php endif; ?>
			<p>Copyright &copy; <?php echo date('Y');
								echo  ' ';
								echo bloginfo('name'); ?></p>
		</div>
	</div>
</footer>
<?php endif; ?>

<?php do_action('woocommerce_after_customer_login_form'); ?>