<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header();
get_template_part('themeplat/navbar/select-nav', 'navbarshop');
global $post;
$args  = array(
	'taxonomy' => 'product_cat'
);
?>
<div class="container-fluid main-content">
	<div class="page_product">
		<div class="wo_breadcrumb">
			<?php woocommerce_breadcrumb(); ?>
		</div>
	</div>
	<div class="row">
		<div class="col-12">
			<header class="woocommerce-products-header">
				<?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
				<?php endif; ?>
				<?php if (woocommerce_product_loop()) {
					do_action('woocommerce_before_main_content');
					do_action('woocommerce_archive_description');
				?>
			</header>
		</div>
		<?php
					$terms = wp_get_post_terms($post->ID, 'product_cat', $args);
					$count = count($terms);
					if ($count > 0) {
						if (is_product_category()) {
							global $wp_query;
							$cat = $wp_query->get_queried_object();
							$thumbnail_id = get_term_meta($cat->term_id, 'thumbnail_id', true);
							$image = wp_get_attachment_url($thumbnail_id);
							if ($image) {
								echo '<div class="col-sm-12 col-lg-3 pal_0 cat_description "><img src="' . $image . '" alt="' . $cat->name . '" width="420px"/></div>';
								echo $term->description;
								echo '<div class="col-sm-12 col-lg-9 term_description post-content sin-content"><div>';
								echo '<h1 class="title_single" style="margin:1rem 0 ">', single_term_title(), '</h1>';
								echo term_description();
								echo '</div></div>';
							}
						}
					}
		?>
		<?php get_sidebar('shop') ?>
		<div class="col-sm-12 col-lg-9 content">
			<div class="arc_pro_content">
				<article class="arc_pro-wrapper">
					<div class="arc_pro-listing">
						<div class="wo-listing__header">
							<?php
							echo woocommerce_catalog_ordering();
							echo woocommerce_result_count();
							?>
						</div>
					<?php
					/**
					 * Hook: woocommerce_before_main_content.
					 *
					 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
					 * @hooked woocommerce_breadcrumb - 20
					 * @hooked WC_Structured_Data::generate_website_data() - 30
					 */
					woocommerce_product_loop_start();

					if (wc_get_loop_prop('total')) {
						while (have_posts()) {
							the_post();
							/**
							 * Hook: woocommerce_shop_loop.
							 *
							 * @hooked WC_Structured_Data::generate_product_data() - 10
							 */
							do_action('woocommerce_shop_loop');

							wc_get_template_part('content', 'product');
						}
					}

					woocommerce_product_loop_end();

					/**
					 * Hook: woocommerce_before_shop_loop.
					 *
					 * @hooked woocommerce_output_all_notices - 10
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */



					/**
					 * Hook: woocommerce_after_shop_loop.
					 *
					 * @hooked woocommerce_pagination - 10
					 */


					do_action('woocommerce_after_shop_loop');
				} else {
					/**
					 * Hook: woocommerce_no_products_found.
					 *
					 * @hooked wc_no_products_found - 10
					 */
					do_action('woocommerce_no_products_found');
				}

				/**
				 * Hook: woocommerce_after_main_content.
				 *
				 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
				 */
				do_action('woocommerce_after_main_content');

				/**
				 * Hook: woocommerce_sidebar.
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */


					?>

					</div>
				</article>
			</div>
			<div class="term_description post-content sin-content">
			<?php 
				the_archive_description( '<div class="taxonomy-description">', '</div>' ); 
			?>
		</div>
		</div>
	</div>
</div>
<?php
get_footer();
