<?php

if (!defined('ABSPATH')) {
	return;
}
//Enable Gallery
$asg_qv_lb_en_gallery_value = sanitize_text_field(get_option('asg-qv-lb-en-gallery', 'true'));
function asg_qv_lb_en_gallery_cb()
{
	global $asg_qv_lb_en_gallery_value;
	$html  = '<input type="checkbox" id="asg-qv-lb-en-gallery" name="asg-qv-lb-en-gallery" value="true" ' . checked('true', $asg_qv_lb_en_gallery_value, false) . '>';
	$html .= '<label for = "asg-qv-lb-en-gallery">' . __('Enable Gallery Images.', 'denver') . '</label>';
	echo $html;
}
function asg_qv_enqueue_scripts()
{
	global $asg_qv_lb_title_value,
		$asg_qv_gl_anim_value,
		$asg_qv_button_position_value;
	wp_localize_script('quick-view', 'asg_qv_localize', array(
		'adminurl' => admin_url() . 'admin-ajax.php',
		'prettyPhoto_title' => esc_attr($asg_qv_lb_title_value),
		'modal_anim' => esc_attr($asg_qv_gl_anim_value),
		'img_hover_btn'		=> esc_attr($asg_qv_button_position_value)
	));
}
add_action('wp_enqueue_scripts', 'asg_qv_enqueue_scripts');


//Product Image
/* 
function asg_qv_product_image(){
	global $post, $product;zz
?>
<div class="images">
	<?php
		if ( has_post_thumbnail() ) {
			$attachment_count = count( $product->get_gallery_attachment_ids() );
			$gallery          = $attachment_count > 0 ? '[product-gallery]' : '';
			$props            = wc_get_product_attachment_props( get_post_thumbnail_id(), $post );
			$image            = get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ), array(
				'title'	 => $props['title'],
				'alt'    => $props['alt'],
			) );
			echo 
				sprintf(
					'<a href="%s" itemprop="image" class="woocommerce-main-image zoom" title="%s" data-rel="prettyPhoto%s">%s</a>',
					esc_url( $props['url'] ),
					esc_attr( $props['caption'] ),
					$gallery,
					$image
				);
		} else {
			echo sprintf( '<img src="%s" alt="%s" />', wc_placeholder_img_src(), __( 'Placeholder', 'woocommerce' ) );
		}

		do_action('asg_qv_after_product_image');
	?>
</div>
<?php
}
add_action('asg-qv-images','asg_qv_product_image',20);
*/
//Product Thumbnail

function asg_qv_product_thumbnails()
{

	global $post, $product, $woocommerce;

	$attachment_ids = $product->get_gallery_attachment_ids();

	if ($attachment_ids) {
		$loop 		= 0;
		$columns 	= apply_filters('woocommerce_product_thumbnails_columns', 3);
?>
		<div class="owl-carousel owl-theme thumbnails <?php echo 'columns-' . $columns; ?>"><?php

																							foreach ($attachment_ids as $attachment_id) {

																								$classes = array('zoom');

																								if ($loop === 0 || $loop % $columns === 0) {
																									$classes[] = 'first';
																								}

																								if (($loop + 1) % $columns === 0) {
																									$classes[] = 'last';
																								}

																								$image_class = implode(' ', $classes);
																								$props       = wc_get_product_attachment_props($attachment_id, $post);

																								if (!$props['url']) {
																									continue;
																								}

																								echo
																									sprintf(
																										'<a href="%s" class="%s item" title="%s" data-rel="prettyPhoto[product-gallery]">%s</a>',
																										esc_url($props['url']),
																										esc_attr($image_class),
																										esc_attr($props['caption']),
																										wp_get_attachment_image($attachment_id, apply_filters('single_product_small_thumbnail_size', 'shop_thumbnail'), 0, $props)
																									);
																								$loop++;
																							}

																							?></div>
		<?php
	}
}
add_action('asg_qv_after_product_image', 'asg_qv_product_thumbnails', 5);

// Summary
add_action('asg-qv-summary', 'woocommerce_template_single_title', 5);
add_action('asg-qv-summary', 'woocommerce_template_single_rating', 10);
add_action('asg-qv-summary', 'woocommerce_template_single_price', 15);
add_action('asg-qv-summary', 'woocommerce_template_single_excerpt', 20);
add_action('asg-qv-summary', 'woocommerce_template_single_add_to_cart', 25);
add_action('asg-qv-summary', 'woocommerce_template_single_meta', 30);
//Quick View Panel
function asg_qv_panel()
{
	$html  = '<div class="asg-qv-opac"></div>';
	$html .= '<div class="asg-qv-panel">';
	$html .= '<div class="asg-qv-preloader asg-qv-opl">';
	$html .= '<div class="loader_theme ">';
	$html .= '<span class="dot"></span>';
	$html .= '<span class="dot"></span>';
	$html .= '<span class="dot"></span>';
	$html .= '</div>';
	$html .= '</div>';
	$html .= '<div class="asg-qv-modal"></div>';
	$html .= '</div>';
	echo $html;
}
add_action('wp_footer', 'asg_qv_panel');

//Quick View button
function asg_qv_button()
{
	global $asg_qv_button_text_value, $asg_qv_btn_icon_value;
	$html  = '<a class="asg-qv-button" qv-id = "' . get_the_ID() . '">';
	$html .= '<span class="asg-qv-btn-icon asgqv-eye asg-qv"><i class="fal fa-search"></i></span>';
	$html .= esc_attr__($asg_qv_button_text_value, 'denver');
	$html .= '</a>';
	echo $html;
}
//Quick View button position
add_action('woocommerce_after_shop_loop_item', 'asg_qv_button', 11); // Quick View button
add_action('add_quick_view_button', 'asg_qv_button', 11); // Quick View button
//Quick View Template.
function asg_qv_ajax()
{
	$product_id = (int) $_POST['product_id'];
	$qv_next 	= (int) $_POST['qv_next'];
	$qv_prev 	= (int) $_POST['qv_prev'];

	$params = array(
		'p' => $product_id,
		'post_type' => array('product', 'product_variation')
	);
	$query = new WP_Query($params);
	global $post;
	if ($query->have_posts()) {
		while ($query->have_posts()) {
			$query->the_post();
		?>
			<div class="asg-qv-nxt asgqv-chevron-right asg-qv" qv-nxt-id="<?php echo  $qv_next; ?>"><i class="fal fa-angle-right"></i></div>
			<div class="asg-qv-prev asgqv-chevron-left asg-qv" qv-prev-id="<?php echo  $qv_prev; ?>"><i class="fal fa-angle-left"></i></div>
			<div class="asg-qv-inner-modal">
				<div class="asg-qv-container woocommerce single-product">
					<div class="asg-qv-top-panel">
						<div class="asg-qv-preloader asg-qv-mpl">
							<div class="loader_theme">
								<span class="dot"></span>
								<span class="dot"></span>
								<span class="dot"></span>
							</div>
						</div>
					</div> 
					<div class="asg-qv-main col-12">
						<div class="asg-qv-images col-12 col-lg-6" itemscope itemtype="<?php echo woocommerce_get_product_schema(); ?>" id="product-<?php the_ID(); ?>" <?php post_class('product'); ?>>
							<?php asg_qv_product_thumbnails(); ?>
							<script>
								$(document).ready(function() {
									var owl = $('.owl-carousel');
									owl.owlCarousel({
										rtl: true,
										items: 1,
										loop: true,
										margin: 30,
										autoplay: true,
										autoplayTimeout: 2000,
										autoplayHoverPause: true
									});
									$('.play').on('click', function() {
										owl.trigger('play.owl.autoplay', [2000])
									})
									$('.stop').on('click', function() {
										owl.trigger('stop.owl.autoplay')
									})
								});
							</script>
						</div>

						<div class="quick_info_product col-12 col-lg-6">
							<?php the_title('<span class="quick_title_prod">', '</span>'); ?>
							<div class="wo-product-category">
								<?php get_template_part('themeplat-part/single-product/rating', 'rating'); ?>
								<ul>
									<li><?php echo woocommerce_template_single_meta(); ?>
										<?php get_template_part('themeplat-part/single-product/meta', 'meta'); ?>
									</li>
								</ul>
							</div>
							<?php $repeatable_fields2 = get_post_meta($post->ID, 'repeatable_fields2', true);
							if ($repeatable_fields2) : ?>
								<div class="spoiler">
									<ul class="hidden-text">
										<?php foreach ($repeatable_fields2 as $field) { ?>
											<li>
												<?php if ($field['name2'] != '') echo '<span class="field">' . esc_attr($field['name2']) . '</span>'; ?> :
												<?php if ($field['url2'] != '') echo '<span class="field">' . esc_attr($field['url2']) . '</span>'; ?>
											</li>
										<?php } ?>
									</ul>
								</div>
							<?php endif; ?>
							<div class="asg-qv-summary">
								<?php
								if (original_product_get_meta('Marketing')) {
									echo '<div id="price-shop_table" class="custom_marketing price">';
									$product = wc_get_product($post->ID);
									$title = $product->get_meta('custom_text_field_title');
									if ($title) {
										printf(
											esc_html($title)
										);
									}
									echo '</div>';
								} else {
									do_action('asg-qv-summary');
								}
								?>
								<a href="<?php the_permalink(); ?>">
									<button type="submit" name="add-to-cart" value="15" class="btn-add-to-cart bth_quick_info">
										<span class="btn-add-to-cart__txt">
											<i class="fal fa-info"></i>
											<?php _e('more details', 'denver'); ?>
										</span>
									</button>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
<?php
		}
	}
	wp_reset_postdata();
	die();
}
add_action('wp_ajax_asg_qv_ajax', 'asg_qv_ajax');
add_action('wp_ajax_nopriv_asg_qv_ajax', 'asg_qv_ajax');



?>