<?php

defined( 'ABSPATH' ) || exit();

class ASG_Menu_Item_Post_Type {
	public function __construct() {
		add_action( 'init', array( $this, 'register_post_types' ) );
		add_action( 'template_include', array( $this, 'template_include' ), 99 );
	}
	public function register_post_types() {
		$labels = array(
			'name'               => _x( 'Menu Item', 'post type general name', 'denver' ),
			'singular_name'      => _x( 'Menu', 'post type singular name', 'denver' ),
			'menu_name'          => _x( 'Menu Items', 'admin menu', 'denver' ),
			'name_admin_bar'     => _x( 'Menu', 'add new on admin bar', 'denver' ),
			'add_new'            => _x( 'Add New', 'book', 'denver' ),
			'add_new_item'       => __( 'Add New Menu', 'denver' ),
			'new_item'           => __( 'New Menu', 'denver' ),
			'edit_item'          => __( 'Edit Menu', 'denver' ),
			'view_item'          => __( 'View Menu', 'denver' ),
			'all_items'          => __( 'All Menu', 'denver' ),
			'search_items'       => __( 'Search Items', 'denver' ),
			'parent_item_colon'  => __( 'Parent Items:', 'denver' ),
			'not_found'          => __( 'No menus found.', 'denver' ),
			'not_found_in_trash' => __( 'No menus found in Trash.', 'denver' )
		);

		$args = array(
			'labels'              => $labels,
			'hierarchical'        => false,
			'description'         => 'description',
			'taxonomies'          => array(),
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'show_in_admin_bar'   => true,
			'menu_position'       => null,
			'menu_icon'           => true,
			'show_in_nav_menus'   => false,
			'publicly_queryable'  => true,
			'exclude_from_search' => true,
			'has_archive'         => false,
			'query_var'           => true,
			'can_export'          => true,
			'capability_type'     => 'post',
			'supports'            => array( 'title', 'editor' ),
			'rewrite'            => array( 'slug' => 'asgh-menus' )
		);

		register_post_type( 'asgh_menu_item', apply_filters( 'asgh_elementor_menu_item_post_type', $args ) );

		add_post_type_support( 'asgh_menu_item', 'elementor' );
	}

	public function template_include( $template ) {
		if ( get_query_var('post_type') !== 'asgh_menu_item' ) {
			return $template;
		}
		$template = locate_template( $this->get_templates() );
		if ( ! $template ) {
			$template =   'single-menu.php';
		}

		return $template;
	}

	public function get_templates() {
		$templates = array();
		$object       = get_queried_object();
		$templates[] = 'single-menu-' . $object->post_name . '.php';
		$templates[] = 'single-menu.php';
		return $templates;
	}

}

new ASG_Menu_Item_Post_Type();