<?php
class Questions extends \Elementor\Widget_Base {


	public function get_name() {
		return 'questions';
	}

	public function get_title() {
		return __( 'questions list', 'denver' );
	}

	public function get_icon() {
		return 'eicon-plus-square-o';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}
	public function get_script_depends() {
		return [ 'elementor-hello-world' ];
	}
	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'General', 'denver' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'title', 'denver' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'title',
			]
        );
        $this->add_control(
			'grid_style',
			[
			  'label' => __( 'Grid Style', 'denver' ),
			  'type' => \Elementor\Controls_Manager::SELECT,
			  'default' => '1',
			  'options' => [
				'1' => esc_html__( 'Layout 1', 'denver' ),
				'2' => esc_html__( 'Layout 2', 'denver' ),
			  ],
			]
		  );
        $this->end_controls_section();
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'denver' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'denver' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'denver' ),
				'label_block' => true,
			]
        );
        $repeater->add_control(
			'mor_title', [
				'label' => __( 'Title more', 'denver' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Title more' , 'denver' ),
				'label_block' => true,
			]
        );
        $repeater->add_control(
			'des_title', [
                'label' => __( 'Description', 'denver' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __( 'Default description', 'denver' ),
                'placeholder' => __( 'Type your description here', 'denver' ),
                
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'denver' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
        );
        $repeater->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'denver' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
        );
        $repeater->add_control(
			'website_link',
			[
				'label' => __( 'Link', 'denver' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'denver' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'denver' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Title #1', 'denver' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
					],
					[
						'list_title' => __( 'Title #2', 'denver' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();
     
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'denver' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'color',
			[
				'label' => __( 'Title Color', 'denver' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00bfd6',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color_2',
			[
				'label' => __( 'Title Color', 'denver' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2a2a2a',
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $grid_style = $settings['grid_style'];
            if( 2 == $grid_style ){
                include( __DIR__ . '/template/questions/layout-2.php' );
              }else{
                include( __DIR__ . '/template/questions/layout-1.php' );
              }
                wp_reset_postdata();
	}

}
