<?php
/**
 * head slid.
 *
 */

use \Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Head_Slid extends \Elementor\Widget_Base {

	public function get_name() {
		return 'head-slid';
	}

	public function get_title() {
		return __( 'head slid', 'denver' );
	}

	public function get_icon() {
		return 'eicon-gallery-group';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}


	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
		$this->start_controls_section(
			'differ_content',
			[
				'label' => __( 'Grid', 'denver' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'grid_style',
			[
			  'label' => __( 'Grid Style', 'denver' ),
			  'type' => \Elementor\Controls_Manager::SELECT,
			  'default' => '1',
			  'options' => [
			  '1' => esc_html__( 'Layout 1', 'denver' ),
			  ],
			]
			);
		 $this->end_controls_section();
		 $this->start_controls_section(
		  'content_section',
		  [
			'label' => __( 'Content', 'denver' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		  ]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'denver' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'denver' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
		  'image',
		  [
			'label' => __( 'Choose Image slider', 'denver' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
			  'url' => \Elementor\Utils::get_placeholder_image_src(),
			],
		  ]
		);
		$repeater->add_control(
		  'website_link',
		  [
			'label' => __( 'Link', 'denver' ),
			'type' => \Elementor\Controls_Manager::URL,
			'placeholder' => __( 'https://your-link.com', 'denver' ),
			'show_external' => true,
			'default' => [
			  'url' => '',
			  'is_external' => true,
			  'nofollow' => true,
			],
		  ]
		);
		$this->add_control(
		  'list',
		  [
			'label' => __( 'Repeater List', 'denver' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
			  [
				'list_title' => __( 'Title #1', 'denver' ),
				'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
			  ],
			  [
				'list_title' => __( 'Title #2', 'denver' ),
				'list_content' => __( 'Item content. Click the edit button to change this text.', 'denver' ),
			  ],
			],
			'title_field' => '{{{ list_title }}}',
		  ]
		);
        $this->add_control(
			'image1',
			[
				'label' => __( 'Choose Image', 'denver' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'default' => 'full',
				'separator' => 'none',
			]
        );
		$this->add_control(
			'website_link1',
			[
			  'label' => __( 'Link', 'denver' ),
			  'type' => \Elementor\Controls_Manager::URL,
			  'placeholder' => __( 'https://your-link.com', 'denver' ),
			  'show_external' => true,
			  'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			  ],
			]
		  );
		$this->add_control(
			'image2',
			[
				'label' => __( 'Choose Image', 'denver' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'website_link2',
			[
			  'label' => __( 'Link', 'denver' ),
			  'type' => \Elementor\Controls_Manager::URL,
			  'placeholder' => __( 'https://your-link.com', 'denver' ),
			  'show_external' => true,
			  'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			  ],
			]
		  );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display(); ?>
		       <script>
           $('.owl-two.owl-carousel').owlCarousel({
            rtl: true,
			mouseDrag:true,
            autoWidth: false,
            navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
            nav: true,
            dots: true,
            autoplay:true,
            loop:true,
            responsive:{ 0:{ items:1, nav:false, }, 600:{ items:1, nav:false, }, 1000:{ items:1 } }
          });
	   </script>
	   <div class="container">
			<div class="row">
				<div class="col-12 col-md-8 pal_0">
				<?php if ( $settings['list'] ) { ?>
				<div class="sec-casino-games">
						<div class="owl-two owl-carousel owl-theme sec-promotions" style=" width: 100%;">
							<?php foreach (  $settings['list'] as $item ) { ?>
								<div class="swiper-container">
									<div class="swiper-wrapper">
										<a href="<?php echo $item['website_link']['url']; ?>" class="woo-product-box-item-link wo-main-slider__slide swiper-slide">
										<?php echo Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'image' ); ?>
										</a>
									</div>
								</div>
							<?php } ?>
						</div>
					</div>
					<?php } ?>
				</div>
				<div class="col-12 col-md-4">
					<div class="sec_image_box">
						<a href="<?php echo $settings['website_link1']['url'];?>">
							<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image1' ); ?>
						</a>
					</div>
					<div class="sec_image_box">
						<a href="<?php echo $settings['website_link2']['url']; ?>">
							<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image2' ); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<?php
        
	}

}