<?php
/**
 * Elementor Box Content Responsive Widget.
 *
 */

 class Article_5 extends \Elementor\Widget_Base {

 	public function get_name() {
 		return 'article-5';
 	}

 	public function get_title() {
 		return __( 'Article 5', 'denver' );
 	}

 	public function get_icon() {
 		return 'eicon-slideshow';
 	}

 	public function get_categories() {
 		return [ 'elementor-widget-be' ];
 	}

  private function grid_get_all_post_type_categories( $post_type ) {
    $options = array();

    if ( $post_type == 'post' ) {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ( $terms as $term ) {
      $options[ $term->slug ] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types() {
   $options = array();
   $exclude = array( 'attachment', 'elementor_widget_be' ); // excluded post types

   $args = array(
     'public' => true,
   );

   foreach ( get_post_types( $args, 'objects' ) as $post_type ) {

     if ( ! isset( $post_type->name ) ) {
       continue;
     }

     if ( ! isset( $post_type->label ) ) {
       continue;
     }

     if ( in_array( $post_type->name, $exclude ) === true ) {
       continue;
     }

     $options[ $post_type->name ] = $post_type->label;
   }

   return $options;
 }

       protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
   $this->start_controls_section(
     'section_content',
     [
       'label' => __( 'Content', 'denver' ),
     ]
   );
   $this->add_control(
     'title',
     [
       'label' => __( 'Title', 'denver' ),
       'type' => \Elementor\Controls_Manager::TEXT,
     ]
   );
   $this->add_control(
     'title_more',
     [
       'label' => __( 'Title More', 'denver' ),
       'type' => \Elementor\Controls_Manager::TEXT,
     ]
   );
   // Post type.
   $this->add_control(
     'grid_post_type',
     [
       'type'    => \Elementor\Controls_Manager::SELECT,
       'label'   => '<i class="fa fa-tag"></i> ' . __( 'Post Type', 'denver' ),
       'default' => 'post',
       'options' => $this->grid_get_all_post_types(),
     ]
   );
   $this->add_control(
     'grid_items',
     [
       'type'        => \Elementor\Controls_Manager::NUMBER,
       'label'       => '<i class="fa fa-th-large"></i> ' . __( 'Items', 'denver' ),
       'placeholder' => __( 'How many items?', 'denver' ),
       'default'     => 4,
     ]
   );

   // Post categories.
   $this->add_control(
     'grid_post_categories',
     [
       'type'    => \Elementor\Controls_Manager::SELECT,
       'label'   => '<i class="fa fa-folder"></i> ' . __( 'Category', 'denver' ),
       'options' => $this->grid_get_all_post_type_categories( 'post' ),
       'condition' => [
         'grid_post_type' => 'post',
       ],
     ]
   );
   $this->add_control(
     'show_more',
     [
       'label' => __( 'Show more', 'denver' ),
       'type' => \Elementor\Controls_Manager::SWITCHER,
       'label_on' => __( 'Show', 'denver' ),
       'label_off' => __( 'Hide', 'denver' ),
       'return_value' => 'yes',
       'default' => 'yes',
     ]
   );
   $this->add_control(
     'website_link',
     [
       'label' => __( 'Link More', 'denver' ),
       'type' => \Elementor\Controls_Manager::URL,
       'placeholder' => __( 'https://your-link.com', 'denver' ),
       'show_external' => true,
       'default' => [
         'url' => '',
         'is_external' => true,
         'nofollow' => true,
       ],
     ]
   );
   $this->add_control(
     'grid_pagination',
     [
       'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __( 'Pagination', 'denver' ),
       'type' => \Elementor\Controls_Manager::SWITCHER,
       'default' => '',
     ]
   );
   // Order by.
   $this->add_control(
     'grid_order_by',
     [
       'type'    => \Elementor\Controls_Manager::SELECT,
       'label'   => '<i class="fa fa-sort"></i> ' . __( 'Order by', 'denver' ),
       'default' => 'date',
       'options' => [
         'date'          => __( 'Date', 'denver' ),
         'title'         => __( 'Title', 'denver' ),
         'modified'      => __( 'Modified date', 'denver' ),
         'comment_count' => __( 'Comment count', 'denver' ),
         'rand'          => __( 'Random', 'denver' ),
       ],
     ]
   );

   // Price.
   $this->add_control(
     'grid_content_price',
     [
       'label' => '<i class="fa fa-usd"></i> ' . __( 'Price', 'denver' ),
       'type' => \Elementor\Controls_Manager::SWITCHER,
       'default' => 'yes',
       'condition' => [
         'section_grid.grid_post_type' => 'product',
       ],
     ]
   );
   $this->end_controls_section();

   $this->start_controls_section(
     'section_style',
     [
       'label' => __( 'Style', 'denver' ),
       'tab' => \Elementor\Controls_Manager::TAB_STYLE,
     ]
   );
   $this->end_controls_section();
 }
 private function grid_pagination_section() {
   $this->start_controls_section(
     'section_grid_pagination',
     [
       'label'     => __( 'Pagination', 'denver' ),
       'condition' => [
         'section_grid.grid_pagination' => 'yes',
       ],
     ]
   );

   // Pagination alignment.
   $this->add_responsive_control(
     'grid_pagination_alignment',
     [
       'label'     => __( 'Alignment', 'denver' ),
       'type'      => \Elementor\Controls_Manager::CHOOSE,
       'options'   => [
         'left'    => [
           'title' => __( 'Left', 'denver' ),
           'icon'  => 'fa fa-align-left',
         ],
         'center'  => [
           'title' => __( 'Center', 'denver' ),
           'icon'  => 'fa fa-align-center',
         ],
         'right'   => [
           'title' => __( 'Right', 'denver' ),
           'icon'  => 'fa fa-align-right',
         ],
       ],
       'default'   => 'center',
       'tablet_default'   => 'center',
       'mobile_default'   => 'center',
       'selectors' => [
         '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'text-align: {{VALUE}};',
       ],
     ]
   );

   $this->end_controls_section();
 }
 private function grid_pagination_style_section() {
   // Tab.
   $this->start_controls_section(
     'section_grid_pagination_style',
     [
       'label' => __( 'Pagination', 'denver' ),
       'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
       'condition' => [
         'section_grid.grid_pagination' => 'yes',
       ],
     ]
   );

   // Image margin.
   $this->add_control(
     'grid_pagination_style_margin',
     [
       'label'      => __( 'Margin', 'denver' ),
       'type'       => \Elementor\Controls_Manager::DIMENSIONS,
       'size_units' => [ 'px' ],
       'selectors'  => [
         '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
       ],
     ]
   );

   $this->end_controls_section();
 }

 protected function render() {
       $settings = $this->get_settings();
       $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
       $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';
       ?>
       <div class="container">
       <section class="background_box_article col-12">
       <header class="title-five">
         <a class="inner-card" href="<?php the_permalink(); ?>">
           <h4 class="Survey-title"><?php echo $settings['title']; ?></h4>
           <?php
           if ( 'yes' === $settings['show_more'] ) {
             echo '<a class="Survey-bt-mor" href="' . $settings['website_link']['url'] . '"' . $target . $nofollow . '>'; echo $settings['title_more'];'';?></a>
             <?php } ?>
               </a>
            </header>
             <?php
       $args = array();
       $args['post_status'] = 'publish';
       $args['ignore_sticky_posts'] = 1;
       if ( ! empty( $settings['grid_post_type'] ) && post_type_exists( $settings['grid_post_type'] ) ) {
         $args['post_type'] = $settings['grid_post_type'];
       }
       if ( ! empty( $settings['grid_post_categories'] ) && $settings['grid_post_type'] == 'post' ) {
         $args['category_name'] = $settings['grid_post_categories'];
       }
       if ( ! empty( $settings['grid_product_categories'] ) && $settings['grid_post_type'] == 'product' ) {
         $args['tax_query'] = array(
           'relation' => 'AND',
           array(
             'taxonomy' => 'product_cat',
             'field' => 'slug',
             'terms' => $settings['grid_product_categories'],
           ),
         );
       }
       if ( ! empty( $settings['grid_items'] ) && intval( $settings['grid_items'] ) == $settings['grid_items'] ) {
         $args['posts_per_page'] = $settings['grid_items'];
       }
       if ( ! empty( $settings['grid_order_by'] ) ) {
         $args['orderby'] = $settings['grid_order_by'];
       }
       if ( ! empty( $settings['grid_pagination'] ) ) {
         $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
         $args['paged'] = $paged;
       }
       $query = new \WP_Query( $args );
       if ( $query->have_posts() ) {
         while ( $query->have_posts() ) {
           $query->the_post();
           ?>
           <div class="col-12 col-xl-3 col-md-3 col-sm-6 col-xs-6 right">
             <div class="example-2 card-area">
               <?php
                if( get_post_thumbnail_id()){
                 $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), array(300, 300) );
                 ?>
                 <div class="wrapper-box" style=" background: url('<?php echo $thumb['0'];?>') ;background-repeat: no-repeat;background-position: center;background-size: cover;">
                 <?php
                 } else { ?>
                 <div class="wrapper-box" style=" background: url('<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif') ;background-repeat: no-repeat;background-position: center;background-size: cover;">
                 <?php } ?>
                 <div class="dg-overlay-dark">
                   <div class="header">
                       <div class="date left daymonthyear">
                        <?php echo human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' پیش'; ?>
                       </div>
                       <ul class="menu-content">
                         <li>
                           <a href="#" class="fal fa-bookmark"></a>
                         </li>
                         <li><a href="#" class="fal fa-heart"><span></span></a></li>
                         <li><a href="#" class="fal fa-comment"><span><?php comments_number( '', '', '%' ); ?></span></a></li>
                       </ul>
                   </div>
                   <div class="data extranslate">
                     <div class="content">
                       <span class="author"><?php the_author(); ?></span>
                       <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                       <?php  echo '<p class="text">' .  get_the_excerpt() . '</p>' ;?>
                       <p style="margin-bottom:1rem"></p>
                     </div>
                   </div>
                 </div>
               </div>
             </div>
           </div>
           <?php
         }
         if ( ! empty( $settings['grid_pagination'] ) ) {
         ?>
         <div class="pagination root"style="width: 100%;">
           <?php
           $big = 999999999;
           $totalpages = $query->max_num_pages;
           $current = max( 1, $paged );
           $paginate_args = array(
             'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
             'format'    => '?paged=%#%',
             'current'   => $current,
             'total'     => $totalpages,
             'show_all'  => false,
             'end_size'  => 1,
             'mid_size'  => 3,
             'prev_next' => true,
             'prev_text'          => __( '<i class="fa fa-chevron-right" aria-hidden="true"></i>', 'denver' ),
             'next_text'          => __( '<i class="fa fa-chevron-left" aria-hidden="true"></i>', 'denver' ),
             'screen_reader_text' => __( 'A' , 'denver')
           );
           $pagination = paginate_links( $paginate_args );
           ?>
           <nav class="pagenumbers">
             <?php echo $pagination; ?>
           </nav>
         </div>
         <?php
         }
       } // end if; ?>
     </section>
       </div>
       <?php
     }
   }
