from django.urls import path
from . import views

urlpatterns = [
    path('list_status/', views.ListTicketStatusView.as_view()),
    path('ticket_department/add/', views.AddTicketDepartmentView.as_view()),
    
    path('custom_field/add/', views.AddCustomFieldView.as_view()),
    path('custom_field/update/<int:cfid>/', views.UpdateCustomFieldView.as_view()),
    path('custom_field/delete/<int:cfid>/', views.DeleteCustomFieldView.as_view()),
    path('custom_field/get/<str:dname>/', views.GetCustomFieldView.as_view()),
    
    path('ticket-template/get-template/<str:dname>/', views.GetTicketTemplateView.as_view()),
    
    # خدمات فاوا
    path('list-ticket/<str:dname>/', views.ListTicketView.as_view()),
    path('open_ticket/', views.OpenTicketView.as_view()),
    path('add_reply/<str:tid>/', views.AddReplyTicket.as_view()),
    path('get-ticket-detail/<str:tid>/', views.GetTicketDetailView.as_view()),
    path('change-ticket-status/', views.ChangeTicketStatusView.as_view()),
    path('delete-ticket/<str:tid>/', views.DeleteTicketView.as_view()),
    path('update_ticket/<str:tid>/', views.UpdateTicketView.as_view()),
    path('it_requests/save_response/<str:tid>/', views.SaveResponseITRequestsView.as_view()),
    
    path('it_equipment/list-units/', views.ITEquipmentsListunitsView.as_view()),
    path('it_equipment/list/', views.ITEquipmentsListView.as_view()),
    path('it_equipment/add/', views.ITEquipmentsAddView.as_view()),
    path('it_equipment/delete/<str:tid>/', views.ITEquipmentsDeleteView.as_view()),
    path('it_equipment/update/<str:tid>/', views.ITEquipmentsUpdateView.as_view()),
    path('it_equipment/change-status/', views.ITEquipmentsChangeStatusView.as_view()),
    path('it_equipment/add-response/<str:tid>/', views.ITEquipmentsAdminResponseView.as_view()),
    
    path('meeting_request/get-content-type/', views.MeetingRequestContentTypeView.as_view()),
    path('meeting_request/get-location/', views.MeetingRequestLocationView.as_view()),
    path('meeting_request/get-serve/', views.MeetingRequestServeView.as_view()),
    path('meeting_request/get-type/', views.MeetingRequestTypeView.as_view()),
    path('get-meeting-requests/<int:lid>/', views.GetMeetingRequestsView.as_view()),
    path('meeting_request/list/', views.ListMeetingRequests.as_view()),
    path('add-meeting-request/', views.AddMeetingRequestsView.as_view()),
    path('edit-meeting-request/<int:id>/', views.EditMeetingRequestsView.as_view()),
    path('delete-meeting-request/<int:id>/', views.DeleteMeetingRequestsView.as_view()),
    path('meeting_request/change-status/', views.MeetingRequestChangeStatusView.as_view()),
    
    path('furniture/list-units/', views.FurnitureListunitsView.as_view()),
    path('furniture/list/', views.FurnitureListView.as_view()),
    path('furniture/add/', views.FurnitureAddView.as_view()),
    path('furniture/delete/<str:tid>/', views.FurnitureDeleteView.as_view()),
    path('furniture/update/<str:tid>/', views.FurnitureUpdateView.as_view()),
    path('furniture/change-status/', views.FurnitureChangeStatusView.as_view()),
    path('furniture/add-response/<str:tid>/', views.FurnitureAdminResponseView.as_view()),
    
    path('gaming-room/get-types/', views.GamingRoomListTypesView.as_view()),
    path('gaming-room/get-users/', views.GamingRoomListUsersView.as_view()),
    path('gaming-room-requests/list/', views.GamingRoomListRequestView.as_view()),
    path('gaming-room-requests/add/', views.GamingRoomAddRequestView.as_view()),
    path('gaming-room-requests/get-time/', views.GamingRoomGetTimeRangesView.as_view()),
    path('gaming-room-requests/delete/<int:id>/', views.GamingRoomDeleteRequestView.as_view()),
    path('gaming-room-requests/edit/<int:id>/', views.GamingRoomEditRequestView.as_view()),
    path('gaming-room-requests/change-status/', views.GamingRoomChangeStatusView.as_view()),
    
    path('get-versioning/', views.GetVersioningView.as_view()),
    path('add-version/', views.AddVersioningView.as_view()),
]