from django.db import models
from usermanagement.models import Users
from insurance.models import Flags


class Notification(models.Model):
    user = models.ForeignKey(Users, on_delete=models.CASCADE)
    message = models.CharField(max_length=255)
    created_at = models.DateTimeField(auto_now_add=True)
    is_read = models.BooleanField(default=False)
    department = models.CharField(default='it_requests')
    notif_id = models.CharField(default=None, null=True, blank=True)
    
    class Meta:
        db_table = 'notifications'



class AnnouncementCategory(models.Model):
    
    name = models.CharField(max_length=255)
    logo_path = models.CharField(max_length=255)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = 'announcement_categories'



class Announcement(models.Model):
    
    category = models.ForeignKey('AnnouncementCategory', on_delete=models.SET_NULL, null=True)
    user = models.ForeignKey(Users, on_delete=models.SET_NULL, null=True)
    flag = models.ForeignKey(Flags, on_delete=models.SET_NULL, null=True)
    title = models.CharField(max_length=255)
    short_description = models.TextField(null=True, blank=True)
    content = models.TextField(null=True, blank=True)
    attachment_path	= models.CharField(null=True, blank=True)
    is_active = models.BooleanField()
    expired_at = models.DateTimeField(null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    
    class Meta:
        db_table = 'announcements'



class InternalPhones(models.Model):
    
    name = models.CharField(max_length=255, null=True, blank=True)
    number = models.CharField(null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True, null=True, blank=True)
    updated_at = models.DateTimeField(auto_now=True, null=True, blank=True)
    
    class Meta:
        db_table = "internal_phones"




