from django.db import models
from usermanagement.models import Users


class InsuranceMembers(models.Model):
    
    first_name= models.CharField(max_length=255, null=True, blank=True)
    last_name = models.CharField(max_length=255, null=True, blank=True)
    father_name = models.CharField(max_length=255, null=True, blank=True)
    relationship = models.ForeignKey('Relationship', on_delete=models.SET_NULL, null=True)
    gender = models.CharField(max_length=255, null=True, blank=True)
    identity_number = models.CharField(max_length=255, null=True, blank=True)
    national_code = models.CharField(max_length=255, null=True, blank=True)
    birth_date = models.DateTimeField(null=True, blank=True)
    insurance_code = models.CharField(max_length=255, null=True, blank=True)
    parent_id = models.IntegerField(null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
    
    class Meta:
        db_table = "insured_members"


class InsuranceDocuments(models.Model):
    
    insurance_contract = models.ForeignKey('InsuranceContracts', on_delete=models.SET_NULL, null=True, blank=True)
    insurance_member = models.ForeignKey('InsuranceMembers', on_delete=models.SET_NULL, null=True, blank=True)
    user = models.ForeignKey(Users, on_delete=models.SET_NULL, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
    
    class Meta:
        db_table = "insurance_documents"


class InsurancePeriods(models.Model):
    
    user = models.ForeignKey(Users, on_delete=models.SET_NULL, null=True, blank=True)
    period_number = models.IntegerField(null=True, blank=True)
    period_date = models.DateTimeField(null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
    
    class Meta:
        db_table = "insurance_periods"


class InsuranceServices(models.Model):
    
    title = models.CharField(max_length=255, null=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
    
    class Meta:
        db_table = "insurance_services"


class InsuranceRequests(models.Model):
    
    user = models.ForeignKey(Users, on_delete=models.SET_NULL, null=True, blank=True)
    document = models.ForeignKey('InsuranceDocuments', on_delete=models.SET_NULL, null=True, blank=True)
    member = models.ForeignKey('InsuranceMembers', on_delete=models.SET_NULL, null=True, blank=True)
    service = models.ForeignKey('InsuranceServices', on_delete=models.SET_NULL, null=True, blank=True)
    period = models.ForeignKey('InsurancePeriods', on_delete=models.SET_NULL, null=True, blank=True)
    flag = models.ForeignKey('Flags', on_delete=models.SET_NULL, null=True, blank=True)
    claimed_service = models.CharField(max_length=255, null=True, blank=True)
    claimed_fee = models.IntegerField(null=True, blank=True)
    claimed_date = models.DateTimeField(null=True, blank=True)
    benefit = models.IntegerField(null=True, blank=True)
    description = models.TextField(null=True, blank=True)
    attachments = models.FileField(upload_to='insurance_attachments/', null=True, blank=True)
    result = models.TextField(null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
    
    class Meta:
        db_table = "insurance_requests"
    

class Relationship(models.Model):
    
    title = models.CharField(max_length=255, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
    
    class Meta:
        db_table = 'relationships'


class InsuranceContracts(models.Model):
    
    company = models.CharField(max_length=255, null=True, blank=True)
    title = models.CharField(max_length=255, null=True, blank=True)
    number = models.CharField(max_length=255, null=True, blank=True)
    start_date = models.DateTimeField(null=True, blank=True)
    end_date = models.DateTimeField(null=True, blank=True)
    is_active = models.BooleanField(default=False)
    description = models.TextField(null=True, blank=True)
    close = models.IntegerField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
        
    class Meta:
        db_table = 'insurance_contracts'


class InsuranceContractMembers(models.Model):
    
    insurance_contract = models.ForeignKey('InsuranceContracts', on_delete=models.SET_NULL, null=True)
    insurance_member = models.ForeignKey('InsuranceMembers', on_delete=models.SET_NULL, null=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
        
    class Meta:
        db_table = 'insurance_contract_members'


class InsuranceContractPeriods(models.Model):
    
    insurance_contract = models.ForeignKey('InsuranceContracts', on_delete=models.SET_NULL, null=True)
    insurance_period = models.ForeignKey('InsurancePeriods', on_delete=models.SET_NULL, null=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
        
    class Meta:
        db_table = 'insurance_contract_periods'


class InsuranceContractServices(models.Model):
    
    insurance_contract = models.ForeignKey('InsuranceContracts', on_delete=models.SET_NULL, null=True)
    insurance_service = models.ForeignKey('InsuranceServices', on_delete=models.SET_NULL, null=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)
        
    class Meta:
        db_table = 'insurance_contract_services'


class Flags(models.Model):
    
    name = models.CharField(max_length=255)
    color = models.CharField(max_length=255, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True, blank=True, null=True)
    updated_at = models.DateTimeField(auto_now=True, blank=True, null=True)

    class Meta:
        db_table = 'flags'




