<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once '../../include/vars.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';

$action = $_POST["action"];
$domain = $_POST["domain"];

function returnCurlResult($url, $action, $time, $domain)
{
    $r = API_REPORT_ADMIN::RunAccessLog($domain, $time, $action);
    return  $r;
}

$validtimerange = ["3h" => "3", "6h" => "6", "12h" => "12", "1d" => "24", "1w" => "7d", "1m" => "30d"];
if (!isset($validtimerange[$_POST["time"]])) {
    echo json_encode(["status" => "error", $dtse, "message" => "زمان درخواستی شما نامعتبر است"]);
    return;
}

if ($_POST["website"] != $domain) {
    $domain = $_POST["website"] . "." . $_POST["domain"];
}

if ($_POST["action"] == "CountryBytes") {
    if (!file_exists("countrybytess/" . $domain))
        mkdir("countrybytess/" . $domain);

    $fp = "countrybytess/" . $domain . "/" . $validtimerange[$_POST["time"]] . ".report";

    if (file_exists($fp)) {
        $response = file_get_contents($fp);

        $now = date("Y/m/d H:i:s");
        $rep = json_decode($response, true);
        $expire = $rep["expire"];
        if ($now > $expire) {
            $response = returnCurlResult(
                '',
                $_POST['action'],
                $validtimerange[$_POST["time"]],
                $domain
            );

            $m = [];
            $url = "";

            $rep = json_decode($response, true);
            asort($rep);
            $keys = array_keys($rep);
            $arraySize = count($rep);
            // AF: {
            //     bytes: 587
            // }
            $o = [];
            $resp = [];
            $allCountry = [];

            $allCountry = TOOLS_ADMIN::ReturnCountry();
            $vals = 0;

            foreach ($rep as $t => $j) {
                foreach ($j as $d => $ds) {
                    $fn = intVal($o[TOOLS_ADMIN::CountryToIso($d)]) + $ds;
                    $o[TOOLS_ADMIN::CountryToIso($d)] = $fn;
                    $resp[$d] = $fn;
                    $vals += intVal($fn);
                }
            }

            if ($_POST["action"] != "CountryVisits") {
                foreach ($resp as $r => $m) {
                    $resp[$r] = $m; //number_format($m / 1048576, 1, '.', '');
                }
                foreach ($o as $r => $m) {
                    $o[$r] = $m; // number_format($m / 1048576, 1, '.', '');
                }
            }
            $output = [
                "status" => "success",
                "data" => [
                    "map" => [$o],
                    "table" => [$resp]
                ]
            ];
            $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

            $dtss = ["expire" => $expire, "data" => $output];
            $dmns = json_encode($dtss);
            $myfile = fopen($fp, "w") or die(json_encode(["status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp]));
            fwrite($myfile, $dmns);
            fclose($myfile);

            echo json_encode($output);
        } else {
            $rep = $rep["data"];
            echo json_encode($rep);
        }
    } else {
        $response = returnCurlResult(
            '',
            $_POST['action'],
            $validtimerange[$_POST["time"]],
            $domain
        );

        $m = [];
        $url = "";

        $rep = json_decode($response, true);
        asort($rep);
        $keys = array_keys($rep);
        $arraySize = count($rep);
        // AF: {
        //     bytes: 587
        // }
        $o = [];
        $resp = [];
        $allCountry = [];

        $allCountry = TOOLS_ADMIN::ReturnCountry();
        $vals = 0;

        foreach ($rep as $t => $j) {
            foreach ($j as $d => $ds) {
                //   foreach($s as $d=>$ds){
                if ($_POST["action"] == "CountryVisits") {

                    $fn = intVal($o[TOOLS_ADMIN::CountryToIso($d)]) + $ds;
                    $o[TOOLS_ADMIN::CountryToIso($d)] = $fn;
                    $resp[$d] = $fn;
                    $vals += intVal($fn);
                    //   $o[TOOLS_ADMIN::CountryToIso($keys[$i])] = [$_POST["action"] => $rep[$keys[$i]]] ;
                } else {
                    $fn = intVal($o[TOOLS_ADMIN::CountryToIso($d)]) + $ds;
                    // $a=intVal($o[TOOLS_ADMIN::CountryToIso($d)])+$ds;
                    // $b=intVal($resp[TOOLS_ADMIN::CountryToIso($d)])+$ds;
                    $o[TOOLS_ADMIN::CountryToIso($d)] = $fn; //number_format($a / 1073741824, 1, '.', '');
                    $resp[$d] = $fn; //number_format($b/ 1073741824, 1, '.', '');
                    $vals += intVal($fn);
                    // $o[TOOLS_ADMIN::CountryToIso($keys[$i])] = [ $_POST["action"] => number_format($rep[$keys[$i]] / 1073741824, 1, '.', '') ];
                }
                // }
                //   print_r($s);
            }
        }

        if ($_POST["action"] != "CountryVisits") {
            foreach ($resp as $r => $m) {
                $resp[$r] = $m; // number_format($m / 1048576, 1, '.', '');
            }
            foreach ($o as $r => $m) {
                $o[$r] = $m; // number_format($m / 1048576, 1, '.', '');
            }
        }
        $output = [
            "status" => "success",
            "data" => [
                "map" => [$o],
                "table" => [$resp]
            ]
        ];
        $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

        $dtss = ["expire" => $expire, "data" => $output];
        $dmns = json_encode($dtss);
        $myfile = fopen($fp, "w") or die(json_encode(["status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp]));
        fwrite($myfile, $dmns);
        fclose($myfile);

        echo json_encode($output);
    }
} else {
    if (!file_exists("CountryVisits/" . $domain))
        mkdir("countryvisits/" . $domain);

    $fp = "countryvisits/" . $domain . "/" . $validtimerange[$_POST["time"]] . ".report";

    if (file_exists($fp)) {
        $response = file_get_contents($fp);

        $now = date("Y/m/d H:i:s");
        $rep = json_decode($response, true);
        $expire = $rep["expire"];
        if ($now > $expire) {
            $response = returnCurlResult(
                '',
                $_POST['action'],
                $validtimerange[$_POST["time"]],
                $domain
            );

            $m = [];
            $url = "";

            $rep = json_decode($response, true);
            asort($rep);
            $keys = array_keys($rep);
            $arraySize = count($rep);
            $o = [];
            $resp = [];
            $allCountry = [];

            $allCountry = TOOLS_ADMIN::ReturnCountry();
            $vals = 0;

            foreach ($rep as $t => $j) {
                foreach ($j as $d => $ds) {
                    $fn = intVal($o[TOOLS_ADMIN::CountryToIso($d)]) + $ds;
                    $o[TOOLS_ADMIN::CountryToIso($d)] = $fn;
                    $resp[$d] = $fn;
                    $vals =   $vals + intVal($fn);
                }
            }

            if ($_POST["action"] != "CountryVisits") {
                foreach ($resp as $r => $m) {
                    $resp[$r] = $m; //number_format($m / 1048576, 1, '.', '');
                }
                foreach ($o as $r => $m) {
                    $o[$r] = $m; // number_format($m / 1048576, 1, '.', '');
                }
            }
            $output = [
                "status" => "success",
                "data" => [
                    "map" => [$o],
                    "table" => [$resp]
                ]
            ];

            $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

            $dtss = ["expire" => $expire, "data" => $output];
            $dmns = json_encode($dtss);
            $myfile = fopen($fp, "w") or die(json_encode(["status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp]));
            fwrite($myfile, $dmns);
            fclose($myfile);

            echo json_encode($output);
        } else {
            $rep = $rep["data"];
            echo json_encode($rep);
        }
    } else {

        $response = returnCurlResult(
            '',
            $_POST['action'],
            $validtimerange[$_POST["time"]],
            $domain
        );

        $m = [];
        $url = "";

        $rep = json_decode($response, true);
        asort($rep);
        $keys = array_keys($rep);
        $arraySize = count($rep);
        // AF: {
        //     bytes: 587
        // }
        $o = [];
        $resp = [];
        $allCountry = [];

        $allCountry = TOOLS_ADMIN::ReturnCountry();
        $vals = 0;

        foreach ($rep as $t => $j) {
            foreach ($j as $d => $ds) {
                $fn = 0;
                if (isset($o[TOOLS_ADMIN::CountryToIso($d)]))
                    $fn = intVal($o[TOOLS_ADMIN::CountryToIso($d)]) + $ds;
                else
                    $o[TOOLS_ADMIN::CountryToIso($d)] = $ds;

                $o[TOOLS_ADMIN::CountryToIso($d)] = $fn;
                $resp[$d] = $fn;
                $vals = $vals + intVal($fn);
            }
        }
        // WTF????
        if ($_POST["action"] != "CountryVisits") {
            foreach ($resp as $r => $m) {
                $resp[$r] = $m; //number_format($m / 1048576, 1, '.', '');
            }
            foreach ($o as $r => $m) {
                $o[$r] = $m; // number_format($m / 1048576, 1, '.', '');
            }
        }
        $output = [
            "status" => "success",
            "data" => [
                "map" => [$o],
                "table" => [$resp]
            ]
        ];
        $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

        $dtss = ["expire" => $expire, "data" => $output];
        $dmns = json_encode($dtss);
        $myfile = fopen($fp = ("countryvisits/" . $domain . "/" . $validtimerange[$_POST["time"]] . ".report"), "w")
            or die(json_encode(["status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp]));
        fwrite($myfile, $dmns);
        fclose($myfile);

        echo json_encode($output);
    }
}
