<?php

require_once '../include/vars.php';
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

$dateExpire = date("Y/m/d H:i:s", strtotime("+1 months"));

// $sql = "SELECT freessl_id,fs_websiteid,fs_sp_id_fk,fs_cert,fs_expiredate  FROM
// `tbl_freessl`, tbl_ssl_websites where sw_sp_id_fk=fs_sp_id_fk and fs_expiredate < '" . $dateExpire . "'";
$sql="SELECT freessl_id,fs_websiteid,fs_sp_id_fk,fs_cert,fs_expiredate,d_name,ws_recordname
 FROM `tbl_freessl`, tbl_ssl_websites,tbl_websites,tbl_domains
  where  d_status=1 and domain_id=ws_domainid_fk and
  wsid=tbl_ssl_websites.sw_ws_id_fk and sw_sp_id_fk=fs_sp_id_fk
  and fs_expiredate < '".$dateExpire."'
order by  fs_expiredate desc";
$conn = GetConnection();

$re = $conn->query($sql);

$list = mysqli_fetch_all($re, MYSQLI_ASSOC);
//print_r($list);
foreach ($list as $l) {
	if($l["ws_recordname"]==$l["d_name"])
		echo "Domain: ".$l["d_name"];
	else
		echo "Domain: ".$l["ws_recordname"].".".$l["d_name"];

	$certinfo = openssl_x509_parse($l["fs_cert"]);
	if ($certinfo['validFrom_time_t'] > time() || $certinfo['validTo_time_t'] < time()) {
		// print_r(["status" => 400, "message" => "گواهینامه منقضی شده  است "]);
	} else {
		$crtindfo = [];
		$crtindfo["MainDomain"] = $certinfo["subject"]["CN"];
		$crtindfo["issuer"] = $certinfo["issuer"]["CN"];
		$crtindfo["websiteid"] = $l["fs_websiteid"];
		$crtindfo["startdate"] = date('Y/m/d H:i:s', $certinfo["validFrom_time_t"]);
		$crtindfo["expiredate"] = date('Y/m/d H:i:s', $certinfo["validTo_time_t"]);
		$crtindfo["alternativedomains"] = $certinfo["extensions"]["subjectAltName"];
		$websitedet = WEBSITES_ADMIN::GetWebsiteWithoutUser($l["fs_websiteid"]);
		$crtindfo["websitedet"] = $websitedet;
		if ($websitedet["status"] == "error") {
			// print_r("website deleted");
		} else {
			// print_r($crtindfo);
			API_SSL_ADMIN::RunCreateAPIFREESSL($certinfo["subject"]["CN"], $l["fs_sp_id_fk"], $l["freessl_id"], $websitedet["data"][0]["d_name"]);
		}
	}
}
