<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class CLOUD_IPPOOL_ADMIN
{
    public static function GetPoolList()
    {
        $sql = "SELECT * FROM `tbl_cloud_ippool` LEFT JOIN tbl_cloud_idc ON JSON_CONTAINS(cp_idcid_fk, ciid, '$')  ORDER BY cp";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function AddIPToPOOL($token,$idcid)
    {

    }
    public static function GetListWithoutToken($uid)
    {
        $sql = "SELECT cv_serverid  as sid," . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate
             from " . $GLOBALS["cloud_volume_tablename"] . "
               where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=0 ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
        public static function GetList($token, $idc,$issnapshot=1)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
         $sql ="";
        if($issnapshot==1){
        $sql = "SELECT csid as ServerID," . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
        csname as ServerHostName from  " . $GLOBALS["cloud_volume_tablename"] . "
        LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=".$issnapshot." AND " . $GLOBALS['cv_idcid_fk'] . "=" . $idc;
        }
        else{
            $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
        csname as ServerHostName from " . $GLOBALS["cloud_volume_tablename"] . "
        LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=".$issnapshot." AND " . $GLOBALS['cv_idcid_fk'] . "=" . $idc;

        }
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
         $i=0;
        foreach($listOfRecordType as $l){
            $listOfRecordType[$i]["VolumeName"]= explode(" ",$l["VolumeName"])[0];
            $i++;
        }
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetListOfSnapShot($token, $serverid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
        csname as ServerHostName from " . $GLOBALS["cloud_volume_tablename"] . "
        LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND cv_is_snapshot=1 and cv_csid_fk=" . $serverid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function RemoveVolume($token, $id)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        $cv=CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $id);
        if ($cv["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فضای ذخیره سازی را ندارید"];
        }

        $vdet = CLOUD_VOLUME_ADMIN::GetOneByID($token, $id);
        $idc = $vdet["data"][0]["idc"];
        $sid = $vdet["data"][0]["sid"];
        $status = $vdet["data"][0]["VolumeStatus"];
        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        if ($status == "inuse") {
            return ["status" => "error", "message" => "فضای ذخیره سازی درخواستی شما به یک سرور متصل است ابتدا آن را از سرور جدا نموده و سپس حذف نمایید"];
        }

        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "DELETE FROM   " . $GLOBALS["cloud_volume_tablename"] . " WHERE "  . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        if($cv["data"][0]["cv_is_snapshot"]=="1"){
              API_CLOUD_SNAPSHOT_ADMIN::RunRemoveSnapshot($sid,$m,$idc);
        }
        else{
                    API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($sid, $m, $idc);
        }
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
    public static function GetOneByID($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,cv_osname,cv_osid,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate ," . $GLOBALS['cv_idcid_fk'] . " as idc
            ," . $GLOBALS['cv_serverid'] . " as sid
          from " . $GLOBALS["cloud_volume_tablename"] . " WHERE " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cvid'] . "=" . $id;

        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToVolume($uid, $id)
    {
        $sql = "SELECT *
        from " . $GLOBALS["cloud_volume_tablename"] . " WHERE " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", $id];
    }
    public static function CheckDuplicatedName($uid, $name)
    {
        $sql = "SELECT * FROM " . $GLOBALS["cloud_volume_tablename"] . " WHERE " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cv_name'] . "='" . $name . "'";

        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",  $sql];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function ExtendVolume($token, $idc, $space, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        if (filter_var($space, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "مقدار ارسالی برای فضای دیسک اشتباه است"];
        }

        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        if (CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $id)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فضای ذخیره سازی را ندارید"];
        }
        $vdet = CLOUD_VOLUME_ADMIN::GetOneByID($token, $id);
        $CurrentSpace = $vdet["data"][0]["VolumeSpace"];
        $idc = $vdet["data"][0]["idc"];
        $sid = $vdet["data"][0]["sid"];

        if ($space < $CurrentSpace) {
            return ["status" => "error", "message" => "امکان کاهش حجم دیسک ذخیره سازی نیست"];
        }
        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_space'] . "='" . $space
            . "'," . $GLOBALS['cv_update_date'] . "='" . $now . "' WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        API_CLOUD_VOLUME_ADMIN::RunExtendAPIVolume($sid, $m, $idc, $space);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
    public static function AddVolume($token, $name, $space, $idcid)
    {

    }
    public static function AddVolumeAndAttachToServer($token, $name, $space, $idcid, $osname, $osid)
    {

    }

    public static function AddVolumeWithSnapShot($token, $name, $space, $idcid, $osname, $osid, $snapshotid, $serverid,$storage_Type)
    {

    }

    public static function UpdateIDFromAPI($id, $serverid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_serverid'] . "='" . $serverid
            . "' WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function UpdateServerID($id, $serverid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_csid_fk'] . "='" . $serverid
            . "' WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function UpdateVPSID($vlid, $vpsid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_csid_fk'] . "='" . $vpsid
        ."'," . $GLOBALS['cv_status'] . "='1' where " . $GLOBALS['cvid'] . "=" . $vlid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function UpdateVPSIDNull($vlid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_csid_fk'] . "='0',"
        ."'," . $GLOBALS['cv_status'] . "='0'  where " . $GLOBALS['cvid'] . "=" . $vlid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function AddSnapShotVolume($uid, $name, $space, $idcid, $id, $osname, $osid, $vpsid)
    {
        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "INSERT INTO " . $GLOBALS["cloud_volume_tablename"] . "
        (`cvid`, `cv_name`, `cv_uid_fk`, `cv_space`, `cv_csid_fk`, `cv_status`, `cv_creation_date`,
         `cv_update_date`, `cv_bootable`, `cv_serverid`, `cv_idcid_fk`, `cv_osname`, `cv_osid`,
         `cv_is_snapshot`) VALUES
         (0,'" . $name . "','" . $uid . "','" . $space . "','".$vpsid."','0','" . $now . "','" . $now . "',0,'" .
          $id . "','" . $idcid . "','" . $osname . "','" . $osid . "',1)";
        $conn = GetConnection();
        $conn->query($sql);
        $ids=$conn->insert_id;
        $conn->close();
        return $ids;
    }
}
