<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class API_CLOUD_PRIVATENETWORKS_ADMIN
{

    public static function RunCreateAPINETWORK(
        $mail,
        $name,
        $prefixlen,
        $cidr,
        $gateway_ip,
        $allocation_pools_Str,
        $dns_nameservers_Str,
        $enable_dhcp,
        $idcid,
        $allocation_pools,
        $dns_nameservers
    ) {

        $actionUrl = "api/v1/subnet/create";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["name"] = $name;
        $postededata["cidr"] = $cidr;
        $postededata["gateway_ip"] = $gateway_ip;
        $postededata["prefixlen"] = $prefixlen;
        $postededata["enable_dhcp"] = $enable_dhcp;
        $postededata["allocation_pools_Str"] = $allocation_pools_Str;
        $postededata["dns_nameservers_Str"] = $dns_nameservers_Str;
        $postededata["IsError"] = false;
        $postededata["dns_nameservers"] = $dns_nameservers;
        $postededata["allocation_pools"] = $allocation_pools;
        $postededata["ip_version"] = "4";

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
         $api = json_decode($apiOut,true);
        $cljs=json_encode($postededata);
        str_replace("'","\'",$cljs);
        // $s= CLOUD_LOG_ADMIN::ADDLog("URL : ".$actionUrl."; ".$cljs,$apiOut);

        if (strpos($apiOut, 'subnet') !== false) {
            $m = json_decode($apiOut);
            $id = $m->subnet->id;
            return ["status" => "success", "data" => $id];
        }
        return ["status" => "error",$apiOut];
    }
    public static function RunUpdateAPINETWORK(
        $mail,
        $name,
        $prefixlen,
        $cidr,
        $gateway_ip,
        $allocation_pools_Str,
        $dns_nameservers_Str,
        $enable_dhcp,
        $idcid,
        $allocation_pools,
        $dns_nameservers,
        $subnet
    ) {

        $actionUrl = "api/v1/subnet/update";
        $postededata["useraccount"] = $mail;
        $postededata["passcode"] = md5($mail);
        $postededata["name"] = $name;
        $postededata["cidr"] = $cidr;
        $postededata["gateway_ip"] = $gateway_ip;
        $postededata["prefixlen"] = $prefixlen;
        $postededata["enable_dhcp"] = $enable_dhcp;
        $postededata["allocation_pools_Str"] = $allocation_pools_Str;
        $postededata["dns_nameservers_Str"] = $dns_nameservers_Str;
        $postededata["IsError"] = false;
        $postededata["dns_nameservers"] = $dns_nameservers;
        $postededata["allocation_pools"] = $allocation_pools;
        $postededata["ip_version"] = "4";
        $postededata["subnet"] = $subnet;

        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idcid);
        if (strpos($apiOut, 'subnet') !== false) {
            $m = json_decode($apiOut);
            $id = $m->subnet->id;
            return ["status" => "success", $postededata,$apiOut, "data" => $id];
        }

         $api = json_decode($apiOut,true);
        $cljs=json_encode($postededata);
        str_replace("'","\'",$cljs);
        // $s= CLOUD_LOG_ADMIN::ADDLog("URL : ".$actionUrl."; ".$cljs,$apiOut);

        return ["status" => "error"];
    }

    public static function RunDeleteSubnet($m,$networkid,$idc)
    {
        $actionUrl = "api/v1/subnet/delete";
        $postededata["useraccount"] = $m;
        $postededata["passcode"] = md5($m);
        $postededata["subnet"] = $networkid;
        $apiOut = SENDAPI_MIDDLECLOUD::SendCloudAPI($actionUrl, $postededata, $idc);

        if (strpos($apiOut, 'status') == true) {

            return ["status" => "error" ,$apiOut];
        }
        return ["status" => "success" ];
    }
    public static function RunDeleteDomainCDN($domain)
    {
        $actionUrl = "api/";
        $postededata["action"] = "dns_delete";
        $postededata["domain"] = $domain;

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
}
