<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/websites_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/domains/admin/domains_admin_class.php';

class WEBSITES_ADMIN
{
	public static function CheckPlan($token, $websiteID, $needed)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteID, $uid);
		if ($websitesOwner["status"] == "error") {
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}

		$planwebsite = $websitesOwner["data"][0]["d_plan"];
		$plans = ReturnPlans();
		if (isset($plans[$planwebsite])) {
			if (isset($plans[$planwebsite][$needed])) {
			} else {
				return [
					"status" => "error", "action" => "needtoupgrade",
					"message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید ",
					"plans" => CheckPlanRequest($needed)

				];
			}
		} else {
			return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
		}
		return ["status" => "success"];
		// 902
	}
	public static function updateFirewallDefault($websiteid, $method, $token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
		if ($websitesOwner["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}

		$allowedMEthods = ["allow", "deny"];
		if (!in_array($method, $allowedMEthods)) {
			return ["status" => "error", "message" => "وضعیت ارسالی نامعتبر است"];
		}
		$sql = "update tbl_websites set ws_default_firewall='" . $method . "' where wsid=" . $websiteid;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		$df = "no";
		if ($method == "allow") {
			$df = "yes";
		}
		$a = MAINRESTRICTION_ADMIN::GenerateAndSendDataToAPI($websiteid, $uid, $df);
		return [
			"status" => "success", $a,
			"message" => "اطلاعات با موفقیت ثبت  شد ",

		];
	}
	public static function CheckForDowngrade($token, $websiteid, $newPlan)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		if ($usersDetails["credit"] < 0) {
			return ["status" => "error", "message" => "اعتبار شما منفی است و امکان کاهش پلان را ندارید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
		if ($websitesOwner["status"] == "error") {
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}
		$currentPlan = $websitesOwner["data"][0]["d_plan"];
		if (!isset(ReturnPlans()[$currentPlan])) {
			return ["status" => "error", "message" => "پلان درخواستی شما ناموجود است"];
		}
		if (!isset(ReturnPlans()[$newPlan])) {
			return ["status" => "error", "message" => "پلان درخواستی شما ناموجود است"];
		}
		$domainID = $websitesOwner["data"][0]["domain_id"];
		$CurrentIndex = returnIndexPlan(ReturnPlans(), $currentPlan);
		$newPlanIndex = returnIndexPlan(ReturnPlans(), $newPlan);
		if ($newPlanIndex > $CurrentIndex) {
			return ["status" => "success"];
		}

		//Check DomainNSRecord
		$DomainNSValidation = DOMAINNSRECORD_ADMIN::CheckValidationForDownrade($domainID, $currentPlan, $newPlan);
		if ($DomainNSValidation["status"] == "error") {
			return $DomainNSValidation;
		}
		//Check WAF
		$wafValidation = WAF_ADMIN::CheckWafForDownGrade($domainID, $currentPlan, $newPlan);
		if ($wafValidation["status"] == "error") {
			return $wafValidation;
		}
		//Check Firewall
		$mainRestrictionValidation = MAINRESTRICTION_ADMIN::CheckFirewallForDownGrade($domainID, $currentPlan, $newPlan);
		if ($mainRestrictionValidation["status"] == "error") {
			return $mainRestrictionValidation;
		}
		//Check Rate limit
		$ratelimitValidation = RATELIMIT_ADMIN::CheckRatelimitForDownGrade($domainID, $currentPlan, $newPlan);
		if ($ratelimitValidation["status"] == "error") {
			return $ratelimitValidation;
		}

		//Check UNDERAttack
		$UnderAttackValidation = UnderAttack_ADMIN::CheckUnderAttackForDownGrade($domainID, $currentPlan, $newPlan);
		if ($UnderAttackValidation["status"] == "error") {
			return $UnderAttackValidation;
		}

		//Check DefaultPages
		$DefaultPageValidation = DEFAULTPAGE_ADMIN::CheckDefaultPageForDownGrade($domainID, $currentPlan, $newPlan);
		if ($DefaultPageValidation["status"] == "error") {
			return $DefaultPageValidation;
		}

		//Check Cluster
		$ClusterValidation = CLUSTERS_ADMIN::CheckClusterForDownGrade($domainID, $currentPlan, $newPlan);
		if ($ClusterValidation["status"] == "error") {
			return $ClusterValidation;
		}

		//Check CACHE
		$ClusterValidation = CACHE_ADMIN::CheckCacheForDownGrade($domainID, $currentPlan, $newPlan);
		if ($ClusterValidation["status"] == "error") {
			return $ClusterValidation;
		}

		//Check resize image
		$ClusterValidation = MINIFYWEBSITE_ADMIN::CheckResizeImageForDownGrade($domainID, $currentPlan, $newPlan);
		if ($ClusterValidation["status"] == "error") {
			return $ClusterValidation;
		}

		//Check PageRules
		$ClusterValidation = SUBFOLDERRULES_ADMIN::CheckPageRuleForDownGrade($domainID, $currentPlan, $newPlan);
		if ($ClusterValidation["status"] == "error") {
			return $ClusterValidation;
		}

		$ClusterValidation = SUBFOLDERRULES_ADMIN::CheckConnectionTimeOurForDownGrade($domainID, $currentPlan, $newPlan);
		if ($ClusterValidation["status"] == "error") {
			return $ClusterValidation;
		}

		return ["status" => "success"];
		// $dnsStatus=DOMAINNSRECORD_ADMIN::CheckForDownGrade($websiteid,$plan,$oldplan);
		return ["status" => "error", "message" => "شما امکان کاهش پلان را ندارید"];
	}
	public static function DeleteAllWebSitesByDomain($domainid)
	{
		$sql = "DELETE from tbl_websites where ws_domainid_fk=" . $domainid;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
	}
	public static function SendEmailForDeactiveCDN($uname, $domain, $umail, $umobile)
	{
		$mailTemplate = '
            %s عزیز،
            <br />
            به علت منفی شدن اعتبار کیف پول شما در میزبان کلود، عبور ترافیک از سرورهای میزبان کلود برای دامنه %s  و تمام ساب دامنه های آن متوقف گردید.
            <br />
            جهت فعالسازی مجدد و بهره مندی از این سرویس، در اسرع وقت نسبت به افزایش اعتبار حساب خود اقدام فرمایید.
            <br /><br />
        ';
		$mailTemplate = sprintf($mailTemplate, $uname, $domain);
		$params = [
			"param1" => $uname,
			"param4" => $domain

		];
		$o = EMAILCLASS::SendEmailPanel($umail, "غیر فعال شدن سرویس CDN سایت " . $domain . " در میزبان کلود", $mailTemplate, "error");
		//,"2kax476ckc",$params,$umobile);
		//  $o= EMAILCLASS::SendEmailPanel($validticket["data"][0]["umail"],"پاسخ به تیکت شما  در میزبان کلود",$mailTemplate,"success","TicketReply",$params,$validticket["data"][0]["umobile"]);

	}
	public static function UserCanAccessToWebsite($uid, $websiteid)
	{
		if ($uid != 0) {
			$sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain FROM
         `tbl_websites`,tbl_domains
                WHERE domain_id=ws_domainid_fk
                and d_status!=2
                    and  wsid=" . $websiteid . " AND " . $GLOBALS['d_user_id_fk'] . "=" . $uid;
		} else {
			$sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain FROM
         `tbl_websites`,tbl_domains
                WHERE domain_id=ws_domainid_fk
                and d_status!=2
                and wsid=" . $websiteid;
		}
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			if ($uid != 0) {
				$sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain FROM
         `tbl_websites`,tbl_domains
                WHERE domain_id=ws_domainid_fk
                and d_status!=2
                    and  wsid=" . $websiteid . " AND " . $GLOBALS['d_user_id_fk'] . "=" . $uid;
			} else {
				$sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain FROM
                    `tbl_websites`,tbl_domains
                WHERE domain_id=ws_domainid_fk
                and d_status!=2
                and wsid=" . $websiteid;
			}

			$result = $conn->query($sql);
			if (!$result || mysqli_num_rows($result) == 0) {
				$res = ["status" => "error", "sql2" => $sql];
			} else {
				$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
				unset($list[0]["wsplan"]);
				$list[0]["wsplan"] = $list[0]["d_plan"];
				$res = [
					"status" => "success", "state" => "withoutrecord",
					"data" => $list
				];
			}
		} else {

			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($list[0]["wsplan"]);
			$list[0]["wsplan"] = $list[0]["d_plan"];
			$res = [
				"status" => "success",  "state" => "withrecord",
				"data" => $list
			];
		}

		$conn->close();
		return $res;
	}
	public static function GetAllWebsiteByDomain($domainid)
	{
		$sql = "SELECT * FROM tbl_websites  where ws_domainid_fk =" . $domainid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		if (count($list) == 0) {
			return ["status" => "error", "message" => "وب سایت موجود نیست"];
		} else {
			return ["status" => "success", "message" => "وب سایت موجود است", "data" => $list];
		}
	}
	public static function UpdatePlan($websiteid, $token, $plan)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);

		if ($websitesOwner["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}
		if ($websitesOwner["data"][0]["wsplan"] == $plan) {
			return ["status" => "error", "message" => "پلان فعلی و درخواستی شما یکسان است"];
		}
		$domainid = $websitesOwner["data"][0]["ws_domainid_fk"];
		$websitelist = self::GetAllWebsiteByDomain($domainid);
		$plansArr = ["free" => 0, "eco" => 1, "com" => 2, "pro" => 3, "org" => 4];
		if (!isset($plansArr[$plan]))
			return ["status" => "error", $plan, "message" => "پلان درخواستی شما نامعتبر است"];
		$zone = "0";
		$maxsize = "512";

		// if ($plan == "pro") {
		//     $zone = "30";
		//     $maxsize = "20480";
		// } else if ($plan == "com") {
		//     $zone = "25";
		//     $maxsize = "15360";
		// } else if ($plan == "free") {
		//     $zone = "15";
		//     $maxsize = "5120";
		// } else if ($plan == "org") {
		//     $zone = "30";
		//     $maxsize = "20480";
		// } else if ($plan == "eco") {
		//     $zone = "20";
		//     $maxsize = "10240";
		// } else {
		//     $zone = "15";
		//     $maxsize = "5120";
		// }
		$domain = $websitesOwner["data"][0]["d_name"];
		$domaindid = $websitesOwner["data"][0]["ws_domainid_fk"];
		$IndexOfcurrentPlan = returnIndexPlan(ReturnPlans(), $websitesOwner["data"][0]["wsplan"]);
		$IndexOfNeededPlan = returnIndexPlan(ReturnPlans(), $plan);
		$zone = ReturnPlans()[$plan]["zone"];
		$maxsize = ReturnPlans()[$plan]["maxsize"];
		if ($IndexOfcurrentPlan < $IndexOfNeededPlan) {
			//UpGrade
			$neededBalance = intVal(ReturnPlans()[$plan]["price"]) * 120;
			if (intVal($usersDetails["credit"]) < $neededBalance) {
				return [
					"status" => "error", "state" => "nobalance",
					"nb" => $neededBalance, "message" => " حداقل اعتبار برای فعالسازی این پلان " . number_format($neededBalance) . " ریال  میباشد"
				];
			}
			$nowDate = date("Y/m/d H:i:s");

			$sql = "UPDATE tbl_websites set wsplan='" . $plan . "',ws_activedate='" . $nowDate . "' where ws_domainid_fk=" . $domaindid;
			$conn = GetConnection();
			$conn->query($sql);
			if ($websitelist["status"] == "success") {
				foreach ($websitelist["data"] as $ls) {
					if ($ls["ws_recordname"] != $domain) {
						API_CAHCE_ADMIN::RunCacheVars($ls["ws_recordname"] . "." . $domain, $zone, $maxsize);
					}
				}
			}
			API_CAHCE_ADMIN::RunCacheVars($domain, $zone, $maxsize);
			$sql2 = "UPDATE tbl_domains set d_plan='" . $plan . "' where domain_id=" . $domaindid;
			$conn->query($sql2);
			$conn->close();
			USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
			$LOGS = FINANCIAL_DOMAINSLOGS_ADMIN::AddDomain($domaindid, $plan);

			return ["status" => "success", "message" => "پلان سایت مد نظر شما به پلان درخواستی تبدیل شد"];
		} else {
			$dateOflastChange = $websitesOwner["data"][0]["ws_activedate"];
			//   $dateOflastChangen=date(strtotime($dateOflastChange), strtotime("+5 days"));
			//   $dateOflastChangen=date("Y/m/d H:i:s",$dateOflastChangen);
			$nowDate = date("Y/m/d H:i:s");

			$dateOflastChangew = strtotime($dateOflastChange);
			$dateOflastChangen = strtotime("+5 day", $dateOflastChangew);
			$dateOflastChangen = date('Y/m/d H:i:s', $dateOflastChangen);
			if ($nowDate < $dateOflastChangen) {
				return ["status" => "error", $dateOflastChange, "message" => "حداقل زمان برای کاهش پلان وب سایت 5روز است"];
			}
			$sql = "UPDATE tbl_websites set wsplan='" . $plan . "',ws_activedate='" . $nowDate . "' where ws_domainid_fk=" . $domaindid;
			$conn = GetConnection();
			$conn->query($sql);

			$sql2 = "UPDATE tbl_domains set d_plan='" . $plan . "' where domain_id=" . $domaindid;
			$conn->query($sql2);

			$conn->close();
			$LOGS = FINANCIAL_DOMAINSLOGS_ADMIN::AddDomain($domaindid, $plan);
			if ($websitelist["status"] == "success") {
				foreach ($websitelist["data"] as $ls) {
					if ($ls["ws_recordname"] != $domain) {
						API_CAHCE_ADMIN::RunCacheVars($ls["ws_recordname"] . "." . $domain, $zone, $maxsize);
					}
				}
			}
			API_CAHCE_ADMIN::RunCacheVars($domain, $zone, $maxsize);
			USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
			return ["status" => "success", "LOGS" => $LOGS, "message" => "پلان سایت مد نظر شما به پلان درخواستی تبدیل شد"];
		}
		return ["current" => $IndexOfcurrentPlan, "Neede" => $IndexOfNeededPlan, "data" => $websitesOwner];
	}
	public static function UserCanAccessToWebsiteWithToken($websiteid, $token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return [
				"status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
			];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "SELECT * FROM " . $GLOBALS["websites_tablename"] . "," . $GLOBALS["domains_tablename"] .
			" WHERE " . $GLOBALS['ws_domainid_fk'] . "=" . $GLOBALS['domain_id']
			. " AND " . $GLOBALS['d_user_id_fk'] . "=" . $uid
			. " AND " . $GLOBALS['wsid'] . "=" . $websiteid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$res = ["status" => "error"];
		} else {

			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$res = ["status" => "success", "data" => WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid)["data"]];
		}

		$conn->close();
		return $res;
	}
	public static function WebsiteDetails($websiteid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["websites_tablename"] . "," . $GLOBALS["domains_tablename"] .
			" WHERE " . $GLOBALS['ws_domainid_fk'] . "=" . $GLOBALS['domain_id']
			. "  and " . $GLOBALS['wsid'] . "=" . $websiteid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$res = ["status" => "error"];
		} else {

			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$res = ["status" => "success", "data" => WEBSITES_ADMIN::GetWebsiteWithoutUser($websiteid)["data"]];
		}

		$conn->close();
		return $res;
	}
	public static function DeleteWebSite($recordname, $domainid)
	{
		$sql = "DELETE  from " . $GLOBALS["websites_tablename"] . " WHERE " .
			$GLOBALS['ws_domainid_fk'] . "=" . $domainid
			. "  and " . $GLOBALS['ws_recordname'] . "='" . $recordname . "'";
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		return $sql;
	}
	public static function GetListByUsers($token, $page, $countofpage)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$allDomains = DOMAINS_ADMIN::GetUserDomainList($token, $page, $countofpage);
		//  return $allDomains;
		if (isset($allDomains["data"])) {
			$allWebsite = [];

			foreach ($allDomains["data"] as $a) {
				$abcd = self::InternalGetWebsiteList($a["id"], $a["status"], $a["domain_name"]);
				unset($abcd["data"][0]);
				$r = [];
				if (array_key_exists("data", $abcd)) {
					foreach ($abcd["data"] as $abc) {
						unset($abc["wsplan"]);
						$abc["wsplan"] = $abc["d_plan"];
						if ($abc["ws_recordname"] != $a["domain_name"]) {
							array_push($r, $abc);
						}
					}
				}

				$abcd["data"] = $r;
				$allWebsite[$a["domain_name"]] = $abcd;
				$allWebsite[$a["domain_name"]]["plansdet"] = ReturnPlans()[$a["plan"]];
			}

			return [
				"status" => "success",
				"currentpage" => $allDomains["currentpage"],
				"countofpage" =>  $allDomains["countofpage"],
				"message" => "اطلاعات با موفقیت دریافت شد",
				"data" => $allWebsite
			];
		} else {
			return [
				"status" => "error",
				"currentpage" => $allDomains["currentpage"],
				"countofpage" =>  $allDomains["countofpage"],
				"message" => "شما سایتی ندارید "
			];
		}
	}
	public static function AddDefaultWebSite($domain, $domainid)
	{
		$webaddress = WEBSITES_ADMIN::GetOneByRecordid($domain, $domainid);
		if ($webaddress["status"] == "error") {
			$sql = "INSERT INTO `tbl_websites`(  `ws_domainid_fk`, `ws_recordname`, `ws_stauts` )
                  VALUES ('" . $domainid . "','" . $domain . "',1 )";

			$conn = GetConnection();
			mysqli_query($conn, $sql);
			$id = $conn->insert_id;
			// SUBFOLDER_ADMIN::InternalAddSubFolder($id, "/", 0);
			$conn->close();
			DOMAINS_ADMIN::UpdateDefaultWebsite($domainid, $id);
			API_CDN_ADMIN::RunCreateAPICDN($domain, "127.0.0.1", "automatic", "80");
			$plans = ReturnPlans()["free"];
			API_CAHCE_ADMIN::RunCacheVars($domain . "." . $domain, $plans["zone"], $plans["maxsize"]);

			return $id;
		} else {
			return $webaddress["id"];
		}
	}
	public static function wwwstatus($token, $websiteid, $status)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
		if ($websitesOwner["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}
		$validstatus = ["www", "nonwww", "off"];
		if (!in_array($status, $validstatus)) {
			return ["status" => "error", "message" => "وصعیت ارسالی نامعتبر است"];
		}
		if (strpos($websitesOwner["data"][0]["ws_recordname"], '*') !== false) {
			return ["status" => "error", "message" => "شما برای رکورد * امکان تغییر در این بخش را ندارید"];
		}

		if ($status == "www") {
			if ($websitesOwner["data"][0]["ws_recordname"] == 'www' || substr($websitesOwner["data"][0]["ws_recordname"], 0, 4) == 'www.') {
				return ["status" => "error", "message" => "شما امکان ریدایرکت برای این رکورد را ندارید"];
			}
		}
		//   return ["status" => "error", "message" => "OK"];

		//  return ["status" => "error", "message" => "شما برای رکورد * امکان تغییر در این بخش را ندارید"];
		$sql = "UPDATE tbl_websites set ws_www='" . $status . "' where wsid=" . $websiteid;
		$conn = GetConnection();
		mysqli_query($conn, $sql);
		$conn->close();
		$dmn = "";
		if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
			$dmn = $websitesOwner["data"][0]["d_name"];
		} else {
			$dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
		}
		$a = API_CDN_ADMIN::RunwwwstatusCDN($dmn, $status);
		return ["status" => "success", $websitesOwner["data"][0]["ws_recordname"] => substr($websitesOwner["data"][0]["ws_recordname"], 0, 4), "message" => "درخواست شما انجام شد"];
	}
	public static function getmainrecord($token, $domainid)
	{

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];

		$allDomains = DOMAINS_ADMIN::GetDomainMainRecord($token, $domainid);
		// return $allDomains;
		if (isset($allDomains["data"])) {
			$allWebsite = [];
			foreach ($allDomains["data"] as $a) {

				$abcd = self::InternalGetWebsiteList($a["id"], $a["status"], $a["domain_name"]);
				return $abcd;
				unset($abcd["data"][0]);
				$r = [];
				if (array_key_exists("data", $abcd)) {
					foreach ($abcd["data"] as $abc) {
						unset($abc["wsplan"]);
						$abc["wsplan"] = $abc["d_plan"];
						if ($abc["ws_recordname"] != $a["domain_name"]) {
							array_push($r, $abc);
						}
					}
				}

				$abcd["data"] = $r;
				$allWebsite[$a["domain_name"]] = $abcd;
			}

			return [
				"status" => "success",
				"currentpage" => $allDomains["currentpage"],
				"countofpage" =>  $allDomains["countofpage"],
				"message" => "اطلاعات با موفقیت دریافت شد",
				"data" => $allWebsite
			];
		} else {
			return [
				"status" => "error",
				"currentpage" => $allDomains["currentpage"],
				"countofpage" =>  $allDomains["countofpage"],
				"message" => "شما سایتی ندارید "
			];
		}
	}
	public static function GetOneByRecordid($name, $did)
	{
		$sql = "SELECT * FROM " . $GLOBALS["websites_tablename"] . " WHERE " .
			$GLOBALS["ws_recordname"] . "='" . $name . "' AND " . $GLOBALS["ws_domainid_fk"] . "= " . $did;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error"];
			return $result;
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);

			$listOfRecordType = ["status" => "success", "id" => $list[0]["wsid"]];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetAliasOneByRecordid($did)
	{
		$sql = "SELECT * FROM " . $GLOBALS["websitesalias_tablename"] . " WHERE " .
			$GLOBALS["websitesalias_tablename"] . "= " . $did;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error"];
			return $result;
		} else {
			$listOfRecordType = ["status" => "success"];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetWebsiteList($domain)
	{
		$sql = "select dnrid,dnr_name,domain_id from tbl_domains_ns_records,tbl_domains
            where domain_id=tbl_domains_ns_records.dnr_d_id_fk
            and d_name='" . $domain . "'
            and dnr_type='A'
            and dnr_proxied=1
            ORDER BY dnrid";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error"];
			return $result;
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$o = [];
			$alias = [];
			$temp = [];
			$m = [];
			$a = 0;
			$b = 0;
			for ($i = 0; $i < count($list); $i++) {
				if (!in_array($list[$i]["dnr_name"], $temp)) {
					$temp[$a] = $list[$i]["dnr_name"];
					$o[$a] = ["id" => $list[$i]["dnrid"], "name" => $list[$i]["dnr_name"]];
					$a++;
				} else {
					$m[$b] = array_search($list[$i]["dnr_name"], $list);
					$alias[$b] = ["id" => $list[$i]["dnrid"], "name" => $list[$i]["dnr_name"]];
					$b++;
				}
			}
			$listOfRecordType = ["status" => "success"];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function InternalGetWebsiteList($domain, $status, $domainname = "null")
	{
		$sql = "SELECT * FROM `tbl_websites`,tbl_domains  WHERE ws_domainid_fk=domain_id and
             ws_domainid_fk='" . $domain . "'
            ";

		$conn = GetConnection();
		$result = $conn->query($sql);

		if (!$result || mysqli_num_rows($result) == 0) {

			$allRecords = DOMAINNSRECORD_ADMIN::GetListOfAllRecordWithoutToken($domainname);

			if (array_key_exists("data", $allRecords)) {
				foreach ($allRecords["data"] as $aaaaa) {
					if ($aaaaa["dnr_type"] == "A" && $aaaaa["dnr_name"] == $aaaaa["d_name"]) {
						//   if($aaaaa["dnr_name"]==$aaaaa["d_name"]){
						//   $aaaaa["dnr_name"].$aaaaa["dnr_d_id_fk"];
						WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($aaaaa["dnr_d_id_fk"], $aaaaa["d_name"], 1);
						API_CDN_ADMIN::RunCreateAPICDN($aaaaa["dnr_d_id_fk"], $aaaaa["dnr_ip"], $aaaaa["dnr_protocol"], $aaaaa["dnr_port"]);
						return self::InternalGetWebsiteList($domain, $status, $domainname);
						// return $aaaaa;
						//   $aaaaa;
						//   }
					}
				}
			}
			// else{
			//                     $postedata=[];
			//                     $domainid=$domain;
			//                     $tk="12323";
			//                     $postedata["type"]="A";
			//                     $postedata["host"]=$domainname;
			//                     $postedata["ip"]="185.226.140.42";
			//                     $postedata["ttl"]=120;
			//                     $postedata["proxied"]=0;
			//                     // DOMAINNSRECORD_ADMIN::AddSingleRecord($domainname, $tk, $postedata,true);
			//                     // return self::InternalGetWebsiteList($domain, $status,$domainname);
			// }
			if ($allRecords["status"] == "error") {
				self::AddDefaultWebSite($domainname, $domain);
				return self::InternalGetWebsiteList($domain, $status, $domainname = "null");
			}
			$result = [
				"status" => "error", "domainid" => $domain, "domainstatus" => $status, "plan" => $allRecords,
				"message" => "وب سایتی برای شما ثبت نشده است ",
			];
			return $result;
		} else {

			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);

			$p = [];
			$ssss = 0;
			$t = "0";

			foreach ($list as $l) {
				$webid = $l["d_defaultwid"];

				$plan = $l["d_plan"];
				if ($l["ws_recordname"] != $domainname) {
					if ($l["ws_stauts"] != 1) {
						unset($list[$ssss]);
					} else {
						array_push($p, $l);
					}
				} else {
					$t = "1";

					$plan = $l["d_plan"];
					array_push($p, $l);
				}
				$ssss++;
			}
			if ($t == "0") {
				$allRecords = DOMAINNSRECORD_ADMIN::GetListOfAllRecordWithoutToken($domainname);

				if (array_key_exists("data", $allRecords)) {
					foreach ($allRecords["data"] as $aaaaa) {
						if ($aaaaa["dnr_type"] == "A") {
							if ($aaaaa["dnr_name"] == $aaaaa["d_name"]) {
								WEBSITES_ADMIN::AddOrUpdateWebSiteStatus($aaaaa["dnr_d_id_fk"], $aaaaa["d_name"], 1);
								API_CDN_ADMIN::RunCreateAPICDN($aaaaa["dnr_d_id_fk"], $aaaaa["dnr_ip"],  $aaaaa["dnr_protocol"], $aaaaa["dnr_port"]);
								return self::InternalGetWebsiteList($domain, $status, $domainname);
							}
						}
					}
				}
			}

			$listOfRecordType = [
				"domainid" => $domain,
				"domainstatus" => $status,
				"status" => "success",
				"message" => "لیست سایت ها با موفقیت دریافت شد",
				"webid" => $webid,
				"plan" => $plan,
				"data" => $p
			];
		}

		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetWebsiteListWithToken($domain, $token)
	{

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$sql = "SELECT wsid,ws_recordname,d_name FROM `tbl_websites`,tbl_domains,tbl_users WHERE
            tbl_users.uid=tbl_domains.d_user_id_fk
            and uid=" . $uid . " and
            domain_id=ws_domainid_fk and
            d_name='" . $domain . "'
            and ws_stauts=1";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {

			$result = [
				"message" => "وب سایتی برای شما ثبت نشده است ",
			];
			return $result;
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($list[0]["wsplan"]);
			$list[0]["wsplan"] = $list[0]["d_plan"];
			$listOfRecordType = ["message" => "لیست سایت ها با موفقیت دریافت شد", "data" => $list];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function AddWebsites($domainid, $recordid, $recordname)
	{
		$webaddress = WEBSITES_ADMIN::GetOneByRecordid($recordname, $domainid);
		if ($webaddress["status"] == "error") {
			$sql = "INSERT INTO " . $GLOBALS["websites_tablename"] . "(" .
				$GLOBALS['ws_domainid_fk'] . "," . $GLOBALS['ws_recordname'] . "," . $GLOBALS['ws_stauts']
				. ") VALUES(" . $domainid . ",'" . $recordname . "',1)";
			$conn = GetConnection();
			$result = mysqli_query($conn, $sql);
			$wsid = $conn->insert_id;
			$sql = "INSERT INTO " . $GLOBALS["websitesalias_tablename"] . "(" .
				$GLOBALS['wsa_dnrid_fk'] . "," . $GLOBALS['wsa_wsid_fk'] . ") VALUES(" . $recordid . "," .
				$wsid . ")";
			$conn = GetConnection();
			$result = mysqli_query($conn, $sql);
			$conn->close();
			$id = $conn->insert_id;
			SUBFOLDER_ADMIN::InternalAddSubFolder($id, "/", 0);
			$conn->close();

			return $sql;
		} else {
			if (WEBSITES_ADMIN::GetAliasOneByRecordid($recordid)["status"] == "error") {
				$sql = "INSERT INTO " . $GLOBALS["websitesalias_tablename"] . "(" .
					$GLOBALS['wsa_dnrid_fk'] . "," . $GLOBALS['wsa_wsid_fk'] . ") VALUES(" . $recordid . "," .
					$webaddress["id"] . ")";
				$conn = GetConnection();
				$result = mysqli_query($conn, $sql);
				$conn->close();
				return $sql;
			}
		}
	}
	public static function CheckWebSiteExist($recordname, $domainid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["websites_tablename"] . " ,tbl_domains WHERE " .
			$GLOBALS["ws_domainid_fk"] . "= " . $domainid . " AND " .
			$GLOBALS["ws_recordname"] . "='" . $recordname .
			"' and domain_id=ws_domainid_fk and d_status!=2";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$res = ["status" => "new"];
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($list[0]["wsplan"]);
			$list[0]["wsplan"] = $list[0]["d_plan"];
			$res = ["status" => "exist", "id" => $list[0]["wsid"], "domain_name" => $list[0]["d_name"]];
		}

		$conn->close();
		return  $res;
	}
	public static function AddOrUpdateWebSiteStatus($domainid, $recordname, $status)
	{
		$webaddress = WEBSITES_ADMIN::CheckWebSiteExist($recordname, $domainid);
		// return $webaddress;
		if ($webaddress["status"] == "new") {
			$sql = "INSERT INTO " . $GLOBALS["websites_tablename"] . "(" .
				$GLOBALS['ws_domainid_fk'] . "," . $GLOBALS['ws_recordname'] . "," . $GLOBALS['ws_stauts']
				. ") VALUES(" . $domainid . ",'" . $recordname . "'," . $status . ")";
		} else {
			$sql = "UPDATE " . $GLOBALS["websites_tablename"] . " SET " .
				$GLOBALS['ws_stauts'] . "=" . $status . " WHERE " . $GLOBALS['ws_domainid_fk'] . "=" . $domainid .
				" AND " . $GLOBALS['ws_recordname'] . "='" . $recordname . "'";
		}
		if ($webaddress["status"] == "exist" && $webaddress["domain_name"] == $recordname) {
			if ($status == 0) {
				return ["webaddress" => $webaddress, "data" => $webaddress];
			}
		}

		$conn = GetConnection();
		$result = mysqli_query($conn, $sql);
		if ($webaddress["status"] == "new") {
			$id = $conn->insert_id;
			if ($status == 1) {
				SUBFOLDER_ADMIN::InternalAddSubFolder($id, "/", 0);
			}
		} else {
			if ($status == 1) {
				SUBFOLDER_ADMIN::InternalAddSubFolder($webaddress["id"], "/", 0);
			}
		}
		$conn->close();
		return ["webaddress" => $webaddress, "data" => $webaddress, "sql" => $sql];
	}
	public static function GetWebsiteListByUserID($uid)
	{
		$sql = "SELECT *,domain_id as id,d_name as domainName,  d_reg_date  as registertime ,
            IF(d_name=ws_recordname,d_name,CONCAT(ws_recordname,'.',d_name)) as domainName
            ,
            (
            CASE
            WHEN d_status = 1 THEN 'دامنه فعال است'
            WHEN d_status = 0 THEN 'در انتظار تغییر نیم سرور'
            END) AS dnsStatus,
            IF(d_status = 0 , 'deactive','active') as status
            FROM `tbl_websites`,tbl_domains
                WHERE domain_id=ws_domainid_fk
                    and d_user_id_fk=" . $uid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", $sql];
			return $result;
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($list[0]["wsplan"]);
			$list[0]["wsplan"] = $list[0]["d_plan"];
			$listOfRecordType = ["status" => "success", "data" => $list];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetWebsiteByID($websiteid, $uid)
	{
		$whr = "";
		if ($uid != 0) {
			$whr = " AND " . $GLOBALS['d_user_id_fk'] . "=" . $uid;
		}
		$sql = "SELECT *  ,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain  FROM
         `tbl_websites`,tbl_domains
                WHERE domain_id=ws_domainid_fk
                    and  " . $GLOBALS['wsid'] . "=" . $websiteid . $whr;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", $sql, "data" => null];
			return $result;
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($list[0]["wsplan"]);
			$list[0]["wsplan"] = $list[0]["d_plan"];
			$listOfRecordType = ["status" => "success", "data" => $list];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetWebsiteByWithoutID($websiteid)
	{
		$sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain FROM
         `tbl_websites`,tbl_domains
                WHERE domain_id=ws_domainid_fk
                    and  " . $GLOBALS['wsid'] . "=" . $websiteid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error"];
			return $result;
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($list[0]["wsplan"]);
			$list[0]["wsplan"] = $list[0]["d_plan"];
			$listOfRecordType = ["status" => "success", "data" => $list];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetWebsiteWithoutUser($websiteid)
	{
		$sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain FROM `tbl_websites`,tbl_domains
               WHERE domain_id=ws_domainid_fk
                   and  " . $GLOBALS['wsid'] . "=" . $websiteid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error"];
			return $result;
		} else {
			$list = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($list[0]["wsplan"]);
			$list[0]["wsplan"] = $list[0]["d_plan"];
			$listOfRecordType = ["status" => "success", "data" => $list];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
}
