<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supportticketsdepartment/admin/supportticketsdepartment_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supporttickets/supporttickets_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supportticketsreplies/admin/supportticketsreplies_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/attachments/admin/attachments_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/supportticketsattachments/admin/supportticketsattachments_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/admin/admin/admin_admin_class.php';

class SUPPORTTICKETS_ADMIN
{
    public static function Search($token, $phrase, $status)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $stat = "!=4";
        if ($status == "closed") {
            $stat = "=4";
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT td_name,tid,t_title,t_lastreply,t_opendate,
        (
           CASE
               WHEN t_user_seen = 1 THEN 'bold'
               WHEN t_user_seen = 0 THEN 'regular'
               END
           ) as isbold,

           (
               CASE
           WHEN t_status = 1 THEN 'مشاهده نشده'
           WHEN t_status = 2 THEN 'در حال رسیدگی'
           WHEN t_status = 3 THEN 'ارجاع داده شده'
           WHEN t_status = 4 THEN 'بسته شده'
           WHEN t_status = 5 THEN 'پاسخ داده شده'
           WHEN t_status = 6 THEN 'پاسخ کاربر'
            END) AS ticket_status,
            (
               CASE
               WHEN t_status = 1 THEN 'open'
               WHEN t_status = 2 THEN 'inprogress'
               WHEN t_status = 3 THEN 'assigned'
               WHEN t_status = 4 THEN 'closed'
               WHEN t_status = 5 THEN 'answered'
               WHEN t_status = 6 THEN 'customer-reply'
               END) AS enstatus
             from " . $GLOBALS["tickets_tablename"]  . "," .
            $GLOBALS["ticketdept_tablename"] . " WHERE " .
            $GLOBALS['t_td_id_fk'] . "=" . $GLOBALS['tdid'] . " and
               t_status" . $stat . " AND (" .
            $GLOBALS['t_description'] . " LIKE '%" . $phrase . "%' OR " .
            $GLOBALS['t_title'] . " LIKE '%" . $phrase . "%' OR " .
            $GLOBALS['tid'] . " LIKE '%" . $phrase . "%') and " .
            $GLOBALS['t_user_id_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعاتی جهت نمایش وجود ندادر"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $result = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $listOfRecordType
            ];

            return $result;
        }
    }
    public static function GetCountOfRecord($uid, $status = "opened")
    {

        $stat = "!=4";
        if ($status == "closed") {
            $stat = "=4";
        }
        $sql = "SELECT count(tid) as cnt from " . $GLOBALS["tickets_tablename"]
            . " WHERE " . $GLOBALS["t_user_id_fk"] . "=" . $uid . " AND t_status" . $stat;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

        return  $listOfRecordType[0]["cnt"];
    }
    public static function GetList($uid, $page, $countofrecord)
    {
        $expsession = jDateTime::date("Y/m/d H:i:s");
        $countOfRecord = self::GetCountOfRecord($uid);
        $fsr = ($page - 1) * $countofrecord;
        $enr = $page * $countofrecord;
        $countOfpageRecordInPage = $countofrecord;
        $a = $countOfRecord / $countOfpageRecordInPage;

        if ($countOfRecord > $countofrecord) {
            $countofpage = intdiv($countOfRecord, $countOfpageRecordInPage);
            if (!is_int($a))
                $countofpage = $countofpage + 1;
        } else {
            $countofpage = 1;
        }

        $sql = "SELECT tid as id,t_title as title,t_description as description, t_services as service,
          ( CASE
            WHEN t_user_seen = 1 THEN 'bold'
            WHEN t_user_seen = 0 THEN 'regular'
            END
        ) as isbold,
         t_lastreply as lastreplytime ,td_name as department,
            (
            CASE
            WHEN t_status = 1 THEN 'open'
            WHEN t_status = 2 THEN 'inprogress'
            WHEN t_status = 3 THEN 'assigned'
            WHEN t_status = 4 THEN 'closed'
            WHEN t_status = 5 THEN 'answered'
            WHEN t_status = 6 THEN 'customer-reply'
            END) AS status
            from " . $GLOBALS["tickets_tablename"] . ",tbl_ticket_dept WHERE tdid=t_td_id_fk and t_status!=4 and
            t_user_id_fk=" . $uid . " ORDER BY t_lastreply DESC  LIMIT " . $fsr . "," . $countofrecord;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "code" => "201", "message" => "اطلاعاتی جهت نمایش وجود ندارد"];
            return $result;
        } else {
            $listOfRecordType = [
                "status" => "success", "code" => "200",
                "currentpage" => $page,
                "countofpage" => $countofpage,
                "countofrecord" => $countofrecord,
                "tickets" => mysqli_fetch_all($result, MYSQLI_ASSOC)
            ];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }

    public static function GetRecordWithParameter($fieldname, $fieldvalue)
    {

        $sql = "SELECT * FROM " . $GLOBALS["tickets_tablename"] . " WHERE " . $GLOBALS[$fieldname] . " LIKE '%" . $fieldvalue . "%'";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["result" => "null"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneByID($uid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tickets_tablename"] . " WHERE " . $GLOBALS['tid'] . "=" . $uid;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function OpenNewTicket($t_title, $t_description, $token, $t_td_id_fk, $service)
    {
        $DepartmentExist = supportticketsdepartment_ADMIN::GetOneActive($t_td_id_fk);
        if ($DepartmentExist["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            $result = ["status" => "error", "result" => "درخواست ارسالی نامعتبر است"];
            return $result;
        } else {
            $userExist = USERS_ADMIN::GetOneByToken($token);
            if ($userExist["status"] == "error") {
                                 $result = ["status" => "error", "result" => "توکن ارسالی نامعتبر است"];
                return $result;
            } else {
                $conn = GetConnection();
                str_replace("\n","<br />",$t_description);
                $sql = "INSERT INTO " . $GLOBALS['tickets_tablename'] . "(" . $GLOBALS['t_title'] . "," .
                    $GLOBALS['t_description'] . "," . $GLOBALS['t_user_id_fk'] . ","  .
                    $GLOBALS['t_td_id_fk'] . "," . $GLOBALS['t_opendate'] . "," . $GLOBALS['t_status'] . "," .
                    $GLOBALS['t_lastreply'] . "," . $GLOBALS['t_user_seen'] . "," . $GLOBALS['t_services'] .
                    ") VALUES ('%s','%s',%s,%s,'%s',%s,'%s',0,'%s')";
                $now = jDateTime::date("Y-m-d H:i:s");
                $sql = sprintf(
                    $sql,
                    $t_title,
                    $t_description,
                    $userExist["userdetail"][0]["uid"],
                    $t_td_id_fk,
                    $now,
                    1,
                    $now,
                    $service
                );

                if ($conn->query($sql) === TRUE) {

                    $mailTemplate = '
               %s عزیز،
                 <br />
                تیکت جدید شما در تاریخ %s ساعت %s با موفقیت برای بخش " %s " ارسال شد.
                  <br />
                در حال حاضر وضعیت تیکت شما " در انتظار پاسخ پشتیبان " می باشد.
                  <br />
                کارشناسان ما در اسرع وقت به تیکت شما پاسخ خواهند داد.
                <br />
                <br />
                ';
                    $nowDate = jDateTime::date("Y/m/d");
                    $nowTime = jDateTime::date("H:i:s");

                    $mailTemplate = sprintf(
                        $mailTemplate,
                        $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
                        $nowDate,
                        $nowTime,
                        $DepartmentExist["Department"][0]["td_name"]
                    );

                    $params = [
                        "param1" => $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
                        "param2" => $DepartmentExist["Department"][0]["td_name"],
                    ];

                    $o = EMAILCLASS::SendEmailPanel($userExist["userdetail"][0]["umail"], "ارسال تیکت جدید در میزبان کلود", $mailTemplate, "success", "upchz18tja", $params, $userExist["userdetail"][0]["umobile"]);

                    $o = EMAILCLASS::SendEmailPanel("pnetco@gmail.com", "ارسال تیکت جدید در میزبان کلود", $mailTemplate, "success", "upchz18tja", $params, "09128953411");

                    $response = [
                        "status" => "success",
                        "message" => "تیکت جدید با موفقیت افزوده شد ",
                        "data" => [
                            "ticketid" => $conn->insert_id,
                        ]
                    ];
                    return $response;
                } else {
                    VARS_ADMIN::ReturnHeaders(406);

                    $response = ["status" => "error", "message" => "خطا در برقراری ارتباط"];
                    return $response;
                    $conn->close();
                }
            }
        }
    }
    public static function ChangeTicketStatus($token, $status, $tid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $conn = GetConnection();
        $sql = "UPDATE " . $GLOBALS['tickets_tablename'] . " SET " .
            $GLOBALS['t_status'] . " = %s" .
            " WHERE " . $GLOBALS['tid'] . "=%s and " . $GLOBALS['t_user_id_fk'] . "=%s  ";

        $sql = sprintf($sql, $status, $tid, $uid);
        $ticketExist = SUPPORTTICKETS_ADMIN::GetOneByID($tid);
        if ($ticketExist["status"] == "error") {
            $response = ["status" => "error", "message" => "تیکت مورد نظر یافت نشد"];
            return $response;
            $conn->close();
        }

        if ($conn->query($sql) === TRUE) {

            $response = [
                "status" => "success", "message" => "تیکت مود نظر با موفقیت ویرایش شد ",
            ];
            return $response;
        } else {
            $response = ["status" => "error", "message" => "شما امکان دسترسی به این تیکت را ندارید "
            ];
            return $response;
            $conn->close();
        }
    }
    public static function AutoChangeTicketStatus($status, $tid)
    {
        $conn = GetConnection();
        $sql = "UPDATE " . $GLOBALS['tickets_tablename'] . " SET " .
            $GLOBALS['t_status'] . " = %s" .
            " WHERE " . $GLOBALS['tid'] . "=%s ";

        $sql = sprintf($sql, $status, $tid);
        if ($conn->query($sql) === TRUE) {

            $response = [
                "status" => "success", $sql,"message" => "تیکت مود نظر با موفقیت ویرایش شد ",
            ];
            return $response;
        }
    }
    public static function ChangeTicketDepartment($t_td_id_fk, $tid)
    {
        $conn = GetConnection();
        $deptExist = supportticketsdepartment_ADMIN::GetOneActive($t_td_id_fk);
        if ($deptExist["status"] == "success") {
            $ticketExist = SUPPORTTICKETS_ADMIN::GetOneByID($tid);
            if ($ticketExist["status"] == "error") {
                $response = ["status" => "error", "message" => "تیکت مورد نظر یافت نشد"];
                return $response;
                $conn->close();
            }
            $sql = "UPDATE " . $GLOBALS['tickets_tablename'] .
                " SET " . $GLOBALS['t_td_id_fk'] . " = %s " .
                " WHERE " . $GLOBALS['tid'] . "=%s";

            $sql = sprintf($sql, $t_td_id_fk, $tid);

            if ($conn->query($sql) === TRUE) {

                $response = [
                    "status" => "success", "message" => "تیکت مود نظر با موفقیت ویرایش شد ",
                ];
                return $response;
                $conn->close();
            } else {
                $response = ["status" => "error", "message" => "خطا در پردازش درخواست  ",
                ];
                return $response;
                $conn->close();
            }
        } else {
            $response = ["status" => "error", "message" => "خطا در ارسال درخواست"];
            return $response;
        }
    }
    public static function ChangeTicketLastReply($tid)
    {
        $conn = GetConnection();
        $sql = "UPDATE " . $GLOBALS['tickets_tablename'] . " SET " . $GLOBALS['t_lastreply'] . " = '%s' " .
            " WHERE " . $GLOBALS['tid'] . "=%s";
        $now = jDateTime::date("Y-m-d H:i:s");

        $sql = sprintf($sql, $now, $tid);

        if ($conn->query($sql) === TRUE) {

            $response = [
                "status" => "success", "message" => "تیکت مود نظر با موفقیت ویرایش شد ",
            ];
            return $response;
        } else {
            $response = ["status" => "error", "message" => "" .  $conn->error];
            return $response;
            $conn->close();
        }
    }
    public static function ChangeUserseen($tid, $tuserseen)
    {
        $conn = GetConnection();
        $sql = "UPDATE " . $GLOBALS['tickets_tablename'] . " SET " . $GLOBALS['t_user_seen'] . " = '%s' " .
            " WHERE " . $GLOBALS['tid'] . "=%s";
        $now = jDateTime::date("Y-m-d H:i:s");

        $sql = sprintf($sql, $tuserseen, $tid);

        if ($conn->query($sql) === TRUE) {

            $response = [
                "status" => "success", "message" => "تیکت مود نظر با موفقیت ویرایش شد ",
            ];
            return $response;
        } else {
            $response = ["status" => "error", "message" => "" .  $conn->error];
            return $response;
            $conn->close();
        }
    }
    public static function AssignTicketToAdmin($tid, $adminid)
    {
        $conn = GetConnection();
        $ticketExist = SUPPORTTICKETS_ADMIN::GetOneByID($tid);
        if ($ticketExist["status"] == "error") {
            $response = ["status" => "error", "message" => "تیکت مورد نظر یافت نشد"];
            return $response;
            $conn->close();
        }
        if ($adminid != 0) {
            $adminExist = ADMIN_ADMIN::GetOneByID($adminid);
            if ($adminExist["status"] == "error") {
                $response = ["status" => "error", "message" => "کاربر مورد نظر یافت نشد"];
                return $response;
                $conn->close();
            }
        }

        $sql = "UPDATE " . $GLOBALS['tickets_tablename'] . " SET " . $GLOBALS['t_admin_id_fk'] . " = %s" .
            " WHERE " . $GLOBALS['tid'] . "=%s";
        $sql = sprintf($sql, $adminid, $tid);

        if ($conn->query($sql) === TRUE) {

            $response = [
                "status" => "success", "message" => "تیکت مود نظر با موفقیت ویرایش شد ",
            ];
            return $response;
        } else {
            $response = ["status" => "error", "message" => "خطا در پردازش درخواست"];
            return $response;
            $conn->close();
        }
    }
    public static function GetlistTicketByStatus($status)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tickets_tablename"] . " WHERE " . $GLOBALS['t_status'] . " = " . $status;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "result" => "درخواست ارسالی نامعتبر است یا تیکتی با وضعیت درخواستی یافت نشد"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetActive()
    {
        $sql = "SELECT * FROM " . $GLOBALS["tickets_tablename"] . " WHERE " . $GLOBALS['t_status'] . " !=4 order by "
            . $GLOBALS['t_lastreply'];
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "result" => "درخواست ارسالی نامعتبر است یا تیکتی با وضعیت درخواستی یافت نشد"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneActive($tid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tickets_tablename"] . " WHERE " . $GLOBALS['t_status'] . " !=4 and "
            . $GLOBALS['tid'] . "=" . $tid . " order by "
            . $GLOBALS['t_lastreply'];
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "result" => "درخواست ارسالی نامعتبر است یا تیکتی با وضعیت درخواستی یافت نشد"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneTicketWithReplies($tid, $token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uadmin = ADMIN_ADMIN::GetList();
        $adminlist = [];
        foreach ($uadmin as $u) {
            $adminlist[$u["aid"]]["a_name"] = $u["a_name"];
            $adminlist[$u["aid"]]["a_family"] = $u["a_family"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        #REPLACE(t_description, '\n', '<br />') as
        $sql = "SELECT t_opendate,t_title,t_description ,t_opendate,t_lastreply  ,
            (
            CASE
            WHEN t_status = 1 THEN 'مشاهده نشده'
            WHEN t_status = 2 THEN 'در حال رسیدگی'
            WHEN t_status = 3 THEN 'ارجاع داده شده'
            WHEN t_status = 4 THEN 'بسته شده'
            WHEN t_status = 5 THEN 'پاسخ داده شده'
            WHEN t_status = 6 THEN 'پاسخ کاربر'
            END) AS ticket_status,
            (
            CASE
            WHEN t_status = 1 THEN 'open'
            WHEN t_status = 2 THEN 'inprogress'
            WHEN t_status = 3 THEN 'assigned'
            WHEN t_status = 4 THEN 'closed'
            WHEN t_status = 5 THEN 'answered'
            WHEN t_status = 6 THEN 'customer-reply'
            END) AS ticket_statusEn
        from " . $GLOBALS["tickets_tablename"]    . "," .
            $GLOBALS["ticketdept_tablename"] .
            " WHERE " . $GLOBALS["t_user_id_fk"] . "=" . $uid .
            " AND " . $GLOBALS['tid'] . " =" . $tid . "  and " .
            $GLOBALS['t_td_id_fk'] . "=" . $GLOBALS['tdid'];
        $conn = GetConnection();

        $resultTickets = mysqli_query($conn, $sql);
        if (!$resultTickets || mysqli_num_rows($resultTickets) == 0) {
            VARS_ADMIN::ReturnHeaders(400);
            $result = [
                $sql,
                "status" => "error",
                "result" => "درخواست ارسالی نامعتبر است یا تیکتی با وضعیت درخواستی یافت نشد ",
            ];
            return $result;
        } else {
            $now = jDateTime::date("Y/m/d H:i:s");
            $r = mysqli_fetch_all($resultTickets, MYSQLI_ASSOC);

            USERS_ADMIN::GetOneByToken($token);
            $attachments = SUPPORTTICKETSATTACHMENTS_ADMIN::GetOneByID($tid, "1");
            $ticket = mysqli_fetch_all($resultTickets, MYSQLI_ASSOC);
            if (!array_key_exists("result", $attachments)) {
                $r[0]["attachments"] = $attachments;
                $r[0]["path"] = "/attachments/tickets/";
            }

            $sql2 = "SELECT  *,IF(tr_type=1, 'TicketReply', 'AdmineNote') as typeOfResponse,REPLACE(tr_description, '\n', '<br />') as tr_description from " .
                $GLOBALS["ticketreplies_tablename"] . " WHERE " . $GLOBALS['tr_tid_fk'] . " =" . $tid
                . " AND " . $GLOBALS['tr_type'] . "=1 order by trid desc";
            $resultTicketsreplies = mysqli_query($conn, $sql2);
            $replies = mysqli_fetch_all($resultTicketsreplies, MYSQLI_ASSOC);
            for ($i = 0; $i < count($replies); $i++) {
                $attachmentsn = [];
                $attachmentsn = SUPPORTTICKETSATTACHMENTS_ADMIN::GetOneByID($replies[$i]["trid"], "2");
                if ($replies[$i]["tr_admin_id_fk"] != 0) {
                    $replies[$i]["admin"] = $adminlist[$replies[$i]["tr_admin_id_fk"]]["a_name"] . " " . $adminlist[$replies[$i]["tr_admin_id_fk"]]["a_family"];
                }
                if (!array_key_exists("result", $attachmentsn)) {
                    $replies[$i]["attachments"] = $attachmentsn;
                    $replies[$i]["path"] = "/attachments/tickets/";
                }
            }

            $listOfRecordType = [
                "status" => "success",
                "data" => $r[0],
                "TicketReplies" => $replies
            ];
            SUPPORTTICKETS_ADMIN::ChangeUserseen($tid, 0);

            $resultTicketsreplies->free_result();
            $resultTickets->free_result();

            $conn->close();
            return $listOfRecordType;
        }
    }
    public static function GetUserTickets($token, $page, $countofrecord, $status)
    {
		$validstatus=["open","inprogress","assigned","closed","answered","customer-reply","all"];
		if(!in_array($status,$validstatus))
			return ["status"=>"error","message"=>"خطا در وضعیت ارسالی"];
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $uid = $usersDetails["userdetail"][0]["uid"];

        $expsession = jDateTime::date("Y/m/d H:i:s");
        $countOfRecord = self::GetCountOfRecord($uid, $status);
        $fsr = ($page - 1) * $countofrecord;
        $enr = $page * $countofrecord;
        $countOfpageRecordInPage = $countofrecord;
        $a = $countOfRecord / $countOfpageRecordInPage;

        if ($countOfRecord > $countofrecord) {
            $countofpage = intdiv($countOfRecord, $countOfpageRecordInPage);
            if (!is_int($a))
                $countofpage = $countofpage + 1;
        } else {
            $countofpage = 1;
        }

        $stat = "";

		switch ($status) {
			case "closed":
				$stat = "AND t_status=4";
				break;
			case "allopen":
				$stat = "AND t_status!=4";
				break;
			case "all":
				$stat = " ";
				break;
			case "customer-reply":
				$stat = "AND t_status=6";
				break;
			case "answered":
				$stat = "AND t_status=5";
				break;
			case "assigned":
				$stat = "AND t_status=3";
				break;
			case "open":
				$stat = "AND t_status=1";
				break;
			case "inprogress":
				$stat = "AND t_status=2";
				break;
		}

        $sql = "SELECT td_name,tid,t_title,t_lastreply,t_opendate,
     (
        CASE
            WHEN t_user_seen = 1 THEN 'bold'
            WHEN t_user_seen = 0 THEN 'regular'
            END
        ) as isbold,

        (
            CASE
        WHEN t_status = 1 THEN 'مشاهده نشده'
        WHEN t_status = 2 THEN 'در حال رسیدگی'
        WHEN t_status = 3 THEN 'ارجاع داده شده'
        WHEN t_status = 4 THEN 'بسته شده'
        WHEN t_status = 5 THEN 'پاسخ داده شده'
        WHEN t_status = 6 THEN 'پاسخ کاربر'
         END) AS ticket_status,
         (
            CASE
            WHEN t_status = 1 THEN 'open'
            WHEN t_status = 2 THEN 'inprogress'
            WHEN t_status = 3 THEN 'assigned'
            WHEN t_status = 4 THEN 'closed'
            WHEN t_status = 5 THEN 'answered'
            WHEN t_status = 6 THEN 'customer-reply'
            END) AS enstatus
          from " . $GLOBALS["tickets_tablename"]  . "," .
            $GLOBALS["ticketdept_tablename"] . " WHERE " .
            $GLOBALS['t_user_id_fk'] . "=" .   $uid . " " . $stat . " AND " .
            $GLOBALS['t_td_id_fk'] . "=" . $GLOBALS['tdid'] ." order by tid desc". "   LIMIT " . $fsr . "," . $countofrecord ;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(400);
            $result = ["status" => "error", "message" => "تیکتی برای کاربر یافت نشد"];
            return $result;
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $now = jDateTime::date("Y/m/d H:i:s");
            VARS_ADMIN::ReturnHeaders(200);

            $listOfRecordType = [
                "status" => "success",
				 "message" => "لیست تیکت های کاربر",
                "currentpage" => $page,
                "countofpage" => $countofpage,
                "countofrecord" => $countofrecord,
                "data" => $r
            ];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckTicketUserIsOwner($token, $tid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT * FROM " . $GLOBALS["tickets_tablename"] .   " WHERE " .
            $GLOBALS['t_user_id_fk'] . "=" . $uid . "  and " . $GLOBALS['tid'] . "=" . $tid;

        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(400);
            $listOfRecordType = ["status" => "error"];
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $now = jDateTime::date("Y/m/d H:i:s");

            VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "data" => $r];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
}
