<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/sslwebsites/sslwebsites_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/sslpools/admin/sslpools_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/ssl/ssl.php';

class SSLWEBSITES_ADMIN
{
    public static function CheckWebSiteHasSSL($website)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslwebsites_tablename"] . " WHERE "
            . $GLOBALS['sw_ws_id_fk'] . "=" . $website;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", $sql];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(400);
            $listOfRecordType = ["status" => "success"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function ChangeSiteBetweenDedCertOrFree($websiteid, $status, $sslstatus)
    {
        $sql = "UPDATE `tbl_ssl_websites` SET `sw_ssl_status` = '" . $status . "' ,`sw_status` = '" . $sslstatus . "' WHERE  `sw_ws_id_fk` =  " . $websiteid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function CheckSSLIsInUse($token, $sslpoolid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . "," . $GLOBALS['sslwebsites_tablename'] . " WHERE "
            . $GLOBALS['sp_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['sw_sp_id_fk'] . "=" . $GLOBALS['sslpoolsid']
            . " AND " . $GLOBALS['sw_sp_id_fk'] . "=" . $sslpoolid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckSSLExpired($poolid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $now = date("Y/m/d H:i:s");
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $exp = str_replace("-", "/", $list[0]["sp_expiredate"]);
            if ($exp < $now) {
                return ["status" => "expired","expire"=>$exp ,"now"=> $now];
            } else {
                return ["status" => "active","expire"=>$exp ,"now"=> $now];
            }
        }
    }
    public static function GetListByUsers($token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT " . $GLOBALS['sslpoolsid'] . " as id ," .
            $GLOBALS['sp_startdate'] . " as StartDate," .
            $GLOBALS['sp_expiredate'] . " as ExpireDate," .
            $GLOBALS['sp_domain'] . " as MainDomain," .
            $GLOBALS['sp_altdomain'] . " as  AlternativeDomains"
            . " FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sp_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error", "message" => "وب سایتی برای شما ثبت نشده است"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "message" => "لیست سایت ها با موفقیت دریافت شد", "data" => $list];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetByCertificate($crt)
    {

        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sp_cert'] . "='" . $crt . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
                         $listOfRecordType = ["status" => "error", "message" => "این گواهینامه قبلا ثبت شده است"];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function HTTPToHTTPSStaus($token, $websiteid, $sslstatus)
    {
        $uid = 0;
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                                 return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
            }

            if ($usersDetails["credit"] < 0) {
                return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
            }

            $uid = $usersDetails["userdetail"][0]["uid"];
        } else {
            $uid = WEBSITES_ADMIN::GetWebsiteByWithoutID($websiteid)["data"][0]["d_user_id_fk"];
        }
        $status = ["forcehttps", "forcehttp", "bothactive"];
        if (!in_array(strtolower($sslstatus), $status)) {
            return ["status" => "error", "message" => "وضعیت ارسالی برای SSL اشتباه است"];
        }
        $b = SSLWEBSITES_ADMIN::CheckWebSiteHasSSL($websiteid);
        if ($b["status"] == "error" && $sslstatus != "forcehttp") {
            return ["status" => "error", "message" => "شما SSL فعال برای این دامنه ندارید"];
        }

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه سایت ارسالی نامعتبر است"];
        }
        $sql = "UPDATE " . $GLOBALS["sslwebsites_tablename"] . " SET " .
            $GLOBALS['sw_status'] . "='" . $sslstatus . "' WHERE " . $GLOBALS['sw_ws_id_fk'] . "=" . $websiteid;

        if ($sslstatus == "forcehttp") {
            $sql = "DELETE FROM  " . $GLOBALS["sslwebsites_tablename"] . " WHERE " .
                $GLOBALS['sw_ws_id_fk'] . "=" . $websiteid;
        }
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = ["status" => "success", $sslstatus, "message" => "درخواست شما با موفقیت انجام شد"];
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        if ($sslstatus == "forcehttps") {
            API_SSL_ADMIN::RunCreateAPIForceHHTTPS($dmn);
        } else if ($sslstatus == "forcehttp") {
            API_SSL_ADMIN::RunCreateAPIUnForceHTTPS($dmn);
            API_SSL_ADMIN::RunCreateAPIForceHTTP($dmn);
            self::ResetAllSSLParams($token, $websiteid);
        } else {
            API_SSL_ADMIN::RunCreateAPIUnForceHTTPS($dmn);
        }
        $conn->close();
        return $listOfRecordType;
    }
    public static function ResetAllSSLParams($token, $websiteid)
    {
        SSLHSTS_ADMIN::RemoveHSTS($websiteid);
        SSLTLS_ADMIN::RemoveTLS($websiteid);
        // REDIRECTSUBLINKTOHTTPS_ADMIN::RemoveRedirectSubLinkToHTTPS($token,$websiteid);
        ChangeResourceToHttps_ADMIN::RemoveChangeResourceToHttps($token, $websiteid);
        self::DeleteWebSitesStatus($websiteid);
    }
    public static function DeleteWebSitesStatus($websiteid)
    {
        $sql = "DELETE  from " . $GLOBALS["sslwebsites_tablename"] . " WHERE " . $GLOBALS['sw_ws_id_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function AddCertificateToWebSite($token, $poolid, $websiteid, $sslstatus, $fs = 1)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $crtinfo = SSLPOOLS_ADMIN::CanAccessToPoolid($poolid, $uid);

        if ($crtinfo["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه ارسالی شما معتبر نیست"];
        }

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه سایت ارسالی نامعتبر است"];
        } else {
            $stat = 0;
            $dmn = "";
            if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
                $dmn = $websitesOwner["data"][0]["d_name"];
            } else {
                $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
            }

            if ($crtinfo["data"][0]["sp_domain"] == $dmn) {
                $stat = "1";
            }
            $certstr = str_replace('DNS:', '', $crtinfo["data"][0]["sp_altdomain"]);
            $certar = explode(',', $certstr);
            $dmns = explode(".", $dmn);
            $wilddomain = implode('.', array_slice($dmns, 1));
            $wilddomain = "*." . $wilddomain;

            foreach ($certar as $c) {
                $d = str_replace(' ', '', $c);
                if ($d == $dmn) {
                    $stat = "1";
                }
                if ($d == $wilddomain) {
                    $stat = "1";
                }
            }
            // return [$certar,$dmn];
            // $tcert = array_map(function($x){ return trim($x); }, $certar);

            // return $tcert;

            $r1 = strpos($crtinfo["data"][0]["sp_domain"], $dmn);
            $r2 = strpos($crtinfo["data"][0]["sp_domain"], "*");
            $r3 = strpos($crtinfo["data"][0]["sp_altdomain"], $dmn);
            // $r4 = strpos($crtinfo["data"][0]["sp_altdomain"],  "www." . $websitesOwner["data"][0]["ws_recordname"]);
            $r4 = strpos($crtinfo["data"][0]["sp_altdomain"], "*");
            // if($r2=== false && $r4=== false){
            //     if ($r1 === false || $r3 === false) {
            //         return["status"=>"error","r1"=>$r1,"r3"=>$r3,"r2"=>$r2,"r4"=>$r4,"dmn"=>$dmn,"message"=>"نام دامنه و SSL همخوانی ندارد"];

            //     }
            // }
            // if ($r2 == true) {
            //     $stat = 1;
            // }
            // if ($r3 == true) {
            //     return ["status" => "error", "message" => "نام دامنه و SSL همخوانی ندارد"];
            //     $stat = 1;
            // }
            // if ($r4 == true) {
            //     $stat = 1;
            // }

            if ($fs == 0)
                $stat = 1;
            if ($stat == 0) {
                return ["status" => "error", "message" => "نام دامنه ارسالی با کواهینامه ارسالی یکسان نیست", $websitesOwner["data"][0]["ws_recordname"]
                ];
            }
            $crtinfos = openssl_x509_parse($crtinfo["data"][0]["sp_cert"]);
            if($crtinfos["validTo_time_t"] < time()){
                return ["status"=>"error","message"=>"گواهینامه شما منقضی شده است"];
            }
            // return ["status"=>"error",self::CheckSSLExpired($poolid),"crt"=>$crtinfos];
            $websiteDuplicated = SSLWEBSITES_ADMIN::GetSSLWebsiteByWebsiteID($token, $websiteid);
            if ($websiteDuplicated["status"] == "error") {
                //    return ["message"=>$websiteDuplicated["message"]];
                return SSLWEBSITES_ADMIN::UpdateCertificateToWebSite(
                    $token,
                    $poolid,
                    $websiteid,
                    $sslstatus,
                    $fs
                );
            }
            $status = ["forcehttps", "forcehttp", "bothactive"];
            if (!in_array(strtolower($sslstatus), $status)) {
                return ["status" => "error", "message" => "وضعیت ارسالی برای SSL اشتباه است"];
            }
            if (SSLWEBSITES_ADMIN::CheckSSLExpired($poolid)["status"] == "active") {
                $sql = "INSERT INTO " . $GLOBALS["sslwebsites_tablename"] . " (" .
                    $GLOBALS['sw_sp_id_fk'] . "," . $GLOBALS['sw_ws_id_fk'] . "," . $GLOBALS['sw_status'] . "
                    ," . $GLOBALS['sw_ssl_status'] . ") VALUES(" . $poolid . "," . $websiteid . ",'" . $sslstatus . "'," . $fs . ")";
                // $sql = sprintf($sql, $poolid, $websiteid, $sslstatus,$fs);
                $conn = GetConnection();
                $conn->query($sql);
                $dmn = "";
                if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
                    $dmn = $websitesOwner["data"][0]["d_name"];
                } else {
                    $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
                }
                $s =[];
                if ($fs == 1) {
                    $s = API_SSL_ADMIN::RunCreateAPISSL($dmn, $crtinfo["data"][0]["sp_privatekey"], $crtinfo["data"][0]["sp_cert"], $crtinfo["data"][0]["sp_cabundle"], $websiteid);
                    // if ($sslstatus == "forcehttps") {
                    //     API_SSL_ADMIN::RunCreateAPIForceHHTTPS($dmn);
                    // } else if ($sslstatus == "forcehttp") {
                    //     API_SSL_ADMIN::RunCreateAPIUnForceHTTPS($dmn);
                    // }
                }
                $listOfRecordType = ["status" => "success", "s" => $s, "message" => "درخواست شما با موفقیت انجام شد", "cert" => $crtinfo];

                $conn->close();
            } else {
                $listOfRecordType = ["status" => "error", "message" => " SSL انتخابی شما منقضی شده است"];
            }
            return $listOfRecordType;
        }
    }

    public static function InternalAddCertificateToWebSite($poolid, $websiteid, $sslstatus, $fs = 1)
    {
        $websiteDuplicated = SSLWEBSITES_ADMIN::GetSSLWebsiteByWebsiteID("12", $websiteid);
        if ($websiteDuplicated["status"] == "error") {
            return SSLWEBSITES_ADMIN::InternalUpdateCertificateToWebSite(
                $poolid,
                $websiteid,
                $sslstatus,
                $fs
            );
        }
        $status = ["forcehttps", "forcehttp", "bothactive"];
        if (!in_array(strtolower($sslstatus), $status)) {
            return ["status" => "error", "message" => "وضعیت ارسالی برای SSL اشتباه است"];
        }
        if (SSLWEBSITES_ADMIN::CheckSSLExpired($poolid)["status"] == "active") {
            $sql = "INSERT INTO " . $GLOBALS["sslwebsites_tablename"] . " (" .
                $GLOBALS['sw_sp_id_fk'] . "," . $GLOBALS['sw_ws_id_fk'] . "," . $GLOBALS['sw_status'] . "
                    ," . $GLOBALS['sw_ssl_status'] . ") VALUES(" . $poolid . "," . $websiteid . ",'" . $sslstatus . "'," . $fs . ")";
            $conn = GetConnection();
            $conn->query($sql);
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            $dmn = "";
            $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, 0);

            if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
                $dmn = $websitesOwner["data"][0]["d_name"];
            } else {
                $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
            }
            if ($fs == 1) {
                API_SSL_ADMIN::RunCreateAPISSL($dmn, $crtinfo["data"][0]["sp_privatekey"], $crtinfo["data"][0]["sp_cert"], $crtinfo["data"][0]["sp_cabundle"], $websiteid);
                // if ($sslstatus == "forcehttps") {
                //     API_SSL_ADMIN::RunCreateAPIForceHHTTPS($dmn);
                // } else if ($sslstatus == "forcehttp") {
                //     API_SSL_ADMIN::RunCreateAPIUnForceHTTPS($dmn);
                // }
            }

            $conn->close();
        } else {
            $listOfRecordType = ["status" => "error", "message" => " SSL انتخابی شما منقضی شده است"];
        }
        return $listOfRecordType;
    }

    public static function GetSSLWebsiteByWebsiteID($token, $webid)
    {

        $sql = "SELECT * FROM " . $GLOBALS["sslwebsites_tablename"] . " WHERE "
            . $GLOBALS['sw_ws_id_fk'] . "=" . $webid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success", "state" => "300", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(400);
            $listOfRecordType = [
                "status" => "error", "state" => "301",
                "message" => "پیش از این برای این وب سایت گواهینامه ثبت شده است"
            ];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }

    public static function GetSSLWebsite($token, $webid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        // if ($usersDetails["credit"] < 0) {
        //     return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
        // }

        $sql = "SELECT * FROM " . $GLOBALS["sslwebsites_tablename"] . " WHERE "
            . $GLOBALS['sw_ws_id_fk'] . "=" . $webid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "success",
                "state" => "301",
                "message" => " شما SSL برای این سایت ثبت نکرده اید"
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(400);
            $uid = $usersDetails["userdetail"][0]["uid"];
            $crtinfo = SSLPOOLS_ADMIN::CanAccessToPoolid($list[0]["sw_sp_id_fk"], $uid);
            if ($list[0]["sw_status"] == "forcehttp") {
                $result = [
                    "status" => "success",
                    "state" => "301",
                    "message" => " شما SSL برای این سایت ثبت نکرده اید"
                ];
                return $result;
            }
            $listOfRecordType = [
                "status" => "success", "state" => "300",
                "message" => "اطلاعات با موفقیت دریافت شد", "data" => $list, "cert" =>   $crtinfo

            ];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CopyToFile($cert,$sp_cabundle,$sp_privatekey,$website){

        $path =  $GLOBALS["RootFiles"] . '/ssl/' .   $website ;
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        $file = fopen($path . '/' .  $website  . ".crt", "w");
        fwrite($file,$cert);
        fclose($file);

        $file = fopen($path . '/' .  $website  . ".key", "w");
        fwrite($file, $sp_privatekey );
        fclose($file);

        $file = fopen($path . '/' . $website . ".ca", "w");
        fwrite($file,$sp_cabundle);
        fclose($file);

    }
    public static function InternalGetSSLWebsite($webid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslwebsites_tablename"] . " WHERE "
            . $GLOBALS['sw_ws_id_fk'] . "=" . $webid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "success",
                "state" => "301",
                "message" => " شما SSL برای این سایت ثبت نکرده اید"
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $crtinfo = SSLPOOLS_ADMIN::InternalCanAccessToPoolid($list[0]["sw_sp_id_fk"]);
            if ($list[0]["sw_status"] == "forcehttp") {
                $result = [
                    "status" => "success",
                    "state" => "301",
                    "message" => " شما SSL برای این سایت ثبت نکرده اید"
                ];
                return $result;
            }
            $listOfRecordType = [
                "status" => "success", "state" => "300",
                "message" => "اطلاعات با موفقیت دریافت شد", "data" => $list, "cert" =>   $crtinfo

            ];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateCertificateToWebSite($token, $poolid, $websiteid, $sslstatus, $fs)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $crtinfo = SSLPOOLS_ADMIN::CanAccessToPoolid($poolid, $uid);

        if ($crtinfo["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه ارسالی شما معتبر نیست"];
        }
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه سایت ارسالی نامعتبر است"];
        } else {
            $stat = 0;
            $r1 = strpos($crtinfo["data"][0]["sp_domain"], $websitesOwner["data"][0]["ws_recordname"]);
            $r2 = strpos($crtinfo["data"][0]["sp_altdomain"], "www." . $websitesOwner["data"][0]["ws_recordname"]);
            $r3 = strpos($crtinfo["data"][0]["sp_domain"], $websitesOwner["data"][0]["ws_recordname"]);
            $r4 = strpos($crtinfo["data"][0]["sp_altdomain"],  "www." . $websitesOwner["data"][0]["ws_recordname"]);
            $r4 = strpos($crtinfo["data"][0]["sp_altdomain"], $websitesOwner["data"][0]["d_name"]);

            if ($r1 == true) {
                $stat = 1;
            }
            if ($r2 == true) {
                $stat = 1;
            }
            if ($r3 == true) {
                $stat = 1;
            }
            if ($r4 == true) {
                $stat = 1;
            }
            if ($fs == 0)
                $stat = 1;
            if ($stat == 0) {
                return ["status" => "error", "message" => "نام دامنه ارسالی با کواهینامه ارسالی یکسان نیست"];
            }
            $websiteDuplicated = SSLWEBSITES_ADMIN::GetSSLWebsiteByWebsiteID($token, $websiteid);
            if ($websiteDuplicated["status"] == "success") {
                VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => "شما امکان ویرایش برای این سایت را ندارید"];
            }
            $status = ["forcehttps", "forcehttp", "bothactive"];
            if (!in_array(strtolower($sslstatus), $status)) {
                return ["status" => "error", "message" => "وضعیت ارسالی برای SSL اشتباه است"];
            }
            $sql = "UPDATE " . $GLOBALS["sslwebsites_tablename"] . " SET " .
                $GLOBALS['sw_sp_id_fk'] . "=" . $poolid . "," . $GLOBALS['sw_status'] . "='" . $sslstatus
                . "'," . $GLOBALS['sw_ssl_status'] . "='" . $fs . "' WHERE " . $GLOBALS['sw_ws_id_fk'] . "=" . $websiteid;

            $conn = GetConnection();
            $result = $conn->query($sql);

            $dmn = "";
            if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
                $dmn = $websitesOwner["data"][0]["d_name"];
            } else {
                $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
            }
            $s = API_SSL_ADMIN::RunCreateAPISSL($dmn, $crtinfo["data"][0]["sp_privatekey"], $crtinfo["data"][0]["sp_cert"], $crtinfo["data"][0]["sp_cabundle"], $websiteid);
            // if ($sslstatus == "forcehttps") {
            //     API_SSL_ADMIN::RunCreateAPIForceHHTTPS($dmn);
            // } else if ($sslstatus == "forcehttp") {
            //     API_SSL_ADMIN::RunCreateAPIUnForceHTTPS($dmn);
            // }

            $listOfRecordType = ["status" => "success", "s" => $s, "message" => "درخواست شما با موفقیت انجام شد", "cert" => $crtinfo];

            $conn->close();
            return $listOfRecordType;
        }
    }

    public static function InternalUpdateCertificateToWebSite($poolid, $websiteid, $sslstatus, $fs)
    {

        $status = ["forcehttps", "forcehttp", "bothactive"];
        if (!in_array(strtolower($sslstatus), $status)) {
            return ["status" => "error", "message" => "وضعیت ارسالی برای SSL اشتباه است"];
        }
        $sql = "UPDATE " . $GLOBALS["sslwebsites_tablename"] . " SET " .
            $GLOBALS['sw_sp_id_fk'] . "=" . $poolid . "," . $GLOBALS['sw_status'] . "='" . $sslstatus
            . "'," . $GLOBALS['sw_ssl_status'] . "='" . $fs . "' WHERE " . $GLOBALS['sw_ws_id_fk'] . "=" . $websiteid;

        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "cert" => $crtinfo];
        $dmn = "";
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, 0);
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        API_SSL_ADMIN::RunCreateAPISSL($dmn, $crtinfo["data"][0]["sp_privatekey"], $crtinfo["data"][0]["sp_cert"], $crtinfo["data"][0]["sp_cabundle"], $websiteid);
        // if ($sslstatus == "forcehttps") {
        //     API_SSL_ADMIN::RunCreateAPIForceHHTTPS($dmn);
        // } else if ($sslstatus == "forcehttp") {
        //     API_SSL_ADMIN::RunCreateAPIUnForceHTTPS($dmn);
        // }
        $conn->close();
        return $listOfRecordType;
    }
    public static function AddFreeCertificateToWebSite($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $poolid = "0";
        $crtinfo = SSLPOOLS_ADMIN::CanAccessToPoolid($poolid, $uid);

        if ($crtinfo["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه ارسالی شما معتبر نیست"];
        }
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه سایت ارسالی نامعتبر است"];
        } else {
            $websiteDuplicated = SSLWEBSITES_ADMIN::GetSSLWebsiteByWebsiteID($token, $websiteid);
            if ($websiteDuplicated["status"] == "error") {
                VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => $websiteDuplicated["message"]];
            }
            $sql = "INSERT INTO " . $GLOBALS["sslwebsites_tablename"] . " (" .
                $GLOBALS['sw_sp_id_fk'] . "," . $GLOBALS['sw_ws_id_fk'] . "," . $GLOBALS['sw_ssl_status'] .
                ") VALUES(
             %s,%s,0)";
            $sql = sprintf($sql, $poolid, $websiteid);
            $conn = GetConnection();
            $result = $conn->query($sql);
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            $conn->close();
            return $listOfRecordType;
        }
    }
}
