<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class SSLHSTS_ADMIN
{
    public static function UpdateHSTS($token, $websiteid, $hsts, $htime)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه سایت ارسالی نامعتبر است"];
        } else {
            $b=SSLWEBSITES_ADMIN::CheckWebSiteHasSSL($websiteid);
             if($b["status"]=="error"){
                 return ["status" => "error", "message" => "شما SSL فعال برای این دامنه ندارید"];
             }
            $valistatus = ["true", "false"];
            $validmonth = ["1", "2", "3", "4", "5", "6", "12"];
            if (!in_array($hsts, $valistatus)) {
                return ["status" => "error", "message" => "وضعیت ارسالی نامعتبر است"];
            }
            if (!in_array($htime, $validmonth)) {
                return ["status" => "error", "message" => "وضعیت ارسالی نامعتبر است"];
            }
            $s = self::GetHSTSStatus($token, $websiteid);
            $sql = "";
            $hsts = $hsts == "true" ? "1" : "0";
            if ($s["code"] == "201") {

                $sql = "insert into " . $GLOBALS["sslhsts_tablename"] . " VALUES(0,'" . $websiteid . "','" . $hsts . "','" . $htime . "')";
            } else {
                $sql = "UPDATE " . $GLOBALS["sslhsts_tablename"] . " SET " . $GLOBALS['sh_status'] . "='" . $hsts . "',".
                                    $GLOBALS['sh_time'] . "='" . $htime . "' WHERE " . $GLOBALS['sh_wid_fk'] . "=" . $websiteid;
            }
            $conn = GetConnection();

            $conn->query($sql);

            if($hsts=="1"){
                $mn=intval($htime)*(2592000) ;
                $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);

                  API_SSL_ADMIN::RunCreateAPIHSTS($dmn,$mn);
            }
            else{
                 $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);

                  API_SSL_ADMIN::RunDisableAPIHSTS($dmn);
            }
            $conn->close();
        }
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد",$mn];
    }
    public static function RemoveHSTS($websiteid)
    {
        $sql="DELETE FROM ". $GLOBALS["sslhsts_tablename"] . " WHERE "
            . $GLOBALS['sh_wid_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function GetHSTSStatus($token, $webid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT IF(sh_status=0,'false','true') as status,sh_time as htime from " . $GLOBALS["sslhsts_tablename"] . " WHERE "
            . $GLOBALS['sh_wid_fk'] . "=" . $webid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success", "code" => "201", "message" => "اطلاعات با موفقیت دریافت شد", "hsts" => "false"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(400);
            $listOfRecordType = ["status" => "success", "code" => "200", "message" => "اطلاعات با موفقیت دریافت شد", "hsts" => $list[0]["status"]
           , "time" => $list[0]["htime"]." month"];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
}
