<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class RATELIMITSUBFOLDER_NEW_ADMIN
{

	public static function GetWebsiteRateLimit($token, $subfolderid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			 			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
		if ($websitesOwner["status"] == "error") {
			VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "آدرس فرعی درخواستی شما اشتباه است"];
		}
		$sql = "SELECT * FROM " . $GLOBALS["ratelimitsubfolder_new_tablename"] .
			" WHERE " . $GLOBALS["rlsf_sfid_fk"] . "=" . $subfolderid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$listOfRecordType = [
				"status" => "success", "code" => "201",
				"message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید"
			];
			$conn->close();
		} else {
			$r = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$rangeips = $r[0]["rlsf_ips"];
			$rgip = [];
			$ips = explode(",", $rangeips);
			foreach ($ips as $ip) {
				array_push($rgip, $ip);
			}
			unset($r[0]["rlsf_ips"]);
			$r[0]["rangeips"] = $rgip;
			$listOfRecordType = [
				"status" => "success", "code" => "200",
				// "countofrules"=>count($r),
				"data" => $r[0]
			];
			$conn->close();
		}
		return $listOfRecordType;
	}

	public static function UpdateWebsiteRateLimit(
		$token,
		$subfolderid,
		$rlsf_requestcount,
		$rlsf_timerate,
		$rlsf_timeformat,
		$rlsf_blockedbytimerange,
		$rlsf_ips,
		$rlsf_blockedbytimeformat,
		$rlsf_description,
		$priority
	) {

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			 			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];

		$websitesOwner = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
		if ($websitesOwner["status"] == "error") {
			VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "آدرس فرعی درخواستی شما اشتباه است"];
		}

		$planwebsite = $websitesOwner["data"][0]["d_plan"];
		$plans = ReturnPlans();
		if (isset($plans[$planwebsite])) {
			if (!isset($plans[$planwebsite]["ratelimit"])) {
				return [
					"status" => "error", "action" => "needtoupgrade", $planwebsite, $websitesOwner,
					"message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید "
				];
			}
		} else {
			return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
		}

		if ($rlsf_timeformat != "s" &&  $rlsf_timeformat != "m" &&  $rlsf_timeformat != "h") {
			return ["status" => "error", "message" => "فرمت زمان ارسالی نامعتبر است"];
		}
		if (!is_numeric($rlsf_requestcount) || !is_numeric($rlsf_timerate) || !is_numeric($rlsf_blockedbytimerange)) {
			return ["status" => "error", "message" => "فرمت اعداد ارسالی نامعتبر است"];
		}
		$ips = explode(",", $rlsf_ips);
		$ips = array_unique($ips);
		$res = [];
		$stat = 1;
		$success_array = [];
		foreach ($ips as $ip) {
			if (strpos($ip, '/')) {
				$nip = explode("/", $ip);
				return ["status"=>"error","message"=>"IP ارسالی نمی تواند شامل رنج باشد"];
				if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
					$stat = 0;
					$out["status"] = "error";
					return	["status" => "error", "message" => "IP نامعتبر است"];
				}
			} else {
				if (!filter_var($ip, FILTER_VALIDATE_IP)) {
					$stat = 0;
					return	["status" => "error", "message" => "IP نامعتبر است"];
				}
				$ipranges = implode(",", $ips);
			}
		}
			$sql = "SELECT * FROM " . $GLOBALS["ratelimitsubfolder_new_tablename"] .
				" WHERE " . $GLOBALS["rlsf_sfid_fk"] . "=" . $subfolderid;
			$conn = GetConnection();
			$result = $conn->query($sql);
			$ins = "UPDATE " . $GLOBALS["ratelimitsubfolder_new_tablename"] . " SET " .
			$GLOBALS['rlsf_ips'] . "='" . $rlsf_ips . "'," . $GLOBALS['rlsf_description'] . "='" . $rlsf_description . "'," .
			$GLOBALS['rlsf_requestcount'] . "='" . $rlsf_requestcount . "'," . $GLOBALS['rlsf_timerate'] . "='" . $rlsf_timerate . "'," .
			$GLOBALS['rlsf_timeformat'] . "='" . $rlsf_timeformat . "'," . $GLOBALS['rlsf_blockedbytimerange'] . "='" .
			$rlsf_blockedbytimerange
			. "'," . $GLOBALS['rlsf_blockedbytimeformat'] . "='" .
			 $rlsf_blockedbytimeformat . "',rlsf_priority=".$priority." WHERE " . $GLOBALS['rlsf_sfid_fk'] . "=" . $subfolderid;

			if (!$result || mysqli_num_rows($result) == 0) {
				$ins = "INSERT INTO " . $GLOBALS["ratelimitsubfolder_new_tablename"]
				. " (rlsf_id," .
				$GLOBALS['rlsf_ips'] . "," . $GLOBALS['rlsf_description'] . "," .
				$GLOBALS['rlsf_requestcount'] . "," . $GLOBALS['rlsf_timerate'] . "," .
				$GLOBALS['rlsf_timeformat'] . "," . $GLOBALS['rlsf_blockedbytimerange'] . "," .
				$GLOBALS['rlsf_blockedbytimeformat'] . "," . $GLOBALS['rlsf_sfid_fk'] . ",rlsf_priority)
                VALUE (0,'" . $rlsf_ips . "','" . $rlsf_description . "','" . $rlsf_requestcount . "','" .
				$rlsf_timerate . "','" . $rlsf_timeformat . "','" . $rlsf_blockedbytimerange . "','" .
				$rlsf_blockedbytimeformat . "','" . $subfolderid . "',".$priority.")";
			}
			$conn->query($ins);
			$conn->close();
			$ip = str_replace(",", ";", $ipranges);
			$dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);

		$requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
		$rate = $rlsf_requestcount . "r/" . $rlsf_timeformat;

		$blockedTime = $rlsf_blockedbytimerange;
		if ($rlsf_blockedbytimeformat != "s")
			$blockedTime = intVal($rlsf_blockedbytimerange) * 60;
		switch ($rlsf_blockedbytimeformat) {
			case "m":
				$blockedTime = intVal($rlsf_blockedbytimerange) * 60;
				break;
			case "h":
				$blockedTime = intVal($rlsf_blockedbytimerange) * 3600;
				break;
		}

		API_RATELIMIT_NEW_ADMIN::RunCreateAPIRATELIMIT(
			$dmn,
			$rate,
			$blockedTime,
			$requiredData[0]["sf_name"],
			$ip,
			$priority
		);
		// API_RATELIMIT_ADMIN::RunCreateAPIRATELIMIT($dmn,
		//  $rname, $rate, $rtimeformat, $brs, "/" . $requiredData[0]["sf_name"], $ip, $priority);

		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}

	public static function RemoveRateLimit($token, $subfolderid, $priority)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			 			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
		if ($websitesOwner["status"] == "error") {
			VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "آدرس فرعی درخواستی شما اشتباه است"];
		}

		$sql = "SELECT * FROM " . $GLOBALS["ratelimitsubfolder_new_tablename"] .
			" WHERE " . $GLOBALS["rlsf_sfid_fk"] . "=" . $subfolderid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$listOfRecordType = [
				"status" => "success", "code" => "201",
				"message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید "
			];
			$conn->close();
		} else {
			$r = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$sql = "DELETE  FROM " . $GLOBALS["ratelimitsubfolder_new_tablename"] .
				" WHERE " . $GLOBALS["rlsf_sfid_fk"] . "=" . $subfolderid;
			$result = $conn->query($sql);
			$conn->close();
			$dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
			$requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);

			API_RATELIMIT_ADMIN::RunDisableAPIRATELIMIT($dmn, $requiredData[0]["sf_name"], $priority);
			$listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
			SUBFOLDERRULES_ADMIN::UpdateArrayinDB($subfolderid, "remove", "ratelimit");
		}

		return $listOfRecordType;
	}
}
